/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.border.BevelBorder;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.PatternWindow;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPatternList;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.View;

public class PatternListPanel
extends JPanel {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    static final Font FONT_NOPATTERN = new Font("SanSerif", 3, 14);
    static final Font FONT_PATTERN = new Font("Monospaced", 0, 14);
    static final Font FONT_PATTERN_POPUP = new Font("Monospaced", 2, 14);
    static final DataFlavor PATTERN_FLAVOR = new DataFlavor(JMLPatternList.PatternRecord.class, "Juggling Lab pattern record");
    protected JMLPatternList pl = new JMLPatternList();
    protected JFrame parent;
    protected View animtarget;
    protected JList<JMLPatternList.PatternRecord> list;
    protected boolean hasUnsavedChanges;
    protected boolean didPopup;
    protected ArrayList<PatternWindow> popupPatterns;
    protected JDialog dialog;
    protected JTextField tf;
    protected JButton okbutton;
    protected boolean draggingOut;
    protected static final String[] popupItems = new String[]{"PLPOPUP Insert text...", null, "PLPOPUP Insert pattern", null, "PLPOPUP Change title...", "PLPOPUP Change display text...", null, "PLPOPUP Remove line"};
    protected static final String[] popupCommands = new String[]{"inserttext", null, "insertpattern", null, "title", "displaytext", null, "remove"};

    protected PatternListPanel() {
        this.makePanel();
        this.setOpaque(false);
    }

    public PatternListPanel(JFrame parent) {
        this();
        this.parent = parent;
    }

    public PatternListPanel(View target) {
        this();
        this.setTargetView(target);
    }

    protected void makePanel() {
        this.list = new JList<JMLPatternList.PatternRecord>(this.pl.getModel());
        this.list.getSelectionModel().setSelectionMode(0);
        this.list.setCellRenderer(new PatternCellRenderer(this));
        this.list.setDragEnabled(true);
        this.list.setTransferHandler(new PatternTransferHandler(this));
        JScrollPane pane = new JScrollPane(this.list);
        this.list.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ PatternListPanel this$0;
            {
                PatternListPanel patternListPanel = this$0;
                Objects.requireNonNull(patternListPanel);
                this.this$0 = patternListPanel;
            }

            @Override
            public void mousePressed(MouseEvent me) {
                int row = this.this$0.list.locationToIndex(me.getPoint());
                if (row >= 0) {
                    this.this$0.list.setSelectedIndex(row);
                }
                this.this$0.didPopup = false;
                if (me.isPopupTrigger()) {
                    this.this$0.makePopupMenu().show(this.this$0.list, me.getX(), me.getY());
                    this.this$0.didPopup = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent me) {
                if (me.isPopupTrigger()) {
                    this.this$0.makePopupMenu().show(this.this$0.list, me.getX(), me.getY());
                    this.this$0.didPopup = true;
                }
                if (!this.this$0.didPopup) {
                    this.this$0.launchAnimation();
                    this.this$0.checkSelection();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)pane, "Center");
    }

    protected void launchAnimation() {
        try {
            int row = this.list.getSelectedIndex();
            if (row < 0 || row == this.pl.getModel().size() - 1) {
                return;
            }
            JMLPattern pat = this.pl.getPatternForLine(row);
            if (pat == null) {
                return;
            }
            pat.layoutPattern();
            if (PatternWindow.bringToFront(pat.getHashCode())) {
                return;
            }
            AnimationPrefs ap = this.pl.getAnimationPrefsForLine(row);
            if (this.animtarget != null) {
                this.animtarget.restartView(pat, ap);
            } else {
                new PatternWindow(pat.getTitle(), pat, ap);
            }
        }
        catch (JuggleExceptionUser jeu) {
            new ErrorDialog(this, jeu.getMessage());
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.handleFatalException(jei);
        }
    }

    public JMLPatternList getPatternList() {
        return this.pl;
    }

    public void clearList() {
        if (this.pl.getModel().size() > 1) {
            this.hasUnsavedChanges = true;
        }
        this.pl.clearModel();
    }

    public void setTargetView(View target) {
        this.animtarget = target;
    }

    public void addPattern(String display, String animprefs, String notation, String anim) {
        this.pl.addLine(-1, display, animprefs, notation, anim, null, null);
    }

    protected JPopupMenu makePopupMenu() {
        JPopupMenu popup = new JPopupMenu();
        int row = this.list.getSelectedIndex();
        this.popupPatterns = new ArrayList();
        for (Frame fr : Frame.getFrames()) {
            if (!fr.isVisible() || !(fr instanceof PatternWindow)) continue;
            this.popupPatterns.add((PatternWindow)fr);
        }
        ActionListener al = new ActionListener(this){
            final /* synthetic */ PatternListPanel this$0;
            {
                PatternListPanel patternListPanel = this$0;
                Objects.requireNonNull(patternListPanel);
                this.this$0 = patternListPanel;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                String command = ae.getActionCommand();
                int row = this.this$0.list.getSelectedIndex();
                if (command.equals("inserttext")) {
                    this.this$0.insertText(row);
                } else if (!command.equals("insertpattern")) {
                    if (command.equals("title")) {
                        this.this$0.changeTitle();
                    } else if (command.equals("displaytext")) {
                        this.this$0.changeDisplayText(row);
                    } else if (command.equals("remove")) {
                        this.this$0.pl.getModel().remove(row);
                    } else {
                        int patnum = Integer.parseInt(command.substring(3, command.length()));
                        PatternWindow pw = this.this$0.popupPatterns.get(patnum);
                        this.this$0.insertPattern(row, pw);
                    }
                }
            }
        };
        for (int i = 0; i < popupItems.length; ++i) {
            String name = popupItems[i];
            if (name == null) {
                popup.addSeparator();
                continue;
            }
            JMenuItem item = new JMenuItem(guistrings.getString(name.replace(' ', '_')));
            item.setActionCommand(popupCommands[i]);
            item.addActionListener(al);
            if ((popupCommands[i].equals("displaytext") || popupCommands[i].equals("remove")) && row < 0) {
                item.setEnabled(false);
            }
            if ((popupCommands[i].equals("displaytext") || popupCommands[i].equals("remove")) && row == this.pl.getModel().size() - 1) {
                item.setEnabled(false);
            }
            if (popupCommands[i].equals("insertpattern") && this.popupPatterns.size() == 0) {
                item.setEnabled(false);
            }
            popup.add(item);
            if (!popupCommands[i].equals("insertpattern")) continue;
            int patnum = 0;
            for (PatternWindow pw : this.popupPatterns) {
                JMenuItem pitem = new JMenuItem("   " + pw.getTitle());
                pitem.setActionCommand("pat" + patnum);
                pitem.addActionListener(al);
                pitem.setFont(FONT_PATTERN_POPUP);
                popup.add(pitem);
                ++patnum;
            }
        }
        popup.setBorder(new BevelBorder(0));
        popup.addPopupMenuListener(new PopupMenuListener(this){
            final /* synthetic */ PatternListPanel this$0;
            {
                PatternListPanel patternListPanel = this$0;
                Objects.requireNonNull(patternListPanel);
                this.this$0 = patternListPanel;
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                this.this$0.checkSelection();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }
        });
        return popup;
    }

    protected void insertPattern(int row, PatternWindow pw) {
        String display = pw.getTitle();
        String animprefs = pw.getAnimationPrefs().toString();
        if (animprefs.length() == 0) {
            animprefs = null;
        }
        String notation = "jml";
        String anim = null;
        JMLPattern pattern = pw.getPattern();
        JMLNode patnode = null;
        try {
            patnode = pattern.getRootNode().findNode("pattern");
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.handleFatalException(jei);
            return;
        }
        JMLNode infonode = patnode.findNode("info");
        if (pattern.hasBasePattern() && !pattern.isBasePatternEdited()) {
            notation = pattern.getBasePatternNotation();
            anim = pattern.getBasePatternConfig();
            patnode = null;
        }
        this.pl.addLine(row, display, animprefs, notation, anim, patnode, infonode);
        if (row < 0) {
            this.list.setSelectedIndex(this.pl.getModel().size() - 2);
        } else {
            this.list.setSelectedIndex(row);
        }
        this.hasUnsavedChanges = true;
    }

    protected void insertText(final int row) {
        this.makeDialog(guistrings.getString("PLDIALOG_Insert_text"), "");
        this.okbutton.addActionListener(new ActionListener(){
            final /* synthetic */ PatternListPanel this$0;
            {
                PatternListPanel patternListPanel = this$0;
                Objects.requireNonNull(patternListPanel);
                this.this$0 = patternListPanel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                String display = this.this$0.tf.getText();
                this.this$0.dialog.dispose();
                this.this$0.pl.addLine(row, display, null, null, null, null, null);
                if (row < 0) {
                    this.this$0.list.setSelectedIndex(this.this$0.pl.size() - 1);
                } else {
                    this.this$0.list.setSelectedIndex(row);
                }
                this.this$0.hasUnsavedChanges = true;
            }
        });
        this.dialog.setVisible(true);
    }

    protected void changeTitle() {
        this.makeDialog(guistrings.getString("PLDIALOG_Change_title"), this.pl.getTitle());
        this.okbutton.addActionListener(new ActionListener(this){
            final /* synthetic */ PatternListPanel this$0;
            {
                PatternListPanel patternListPanel = this$0;
                Objects.requireNonNull(patternListPanel);
                this.this$0 = patternListPanel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this.this$0.pl.setTitle(this.this$0.tf.getText());
                this.this$0.dialog.dispose();
                if (this.this$0.parent != null) {
                    this.this$0.parent.setTitle(this.this$0.pl.getTitle());
                }
                this.this$0.hasUnsavedChanges = true;
            }
        });
        this.dialog.setVisible(true);
        this.list.clearSelection();
    }

    protected void changeDisplayText(final int row) {
        final JMLPatternList.PatternRecord rec = this.pl.getModel().get(row);
        this.makeDialog(guistrings.getString("PLDIALOG_Change_display_text"), rec.display);
        this.okbutton.addActionListener(new ActionListener(){
            final /* synthetic */ PatternListPanel this$0;
            {
                PatternListPanel patternListPanel = this$0;
                Objects.requireNonNull(patternListPanel);
                this.this$0 = patternListPanel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                rec.display = this.this$0.tf.getText();
                this.this$0.dialog.dispose();
                this.this$0.pl.getModel().set(row, rec);
                this.this$0.hasUnsavedChanges = true;
            }
        });
        this.dialog.setVisible(true);
    }

    protected JDialog makeDialog(String title, String default_text) {
        this.dialog = new JDialog(this.parent, title, true);
        GridBagLayout gb = new GridBagLayout();
        this.dialog.getContentPane().setLayout(gb);
        this.tf = new JTextField(20);
        this.tf.setText(default_text);
        this.okbutton = new JButton(guistrings.getString("OK"));
        this.dialog.getContentPane().add(this.tf);
        gb.setConstraints(this.tf, JLFunc.constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        this.dialog.getContentPane().add(this.okbutton);
        gb.setConstraints(this.okbutton, JLFunc.constraints(22, 0, 1, new Insets(10, 10, 10, 10)));
        this.dialog.getRootPane().setDefaultButton(this.okbutton);
        this.dialog.pack();
        this.dialog.setResizable(false);
        this.dialog.setLocationRelativeTo(this);
        this.dialog.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ PatternListPanel this$0;
            {
                PatternListPanel patternListPanel = this$0;
                Objects.requireNonNull(patternListPanel);
                this.this$0 = patternListPanel;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                this.this$0.checkSelection();
            }
        });
        return this.dialog;
    }

    protected void checkSelection() {
        if (this.list.getSelectedIndex() == this.pl.getModel().size() - 1) {
            this.list.clearSelection();
        }
        this.popupPatterns = null;
        this.dialog = null;
        this.tf = null;
        this.okbutton = null;
    }

    class PatternCellRenderer
    extends JLabel
    implements ListCellRenderer<JMLPatternList.PatternRecord> {
        final /* synthetic */ PatternListPanel this$0;

        PatternCellRenderer(PatternListPanel this$0) {
            PatternListPanel patternListPanel = this$0;
            Objects.requireNonNull(patternListPanel);
            this.this$0 = patternListPanel;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends JMLPatternList.PatternRecord> list, JMLPatternList.PatternRecord value, int index, boolean isSelected, boolean cellHasFocus) {
            JMLPatternList.PatternRecord rec = value;
            this.setFont(rec.anim == null && rec.patnode == null ? FONT_NOPATTERN : FONT_PATTERN);
            this.setText(rec.display.length() > 0 ? rec.display : " ");
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setOpaque(true);
            return this;
        }
    }

    class PatternTransferHandler
    extends TransferHandler {
        final /* synthetic */ PatternListPanel this$0;

        PatternTransferHandler(PatternListPanel this$0) {
            PatternListPanel patternListPanel = this$0;
            Objects.requireNonNull(patternListPanel);
            this.this$0 = patternListPanel;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 3;
        }

        @Override
        public Transferable createTransferable(JComponent c) {
            int row = this.this$0.list.getSelectedIndex();
            if (row < 0 || row == this.this$0.pl.getModel().size() - 1) {
                return null;
            }
            this.this$0.draggingOut = true;
            JMLPatternList.PatternRecord rec = this.this$0.pl.getModel().get(row);
            return new PatternTransferable(this.this$0, rec);
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport info) {
            if (!info.isDrop()) {
                return false;
            }
            if (this.this$0.draggingOut) {
                info.setDropAction(2);
            } else {
                info.setDropAction(1);
            }
            if (info.isDataFlavorSupported(PATTERN_FLAVOR)) {
                return true;
            }
            return info.isDataFlavorSupported(DataFlavor.stringFlavor);
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport info) {
            if (!info.isDrop()) {
                return false;
            }
            JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
            int index = dl.getIndex();
            if (index < 0) {
                index = this.this$0.pl.getModel().size() - 1;
            }
            Transferable t = info.getTransferable();
            try {
                if (t.isDataFlavorSupported(PATTERN_FLAVOR)) {
                    JMLPatternList.PatternRecord rec = (JMLPatternList.PatternRecord)t.getTransferData(PATTERN_FLAVOR);
                    this.this$0.pl.getModel().add(index, new JMLPatternList.PatternRecord(rec));
                    this.this$0.list.setSelectedIndex(index);
                    this.this$0.hasUnsavedChanges = true;
                    return true;
                }
                if (t.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                    String s = (String)t.getTransferData(DataFlavor.stringFlavor);
                    String[] lines = s.stripTrailing().split("\n");
                    for (int i = lines.length - 1; i >= 0; --i) {
                        JMLPatternList.PatternRecord rec = new JMLPatternList.PatternRecord(lines[i], null, null, null, null, null, null);
                        this.this$0.pl.getModel().add(index, rec);
                    }
                    this.this$0.list.setSelectedIndex(index);
                    this.this$0.hasUnsavedChanges = true;
                    return true;
                }
            }
            catch (Exception e) {
                ErrorDialog.handleFatalException(e);
            }
            return false;
        }

        @Override
        protected void exportDone(JComponent c, Transferable data, int action) {
            if (action == 2) {
                if (!(data instanceof PatternTransferable)) {
                    return;
                }
                if (!this.this$0.pl.getModel().removeElement(((PatternTransferable)data).rec)) {
                    ErrorDialog.handleFatalException(new JuggleExceptionInternal("PLP: exportDone()"));
                }
                this.this$0.hasUnsavedChanges = true;
            }
            this.this$0.draggingOut = false;
        }
    }

    class PatternTransferable
    implements Transferable {
        public JMLPatternList.PatternRecord rec;

        public PatternTransferable(PatternListPanel this$0, JMLPatternList.PatternRecord pr) {
            Objects.requireNonNull(this$0);
            this.rec = pr;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            if (flavor.equals(PATTERN_FLAVOR)) {
                return this.rec;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                String s = this.rec.anim == null || this.rec.anim.equals("") ? this.rec.display : this.rec.anim;
                return s;
            }
            return null;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{PATTERN_FLAVOR, DataFlavor.stringFlavor};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.equals(PATTERN_FLAVOR) || flavor.equals(DataFlavor.stringFlavor);
        }
    }
}

