/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import jugglinglab.JugglingLab;
import jugglinglab.core.ApplicationWindow;
import jugglinglab.core.PatternListPanel;
import jugglinglab.jml.JMLNode;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class PatternListWindow
extends JFrame
implements ActionListener {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected static final int NUM_TILES = 8;
    protected static final Point TILE_START = new Point(0, 620);
    protected static final Point TILE_OFFSET = new Point(25, 25);
    protected static Point[] tile_locations;
    protected static int next_tile_num;
    protected PatternListPanel plp;
    protected JMenu windowmenu;
    protected String last_jml_filename;
    protected static final String[] fileItems;
    protected static final String[] fileCommands;
    protected static final char[] fileShortcuts;
    protected static final String[] helpItems;
    protected static final String[] helpCommands;

    public PatternListWindow(String title) {
        this.createMenus();
        this.createContents();
        this.plp.getPatternList().setTitle(title);
        this.setTitle(title);
        this.setLocation(PatternListWindow.getNextScreenLocation());
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ PatternListWindow this$0;
            {
                PatternListWindow patternListWindow = this$0;
                Objects.requireNonNull(patternListWindow);
                this.this$0 = patternListWindow;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    this.this$0.doMenuCommand(MenuCommand.FILE_CLOSE);
                }
                catch (JuggleException je) {
                    ErrorDialog.handleFatalException(je);
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void run() {
                ApplicationWindow.updateWindowMenus();
            }
        });
    }

    public PatternListWindow(JMLNode root) throws JuggleExceptionUser {
        this("");
        if (root != null) {
            this.plp.getPatternList().readJML(root);
            this.setTitle(this.plp.getPatternList().getTitle());
        }
    }

    public PatternListWindow(String title, Thread gen) {
        this(title);
        if (gen != null) {
            final Thread generator = gen;
            this.addWindowListener(new WindowAdapter(this){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public void windowClosing(WindowEvent e) {
                    try {
                        generator.interrupt();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
    }

    protected void createContents() {
        this.plp = new PatternListPanel(this);
        this.plp.setDoubleBuffered(true);
        this.setContentPane(this.plp);
        Locale loc = Locale.getDefault();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        this.setBackground(Color.white);
        this.setSize(300, 450);
    }

    public PatternListPanel getPatternListPanel() {
        return this.plp;
    }

    public void setJMLFilename(String fname) {
        this.last_jml_filename = fname;
    }

    protected static Point getNextScreenLocation() {
        if (tile_locations == null) {
            tile_locations = new Point[8];
            Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            int locx = Math.max(0, center.x - 600);
            for (int i = 0; i < 8; ++i) {
                int loc_x = locx + PatternListWindow.TILE_START.x + i * PatternListWindow.TILE_OFFSET.x;
                int loc_y = PatternListWindow.TILE_START.y + i * PatternListWindow.TILE_OFFSET.y;
                PatternListWindow.tile_locations[i] = new Point(loc_x, loc_y);
            }
            next_tile_num = 0;
        }
        Point loc = tile_locations[next_tile_num];
        if (++next_tile_num == 8) {
            next_tile_num = 0;
        }
        return loc;
    }

    protected void createMenus() {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu());
        this.windowmenu = new JMenu(guistrings.getString("Window"));
        mb.add(this.windowmenu);
        mb.add(this.createHelpMenu());
        this.setJMenuBar(mb);
    }

    protected JMenu createFileMenu() {
        JMenu filemenu = new JMenu(guistrings.getString("File"));
        for (int i = 0; i < fileItems.length; ++i) {
            if (fileItems[i] == null) {
                filemenu.addSeparator();
                continue;
            }
            JMenuItem fileitem = new JMenuItem(guistrings.getString(fileItems[i].replace(' ', '_')));
            if (fileShortcuts[i] != ' ') {
                fileitem.setAccelerator(KeyStroke.getKeyStroke((int)fileShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
            }
            fileitem.setActionCommand(fileCommands[i]);
            fileitem.addActionListener(this);
            filemenu.add(fileitem);
        }
        return filemenu;
    }

    public JMenu getWindowMenu() {
        return this.windowmenu;
    }

    protected JMenu createHelpMenu() {
        int i;
        boolean include_about = !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.APP_ABOUT);
        Object menuname = guistrings.getString("Help");
        if (JugglingLab.isMacOS) {
            menuname = (String)menuname + " ";
        }
        JMenu helpmenu = new JMenu((String)menuname);
        int n = i = include_about ? 0 : 1;
        while (i < helpItems.length) {
            if (helpItems[i] == null) {
                helpmenu.addSeparator();
            } else {
                JMenuItem helpitem = new JMenuItem(guistrings.getString(helpItems[i].replace(' ', '_')));
                helpitem.setActionCommand(helpCommands[i]);
                helpitem.addActionListener(this);
                helpmenu.add(helpitem);
            }
            ++i;
        }
        return helpmenu;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        try {
            if (command.equals("newpat")) {
                this.doMenuCommand(MenuCommand.FILE_NEWPAT);
            } else if (command.equals("newpl")) {
                this.doMenuCommand(MenuCommand.FILE_NEWPL);
            } else if (command.equals("open")) {
                this.doMenuCommand(MenuCommand.FILE_OPEN);
            } else if (command.equals("close")) {
                this.doMenuCommand(MenuCommand.FILE_CLOSE);
            } else if (command.equals("saveas")) {
                this.doMenuCommand(MenuCommand.FILE_SAVE);
            } else if (command.equals("savetext")) {
                this.doMenuCommand(MenuCommand.FILE_SAVETEXT);
            } else if (command.equals("about")) {
                this.doMenuCommand(MenuCommand.HELP_ABOUT);
            } else if (command.equals("online")) {
                this.doMenuCommand(MenuCommand.HELP_ONLINE);
            }
        }
        catch (JuggleExceptionUser je) {
            new ErrorDialog(this, je.getMessage());
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.handleFatalException(jei);
        }
    }

    protected void doMenuCommand(MenuCommand action) throws JuggleExceptionUser, JuggleExceptionInternal {
        switch (action.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                ApplicationWindow.newPattern();
                break;
            }
            case 2: {
                new PatternListWindow("").setTitle(null);
                break;
            }
            case 3: {
                ApplicationWindow.openJMLFile();
                break;
            }
            case 4: {
                this.dispose();
                break;
            }
            case 5: {
                try {
                    File f;
                    Object fname = this.last_jml_filename;
                    if (fname == null) {
                        fname = this.getTitle() + ".jml";
                    }
                    fname = JLFunc.sanitizeFilename((String)fname);
                    JLFunc.jfc().setSelectedFile(new File((String)fname));
                    JLFunc.jfc().setFileFilter(new FileNameExtensionFilter("JML file", "jml"));
                    if (JLFunc.jfc().showSaveDialog(this) != 0 || (f = JLFunc.jfc().getSelectedFile()) == null) break;
                    if (!f.getAbsolutePath().endsWith(".jml")) {
                        f = new File(f.getAbsolutePath() + ".jml");
                    }
                    JLFunc.errorIfNotSanitized(f.getName());
                    this.last_jml_filename = f.getName();
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    FileWriter fw = new FileWriter(f);
                    this.plp.getPatternList().writeJML(fw);
                    fw.close();
                    this.plp.hasUnsavedChanges = false;
                    break;
                }
                catch (FileNotFoundException fnfe) {
                    throw new JuggleExceptionInternal("File not found on save: " + fnfe.getMessage());
                }
                catch (IOException ioe) {
                    throw new JuggleExceptionInternal("IOException on save: " + ioe.getMessage());
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            case 6: {
                try {
                    File f;
                    Object fname = this.last_jml_filename;
                    if (fname != null) {
                        int index = ((String)fname).lastIndexOf(".");
                        Object base = index >= 0 ? ((String)fname).substring(0, index) : fname;
                        fname = (String)base + ".txt";
                    } else {
                        fname = this.getTitle() + ".txt";
                    }
                    fname = JLFunc.sanitizeFilename((String)fname);
                    JLFunc.jfc().setSelectedFile(new File((String)fname));
                    JLFunc.jfc().setFileFilter(new FileNameExtensionFilter("Text file", "txt"));
                    if (JLFunc.jfc().showSaveDialog(this) != 0 || (f = JLFunc.jfc().getSelectedFile()) == null) break;
                    if (!f.getAbsolutePath().endsWith(".txt")) {
                        f = new File(f.getAbsolutePath() + ".txt");
                    }
                    JLFunc.errorIfNotSanitized(f.getName());
                    int index = f.getName().lastIndexOf(".");
                    String base = index >= 0 ? f.getName().substring(0, index) : f.getName();
                    this.last_jml_filename = base + ".jml";
                    this.setCursor(Cursor.getPredefinedCursor(3));
                    FileWriter fw = new FileWriter(f);
                    this.plp.getPatternList().writeText(fw);
                    fw.close();
                    break;
                }
                catch (FileNotFoundException fnfe) {
                    throw new JuggleExceptionInternal("File not found on save: " + fnfe.getMessage());
                }
                catch (IOException ioe) {
                    throw new JuggleExceptionInternal("IOException on save: " + ioe.getMessage());
                }
                finally {
                    this.setCursor(Cursor.getDefaultCursor());
                }
            }
            case 7: {
                ApplicationWindow.showAboutBox();
                break;
            }
            case 8: {
                ApplicationWindow.showOnlineHelp();
            }
        }
    }

    @Override
    public void setTitle(String title) {
        if (title == null || title.length() == 0) {
            title = guistrings.getString("PLWINDOW_Default_window_title");
        }
        super.setTitle(title);
        ApplicationWindow.updateWindowMenus();
    }

    @Override
    public void dispose() {
        if (this.plp != null && this.plp.hasUnsavedChanges) {
            String title;
            Object[] arguments;
            String template = guistrings.getString("PLWINDOW_Unsaved_changes_message");
            String message = MessageFormat.format(template, arguments = new Object[]{this.getTitle()});
            int res = JOptionPane.showConfirmDialog(this.plp, message, title = guistrings.getString("PLWINDOW_Unsaved_changes_title"), 1, -1);
            if (res == 2) {
                return;
            }
            if (res == 0) {
                try {
                    this.doMenuCommand(MenuCommand.FILE_SAVE);
                }
                catch (JuggleException je) {
                    ErrorDialog.handleFatalException(je);
                    return;
                }
                if (this.plp.hasUnsavedChanges) {
                    return;
                }
            }
        }
        super.dispose();
        SwingUtilities.invokeLater(new Runnable(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void run() {
                ApplicationWindow.updateWindowMenus();
            }
        });
    }

    static {
        fileItems = new String[]{"New Pattern", "New Pattern List", "Open JML...", "Save JML As...", "Save Text As...", null, "Close"};
        fileCommands = new String[]{"newpat", "newpl", "open", "saveas", "savetext", null, "close"};
        fileShortcuts = new char[]{'N', 'L', 'O', 'S', 'T', ' ', 'W'};
        helpItems = new String[]{"About Juggling Lab", "Juggling Lab Online Help"};
        helpCommands = new String[]{"about", "online"};
    }

    protected static enum MenuCommand {
        FILE_NONE,
        FILE_NEWPAT,
        FILE_NEWPL,
        FILE_OPEN,
        FILE_CLOSE,
        FILE_SAVE,
        FILE_SAVETEXT,
        HELP_ABOUT,
        HELP_ONLINE;

    }
}

