/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.core;

import java.awt.Color;
import java.awt.ComponentOrientation;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.filechooser.FileNameExtensionFilter;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.AnimationPrefsDialog;
import jugglinglab.core.ApplicationWindow;
import jugglinglab.core.PatternListWindow;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.EditView;
import jugglinglab.view.PatternView;
import jugglinglab.view.SelectionView;
import jugglinglab.view.SimpleView;
import jugglinglab.view.View;

public class PatternWindow
extends JFrame
implements ActionListener {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected static final double MAX_ZOOM = 3.0;
    protected static final double MIN_ZOOM = 0.25;
    protected static final double ZOOM_PER_STEP = 1.1;
    protected static boolean exit_on_last_close;
    protected static final int NUM_TILES = 8;
    protected static final Point TILE_START;
    protected static final Point TILE_OFFSET;
    protected static Point[] tile_locations;
    protected static int next_tile_num;
    protected static Class<?> optimizer;
    protected static boolean optimizer_loaded;
    protected View view;
    protected JMenu viewmenu;
    protected JMenu windowmenu;
    protected ArrayList<JMLPattern> undo = new ArrayList();
    protected String last_jml_filename;
    protected static final String[] fileItems;
    protected static final String[] fileCommands;
    protected static final char[] fileShortcuts;
    protected static final String[] viewItems;
    protected static final String[] viewCommands;
    protected static final char[] viewShortcuts;
    protected static final String[] helpItems;
    protected static final String[] helpCommands;

    public PatternWindow(String title, JMLPattern pat, AnimationPrefs jc) throws JuggleExceptionUser, JuggleExceptionInternal {
        super(title);
        PatternWindow.loadOptimizer();
        this.createMenus();
        this.createInitialView(pat, jc);
        this.view.addToUndoList(pat);
        this.setLocation(PatternWindow.getNextScreenLocation());
        this.setVisible(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(this){
            final /* synthetic */ PatternWindow this$0;
            {
                PatternWindow patternWindow = this$0;
                Objects.requireNonNull(patternWindow);
                this.this$0 = patternWindow;
            }

            @Override
            public void windowClosing(WindowEvent e) {
                try {
                    this.this$0.doMenuCommand(MenuCommand.FILE_CLOSE);
                }
                catch (JuggleException je) {
                    ErrorDialog.handleFatalException(je);
                }
            }
        });
        this.addMouseWheelListener(new MouseWheelListener(this){
            final /* synthetic */ PatternWindow this$0;
            {
                PatternWindow patternWindow = this$0;
                Objects.requireNonNull(patternWindow);
                this.this$0 = patternWindow;
            }

            @Override
            public void mouseWheelMoved(MouseWheelEvent mwe) {
                mwe.consume();
                try {
                    if (mwe.getWheelRotation() > 0) {
                        this.this$0.doMenuCommand(MenuCommand.VIEW_ZOOMIN);
                    } else if (mwe.getWheelRotation() < 0) {
                        this.this$0.doMenuCommand(MenuCommand.VIEW_ZOOMOUT);
                    }
                }
                catch (JuggleException je) {
                    ErrorDialog.handleFatalException(je);
                }
            }
        });
        SwingUtilities.invokeLater(new Runnable(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void run() {
                ApplicationWindow.updateWindowMenus();
            }
        });
    }

    protected PatternWindow(PatternWindow pw) throws JuggleExceptionUser, JuggleExceptionInternal {
        this(pw.getTitle(), new JMLPattern(pw.view.getPattern()), new AnimationPrefs(pw.view.getAnimationPrefs()));
    }

    protected void createInitialView(JMLPattern pat, AnimationPrefs jc) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (jc == null) {
            jc = new AnimationPrefs();
        }
        int mode = 2;
        if (jc.view != 0) {
            mode = jc.view;
        } else if (pat.getNumberOfJugglers() > 8) {
            mode = 1;
        }
        this.viewmenu.getItem(mode - 1).setSelected(true);
        Dimension animsize = new Dimension(jc.width, jc.height);
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                this.view = new SimpleView(animsize);
                break;
            }
            case 2: {
                this.view = new EditView(animsize, pat);
                break;
            }
            case 3: {
                this.view = new PatternView(animsize);
                break;
            }
            case 4: {
                this.view = new SelectionView(animsize);
            }
        }
        if (this.view == null) {
            throw new JuggleExceptionInternal("createInitialView: problem creating view");
        }
        this.view.setParent(this);
        this.view.setOpaque(true);
        this.view.setDoubleBuffered(true);
        this.setContentPane(this.view);
        Locale loc = Locale.getDefault();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        this.setBackground(Color.white);
        this.pack();
        this.view.restartView(pat, jc);
        this.view.setUndoList(this.undo, -1);
    }

    protected void setViewMode(int mode) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (this.view == null) {
            throw new JuggleExceptionInternal("setViewMode called with no prior view");
        }
        this.viewmenu.getItem(mode - 1).setSelected(true);
        JMLPattern pat = this.view.getPattern();
        AnimationPrefs jc = this.view.getAnimationPrefs();
        boolean paused = this.view.isPaused();
        int undo_index = this.view.getUndoIndex();
        View newview = null;
        Dimension animsize = new Dimension(jc.width, jc.height);
        switch (mode) {
            case 0: {
                break;
            }
            case 1: {
                newview = new SimpleView(animsize);
                break;
            }
            case 2: {
                newview = new EditView(animsize, pat);
                break;
            }
            case 3: {
                newview = new PatternView(animsize);
                break;
            }
            case 4: {
                newview = new SelectionView(animsize);
            }
        }
        if (newview == null) {
            throw new JuggleExceptionInternal("setViewMode: problem creating view");
        }
        newview.setParent(this);
        newview.setPaused(paused);
        newview.setOpaque(true);
        newview.setDoubleBuffered(true);
        this.setContentPane(newview);
        if (this.isWindowMaximized()) {
            this.validate();
        } else {
            this.pack();
        }
        newview.restartView(pat, jc);
        newview.setUndoList(this.undo, undo_index);
        this.view.disposeView();
        this.view = newview;
    }

    public int getViewMode() {
        if (this.view == null) {
            return 0;
        }
        if (this.view instanceof SimpleView) {
            return 1;
        }
        if (this.view instanceof EditView) {
            return 2;
        }
        if (this.view instanceof PatternView) {
            return 3;
        }
        if (this.view instanceof SelectionView) {
            return 4;
        }
        return 0;
    }

    public JMLPattern getPattern() {
        return this.view == null ? null : this.view.getPattern();
    }

    public AnimationPrefs getAnimationPrefs() {
        return this.view == null ? null : this.view.getAnimationPrefs();
    }

    protected int getHashCode() {
        return this.view == null ? 0 : this.view.getHashCode();
    }

    public boolean isWindowMaximized() {
        return (this.getExtendedState() & 6) != 0;
    }

    public void setJMLFilename(String fname) {
        this.last_jml_filename = fname;
    }

    protected static void loadOptimizer() {
        if (optimizer_loaded) {
            return;
        }
        try {
            optimizer = Class.forName("jugglinglab.optimizer.Optimizer");
            Method optimizerAvailable = optimizer.getMethod("optimizerAvailable", new Class[0]);
            Boolean canOptimize = (Boolean)optimizerAvailable.invoke(null, new Object[0]);
            if (!canOptimize.booleanValue()) {
                optimizer = null;
            }
        }
        catch (Exception e) {
            optimizer = null;
        }
        optimizer_loaded = true;
    }

    protected static Point getNextScreenLocation() {
        if (tile_locations == null) {
            tile_locations = new Point[8];
            Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
            int locx = Math.max(0, center.x - 600);
            for (int i = 0; i < 8; ++i) {
                int loc_x = locx + PatternWindow.TILE_START.x + i * PatternWindow.TILE_OFFSET.x;
                int loc_y = PatternWindow.TILE_START.y + i * PatternWindow.TILE_OFFSET.y;
                PatternWindow.tile_locations[i] = new Point(loc_x, loc_y);
            }
            next_tile_num = 0;
        }
        Point loc = tile_locations[next_tile_num];
        if (++next_tile_num == 8) {
            next_tile_num = 0;
        }
        return loc;
    }

    public static boolean bringToFront(int hash) {
        for (Frame fr : Frame.getFrames()) {
            PatternWindow pw;
            if (!(fr instanceof PatternWindow) || !fr.isVisible() || (pw = (PatternWindow)fr).getHashCode() != hash) continue;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    pw.toFront();
                }
            });
            return true;
        }
        return false;
    }

    public static void setExitOnLastClose(boolean value) {
        exit_on_last_close = value;
    }

    protected void createMenus() {
        JMenuBar mb = new JMenuBar();
        mb.add(this.createFileMenu());
        mb.add(this.createViewMenu());
        this.windowmenu = new JMenu(guistrings.getString("Window"));
        mb.add(this.windowmenu);
        mb.add(this.createHelpMenu());
        this.setJMenuBar(mb);
    }

    protected JMenu createFileMenu() {
        JMenu filemenu = new JMenu(guistrings.getString("File"));
        for (int i = 0; i < fileItems.length; ++i) {
            if (fileItems[i] == null) {
                filemenu.addSeparator();
                continue;
            }
            JMenuItem fileitem = new JMenuItem(guistrings.getString(fileItems[i].replace(' ', '_')));
            if (fileShortcuts[i] != ' ') {
                fileitem.setAccelerator(KeyStroke.getKeyStroke((int)fileShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
            }
            fileitem.setActionCommand(fileCommands[i]);
            fileitem.addActionListener(this);
            filemenu.add(fileitem);
            if (!fileCommands[i].equals("optimize") || optimizer != null) continue;
            fileitem.setEnabled(false);
        }
        return filemenu;
    }

    protected JMenu createViewMenu() {
        this.viewmenu = new JMenu(guistrings.getString("View"));
        ButtonGroup buttonGroup = new ButtonGroup();
        boolean addingviews = true;
        for (int i = 0; i < viewItems.length; ++i) {
            JMenuItem viewitem;
            if (viewItems[i] == null) {
                this.viewmenu.addSeparator();
                addingviews = false;
                continue;
            }
            if (addingviews) {
                viewitem = new JRadioButtonMenuItem(guistrings.getString(viewItems[i].replace(' ', '_')));
                if (viewShortcuts[i] != ' ') {
                    viewitem.setAccelerator(KeyStroke.getKeyStroke((int)viewShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
                }
                viewitem.setActionCommand(viewCommands[i]);
                viewitem.addActionListener(this);
                this.viewmenu.add(viewitem);
                buttonGroup.add(viewitem);
                continue;
            }
            viewitem = new JMenuItem(guistrings.getString(viewItems[i].replace(' ', '_')));
            if (viewShortcuts[i] != ' ') {
                viewitem.setAccelerator(KeyStroke.getKeyStroke((int)viewShortcuts[i], Toolkit.getDefaultToolkit().getMenuShortcutKeyMaskEx()));
            }
            viewitem.setActionCommand(viewCommands[i]);
            viewitem.addActionListener(this);
            this.viewmenu.add(viewitem);
        }
        return this.viewmenu;
    }

    public void updateUndoMenu() {
        if (this.view == null || this.viewmenu == null) {
            return;
        }
        int undo_index = this.view.getUndoIndex();
        boolean undo_enabled = undo_index > 0;
        boolean redo_enabled = undo_index < this.undo.size() - 1;
        for (int i = 0; i < this.viewmenu.getItemCount(); ++i) {
            JMenuItem jmi = this.viewmenu.getItem(i);
            if (jmi == null || jmi.getActionCommand() == null) continue;
            if (jmi.getActionCommand().equals("undo")) {
                jmi.setEnabled(undo_enabled);
                continue;
            }
            if (!jmi.getActionCommand().equals("redo")) continue;
            jmi.setEnabled(redo_enabled);
        }
    }

    public JMenu getWindowMenu() {
        return this.windowmenu;
    }

    protected JMenu createHelpMenu() {
        int i;
        boolean include_about = !Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.APP_ABOUT);
        Object menuname = guistrings.getString("Help");
        if (JugglingLab.isMacOS) {
            menuname = (String)menuname + " ";
        }
        JMenu helpmenu = new JMenu((String)menuname);
        int n = i = include_about ? 0 : 1;
        while (i < helpItems.length) {
            if (helpItems[i] == null) {
                helpmenu.addSeparator();
            } else {
                JMenuItem helpitem = new JMenuItem(guistrings.getString(helpItems[i].replace(' ', '_')));
                helpitem.setActionCommand(helpCommands[i]);
                helpitem.addActionListener(this);
                helpmenu.add(helpitem);
            }
            ++i;
        }
        return helpmenu;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        try {
            if (command.equals("newpat")) {
                this.doMenuCommand(MenuCommand.FILE_NEWPAT);
            } else if (command.equals("newpl")) {
                this.doMenuCommand(MenuCommand.FILE_NEWPL);
            } else if (command.equals("open")) {
                this.doMenuCommand(MenuCommand.FILE_OPEN);
            } else if (command.equals("close")) {
                this.doMenuCommand(MenuCommand.FILE_CLOSE);
            } else if (command.equals("saveas")) {
                this.doMenuCommand(MenuCommand.FILE_SAVE);
            } else if (command.equals("savegifanim")) {
                this.doMenuCommand(MenuCommand.FILE_GIFSAVE);
            } else if (command.equals("duplicate")) {
                this.doMenuCommand(MenuCommand.FILE_DUPLICATE);
            } else if (command.equals("optimize")) {
                this.doMenuCommand(MenuCommand.FILE_OPTIMIZE);
            } else if (command.equals("swaphands")) {
                this.doMenuCommand(MenuCommand.FILE_SWAPHANDS);
            } else if (command.equals("invertx")) {
                this.doMenuCommand(MenuCommand.FILE_INVERTX);
            } else if (command.equals("inverttime")) {
                this.doMenuCommand(MenuCommand.FILE_INVERTTIME);
            } else if (command.equals("restart")) {
                this.doMenuCommand(MenuCommand.VIEW_RESTART);
            } else if (command.equals("prefs")) {
                this.doMenuCommand(MenuCommand.VIEW_ANIMPREFS);
            } else if (command.equals("undo")) {
                this.doMenuCommand(MenuCommand.VIEW_UNDO);
            } else if (command.equals("redo")) {
                this.doMenuCommand(MenuCommand.VIEW_REDO);
            } else if (command.equals("zoomin")) {
                this.doMenuCommand(MenuCommand.VIEW_ZOOMIN);
            } else if (command.equals("zoomout")) {
                this.doMenuCommand(MenuCommand.VIEW_ZOOMOUT);
            } else if (command.equals("simple")) {
                if (this.getViewMode() != 1) {
                    this.setViewMode(1);
                }
            } else if (command.equals("visual_edit")) {
                if (this.getViewMode() != 2) {
                    this.setViewMode(2);
                }
            } else if (command.equals("pattern_edit")) {
                if (this.getViewMode() != 3) {
                    this.setViewMode(3);
                }
            } else if (command.equals("selection_edit")) {
                if (this.getViewMode() != 4) {
                    this.setViewMode(4);
                }
            } else if (command.equals("about")) {
                this.doMenuCommand(MenuCommand.HELP_ABOUT);
            } else if (command.equals("online")) {
                this.doMenuCommand(MenuCommand.HELP_ONLINE);
            }
        }
        catch (JuggleExceptionUser je) {
            new ErrorDialog(this, je.getMessage());
        }
        catch (JuggleExceptionInternal jei) {
            ErrorDialog.handleFatalException(jei);
        }
    }

    protected void doMenuCommand(MenuCommand action) throws JuggleExceptionUser, JuggleExceptionInternal {
        switch (action.ordinal()) {
            case 0: {
                break;
            }
            case 1: {
                ApplicationWindow.newPattern();
                break;
            }
            case 2: {
                new PatternListWindow("").setTitle(null);
                break;
            }
            case 3: {
                ApplicationWindow.openJMLFile();
                break;
            }
            case 4: {
                this.dispose();
                if (!exit_on_last_close) break;
                int window_count = 0;
                for (Frame fr : Frame.getFrames()) {
                    if (!(fr instanceof PatternWindow) || !fr.isVisible()) continue;
                    ++window_count;
                }
                if (window_count != 0) break;
                System.exit(0);
                break;
            }
            case 5: {
                File f;
                if (this.view == null) break;
                if (!this.view.getPattern().isValid()) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_saving_invalid_pattern"));
                }
                Object fname = this.last_jml_filename;
                if (fname == null) {
                    fname = this.getTitle() + ".jml";
                }
                fname = JLFunc.sanitizeFilename((String)fname);
                JLFunc.jfc().setSelectedFile(new File((String)fname));
                JLFunc.jfc().setFileFilter(new FileNameExtensionFilter("JML file", "jml"));
                if (JLFunc.jfc().showSaveDialog(this) != 0 || (f = JLFunc.jfc().getSelectedFile()) == null) break;
                if (!f.getAbsolutePath().endsWith(".jml")) {
                    f = new File(f.getAbsolutePath() + ".jml");
                }
                JLFunc.errorIfNotSanitized(f.getName());
                this.last_jml_filename = f.getName();
                try {
                    FileWriter fw = new FileWriter(f);
                    this.view.getPattern().writeJML(fw, true, true);
                    fw.close();
                    break;
                }
                catch (FileNotFoundException fnfe) {
                    throw new JuggleExceptionInternal("FileNotFound: " + fnfe.getMessage());
                }
                catch (IOException ioe) {
                    throw new JuggleExceptionInternal("IOException: " + ioe.getMessage());
                }
            }
            case 6: {
                File f;
                if (this.view == null) break;
                Object fname = this.last_jml_filename;
                if (fname != null) {
                    int index = ((String)fname).lastIndexOf(".");
                    Object base = index >= 0 ? ((String)fname).substring(0, index) : fname;
                    fname = (String)base + ".gif";
                } else {
                    fname = this.getTitle() + ".gif";
                }
                fname = JLFunc.sanitizeFilename((String)fname);
                JLFunc.jfc().setSelectedFile(new File((String)fname));
                JLFunc.jfc().setFileFilter(new FileNameExtensionFilter("GIF file", "gif"));
                if (JLFunc.jfc().showSaveDialog(this) != 0 || (f = JLFunc.jfc().getSelectedFile()) == null) break;
                if (!f.getAbsolutePath().endsWith(".gif")) {
                    f = new File(f.getAbsolutePath() + ".gif");
                }
                JLFunc.errorIfNotSanitized(f.getName());
                int index = f.getName().lastIndexOf(".");
                String base = index >= 0 ? f.getName().substring(0, index) : f.getName();
                this.last_jml_filename = base + ".jml";
                this.view.writeGIF(f);
                break;
            }
            case 7: {
                new PatternWindow(this);
                break;
            }
            case 8: {
                if (optimizer == null || this.view == null) break;
                try {
                    Method optimize = optimizer.getMethod("optimize", JMLPattern.class);
                    JMLPattern pat = this.view.getPattern();
                    JMLPattern new_pat = (JMLPattern)optimize.invoke(null, pat);
                    this.view.restartView(new_pat, null);
                    this.view.addToUndoList(new_pat);
                    break;
                }
                catch (JuggleExceptionUser jeu) {
                    throw new JuggleExceptionInternal("optimizer jeu: " + jeu.getMessage());
                }
                catch (InvocationTargetException ite) {
                    Throwable ex = ite.getCause();
                    if (ex instanceof JuggleExceptionUser) {
                        throw (JuggleExceptionUser)ex;
                    }
                    if (ex instanceof JuggleExceptionInternal) {
                        throw (JuggleExceptionInternal)ex;
                    }
                    throw new JuggleExceptionInternal("optimizer unknown ite: " + ex.getMessage());
                }
                catch (NoSuchMethodException nsme) {
                    throw new JuggleExceptionInternal("optimizer nsme: " + nsme.getMessage());
                }
                catch (IllegalAccessException iae) {
                    throw new JuggleExceptionInternal("optimizer iae: " + iae.getMessage());
                }
            }
            case 9: {
                if (this.view == null) break;
                try {
                    JMLPattern newpat = new JMLPattern(this.view.getPattern());
                    newpat.swapHands();
                    this.view.restartView(newpat, null);
                    this.view.addToUndoList(newpat);
                    break;
                }
                catch (JuggleExceptionUser jeu) {
                    throw new JuggleExceptionInternal("Error in FILE_SWAPHANDS");
                }
            }
            case 10: {
                if (this.view == null) break;
                try {
                    JMLPattern newpat = new JMLPattern(this.view.getPattern());
                    newpat.invertXAxis();
                    this.view.restartView(newpat, null);
                    this.view.addToUndoList(newpat);
                    break;
                }
                catch (JuggleExceptionUser jeu) {
                    throw new JuggleExceptionInternal("Error in FILE_INVERTX");
                }
            }
            case 11: {
                if (this.view == null) break;
                try {
                    JMLPattern newpat = new JMLPattern(this.view.getPattern());
                    newpat.invertTime();
                    this.view.restartView(newpat, null);
                    this.view.addToUndoList(newpat);
                    break;
                }
                catch (JuggleExceptionUser jeu) {
                    throw new JuggleExceptionInternal("Error in FILE_INVERTTIME");
                }
            }
            case 12: {
                if (this.view == null) break;
                this.view.restartView();
                break;
            }
            case 13: {
                AnimationPrefs jc;
                AnimationPrefsDialog japd;
                AnimationPrefs newjc;
                if (this.view == null || (newjc = (japd = new AnimationPrefsDialog(this)).getPrefs(jc = this.view.getAnimationPrefs())) == jc) break;
                this.view.restartView(null, newjc);
                if (newjc.width == jc.width && newjc.height == jc.height) break;
                if (this.isWindowMaximized()) {
                    this.validate();
                    break;
                }
                this.pack();
                break;
            }
            case 14: {
                if (this.view == null) break;
                this.view.undoEdit();
                break;
            }
            case 15: {
                if (this.view == null) break;
                this.view.redoEdit();
                break;
            }
            case 16: {
                if (this.view == null || !(this.view.getZoomLevel() < 2.727272727272727)) break;
                this.view.setZoomLevel(1.1 * this.view.getZoomLevel());
                break;
            }
            case 17: {
                if (this.view == null || !(this.view.getZoomLevel() > 0.275)) break;
                this.view.setZoomLevel(this.view.getZoomLevel() / 1.1);
                break;
            }
            case 18: {
                ApplicationWindow.showAboutBox();
                break;
            }
            case 19: {
                ApplicationWindow.showOnlineHelp();
            }
        }
    }

    @Override
    public void setTitle(String title) {
        if (title == null || title.length() == 0) {
            title = guistrings.getString("PWINDOW_Default_window_title");
        }
        super.setTitle(title);
        ApplicationWindow.updateWindowMenus();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.view != null) {
            this.view.disposeView();
            this.view = null;
        }
        SwingUtilities.invokeLater(new Runnable(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void run() {
                ApplicationWindow.updateWindowMenus();
            }
        });
    }

    static {
        TILE_START = new Point(420, 50);
        TILE_OFFSET = new Point(25, 25);
        fileItems = new String[]{"New Pattern", "New Pattern List", "Open JML...", "Save JML As...", "Save Animated GIF As...", null, "Duplicate", "Optimize", "Swap Hands", "Flip Pattern in X", "Flip Pattern in Time", null, "Close"};
        fileCommands = new String[]{"newpat", "newpl", "open", "saveas", "savegifanim", null, "duplicate", "optimize", "swaphands", "invertx", "inverttime", null, "close"};
        fileShortcuts = new char[]{'N', 'L', 'O', 'S', 'G', ' ', 'D', 'J', ' ', 'M', 'T', ' ', 'W'};
        viewItems = new String[]{"Simple", "Visual Editor", "Pattern Editor", "Selection Editor", null, "Undo", "Redo", null, "Restart", "Animation Preferences...", "Zoom In", "Zoom Out"};
        viewCommands = new String[]{"simple", "visual_edit", "pattern_edit", "selection_edit", null, "undo", "redo", null, "restart", "prefs", "zoomin", "zoomout"};
        viewShortcuts = new char[]{'1', '2', '3', '4', ' ', 'Z', 'Y', ' ', ' ', 'P', '=', '-'};
        helpItems = new String[]{"About Juggling Lab", "Juggling Lab Online Help"};
        helpCommands = new String[]{"about", "online"};
    }

    protected static enum MenuCommand {
        FILE_NONE,
        FILE_NEWPAT,
        FILE_NEWPL,
        FILE_OPEN,
        FILE_CLOSE,
        FILE_SAVE,
        FILE_GIFSAVE,
        FILE_DUPLICATE,
        FILE_OPTIMIZE,
        FILE_SWAPHANDS,
        FILE_INVERTX,
        FILE_INVERTTIME,
        VIEW_RESTART,
        VIEW_ANIMPREFS,
        VIEW_UNDO,
        VIEW_REDO,
        VIEW_ZOOMIN,
        VIEW_ZOOMOUT,
        HELP_ABOUT,
        HELP_ONLINE;

    }
}

