/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.curve;

import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;

public abstract class Curve {
    public static final int CURVE_SPLINE = 1;
    public static final int CURVE_LINE = 2;
    protected int numpoints;
    protected double[] times;
    protected Coordinate[] positions;
    protected Coordinate[] velocities;

    public abstract void calcCurve() throws JuggleExceptionInternal;

    public abstract void getCoordinate(double var1, Coordinate var3);

    protected abstract Coordinate getMax2(double var1, double var3);

    protected abstract Coordinate getMin2(double var1, double var3);

    public void setCurve(double[] times, Coordinate[] positions, Coordinate[] velocities) throws JuggleExceptionInternal {
        this.numpoints = times.length;
        this.times = times;
        this.positions = positions;
        this.velocities = velocities;
        if (this.numpoints != positions.length || this.numpoints != velocities.length) {
            throw new JuggleExceptionInternal("Curve error 1");
        }
    }

    public double getStartTime() {
        return this.times[0];
    }

    public double getEndTime() {
        return this.times[this.numpoints - 1];
    }

    public double getDuration() {
        return this.times[this.numpoints - 1] - this.times[0];
    }

    public void translateTime(double deltat) {
        int i = 0;
        while (i < this.numpoints) {
            int n = i++;
            this.times[n] = this.times[n] + deltat;
        }
    }

    public Coordinate getMax() {
        return this.getMax2(this.times[0], this.times[this.numpoints - 1]);
    }

    public Coordinate getMin() {
        return this.getMin2(this.times[0], this.times[this.numpoints - 1]);
    }

    public Coordinate getMax(double begin, double end) {
        if (end < this.getStartTime() || begin > this.getEndTime()) {
            return null;
        }
        return this.getMax2(begin, end);
    }

    public Coordinate getMin(double begin, double end) {
        if (end < this.getStartTime() || begin > this.getEndTime()) {
            return null;
        }
        return this.getMin2(begin, end);
    }

    protected Coordinate check(Coordinate result, double t, boolean findmax) {
        Coordinate loc = new Coordinate();
        this.getCoordinate(t, loc);
        result = findmax ? Coordinate.max(result, loc) : Coordinate.min(result, loc);
        return result;
    }
}

