/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.curve;

import jugglinglab.curve.Curve;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;

public class LineCurve
extends Curve {
    protected int n;
    protected double[][] a;
    protected double[][] b;
    protected double[] durations;

    @Override
    public void calcCurve() throws JuggleExceptionInternal {
        this.n = this.numpoints - 1;
        if (this.n < 1) {
            throw new JuggleExceptionInternal("LineCurve error 1");
        }
        this.a = new double[this.n][3];
        this.b = new double[this.n][3];
        this.durations = new double[this.n];
        for (int i = 0; i < this.n; ++i) {
            this.durations[i] = this.times[i + 1] - this.times[i];
            if (!(this.durations[i] <= 0.0)) continue;
            throw new JuggleExceptionInternal("LineCurve error 2");
        }
        double[] x = new double[this.n + 1];
        for (int i = 0; i < 3; ++i) {
            int j;
            for (j = 0; j < this.n + 1; ++j) {
                x[j] = this.positions[j].getIndex(i);
            }
            for (j = 0; j < this.n; ++j) {
                this.a[j][i] = x[j];
                this.b[j][i] = (x[j + 1] - x[j]) / this.durations[j];
            }
        }
    }

    @Override
    public void getCoordinate(double time, Coordinate newPosition) {
        int i;
        if (time < this.times[0] || time > this.times[this.n]) {
            return;
        }
        for (i = 0; i < this.n && !(time <= this.times[i + 1]); ++i) {
        }
        if (i == this.n) {
            i = this.n - 1;
        }
        newPosition.setCoordinate(this.a[i][0] + (time -= this.times[i]) * this.b[i][0], this.a[i][1] + time * this.b[i][1], this.a[i][2] + time * this.b[i][2]);
    }

    @Override
    protected Coordinate getMax2(double begin, double end) {
        if (end < this.times[0] || begin > this.times[this.n]) {
            return null;
        }
        Coordinate result = null;
        double tlow = Math.max(this.times[0], begin);
        double thigh = Math.min(this.times[this.n], end);
        result = this.check(result, tlow, true);
        result = this.check(result, thigh, true);
        for (int i = 0; i <= this.n; ++i) {
            double thightemp;
            double tlowtemp;
            if (tlow <= this.times[i] && this.times[i] <= thigh) {
                result = this.check(result, this.times[i], true);
            }
            if (i == this.n || !((tlowtemp = Math.max(tlow, this.times[i])) < (thightemp = Math.min(thigh, this.times[i + 1])))) continue;
            result = this.check(result, tlowtemp, true);
            result = this.check(result, thightemp, true);
        }
        return result;
    }

    @Override
    protected Coordinate getMin2(double begin, double end) {
        if (end < this.times[0] || begin > this.times[this.n]) {
            return null;
        }
        Coordinate result = null;
        double tlow = Math.max(this.times[0], begin);
        double thigh = Math.min(this.times[this.n], end);
        result = this.check(result, tlow, false);
        result = this.check(result, thigh, false);
        for (int i = 0; i <= this.n; ++i) {
            double thightemp;
            double tlowtemp;
            if (tlow <= this.times[i] && this.times[i] <= thigh) {
                result = this.check(result, this.times[i], false);
            }
            if (i == this.n || !((tlowtemp = Math.max(tlow, this.times[i])) < (thightemp = Math.min(thigh, this.times[i + 1])))) continue;
            result = this.check(result, tlowtemp, false);
            result = this.check(result, thightemp, false);
        }
        return result;
    }
}

