/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.curve;

import jugglinglab.curve.Curve;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.RealVector;
import org.apache.commons.math3.linear.SingularMatrixException;

public class SplineCurve
extends Curve {
    protected int n;
    protected double[][] a;
    protected double[][] b;
    protected double[][] c;
    protected double[][] d;
    public static final int MINIMIZE_RMSACCEL = 0;
    public static final int CONTINUOUS_ACCEL = 1;
    public static final int MINIMIZE_RMSVEL = 2;

    @Override
    public void calcCurve() throws JuggleExceptionInternal {
        int i;
        this.n = this.numpoints - 1;
        if (this.n < 1) {
            throw new JuggleExceptionInternal("SplineCurve error 1");
        }
        this.a = new double[this.n][3];
        this.b = new double[this.n][3];
        this.c = new double[this.n][3];
        this.d = new double[this.n][3];
        double[] durations = new double[this.n];
        for (int i2 = 0; i2 < this.n; ++i2) {
            durations[i2] = this.times[i2 + 1] - this.times[i2];
            if (!(durations[i2] <= 0.0)) continue;
            throw new JuggleExceptionInternal("SplineCurve error 2");
        }
        Coordinate[] vel = new Coordinate[this.n + 1];
        for (i = 0; i < this.n + 1; ++i) {
            vel[i] = this.velocities[i] == null ? null : new Coordinate(this.velocities[i]);
        }
        if (vel[0] != null && vel[this.n] != null) {
            SplineCurve.findvels_edges_known(this.n, durations, this.positions, vel);
        } else {
            SplineCurve.findvels_edges_unknown(this.n, durations, this.positions, vel);
        }
        for (i = 0; i < this.n; ++i) {
            double t = durations[i];
            for (int j = 0; j < 3; ++j) {
                double xi0 = this.positions[i].getIndex(j);
                double xi1 = this.positions[i + 1].getIndex(j);
                double vi0 = vel[i].getIndex(j);
                double vi1 = vel[i + 1].getIndex(j);
                this.a[i][j] = xi0;
                this.b[i][j] = vi0;
                this.c[i][j] = (3.0 * (xi1 - xi0) - (vi1 + 2.0 * vi0) * t) / (t * t);
                this.d[i][j] = (-2.0 * (xi1 - xi0) + (vi1 + vi0) * t) / (t * t * t);
            }
        }
    }

    protected static void findvels_edges_known(int n, double[] t, Coordinate[] x, Coordinate[] v) throws JuggleExceptionInternal {
        if (n < 2) {
            return;
        }
        int numcatches = 0;
        for (int i = 1; i < n; ++i) {
            if (v[i] == null) continue;
            ++numcatches;
        }
        int dim = 3 * (n - 1) + 2 * numcatches;
        double[][] m = new double[dim][dim];
        double[] b = new double[dim];
        for (int axis = 0; axis < 3; ++axis) {
            double v0 = v[0].getIndex(axis);
            double vn = v[n].getIndex(axis);
            block13: for (int i = 0; i < n - 1; ++i) {
                double xi0 = x[i].getIndex(axis);
                double xi1 = x[i + 1].getIndex(axis);
                double xi2 = x[i + 2].getIndex(axis);
                int index = i + axis * (n - 1);
                switch (0) {
                    case 0: 
                    case 1: {
                        double offdiag1;
                        m[index][index] = 2.0 / t[i] + 2.0 / t[i + 1];
                        double d = offdiag1 = i == n - 2 ? 0.0 : 1.0 / t[i + 1];
                        if (index < 3 * (n - 1) - 1) {
                            m[index][index + 1] = offdiag1;
                            m[index + 1][index] = offdiag1;
                        }
                        b[index] = 3.0 * (xi2 - xi1) / (t[i + 1] * t[i + 1]) + 3.0 * (xi1 - xi0) / (t[i] * t[i]);
                        if (i == 0) {
                            int n2 = index;
                            b[n2] = b[n2] - v0 / t[0];
                        }
                        if (i != n - 2) continue block13;
                        int n3 = index;
                        b[n3] = b[n3] - vn / t[n - 1];
                        continue block13;
                    }
                    case 2: {
                        double offdiag2;
                        m[index][index] = 4.0 * (t[i] + t[i + 1]);
                        double d = offdiag2 = i == n - 2 ? 0.0 : -t[i + 1];
                        if (index < 3 * (n - 1) - 1) {
                            m[index][index + 1] = offdiag2;
                            m[index + 1][index] = offdiag2;
                        }
                        b[index] = 3.0 * (xi2 - xi0);
                        if (i == 0) {
                            int n4 = index;
                            b[n4] = b[n4] + v0 * t[0];
                        }
                        if (i != n - 2) continue block13;
                        int n5 = index;
                        b[n5] = b[n5] + vn * t[n - 1];
                    }
                }
            }
        }
        int catchnum = 0;
        for (int i = 0; i < n - 1; ++i) {
            if (v[i + 1] == null) continue;
            int index = 3 * (n - 1) + 2 * catchnum;
            double ci0 = v[i + 1].getIndex(0);
            double ci1 = v[i + 1].getIndex(1);
            double ci2 = v[i + 1].getIndex(2);
            int largeaxis = 0;
            if (Math.abs(ci1) >= Math.max(Math.abs(ci0), Math.abs(ci2))) {
                largeaxis = 1;
            } else if (Math.abs(ci2) >= Math.max(Math.abs(ci0), Math.abs(ci1))) {
                largeaxis = 2;
            }
            switch (largeaxis) {
                case 0: {
                    double d = ci2;
                    m[index][i] = d;
                    m[i][index] = d;
                    double d2 = ci1;
                    m[index + 1][i] = d2;
                    m[i][index + 1] = d2;
                    double d3 = -ci0;
                    m[index + 1][i + (n - 1)] = d3;
                    m[i + (n - 1)][index + 1] = d3;
                    double d4 = -ci0;
                    m[index][i + 2 * (n - 1)] = d4;
                    m[i + 2 * (n - 1)][index] = d4;
                    break;
                }
                case 1: {
                    double d = ci1;
                    m[index + 1][i] = d;
                    m[i][index + 1] = d;
                    double d5 = ci2;
                    m[index][i + (n - 1)] = d5;
                    m[i + (n - 1)][index] = d5;
                    double d6 = -ci0;
                    m[index + 1][i + (n - 1)] = d6;
                    m[i + (n - 1)][index + 1] = d6;
                    double d7 = -ci1;
                    m[index][i + 2 * (n - 1)] = d7;
                    m[i + 2 * (n - 1)][index] = d7;
                    break;
                }
                case 2: {
                    double d = ci2;
                    m[index + 1][i] = d;
                    m[i][index + 1] = d;
                    double d8 = ci2;
                    m[index][i + (n - 1)] = d8;
                    m[i + (n - 1)][index] = d8;
                    double d9 = -ci1;
                    m[index][i + 2 * (n - 1)] = d9;
                    m[i + 2 * (n - 1)][index] = d9;
                    double d10 = -ci0;
                    m[index + 1][i + 2 * (n - 1)] = d10;
                    m[i + 2 * (n - 1)][index + 1] = d10;
                }
            }
            ++catchnum;
        }
        try {
            DecompositionSolver solver = new LUDecomposition(new Array2DRowRealMatrix(m)).getSolver();
            RealVector solution = solver.solve(new ArrayRealVector(b));
            for (int i = 0; i < n - 1; ++i) {
                v[i + 1] = new Coordinate(solution.getEntry(i), solution.getEntry(i + (n - 1)), solution.getEntry(i + 2 * (n - 1)));
            }
        }
        catch (SingularMatrixException sme) {
            throw new JuggleExceptionInternal("Singular matrix in findvels_edges_known()");
        }
    }

    protected static void findvels_edges_unknown(int n, double[] t, Coordinate[] x, Coordinate[] v) throws JuggleExceptionInternal {
        if (n < 1) {
            return;
        }
        double[] Adiag = new double[n];
        double[] Aoffd = new double[n];
        double Acorner = 0.0;
        double[] b = new double[n];
        for (int i = 0; i < n; ++i) {
            v[i] = new Coordinate(0.0, 0.0, 0.0);
        }
        for (int axis = 0; axis < 3; ++axis) {
            double xn0 = x[n].getIndex(axis);
            double xnm1 = x[n - 1].getIndex(axis);
            block6: for (int i = 0; i < n; ++i) {
                double xi0 = x[i].getIndex(axis);
                double xi1 = x[i + 1].getIndex(axis);
                double xim1 = i == 0 ? 0.0 : x[i - 1].getIndex(axis);
                switch (0) {
                    case 0: 
                    case 1: {
                        if (i == 0) {
                            Adiag[i] = 2.0 / t[n - 1] + 2.0 / t[0];
                            Acorner = 1.0 / t[n - 1];
                            b[i] = 3.0 * (xi1 - xi0) / (t[0] * t[0]) + 3.0 * (xn0 - xnm1) / (t[n - 1] * t[n - 1]);
                        } else {
                            Adiag[i] = 2.0 / t[i - 1] + 2.0 / t[i];
                            b[i] = 3.0 * (xi1 - xi0) / (t[i] * t[i]) + 3.0 * (xi0 - xim1) / (t[i - 1] * t[i - 1]);
                        }
                        Aoffd[i] = 1.0 / t[i];
                        continue block6;
                    }
                    case 2: {
                        if (i == 0) {
                            Adiag[i] = 4.0 * (t[n - 1] + t[0]);
                            Acorner = -t[n - 1];
                            b[i] = 3.0 * (xn0 - xnm1 + xi1 - xi0);
                        } else {
                            Adiag[i] = 4.0 * (t[i - 1] + t[i]);
                            b[i] = 3.0 * (xi1 - xim1);
                        }
                        Aoffd[i] = -t[i];
                    }
                }
            }
            double[] vel = new double[n];
            for (int i = 0; i < n; ++i) {
                vel[i] = v[i].getIndex(axis);
            }
            SplineCurve.tridag(Aoffd, Adiag, Aoffd, b, vel, n);
            if (n > 2) {
                double[] z1 = new double[n];
                b[0] = Acorner;
                for (int i = 1; i < n; ++i) {
                    b[i] = 0.0;
                }
                SplineCurve.tridag(Aoffd, Adiag, Aoffd, b, z1, n);
                double[] z2 = new double[n];
                b[n - 1] = Acorner;
                for (int i = 0; i < n - 1; ++i) {
                    b[i] = 0.0;
                }
                SplineCurve.tridag(Aoffd, Adiag, Aoffd, b, z2, n);
                double H00 = 1.0 + z2[0];
                double H01 = -z2[n - 1];
                double H10 = -z1[0];
                double H11 = 1.0 + z1[n - 1];
                double det = H00 * H11 - H01 * H10;
                double m0 = (H00 /= det) * vel[n - 1] + (H01 /= det) * vel[0];
                double m1 = (H10 /= det) * vel[n - 1] + (H11 /= det) * vel[0];
                for (int i = 0; i < n; ++i) {
                    int n2 = i;
                    vel[n2] = vel[n2] - (z1[i] * m0 + z2[i] * m1);
                }
            }
            for (int i = 0; i < n; ++i) {
                v[i].setIndex(axis, vel[i]);
            }
        }
        v[n] = new Coordinate(v[0]);
    }

    protected static void tridag(double[] a, double[] b, double[] c, double[] r, double[] u, int n) throws JuggleExceptionInternal {
        int j;
        if (b[0] == 0.0) {
            throw new JuggleExceptionInternal("Error 1 in TRIDAG");
        }
        double bet = b[0];
        double[] gam = new double[n];
        u[0] = r[0] / bet;
        for (j = 1; j < n; ++j) {
            gam[j] = c[j - 1] / bet;
            bet = b[j] - a[j - 1] * gam[j];
            if (bet == 0.0) {
                throw new JuggleExceptionInternal("Error 2 in TRIDAG");
            }
            u[j] = (r[j] - a[j - 1] * u[j - 1]) / bet;
        }
        for (j = n - 1; j > 0; --j) {
            int n2 = j - 1;
            u[n2] = u[n2] - gam[j] * u[j];
        }
    }

    @Override
    public void getCoordinate(double time, Coordinate newPosition) {
        int i;
        if (time < this.times[0] || time > this.times[this.n]) {
            return;
        }
        for (i = 0; i < this.n && !(time <= this.times[i + 1]); ++i) {
        }
        if (i == this.n) {
            i = this.n - 1;
        }
        newPosition.setCoordinate(this.a[i][0] + (time -= this.times[i]) * (this.b[i][0] + time * (this.c[i][0] + time * this.d[i][0])), this.a[i][1] + time * (this.b[i][1] + time * (this.c[i][1] + time * this.d[i][1])), this.a[i][2] + time * (this.b[i][2] + time * (this.c[i][2] + time * this.d[i][2])));
    }

    @Override
    protected Coordinate getMax2(double begin, double end) {
        if (end < this.times[0] || begin > this.times[this.n]) {
            return null;
        }
        Coordinate result = null;
        double tlow = Math.max(this.times[0], begin);
        double thigh = Math.min(this.times[this.n], end);
        result = this.check(result, tlow, true);
        result = this.check(result, thigh, true);
        for (int i = 0; i <= this.n; ++i) {
            double thightemp;
            double tlowtemp;
            if (tlow <= this.times[i] && this.times[i] <= thigh) {
                result = this.check(result, this.times[i], true);
            }
            if (i == this.n || !((tlowtemp = Math.max(tlow, this.times[i])) < (thightemp = Math.min(thigh, this.times[i + 1])))) continue;
            result = this.check(result, tlowtemp, true);
            result = this.check(result, thightemp, true);
            for (int index = 0; index < 3; ++index) {
                if (Math.abs(this.d[i][index]) > 1.0E-6) {
                    double te;
                    double k = this.c[i][index] * this.c[i][index] - 3.0 * this.b[i][index] * this.d[i][index];
                    if (!(k > 0.0) || !(tlowtemp < (te = this.times[i] + (-this.c[i][index] - Math.sqrt(k)) / (3.0 * this.d[i][index]))) || !(te < thightemp)) continue;
                    result = this.check(result, te, true);
                    continue;
                }
                if (!(this.c[i][index] < 0.0)) continue;
                double te = -this.b[i][index] / (2.0 * this.c[i][index]);
                if (!(tlowtemp < (te += this.times[i])) || !(te < thightemp)) continue;
                result = this.check(result, te, true);
            }
        }
        return result;
    }

    @Override
    protected Coordinate getMin2(double begin, double end) {
        if (end < this.times[0] || begin > this.times[this.n]) {
            return null;
        }
        Coordinate result = null;
        double tlow = Math.max(this.times[0], begin);
        double thigh = Math.min(this.times[this.n], end);
        result = this.check(result, tlow, false);
        result = this.check(result, thigh, false);
        for (int i = 0; i <= this.n; ++i) {
            double thightemp;
            double tlowtemp;
            if (tlow <= this.times[i] && this.times[i] <= thigh) {
                result = this.check(result, this.times[i], false);
            }
            if (i == this.n || !((tlowtemp = Math.max(tlow, this.times[i])) < (thightemp = Math.min(thigh, this.times[i + 1])))) continue;
            result = this.check(result, tlowtemp, false);
            result = this.check(result, thightemp, false);
            for (int index = 0; index < 3; ++index) {
                if (Math.abs(this.d[i][index]) > 1.0E-6) {
                    double te;
                    double k = this.c[i][index] * this.c[i][index] - 3.0 * this.b[i][index] * this.d[i][index];
                    if (!(k > 0.0) || !(tlowtemp < (te = this.times[i] + (-this.c[i][index] + Math.sqrt(k)) / (3.0 * this.d[i][index]))) || !(te < thightemp)) continue;
                    result = this.check(result, te, false);
                    continue;
                }
                if (!(this.c[i][index] > 0.0)) continue;
                double te = -this.b[i][index] / (2.0 * this.c[i][index]);
                if (!(tlowtemp < (te += this.times[i])) || !(te < thightemp)) continue;
                result = this.check(result, te, false);
            }
        }
        return result;
    }
}

