/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.generator;

import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import jugglinglab.JugglingLab;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.SiteswapGenerator;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public abstract class Generator {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    public static final String[] builtinGenerators = new String[]{"Siteswap"};

    public static Generator newGenerator(String name) {
        if (name.equalsIgnoreCase("siteswap")) {
            return new SiteswapGenerator();
        }
        return null;
    }

    public void initGenerator(String arg) throws JuggleExceptionUser {
        StringTokenizer st = new StringTokenizer(arg, " \n");
        int numargs = st.countTokens();
        String[] args = new String[numargs];
        for (int i = 0; i < numargs; ++i) {
            args[i] = st.nextToken();
        }
        this.initGenerator(args);
    }

    public abstract String getNotationName();

    public abstract String getStartupMessage();

    public abstract JPanel getGeneratorControl();

    public abstract void resetGeneratorControl();

    public abstract void initGenerator() throws JuggleExceptionUser;

    public abstract void initGenerator(String[] var1) throws JuggleExceptionUser;

    public abstract int runGenerator(GeneratorTarget var1) throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract int runGenerator(GeneratorTarget var1, int var2, double var3) throws JuggleExceptionUser, JuggleExceptionInternal;
}

