/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.generator;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JPanel;
import jugglinglab.generator.Generator;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.SiteswapGeneratorControl;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionDone;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionInterrupted;
import jugglinglab.util.JuggleExceptionUser;

public class SiteswapGenerator
extends Generator {
    protected static final int ASYNC = 0;
    protected static final int SYNC = 1;
    private static final int MP_EMPTY = 0;
    private static final int MP_THROW = 1;
    private static final int MP_LOWER_BOUND = 2;
    private static final int TYPE = 0;
    private static final int FROM = 1;
    private static final int VALUE = 2;
    private static final int CHARS_PER_THROW = 50;
    protected static final int[][] async_rhythm_repunit = new int[][]{{1}};
    protected static final int[][] sync_rhythm_repunit = new int[][]{{1, 0}, {1, 0}};
    private static final int LOOP_COUNTER_MAX = 20000;
    protected int n;
    protected int jugglers;
    protected int ht;
    protected int l_min;
    protected int l_max;
    protected ArrayList<Pattern> exclude;
    protected ArrayList<Pattern> include;
    protected int numflag;
    protected int groundflag;
    protected int rotflag;
    protected int fullflag;
    protected int mpflag;
    protected int multiplex;
    protected int delaytime;
    protected int hands;
    protected int max_occupancy;
    protected int leader_person;
    protected int[][] rhythm_repunit;
    protected int rhythm_period;
    protected int[] holdthrow;
    protected int[] person_number;
    protected int[][] ground_state;
    protected int ground_state_length;
    protected boolean mp_clustered;
    protected boolean lameflag;
    protected boolean sequenceflag;
    protected boolean connected_patterns;
    protected boolean symmetric_patterns;
    protected boolean juggler_permutations;
    protected int mode;
    protected int slot_size;
    protected int[][][] state;
    protected int l_target;
    protected int[][][] rhythm;
    protected int[][] throws_left;
    protected int[][] holes;
    protected int[][][] throw_to;
    protected int[][][] throw_value;
    protected int[][][][] mp_filter;
    protected boolean pattern_printx;
    protected int[] scratch1;
    protected int[] scratch2;
    protected char[] output;
    protected boolean[] connections;
    protected boolean[] perm_scratch1;
    protected boolean[] perm_scratch2;
    protected char[] starting_seq;
    protected char[] ending_seq;
    protected int starting_seq_length;
    protected int ending_seq_length;
    protected int max_num;
    protected double max_time;
    protected long max_time_millis;
    protected long start_time_millis;
    protected int loop_counter;
    protected SiteswapGeneratorControl control;
    protected GeneratorTarget target;

    @Override
    public String getNotationName() {
        return "Siteswap";
    }

    @Override
    public String getStartupMessage() {
        return "Welcome to the J2 Siteswap Generator";
    }

    @Override
    public JPanel getGeneratorControl() {
        if (this.control == null) {
            this.control = new SiteswapGeneratorControl();
        }
        return this.control;
    }

    @Override
    public void resetGeneratorControl() {
        if (this.control != null) {
            this.control.resetControl();
        }
    }

    @Override
    public void initGenerator() throws JuggleExceptionUser {
        if (this.control == null) {
            this.initGenerator("5 7 5");
        } else {
            this.initGenerator(this.control.getParams());
        }
    }

    @Override
    public void initGenerator(String[] args) throws JuggleExceptionUser {
        this.configGenerator(args);
        this.allocateWorkspace();
    }

    @Override
    public int runGenerator(GeneratorTarget t) throws JuggleExceptionUser, JuggleExceptionInternal {
        return this.runGenerator(t, -1, -1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runGenerator(GeneratorTarget t, int num_limit, double secs_limit) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (this.groundflag == 1 && this.ground_state_length > this.ht) {
            return 0;
        }
        this.max_num = num_limit;
        this.max_time = secs_limit;
        if (this.max_time > 0.0) {
            this.max_time_millis = (long)(1000.0 * secs_limit);
            this.start_time_millis = System.currentTimeMillis();
            this.loop_counter = 0;
        }
        this.target = t;
        int num = 0;
        this.l_target = this.l_min;
        while (this.l_target <= this.l_max) {
            num += this.findPatterns(0, 0, 0);
            this.l_target += this.rhythm_period;
        }
        if (this.numflag != 0) {
            if (num == 1) {
                this.target.setStatus(guistrings.getString("Generator_patterns_1"));
            } else {
                String template = guistrings.getString("Generator_patterns_ne1");
                Object[] arguments = new Object[]{num};
                this.target.setStatus(MessageFormat.format(template, arguments));
            }
        }
        int n = num;
        return n;
    }

    protected void configGenerator(String[] args) throws JuggleExceptionUser {
        String template;
        int i;
        if (args.length < 3) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_insufficient_input"));
        }
        this.max_occupancy = 0;
        this.leader_person = 1;
        this.numflag = 0;
        this.groundflag = 0;
        this.rotflag = 0;
        this.mpflag = 1;
        this.fullflag = 1;
        this.mp_clustered = true;
        this.multiplex = 1;
        this.delaytime = 0;
        this.lameflag = false;
        this.connected_patterns = false;
        this.symmetric_patterns = false;
        this.juggler_permutations = false;
        this.sequenceflag = true;
        this.mode = 0;
        this.jugglers = 1;
        this.target = null;
        this.exclude = new ArrayList();
        this.include = new ArrayList();
        boolean true_multiplex = false;
        for (i = 3; i < args.length; ++i) {
            Object re;
            if (args[i].equals("-n")) {
                this.numflag = 1;
                continue;
            }
            if (args[i].equals("-no")) {
                this.numflag = 2;
                continue;
            }
            if (args[i].equals("-g")) {
                this.groundflag = 1;
                continue;
            }
            if (args[i].equals("-ng")) {
                this.groundflag = 2;
                continue;
            }
            if (args[i].equals("-f")) {
                this.fullflag = 0;
                continue;
            }
            if (args[i].equals("-prime")) {
                this.fullflag = 2;
                continue;
            }
            if (args[i].equals("-rot")) {
                this.rotflag = 1;
                continue;
            }
            if (args[i].equals("-jp")) {
                this.juggler_permutations = true;
                continue;
            }
            if (args[i].equals("-lame")) {
                this.lameflag = true;
                continue;
            }
            if (args[i].equals("-se")) {
                this.sequenceflag = false;
                continue;
            }
            if (args[i].equals("-s")) {
                this.mode = 1;
                continue;
            }
            if (args[i].equals("-cp")) {
                this.connected_patterns = true;
                continue;
            }
            if (args[i].equals("-sym")) {
                this.symmetric_patterns = true;
                continue;
            }
            if (args[i].equals("-mf")) {
                this.mpflag = 0;
                continue;
            }
            if (args[i].equals("-mc")) {
                this.mp_clustered = false;
                continue;
            }
            if (args[i].equals("-mt")) {
                true_multiplex = true;
                continue;
            }
            if (args[i].equals("-m")) {
                if (i >= args.length - 1 || args[i + 1].charAt(0) == '-') continue;
                try {
                    this.multiplex = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException nfe) {
                    String template2 = errorstrings.getString("Error_number_format");
                    String str = guistrings.getString("simultaneous_throws");
                    Object[] arguments = new Object[]{str};
                    throw new JuggleExceptionUser(MessageFormat.format(template2, arguments));
                }
                ++i;
                continue;
            }
            if (args[i].equals("-j")) {
                if (i >= args.length - 1 || args[i + 1].charAt(0) == '-') continue;
                try {
                    this.jugglers = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException nfe) {
                    String template3 = errorstrings.getString("Error_number_format");
                    String str = guistrings.getString("Jugglers");
                    Object[] arguments = new Object[]{str};
                    throw new JuggleExceptionUser(MessageFormat.format(template3, arguments));
                }
                ++i;
                continue;
            }
            if (args[i].equals("-d")) {
                if (i >= args.length - 1 || args[i + 1].charAt(0) == '-') continue;
                try {
                    this.delaytime = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException nfe) {
                    String template4 = errorstrings.getString("Error_number_format");
                    String str = guistrings.getString("Passing_communication_delay");
                    Object[] arguments = new Object[]{str};
                    throw new JuggleExceptionUser(MessageFormat.format(template4, arguments));
                }
                this.groundflag = 1;
                ++i;
                continue;
            }
            if (args[i].equals("-l")) {
                if (i >= args.length - 1 || args[i + 1].charAt(0) == '-') continue;
                try {
                    this.leader_person = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException nfe) {
                    String template5 = errorstrings.getString("Error_number_format");
                    String str = guistrings.getString("Error_passing_leader_number");
                    Object[] arguments = new Object[]{str};
                    throw new JuggleExceptionUser(MessageFormat.format(template5, arguments));
                }
                ++i;
                continue;
            }
            if (args[i].equals("-x")) {
                ++i;
                while (i < args.length && args[i].charAt(0) != '-') {
                    try {
                        re = SiteswapGenerator.makeStandardRegex(args[i]);
                        if (((String)re).indexOf("^") < 0) {
                            re = ".*" + (String)re + ".*";
                        }
                        this.exclude.add(Pattern.compile((String)re));
                    }
                    catch (PatternSyntaxException pse) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_excluded_throws"));
                    }
                    ++i;
                }
                --i;
                continue;
            }
            if (args[i].equals("-i")) {
                ++i;
                while (i < args.length && args[i].charAt(0) != '-') {
                    try {
                        re = SiteswapGenerator.makeStandardRegex(args[i]);
                        if (((String)re).indexOf("^") < 0) {
                            re = ".*" + (String)re;
                        }
                        if (((String)re).indexOf("$") < 0) {
                            re = (String)re + ".*";
                        }
                        this.include.add(Pattern.compile((String)re));
                    }
                    catch (PatternSyntaxException ps) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_included_throws"));
                    }
                    ++i;
                }
                --i;
                continue;
            }
            template = errorstrings.getString("Error_unrecognized_option");
            Object[] arguments = new Object[]{args[i]};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        this.configMode();
        try {
            this.n = Integer.parseInt(args[0]);
        }
        catch (NumberFormatException nfe) {
            template = errorstrings.getString("Error_number_format");
            String str = guistrings.getString("balls");
            Object[] arguments = new Object[]{str};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        try {
            this.ht = args[1].equals("-") ? -1 : (args[1].matches("^[0-9]+$") ? Integer.parseInt(args[1]) : Integer.parseInt(args[1], 36));
        }
        catch (NumberFormatException nfe) {
            template = errorstrings.getString("Error_number_format");
            String str = guistrings.getString("max._throw");
            Object[] arguments = new Object[]{str};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        try {
            if (args[2].equals("-")) {
                this.l_min = this.rhythm_period;
                this.l_max = -1;
            } else {
                int divider = args[2].indexOf(45);
                if (divider == 0) {
                    this.l_min = this.rhythm_period;
                    this.l_max = Integer.parseInt(args[2].substring(1));
                } else if (divider == args[2].length() - 1) {
                    this.l_min = Integer.parseInt(args[2].substring(0, divider));
                    this.l_max = -1;
                } else if (divider > 0) {
                    this.l_min = Integer.parseInt(args[2].substring(0, divider));
                    this.l_max = Integer.parseInt(args[2].substring(divider + 1));
                } else {
                    this.l_min = this.l_max = Integer.parseInt(args[2]);
                }
            }
        }
        catch (NumberFormatException nfe) {
            template = errorstrings.getString("Error_number_format");
            String str = guistrings.getString("period");
            Object[] arguments = new Object[]{str};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        if (this.n < 1) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_too_few_balls"));
        }
        if (this.l_max == -1) {
            if (this.fullflag != 2) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_generator_must_be_prime_mode"));
            }
            if (this.ht == -1) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_generator_underspecified"));
            }
            this.l_max = JLFunc.binomial(this.ht * this.hands, this.n);
            this.l_max -= this.l_max % this.rhythm_period;
        }
        if (this.ht == -1) {
            this.ht = this.n * this.l_max;
        }
        if (this.ht < 1) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_height_too_small"));
        }
        if (this.l_min < 1 || this.l_max < 1 || this.l_min > this.l_max) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_generator_period_problem"));
        }
        this.output = new char[this.l_max * 50];
        if (this.jugglers > 1 && !this.juggler_permutations && this.groundflag != 0) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_juggler_permutations"));
        }
        if (this.l_min % this.rhythm_period != 0 || this.l_max % this.rhythm_period != 0) {
            String template6 = errorstrings.getString("Error_period_multiple");
            Object[] arguments = new Object[]{this.rhythm_period};
            throw new JuggleExceptionUser(MessageFormat.format(template6, arguments));
        }
        this.findGround();
        this.slot_size = Math.max(this.ht, this.l_max);
        this.slot_size += this.rhythm_period - this.slot_size % this.rhythm_period;
        for (i = 0; i < this.hands; ++i) {
            for (int j = 0; j < this.rhythm_period; ++j) {
                this.max_occupancy = Math.max(this.max_occupancy, this.rhythm_repunit[i][j]);
            }
        }
        this.max_occupancy *= this.multiplex;
        if (this.max_occupancy == 1) {
            this.mpflag = 0;
        }
        if (true_multiplex) {
            String include_RE = null;
            if (this.jugglers == 1) {
                if (this.mode == 0) {
                    include_RE = ".*\\[[^2]*\\].*";
                } else if (this.mode == 1) {
                    include_RE = ".*\\[([^2\\]]*2x)*[^2\\]]*\\].*";
                }
            } else if (this.mode == 0) {
                include_RE = ".*\\[([^2\\]]*(2p|.p2|2p.))*[^2\\]]*\\].*";
            } else if (this.mode == 1) {
                include_RE = ".*\\[([^2\\]]*(2p|.p2|2p.|2x|2xp|.xp2|2xp.))*[^2\\]]*\\].*";
            }
            if (include_RE != null) {
                this.include.add(Pattern.compile(include_RE));
            }
        }
    }

    protected void configMode() {
        switch (this.mode) {
            case 0: {
                this.rhythm_repunit = new int[this.jugglers][1];
                this.holdthrow = new int[this.jugglers];
                this.person_number = new int[this.jugglers];
                this.hands = this.jugglers;
                this.rhythm_period = 1;
                this.pattern_printx = false;
                for (int i = 0; i < this.hands; ++i) {
                    this.rhythm_repunit[i][0] = async_rhythm_repunit[0][0];
                    this.holdthrow[i] = 2;
                    this.person_number[i] = i + 1;
                }
                break;
            }
            case 1: {
                this.rhythm_repunit = new int[2 * this.jugglers][2];
                this.holdthrow = new int[2 * this.jugglers];
                this.person_number = new int[2 * this.jugglers];
                this.hands = 2 * this.jugglers;
                this.rhythm_period = 2;
                this.pattern_printx = true;
                for (int i = 0; i < this.hands; ++i) {
                    for (int j = 0; j < this.rhythm_period; ++j) {
                        this.rhythm_repunit[i][j] = sync_rhythm_repunit[i % 2][j];
                    }
                    this.holdthrow[i] = 2;
                    this.person_number[i] = i / 2 + 1;
                }
                break;
            }
        }
    }

    protected void allocateWorkspace() {
        this.state = new int[this.l_max + 1][this.hands][this.ground_state_length];
        this.holes = new int[this.hands][this.l_max + this.ht];
        this.throw_to = new int[this.slot_size][this.hands][this.max_occupancy];
        this.throw_value = new int[this.slot_size][this.hands][this.max_occupancy];
        this.rhythm = new int[this.slot_size + 1][this.hands][this.ht];
        for (int i = 0; i < this.slot_size + 1; ++i) {
            for (int j = 0; j < this.hands; ++j) {
                for (int k = 0; k < this.ht; ++k) {
                    this.rhythm[i][j][k] = this.multiplex * this.rhythm_repunit[j][(k + i) % this.rhythm_period];
                }
            }
        }
        if (this.mpflag != 0) {
            this.mp_filter = new int[this.l_max + 1][this.hands][this.slot_size][3];
        }
        this.throws_left = new int[this.l_max][this.hands];
        if (this.jugglers > 1) {
            this.scratch1 = new int[this.hands];
            this.scratch2 = new int[this.hands];
        }
        if (this.connected_patterns) {
            this.connections = new boolean[this.jugglers];
        }
        if (this.jugglers > 1 && !this.juggler_permutations) {
            this.perm_scratch1 = new boolean[this.l_max];
            this.perm_scratch2 = new boolean[this.l_max];
        }
    }

    protected int findPatterns(int balls_placed, int min_value, int min_to) throws JuggleExceptionUser, JuggleExceptionInternal {
        int j;
        if (Thread.interrupted()) {
            throw new JuggleExceptionInterrupted();
        }
        if (balls_placed == this.n || this.groundflag == 1) {
            int j2;
            int i;
            if (this.groundflag == 1) {
                for (i = 0; i < this.hands; ++i) {
                    for (j2 = 0; j2 < this.ht; ++j2) {
                        this.state[0][i][j2] = this.ground_state[i][j2];
                    }
                }
            } else if (this.groundflag == 2 && this.compareStates(this.state[0], this.ground_state) == 0) {
                return 0;
            }
            for (i = 0; i < this.hands; ++i) {
                for (j2 = 0; j2 < this.ht; ++j2) {
                    int k = this.state[0][i][j2];
                    if (this.mpflag != 0 && k == 0) {
                        this.mp_filter[0][i][j2][0] = 0;
                        continue;
                    }
                    if (this.mpflag != 0) {
                        this.mp_filter[0][i][j2][2] = j2 + 1;
                        this.mp_filter[0][i][j2][1] = i;
                        this.mp_filter[0][i][j2][0] = 2;
                    }
                    int m = j2;
                    int q = 0;
                    while ((m += this.l_target) < this.ht) {
                        q = this.state[0][i][m];
                        if (q > k) {
                            return 0;
                        }
                        if (this.mpflag == 0 || q == 0) continue;
                        if (q < k && j2 > this.holdthrow[i]) {
                            return 0;
                        }
                        this.mp_filter[0][i][j2][2] = m + 1;
                    }
                }
                if (this.mpflag == 0) continue;
                while (j2 < this.slot_size) {
                    this.mp_filter[0][i][j2][0] = 0;
                    ++j2;
                }
            }
            if (this.numflag != 2 && this.sequenceflag) {
                this.findStartEnd();
            }
            for (int h = 0; h < this.hands; ++h) {
                for (int ti = 0; ti < this.l_target + this.ht; ++ti) {
                    int num_holes = ti < this.l_target ? this.multiplex * this.rhythm_repunit[h][ti % this.rhythm_period] : this.state[0][h][ti - this.l_target];
                    if (ti < this.ht) {
                        num_holes -= this.state[0][h][ti];
                    }
                    this.holes[h][ti] = num_holes;
                }
            }
            this.startBeat(0);
            return this.findCycles(0, 1, 0, 0);
        }
        if (balls_placed == 0) {
            for (int i = 0; i < this.hands; ++i) {
                for (j = 0; j < this.ht; ++j) {
                    this.state[0][i][j] = 0;
                }
            }
        }
        int num = 0;
        j = min_to;
        for (int i = min_value; i < this.ht; ++i) {
            while (j < this.hands) {
                if (this.state[0][j][i] < this.rhythm[0][j][i]) {
                    int[] nArray = this.state[0][j];
                    int n = i;
                    nArray[n] = nArray[n] + 1;
                    if (i < this.l_target || this.state[0][j][i] <= this.state[0][j][i - this.l_target]) {
                        num += this.findPatterns(balls_placed + 1, i, j);
                    }
                    int[] nArray2 = this.state[0][j];
                    int n2 = i;
                    nArray2[n2] = nArray2[n2] - 1;
                }
                ++j;
            }
            j = 0;
        }
        return num;
    }

    protected int findCycles(int pos, int min_throw, int min_hand, int outputpos) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (Thread.interrupted()) {
            throw new JuggleExceptionInterrupted();
        }
        if (this.max_time > 0.0 && this.loop_counter++ > 20000) {
            this.loop_counter = 0;
            if (System.currentTimeMillis() - this.start_time_millis > this.max_time_millis) {
                String template = guistrings.getString("Generator_timeout");
                Object[] arguments = new Object[]{(int)this.max_time};
                throw new JuggleExceptionDone(MessageFormat.format(template, arguments));
            }
        }
        int h = 0;
        while (this.throws_left[pos][h] == 0) {
            if (++h < this.hands) continue;
            int outputpos_new = this.outputBeat(pos, this.output, outputpos);
            if (!this.areThrowsValid(pos, outputpos_new)) {
                return 0;
            }
            if (this.mpflag != 0 && !this.isMultiplexingValid(pos)) {
                return 0;
            }
            this.calculateState(pos + 1);
            if (!this.isStateValid(pos + 1)) {
                return 0;
            }
            if (++pos < this.l_target) {
                this.startBeat(pos);
                return this.findCycles(pos, 1, 0, outputpos_new);
            }
            if (this.compareStates(this.state[0], this.state[this.l_target]) == 0 && this.isPatternValid(outputpos_new)) {
                if (this.numflag != 2) {
                    this.outputPattern(outputpos_new);
                }
                return 1;
            }
            return 0;
        }
        int[] nArray = this.throws_left[pos];
        int n = h;
        nArray[n] = nArray[n] - 1;
        int slot = this.throws_left[pos][h];
        int k = min_hand;
        int num = 0;
        for (int j = min_throw; j <= this.ht; ++j) {
            int ti = pos + j;
            while (k < this.hands) {
                if (this.holes[k][ti] != 0) {
                    int[] nArray2 = this.holes[k];
                    int n2 = ti;
                    nArray2[n2] = nArray2[n2] - 1;
                    this.throw_to[pos][h][slot] = k;
                    this.throw_value[pos][h][slot] = j;
                    num = slot != 0 ? (num += this.findCycles(pos, j, k, outputpos)) : (num += this.findCycles(pos, 1, 0, outputpos));
                    int[] nArray3 = this.holes[k];
                    int n3 = ti;
                    nArray3[n3] = nArray3[n3] + 1;
                    if (this.max_num >= 0 && num >= this.max_num) {
                        String template = guistrings.getString("Generator_spacelimit");
                        Object[] arguments = new Object[]{this.max_num};
                        throw new JuggleExceptionDone(MessageFormat.format(template, arguments));
                    }
                }
                ++k;
            }
            k = 0;
        }
        int[] nArray4 = this.throws_left[pos];
        int n4 = h;
        nArray4[n4] = nArray4[n4] + 1;
        return num;
    }

    protected void calculateState(int pos) {
        int k;
        int j;
        if (pos == 0) {
            return;
        }
        for (j = 0; j < this.hands; ++j) {
            for (k = 0; k < this.ht - 1; ++k) {
                this.state[pos][j][k] = this.state[pos - 1][j][k + 1];
            }
            this.state[pos][j][this.ht - 1] = 0;
        }
        for (j = 0; j < this.hands; ++j) {
            int v;
            for (k = 0; k < this.max_occupancy && (v = this.throw_value[pos - 1][j][k]) != 0; ++k) {
                int[] nArray = this.state[pos][this.throw_to[pos - 1][j][k]];
                int n = v - 1;
                nArray[n] = nArray[n] + 1;
            }
        }
    }

    protected boolean isStateValid(int pos) {
        int j;
        if (this.ht > this.l_target) {
            for (j = 0; j < this.hands; ++j) {
                for (int k = 0; k < this.l_target; ++k) {
                    for (int o = k; o < this.ht - this.l_target; o += this.l_target) {
                        if (this.state[pos][j][o + this.l_target] <= this.state[pos][j][o]) continue;
                        return false;
                    }
                }
            }
        }
        if (pos % this.rhythm_period == 0) {
            int cs = this.compareStates(this.state[0], this.state[pos]);
            if (this.fullflag != 0 && pos != this.l_target && cs == 0) {
                return false;
            }
            if (this.rotflag == 0 && cs == 1) {
                return false;
            }
        }
        if (this.fullflag == 2) {
            for (j = 1; j < pos; ++j) {
                if ((pos - j) % this.rhythm_period != 0 || this.compareStates(this.state[j], this.state[pos]) != 0) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isMultiplexingValid(int pos) {
        int k;
        int j;
        for (j = 0; j < this.hands; ++j) {
            for (k = 0; k < this.slot_size - 1; ++k) {
                this.mp_filter[pos + 1][j][k][0] = this.mp_filter[pos][j][k + 1][0];
                this.mp_filter[pos + 1][j][k][1] = this.mp_filter[pos][j][k + 1][1];
                this.mp_filter[pos + 1][j][k][2] = this.mp_filter[pos][j][k + 1][2];
            }
            this.mp_filter[pos + 1][j][this.slot_size - 1][0] = 0;
            if (this.addThrowMPFilter(this.mp_filter[pos + 1][j][this.l_target - 1], j, this.mp_filter[pos][j][0][0], this.mp_filter[pos][j][0][2], this.mp_filter[pos][j][0][1]) == 0) continue;
            return false;
        }
        for (j = 0; j < this.hands; ++j) {
            int m;
            for (k = 0; k < this.max_occupancy && (m = this.throw_value[pos][j][k]) != 0; ++k) {
                if (this.addThrowMPFilter(this.mp_filter[pos + 1][this.throw_to[pos][j][k]][m - 1], this.throw_to[pos][j][k], 1, m, j) == 0) continue;
                return false;
            }
        }
        return true;
    }

    protected void startBeat(int pos) {
        for (int i = 0; i < this.hands; ++i) {
            this.throws_left[pos][i] = this.state[pos][i][0];
            for (int j = 0; j < this.max_occupancy; ++j) {
                this.throw_to[pos][i][j] = i;
                this.throw_value[pos][i][j] = 0;
            }
        }
    }

    protected boolean areThrowsValid(int pos, int outputpos) {
        for (Pattern regex : this.exclude) {
            if (!regex.matcher(new String(this.output, 0, outputpos)).matches()) continue;
            return false;
        }
        if (!this.mp_clustered) {
            for (int i = 0; i < this.hands; ++i) {
                if (this.rhythm[pos][i][0] == 0) continue;
                for (int j = 0; j < this.max_occupancy && this.throw_value[pos][i][j] != 0; ++j) {
                    for (int l = 0; l < j; ++l) {
                        if (this.throw_value[pos][i][j] != this.throw_value[pos][i][l] || this.throw_to[pos][i][j] != this.throw_to[pos][i][l]) continue;
                        return false;
                    }
                }
            }
        }
        if (this.jugglers > 1 && pos < this.delaytime) {
            int i;
            int balls_thrown = 0;
            for (int i2 = 0; i2 < this.hands; ++i2) {
                if (this.rhythm[pos][i2][0] == 0) continue;
                ++balls_thrown;
                if (this.state[pos][i2][0] == 1 || this.person_number[i2] == this.leader_person) continue;
                return false;
            }
            int balls_left = this.n;
            for (i = 0; i < this.ht && balls_left != 0; ++i) {
                for (int j = 0; j < this.hands && balls_left != 0; ++j) {
                    if (this.rhythm[pos + 1][j][i] == 0 || --balls_left >= balls_thrown) continue;
                    this.scratch1[balls_left] = j;
                    this.scratch2[balls_left] = i + 1;
                }
            }
            if (balls_left != 0) {
                return false;
            }
            for (i = 0; i < this.hands; ++i) {
                if (this.state[pos][i][0] == 0 || this.person_number[i] == this.leader_person) continue;
                boolean found_spot = false;
                for (int j = 0; j < balls_thrown; ++j) {
                    if (this.scratch1[j] != this.throw_to[pos][i][0] || this.scratch2[j] != this.throw_value[pos][i][0]) continue;
                    this.scratch2[j] = 0;
                    found_spot = true;
                    break;
                }
                if (found_spot) continue;
                return false;
            }
        }
        return true;
    }

    protected boolean isPatternValid(int outputpos) {
        for (Pattern regex : this.include) {
            if (regex.matcher(new String(this.output, 0, outputpos)).matches()) continue;
            return false;
        }
        if (this.mode == 0 && this.lameflag && this.max_occupancy == 1) {
            for (int i = 0; i < this.l_target - 1; ++i) {
                for (int j = 0; j < this.hands; ++j) {
                    if (this.throw_value[i][j][0] != 1 || this.person_number[this.throw_to[i][j][0]] != this.person_number[j] || this.throw_value[i + 1][j][0] != 1 || this.person_number[this.throw_to[i + 1][j][0]] != this.person_number[j]) continue;
                    return false;
                }
            }
        }
        if (this.fullflag == 0 && this.rotflag == 0) {
            for (int i = 1; i < this.l_target; ++i) {
                if (i % this.rhythm_period != 0 || this.compareStates(this.state[0], this.state[i]) != 0 || this.compareRotations(0, i) >= 0) continue;
                return false;
            }
        }
        if (this.jugglers > 1 && this.connected_patterns) {
            for (int i = 0; i < this.jugglers; ++i) {
                this.connections[i] = false;
            }
            this.connections[0] = true;
            boolean changed = true;
            while (changed) {
                changed = false;
                for (int i = 0; i < this.l_target; ++i) {
                    for (int j = 0; j < this.hands; ++j) {
                        if (this.connections[this.person_number[j] - 1]) continue;
                        for (int k = 0; k < this.max_occupancy && this.throw_value[i][j][k] > 0; ++k) {
                            int p = this.person_number[this.throw_to[i][j][k]];
                            if (!this.connections[p - 1]) continue;
                            this.connections[this.person_number[j] - 1] = true;
                            changed = true;
                        }
                    }
                }
            }
            for (int i = 0; i < this.jugglers; ++i) {
                if (this.connections[i]) continue;
                return false;
            }
        }
        if (this.jugglers > 1 && !this.juggler_permutations) {
            block10: for (int m = 1; m <= this.jugglers - 1; ++m) {
                for (int i = 0; i < this.l_target; ++i) {
                    this.perm_scratch2[i] = false;
                    this.perm_scratch1[i] = false;
                }
                for (int p = 0; p < this.l_target; ++p) {
                    int scorem = -1;
                    int scoremp1 = -1;
                    int maxm = 0;
                    int maxmp1 = 0;
                    for (int i = 0; i < this.l_target; ++i) {
                        int k;
                        int j;
                        int scoretemp;
                        if (!this.perm_scratch1[i]) {
                            scoretemp = 0;
                            for (j = 0; j < this.hands; ++j) {
                                if (this.person_number[j] != m) continue;
                                for (k = 0; k < this.max_occupancy && this.throw_value[i][j][k] > 0; ++k) {
                                    scoretemp += 4 * this.throw_value[i][j][k] * (2 * this.max_occupancy) * (2 * this.max_occupancy);
                                    if (this.throw_to[i][j][k] == j) continue;
                                    scoretemp += 2 * (2 * this.max_occupancy);
                                    if (this.person_number[this.throw_to[i][j][k]] == m) continue;
                                    ++scoretemp;
                                }
                            }
                            if (scoretemp > scorem) {
                                scorem = scoretemp;
                                maxm = i;
                            }
                        }
                        if (this.perm_scratch2[i]) continue;
                        scoretemp = 0;
                        for (j = 0; j < this.hands; ++j) {
                            if (this.person_number[j] != m + 1) continue;
                            for (k = 0; k < this.max_occupancy && this.throw_value[i][j][k] > 0; ++k) {
                                scoretemp += 4 * this.throw_value[i][j][k] * (2 * this.max_occupancy) * (2 * this.max_occupancy);
                                if (this.throw_to[i][j][k] == j) continue;
                                scoretemp += 2 * (2 * this.max_occupancy);
                                if (this.person_number[this.throw_to[i][j][k]] == m + 1) continue;
                                ++scoretemp;
                            }
                        }
                        if (scoretemp <= scoremp1) continue;
                        scoremp1 = scoretemp;
                        maxmp1 = i;
                    }
                    if (scoremp1 > scorem) {
                        return false;
                    }
                    if (scoremp1 < scorem) continue block10;
                    this.perm_scratch2[maxmp1] = true;
                    this.perm_scratch1[maxm] = true;
                }
            }
        }
        if (this.jugglers > 1 && this.symmetric_patterns) {
            block18: for (int j = 2; j <= this.jugglers; ++j) {
                block19: for (int offset = 0; offset < this.l_target; ++offset) {
                    for (int i = 0; i < this.l_target; ++i) {
                        int h_juggler1 = 0;
                        int index = (i + offset) % this.l_target;
                        for (int h = 1; h < this.hands; ++h) {
                            if (this.person_number[h] != j) continue;
                            for (int k = 0; k < this.max_occupancy; ++k) {
                                boolean same_j;
                                int val_1 = this.throw_value[i][h_juggler1][k];
                                boolean self_1 = this.person_number[this.throw_to[i][h_juggler1][k]] == 1;
                                boolean same_1 = this.throw_to[i][h_juggler1][k] == h_juggler1;
                                int val_j = this.throw_value[index][h][k];
                                boolean self_j = this.person_number[this.throw_to[index][h][k]] == j;
                                boolean bl = same_j = this.throw_to[index][h][k] == h;
                                if (val_1 == 0 && val_j == 0) break;
                                if (val_1 != val_j || self_1 != self_j || same_1 != same_j) continue block19;
                            }
                            ++h_juggler1;
                        }
                    }
                    continue block18;
                }
                return false;
            }
        }
        return true;
    }

    protected int compareRotations(int pos1, int pos2) {
        int i = 0;
        while (i < this.l_target) {
            int res = this.compareLoops((pos1 + i) % this.l_target, (pos2 + i) % this.l_target);
            if (res > 0) {
                return 1;
            }
            if (res < 0) {
                return -1;
            }
            ++i;
            while (i < this.l_target && this.compareStates(this.state[pos1], this.state[(pos1 + i) % this.l_target]) != 0) {
                ++i;
            }
        }
        return 0;
    }

    protected int compareLoops(int pos1, int pos2) {
        int[][] state_start = this.state[pos1];
        int result = 0;
        int i = 0;
        while (true) {
            ++i;
            if (result == 0) {
                result = this.compareThrows(pos1, pos2);
            }
            if (i % this.rhythm_period == 0) {
                int cs1 = this.compareStates(this.state[pos1 + 1], state_start);
                int cs2 = this.compareStates(this.state[pos2 + 1], state_start);
                if (cs1 == 0) {
                    if (cs2 == 0) {
                        return result;
                    }
                    return -1;
                }
                if (cs2 == 0) {
                    return 1;
                }
            }
            ++pos1;
            ++pos2;
        }
    }

    protected int compareThrows(int pos1, int pos2) {
        int[][] value1 = this.throw_value[pos1];
        int[][] to1 = this.throw_to[pos1];
        int[][] value2 = this.throw_value[pos2];
        int[][] to2 = this.throw_to[pos2];
        int[][] rhy = this.rhythm[pos1];
        for (int i = 0; i < this.hands; ++i) {
            for (int j = 0; j < rhy[i][0]; ++j) {
                if (value1[i][j] > value2[i][j]) {
                    return 1;
                }
                if (value1[i][j] < value2[i][j]) {
                    return -1;
                }
                if (to1[i][j] > to2[i][j]) {
                    return 1;
                }
                if (to1[i][j] >= to2[i][j]) continue;
                return -1;
            }
        }
        return 0;
    }

    protected int compareStates(int[][] state1, int[][] state2) {
        int mo1 = 0;
        int mo2 = 0;
        for (int i = 0; i < this.hands; ++i) {
            for (int j = 0; j < this.ht; ++j) {
                if (state1[i][j] > mo1) {
                    mo1 = state1[i][j];
                }
                if (state2[i][j] <= mo2) continue;
                mo2 = state2[i][j];
            }
        }
        if (mo1 > mo2) {
            return 1;
        }
        if (mo1 < mo2) {
            return -1;
        }
        for (int j = this.ht - 1; j >= 0; --j) {
            for (int i = this.hands - 1; i >= 0; --i) {
                mo1 = state1[i][j];
                mo2 = state2[i][j];
                if (mo1 > mo2) {
                    return 1;
                }
                if (mo1 >= mo2) continue;
                return -1;
            }
        }
        return 0;
    }

    protected static char convertNumber(int value) {
        return Character.toLowerCase(Character.forDigit(value, 36));
    }

    protected int outputBeat(int pos, char[] out, int outpos) {
        boolean x_space;
        boolean no_throw = true;
        for (int i = 0; i < this.rhythm[pos].length; ++i) {
            if (this.rhythm[pos][i][0] == 0) continue;
            no_throw = false;
            break;
        }
        if (no_throw) {
            return outpos;
        }
        boolean bl = x_space = outpos > 0;
        if (this.jugglers > 1) {
            out[outpos++] = 60;
            x_space = false;
        }
        for (int i = 1; i <= this.jugglers; ++i) {
            int hi_hand;
            int lo_hand = 0;
            while (this.person_number[lo_hand] != i) {
                ++lo_hand;
            }
            for (hi_hand = lo_hand; hi_hand < this.hands && this.person_number[hi_hand] == i; ++hi_hand) {
            }
            int num_hands_throwing = 0;
            for (int j = lo_hand; j < hi_hand; ++j) {
                if (this.rhythm[pos][j][0] == 0) continue;
                ++num_hands_throwing;
            }
            if (num_hands_throwing > 0) {
                boolean parens = false;
                if (num_hands_throwing > 1) {
                    out[outpos++] = 40;
                    x_space = false;
                    parens = true;
                }
                for (int j = lo_hand; j < hi_hand; ++j) {
                    if (this.rhythm[pos][j][0] == 0) continue;
                    boolean is_multiplex = false;
                    if (this.max_occupancy > 1 && this.throw_value[pos][j][1] > 0) {
                        out[outpos++] = 91;
                        x_space = false;
                        is_multiplex = true;
                    }
                    boolean got_throw = false;
                    for (int k = 0; k < this.max_occupancy && this.throw_value[pos][j][k] > 0; ++k) {
                        got_throw = true;
                        if (this.throw_value[pos][j][k] == 33 && x_space) {
                            out[outpos++] = 32;
                        }
                        out[outpos++] = SiteswapGenerator.convertNumber(this.throw_value[pos][j][k]);
                        x_space = true;
                        if (this.hands > 1) {
                            int target_juggler = this.person_number[this.throw_to[pos][j][k]];
                            if (this.pattern_printx) {
                                int q = this.throw_to[pos][j][k] - 1;
                                int dest_hand = 0;
                                while (q >= 0 && this.person_number[q] == target_juggler) {
                                    --q;
                                    ++dest_hand;
                                }
                                if (dest_hand != j - lo_hand) {
                                    out[outpos++] = 120;
                                }
                            }
                            if (target_juggler != i) {
                                out[outpos++] = 112;
                                if (this.jugglers > 2) {
                                    out[outpos++] = SiteswapGenerator.convertNumber(target_juggler);
                                }
                            }
                        }
                        if (!is_multiplex || this.jugglers <= 1 || k == this.max_occupancy - 1 || this.throw_value[pos][j][k + 1] <= 0) continue;
                        out[outpos++] = 47;
                        x_space = false;
                    }
                    if (!got_throw) {
                        out[outpos++] = 48;
                        x_space = true;
                    }
                    if (is_multiplex) {
                        out[outpos++] = 93;
                        x_space = false;
                    }
                    if (j >= hi_hand - 1 || !parens) continue;
                    out[outpos++] = 44;
                    x_space = false;
                }
                if (parens) {
                    out[outpos++] = 41;
                    x_space = false;
                }
            }
            if (i >= this.jugglers) continue;
            out[outpos++] = 124;
            x_space = false;
        }
        if (this.jugglers > 1) {
            out[outpos++] = 62;
        }
        return outpos;
    }

    protected void outputPattern(int outputpos) throws JuggleExceptionInternal {
        int i;
        boolean is_excited = false;
        StringBuffer outputline = new StringBuffer(this.hands * (2 * this.ground_state_length + this.l_target) * 50 + 10);
        StringBuffer outputline2 = new StringBuffer(this.hands * (2 * this.ground_state_length + this.l_target) * 50 + 10);
        if (this.groundflag != 1) {
            if (this.sequenceflag) {
                if (this.mode == 0) {
                    for (i = this.n - this.starting_seq_length; i > 0; --i) {
                        outputline.append(" ");
                    }
                }
                outputline.append(this.starting_seq, 0, this.starting_seq_length);
                outputline.append("  ");
            } else {
                boolean bl = is_excited = this.compareStates(this.ground_state, this.state[0]) != 0;
                if (is_excited) {
                    outputline.append("* ");
                } else {
                    outputline.append("  ");
                }
            }
        }
        outputline.append(this.output, 0, outputpos);
        outputline2.append(this.output, 0, outputpos);
        if (this.groundflag != 1) {
            if (this.sequenceflag) {
                outputline.append("  ");
                outputline.append(this.ending_seq, 0, this.ending_seq_length);
                if (this.mode == 0) {
                    for (i = this.n - this.ending_seq_length; i > 0; --i) {
                        outputline.append(" ");
                    }
                }
            } else if (is_excited) {
                outputline.append(" *");
            } else {
                outputline.append("  ");
            }
        }
        this.target.writePattern(outputline.toString(), "siteswap", outputline2.toString().trim());
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int addThrowMPFilter(int[] dest_slot, int slot_hand, int type, int value, int from) {
        switch (type) {
            case 0: {
                return 0;
            }
            case 2: {
                if (dest_slot[0] != 0) return 0;
                dest_slot[0] = 2;
                dest_slot[2] = value;
                dest_slot[1] = from;
                return 0;
            }
            case 1: {
                if (from == slot_hand && value == this.holdthrow[slot_hand]) {
                    return 0;
                }
                switch (dest_slot[0]) {
                    case 0: {
                        dest_slot[0] = 1;
                        dest_slot[2] = value;
                        dest_slot[1] = from;
                        return 0;
                    }
                    case 2: {
                        if (dest_slot[2] > value && dest_slot[2] > this.holdthrow[slot_hand]) return 1;
                        dest_slot[0] = 1;
                        dest_slot[2] = value;
                        dest_slot[1] = from;
                        return 0;
                    }
                    case 1: {
                        if (dest_slot[1] != from || dest_slot[2] != value) return 1;
                        return 0;
                    }
                }
                return 1;
            }
        }
        return 1;
    }

    protected void findStartEnd() {
        int i;
        int k;
        int j;
        int i2;
        int start_beats = 0;
        while (true) {
            block1: for (int j2 = 0; j2 < this.hands; ++j2) {
                for (int k2 = 0; k2 < this.ht; ++k2) {
                    this.state[1][j2][k2] = k2 + start_beats < this.ground_state_length ? this.ground_state[j2][k2 + start_beats] : 0;
                    if (this.state[1][j2][k2] > this.state[0][j2][k2]) {
                        start_beats += this.rhythm_period;
                        continue block1;
                    }
                    this.state[1][j2][k2] = this.state[0][j2][k2] - this.state[1][j2][k2];
                }
            }
            break;
        }
        for (i2 = 0; i2 < start_beats; ++i2) {
            block4: for (j = 0; j < this.hands; ++j) {
                for (k = 0; k < this.max_occupancy; ++k) {
                    this.throw_value[i2][j][k] = 0;
                    this.throw_to[i2][j][k] = j;
                }
                if (i2 >= this.ground_state_length || this.ground_state[j][i2] == 0) continue;
                for (k = 0; k < this.ht; ++k) {
                    for (int m = 0; m < this.hands; ++m) {
                        if (this.state[1][m][k] <= 0) continue;
                        int[] nArray = this.state[1][m];
                        int n = k;
                        nArray[n] = nArray[n] - 1;
                        this.throw_value[i2][j][0] = k + start_beats - i2;
                        this.throw_to[i2][j][0] = m;
                        continue block4;
                    }
                }
            }
        }
        this.starting_seq = new char[this.hands * start_beats * 50];
        this.starting_seq_length = 0;
        for (i2 = 0; i2 < start_beats; ++i2) {
            this.starting_seq_length = this.outputBeat(i2, this.starting_seq, this.starting_seq_length);
        }
        int end_beats = 0;
        while (true) {
            block10: for (j = 0; j < this.hands; ++j) {
                for (k = 0; k < this.ground_state_length; ++k) {
                    this.state[1][j][k] = k + end_beats < this.ht ? this.state[0][j][k + end_beats] : 0;
                    if (this.state[1][j][k] > this.ground_state[j][k]) {
                        end_beats += this.rhythm_period;
                        continue block10;
                    }
                    this.state[1][j][k] = this.ground_state[j][k] - this.state[1][j][k];
                }
            }
            break;
        }
        for (i = 0; i < end_beats; ++i) {
            for (int j3 = 0; j3 < this.hands; ++j3) {
                for (int k3 = 0; k3 < this.max_occupancy; ++k3) {
                    this.throw_value[i][j3][k3] = 0;
                    this.throw_to[i][j3][k3] = j3;
                }
                if (i >= this.ht) continue;
                block15: for (int q = 0; q < this.state[0][j3][i]; ++q) {
                    for (int k4 = 0; k4 < this.ground_state_length; ++k4) {
                        for (int m = 0; m < this.hands; ++m) {
                            if (this.state[1][m][k4] <= 0) continue;
                            int[] nArray = this.state[1][m];
                            int n = k4;
                            nArray[n] = nArray[n] - 1;
                            this.throw_value[i][j3][q] = k4 + end_beats - i;
                            this.throw_to[i][j3][q] = m;
                            continue block15;
                        }
                    }
                }
            }
        }
        this.ending_seq = new char[this.hands * end_beats * 50];
        this.ending_seq_length = 0;
        for (i = 0; i < end_beats; ++i) {
            this.ending_seq_length = this.outputBeat(i, this.ending_seq, this.ending_seq_length);
        }
    }

    protected void findGround() {
        int j;
        int balls_left = this.n;
        int i = 0;
        while (balls_left != 0) {
            for (j = 0; j < this.hands && balls_left != 0; ++j) {
                if (this.rhythm_repunit[j][i % this.rhythm_period] == 0 || --balls_left != 0) continue;
                this.ground_state_length = i + 1;
            }
            ++i;
        }
        if (this.ground_state_length < this.ht) {
            this.ground_state_length = this.ht;
        }
        this.ground_state = new int[this.hands][this.ground_state_length];
        for (i = 0; i < this.hands; ++i) {
            for (j = 0; j < this.ground_state_length; ++j) {
                this.ground_state[i][j] = 0;
            }
        }
        balls_left = this.n;
        i = 0;
        while (balls_left != 0) {
            for (j = 0; j < this.hands && balls_left != 0; ++j) {
                if (this.rhythm_repunit[j][i % this.rhythm_period] == 0) continue;
                this.ground_state[j][i] = 1;
                --balls_left;
            }
            ++i;
        }
    }

    protected void printState(int[][] st) {
        int j;
        int i;
        int last_index = 0;
        for (i = 0; i < this.ground_state_length; ++i) {
            for (j = 0; j < this.hands; ++j) {
                if (st[j][i] == 0) continue;
                last_index = i;
            }
        }
        for (i = 0; i <= last_index; ++i) {
            for (j = 0; j < this.hands; ++j) {
                System.out.println("  s[" + j + "][" + i + "] = " + st[j][i]);
            }
        }
    }

    protected static String makeStandardRegex(String term) {
        String res = Pattern.compile("\\\\\\[").matcher(term).replaceAll("@");
        res = Pattern.compile("\\[").matcher(res).replaceAll("\\\\[");
        res = Pattern.compile("@").matcher(res).replaceAll("[");
        res = Pattern.compile("\\\\\\]").matcher(res).replaceAll("@");
        res = Pattern.compile("\\]").matcher(res).replaceAll("\\\\]");
        res = Pattern.compile("@").matcher(res).replaceAll("]");
        res = Pattern.compile("\\\\\\(").matcher(res).replaceAll("@");
        res = Pattern.compile("\\(").matcher(res).replaceAll("\\\\(");
        res = Pattern.compile("@").matcher(res).replaceAll("(");
        res = Pattern.compile("\\\\\\)").matcher(res).replaceAll("@");
        res = Pattern.compile("\\)").matcher(res).replaceAll("\\\\)");
        res = Pattern.compile("@").matcher(res).replaceAll(")");
        res = Pattern.compile("\\\\\\|").matcher(res).replaceAll("@");
        res = Pattern.compile("\\|").matcher(res).replaceAll("\\\\|");
        res = Pattern.compile("@").matcher(res).replaceAll("|");
        return res;
    }

    public static void runGeneratorCLI(String[] args, GeneratorTarget target) {
        if (args.length < 3) {
            String template = guistrings.getString("Version");
            Object[] arg1 = new Object[]{"1.6.6"};
            String output = "Juggling Lab " + MessageFormat.format(template, arg1).toLowerCase() + "\n";
            template = guistrings.getString("Copyright_message");
            Object[] arg2 = new Object[]{"2025"};
            output = output + MessageFormat.format(template, arg2) + "\n";
            output = output + guistrings.getString("GPL_message") + "\n\n";
            output = output + guistrings.getString("Generator_intro");
            System.out.println(output);
            return;
        }
        if (target == null) {
            return;
        }
        try {
            SiteswapGenerator ssg = new SiteswapGenerator();
            ssg.initGenerator(args);
            ssg.runGenerator(target);
        }
        catch (Exception e) {
            System.out.println(errorstrings.getString("Error") + ": " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        SiteswapGenerator.runGeneratorCLI(args, new GeneratorTarget(System.out));
    }
}

