/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.generator;

import java.text.MessageFormat;
import jugglinglab.JugglingLab;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.SiteswapTransitionerControl;
import jugglinglab.generator.Transitioner;
import jugglinglab.notation.MHNThrow;
import jugglinglab.notation.SiteswapPattern;
import jugglinglab.util.JuggleExceptionDone;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionInterrupted;
import jugglinglab.util.JuggleExceptionUser;

public class SiteswapTransitioner
extends Transitioner {
    protected static final int LOOP_COUNTER_MAX = 20000;
    protected int n;
    protected int jugglers;
    protected int indexes;
    protected int l_min;
    protected int l_max;
    protected int target_occupancy;
    protected int max_occupancy;
    protected boolean mp_allow_simulcatches;
    protected boolean mp_allow_clusters;
    protected boolean no_limits;
    protected String pattern_from;
    protected String pattern_to;
    protected SiteswapPattern siteswap_from;
    protected SiteswapPattern siteswap_to;
    protected int[][][] state_from;
    protected int[][][] state_to;
    protected String return_trans;
    protected int[][][][] state;
    protected int[][][] state_target;
    protected int l_target;
    protected int l_return;
    protected MHNThrow[][][][] th;
    protected int[][][] throws_left;
    protected boolean find_all;
    protected String[][] out;
    protected boolean[] should_print;
    protected boolean[][] async_hand_right;
    protected SiteswapPattern siteswap_prev;
    protected int target_max_filled_index;
    protected int max_num;
    protected double max_time;
    protected long max_time_millis;
    protected long start_time_millis;
    protected int loop_counter;
    protected SiteswapTransitionerControl control;
    protected GeneratorTarget target;
    protected static final int TRANS_MAX_PATTERNS = 1000;
    protected static final double TRANS_MAX_TIME = 15.0;

    @Override
    public String getNotationName() {
        return "Siteswap";
    }

    @Override
    public SiteswapTransitionerControl getTransitionerControl() {
        if (this.control == null) {
            this.control = new SiteswapTransitionerControl();
        }
        return this.control;
    }

    @Override
    public void resetTransitionerControl() {
        if (this.control != null) {
            this.control.resetControl();
        }
    }

    @Override
    public void initTransitioner() throws JuggleExceptionUser, JuggleExceptionInternal {
        if (this.control == null) {
            this.initTransitioner("5 771");
        } else {
            this.initTransitioner(this.control.getParams());
        }
    }

    @Override
    public void initTransitioner(String[] args) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.configTransitioner(args);
        this.allocateWorkspace();
    }

    @Override
    public int runTransitioner(GeneratorTarget t) throws JuggleExceptionUser, JuggleExceptionInternal {
        return this.runTransitioner(t, -1, -1.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int runTransitioner(GeneratorTarget t, int num_limit, double secs_limit) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.max_num = num_limit;
        this.max_time = secs_limit;
        if (this.max_time > 0.0) {
            this.max_time_millis = (long)(1000.0 * secs_limit);
            this.start_time_millis = System.currentTimeMillis();
            this.loop_counter = 0;
        }
        t.setPrefixSuffix("(" + this.pattern_from + "^2)", "(" + this.pattern_to + "^2)" + this.findReturnTrans());
        int num = 0;
        this.target = t;
        if (this.l_min == 0) {
            this.target.writePattern("", "siteswap", "");
            num = 1;
        } else {
            this.siteswap_prev = this.siteswap_from;
            for (int l = this.l_min; l <= this.l_max || num == 0; num += this.findTrans(this.state_from, this.state_to, l, true), ++l) {
            }
        }
        if (num == 1) {
            this.target.setStatus(guistrings.getString("Generator_patterns_1"));
        } else {
            String template = guistrings.getString("Generator_patterns_ne1");
            Object[] arguments = new Object[]{num};
            this.target.setStatus(MessageFormat.format(template, arguments));
        }
        int n = num;
        return n;
    }

    protected void configTransitioner(String[] args) throws JuggleExceptionUser, JuggleExceptionInternal {
        int to_jugglers;
        if (args.length < 2) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_trans_too_few_args"));
        }
        if (args[0].equals("-")) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_trans_from_pattern"));
        }
        if (args[1].equals("-")) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_trans_to_pattern"));
        }
        this.target_occupancy = 1;
        this.mp_allow_simulcatches = false;
        this.mp_allow_clusters = true;
        this.no_limits = false;
        this.target = null;
        for (int i = 2; i < args.length; ++i) {
            if (args[i].equals("-mf")) {
                this.mp_allow_simulcatches = true;
                continue;
            }
            if (args[i].equals("-mc")) {
                this.mp_allow_clusters = false;
                continue;
            }
            if (args[i].equals("-m")) {
                if (i >= args.length - 1 || args[i + 1].charAt(0) == '-') continue;
                try {
                    this.target_occupancy = Integer.parseInt(args[i + 1]);
                }
                catch (NumberFormatException nfe) {
                    String template = errorstrings.getString("Error_number_format");
                    String str = guistrings.getString("simultaneous_throws");
                    Object[] arguments = new Object[]{str};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
                ++i;
                continue;
            }
            if (args[i].equals("-limits")) {
                this.no_limits = true;
                continue;
            }
            String template = errorstrings.getString("Error_unrecognized_option");
            Object[] arguments = new Object[]{args[i]};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        this.pattern_from = args[0];
        this.pattern_to = args[1];
        this.siteswap_from = new SiteswapPattern();
        this.siteswap_to = new SiteswapPattern();
        try {
            this.siteswap_from.fromString(this.pattern_from);
        }
        catch (JuggleExceptionUser jeu) {
            String template = errorstrings.getString("Error_trans_in_from_pattern");
            Object[] arguments = new Object[]{jeu.getMessage()};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        try {
            this.siteswap_to.fromString(this.pattern_to);
        }
        catch (JuggleExceptionUser jeu) {
            String template = errorstrings.getString("Error_trans_in_to_pattern");
            Object[] arguments = new Object[]{jeu.getMessage()};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        int from_n = this.siteswap_from.getNumberOfPaths();
        int to_n = this.siteswap_to.getNumberOfPaths();
        if (from_n != to_n) {
            String template = errorstrings.getString("Error_trans_unequal_objects");
            Object[] arguments = new Object[]{from_n, to_n};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        this.n = from_n;
        int from_jugglers = this.siteswap_from.getNumberOfJugglers();
        if (from_jugglers != (to_jugglers = this.siteswap_to.getNumberOfJugglers())) {
            String template = errorstrings.getString("Error_trans_unequal_jugglers");
            Object[] arguments = new Object[]{from_jugglers, to_jugglers};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        this.jugglers = from_jugglers;
        this.indexes = Math.max(this.siteswap_from.getIndexes(), this.siteswap_to.getIndexes());
        this.max_occupancy = Math.max(this.target_occupancy, Math.max(this.siteswap_from.getMaxOccupancy(), this.siteswap_to.getMaxOccupancy()));
        this.state_from = this.siteswap_from.getStartingState(this.indexes);
        this.state_to = this.siteswap_to.getStartingState(this.indexes);
        this.l_min = this.findMinLength(this.state_from, this.state_to);
        this.l_max = this.findMaxLength(this.state_from, this.state_to);
        this.l_return = this.findMinLength(this.state_to, this.state_from);
    }

    protected void allocateWorkspace() {
        int size = Math.max(this.l_max, this.l_return);
        this.state = new int[size + 1][this.jugglers][2][this.indexes];
        this.state_target = new int[this.jugglers][2][this.indexes];
        this.th = new MHNThrow[this.jugglers][2][size][this.max_occupancy];
        this.throws_left = new int[size + 1][this.jugglers][2];
        this.out = new String[this.jugglers][size];
        this.should_print = new boolean[size + 1];
        this.async_hand_right = new boolean[this.jugglers][size + 1];
    }

    protected String findReturnTrans() throws JuggleExceptionUser, JuggleExceptionInternal {
        int num;
        if (this.l_return == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        this.target = new GeneratorTarget(sb);
        this.siteswap_prev = this.siteswap_to;
        while ((num = this.findTrans(this.state_to, this.state_from, this.l_return, false)) == 0) {
            ++this.l_return;
            this.allocateWorkspace();
        }
        if (num != 1) {
            throw new JuggleExceptionInternal("Too many transitions in findReturnTrans()");
        }
        String return_trans = sb.toString().replaceAll("\n", "").replaceAll("R$", "").replaceAll("\\<(R\\|)+R\\>$", "");
        return return_trans;
    }

    protected int findTrans(int[][][] from_st, int[][][] to_st, int l, boolean all) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.l_target = l;
        for (int j = 0; j < this.jugglers; ++j) {
            for (int h = 0; h < 2; ++h) {
                for (int i = 0; i < this.indexes; ++i) {
                    this.state[0][j][h][i] = from_st[j][h][i];
                    this.state_target[j][h][i] = to_st[j][h][i];
                }
            }
        }
        this.target_max_filled_index = this.getMaxFilledIndex(this.state_target);
        this.startBeat(0);
        this.find_all = all;
        int num = this.recurse(0, 0, 0);
        return num;
    }

    protected int recurse(int pos, int j, int h) throws JuggleExceptionUser, JuggleExceptionInternal {
        int ti_threshold;
        if (Thread.interrupted()) {
            throw new JuggleExceptionInterrupted();
        }
        if (this.max_time > 0.0 && ++this.loop_counter > 20000) {
            this.loop_counter = 0;
            if (System.currentTimeMillis() - this.start_time_millis > this.max_time_millis) {
                String template = guistrings.getString("Generator_timeout");
                Object[] arguments = new Object[]{(int)this.max_time};
                throw new JuggleExceptionDone(MessageFormat.format(template, arguments));
            }
        }
        while (this.throws_left[pos][j][h] == 0) {
            if (h == 1) {
                h = 0;
                ++j;
            } else {
                h = 1;
            }
            if (j != this.jugglers) continue;
            if (++pos < this.l_target) {
                this.startBeat(pos);
                h = 0;
                j = 0;
                continue;
            }
            if (this.statesEqual(this.state[pos], this.state_target)) {
                this.outputPattern();
                return 1;
            }
            return 0;
        }
        MHNThrow mhnt = new MHNThrow();
        mhnt.juggler = j + 1;
        mhnt.hand = h;
        mhnt.index = pos;
        mhnt.slot = 0;
        while (this.th[j][h][pos][mhnt.slot] != null) {
            ++mhnt.slot;
        }
        int ti_min = pos + 1;
        int ti_max = Math.min(pos + Math.min(this.indexes, 35), this.l_target + this.target_max_filled_index);
        int ti = ti_threshold = Math.min(Math.max(this.l_target, ti_min), ti_max);
        int num = 0;
        do {
            for (int tj = 0; tj < this.jugglers; ++tj) {
                for (int th = 0; th < 2; ++th) {
                    int ts = this.state[pos + 1][tj][th][ti - pos - 1];
                    int finali = ti - this.l_target;
                    if (finali >= 0 && finali < this.indexes ? ts >= this.state_target[tj][th][finali] : ts >= this.target_occupancy) continue;
                    mhnt.targetjuggler = tj + 1;
                    mhnt.targethand = th;
                    mhnt.targetindex = ti;
                    mhnt.targetslot = ts;
                    if (!this.isThrowValid(pos, mhnt)) continue;
                    this.addThrow(pos, mhnt);
                    this.removeThrow(pos, mhnt);
                    if (!this.find_all && (num += this.recurse(pos, j, h)) > 0) {
                        return num;
                    }
                    if (this.max_num <= 0 || num < this.max_num) continue;
                    String template = guistrings.getString("Generator_spacelimit");
                    Object[] arguments = new Object[]{this.max_num};
                    throw new JuggleExceptionDone(MessageFormat.format(template, arguments));
                }
            }
            if (++ti <= ti_max) continue;
            ti = ti_min;
        } while (ti != ti_threshold);
        return num;
    }

    protected boolean isThrowValid(int pos, MHNThrow mhnt) {
        MHNThrow prev;
        int s;
        int[][][] next_st;
        int j = mhnt.juggler - 1;
        int h = mhnt.hand;
        int i = mhnt.index;
        int targetj = mhnt.targetjuggler - 1;
        int targeth = mhnt.targethand;
        int targeti = mhnt.targetindex;
        if (targeti - i > 35) {
            return false;
        }
        int[][][] nArray = next_st = pos + 1 == this.l_target ? this.state_target : this.state[pos + 1];
        if (next_st[j][h][0] > 0 && (targetj != j || targeth != h || targeti != i + 1)) {
            return false;
        }
        if (pos > 0 && this.state[pos - 1][j][h][0] > 0 && targetj == j && targeth == h && targeti == i + 1) {
            return false;
        }
        for (s = 0; s < this.max_occupancy && (prev = this.th[j][h][pos][s]) != null; ++s) {
            if (MHNThrow.compareThrows(mhnt, prev) != 1) continue;
            return false;
        }
        if (this.max_occupancy > 1 && !this.mp_allow_clusters) {
            for (s = 0; s < this.max_occupancy && (prev = this.th[j][h][pos][s]) != null; ++s) {
                if (MHNThrow.compareThrows(mhnt, prev) != 0) continue;
                return false;
            }
        }
        if (this.target_occupancy > 1 && !this.mp_allow_simulcatches && this.th[j][h][pos][0] != null) {
            int num_not_holds = 0;
            for (int j2 = 0; j2 < this.jugglers; ++j2) {
                for (int h2 = 0; h2 < 2; ++h2) {
                    for (int i2 = 0; i2 < pos; ++i2) {
                        MHNThrow mhnt2;
                        for (int s2 = 0; s2 < this.max_occupancy && (mhnt2 = this.th[j2][h2][i2][s2]) != null; ++s2) {
                            if (mhnt2.targetjuggler != mhnt.juggler || mhnt2.targethand != mhnt.hand || mhnt2.targetindex != pos || mhnt2.isHold()) continue;
                            ++num_not_holds;
                        }
                    }
                }
            }
            MHNThrow[][][][] th2 = this.siteswap_prev.getThrows();
            int period = this.siteswap_prev.getPeriod();
            int slots = this.siteswap_prev.getMaxOccupancy();
            for (int j2 = 0; j2 < this.jugglers; ++j2) {
                for (int h2 = 0; h2 < 2; ++h2) {
                    for (int i2 = 0; i2 < period; ++i2) {
                        MHNThrow mhnt2;
                        for (int s2 = 0; s2 < slots && (mhnt2 = th2[j2][h2][i2][s2]) != null; ++s2) {
                            boolean correct_index;
                            int index_overshoot = mhnt2.targetindex - (pos + period);
                            boolean bl = correct_index = index_overshoot >= 0 && index_overshoot % period == 0;
                            if (!correct_index || mhnt2.targetjuggler != mhnt.juggler || mhnt2.targethand != mhnt.hand || mhnt2.isHold()) continue;
                            ++num_not_holds;
                        }
                    }
                }
            }
            if (num_not_holds > 1) {
                return false;
            }
        }
        if ((targeti - i != 1 || targetj != j || targeth != h) && targeti - pos - 2 >= 0) {
            int reserved = this.state[pos + 1][targetj][targeth][targeti - pos - 2];
            int max_slot = this.target_occupancy - 1;
            int finali = targeti - this.l_target;
            if (finali >= 0 && finali < this.indexes) {
                max_slot = this.state_target[targetj][targeth][finali] - 1;
            }
            if (mhnt.targetslot > max_slot - reserved) {
                return false;
            }
        }
        return true;
    }

    protected void addThrow(int pos, MHNThrow mhnt) {
        int j = mhnt.juggler - 1;
        int h = mhnt.hand;
        int i = mhnt.index;
        int s = mhnt.slot;
        int dj = mhnt.targetjuggler - 1;
        int dh = mhnt.targethand;
        int di = mhnt.targetindex;
        this.th[j][h][i][s] = mhnt;
        int[] nArray = this.throws_left[pos][j];
        int n = h;
        nArray[n] = nArray[n] - 1;
        for (int pos2 = pos + 1; pos2 <= this.l_target && pos2 <= di; ++pos2) {
            int[] nArray2 = this.state[pos2][dj][dh];
            int n2 = di - pos2;
            nArray2[n2] = nArray2[n2] + 1;
        }
    }

    protected void removeThrow(int pos, MHNThrow mhnt) {
        int j = mhnt.juggler - 1;
        int h = mhnt.hand;
        int i = mhnt.index;
        int s = mhnt.slot;
        int dj = mhnt.targetjuggler - 1;
        int dh = mhnt.targethand;
        int di = mhnt.targetindex;
        this.th[j][h][i][s] = null;
        int[] nArray = this.throws_left[pos][j];
        int n = h;
        nArray[n] = nArray[n] + 1;
        for (int pos2 = pos + 1; pos2 <= this.l_target && pos2 <= di; ++pos2) {
            int[] nArray2 = this.state[pos2][dj][dh];
            int n2 = di - pos2;
            nArray2[n2] = nArray2[n2] - 1;
        }
    }

    protected void outputPattern() throws JuggleExceptionInternal {
        int j;
        if (this.target == null) {
            return;
        }
        for (int pos = 0; pos < this.l_target; ++pos) {
            this.outputBeat(pos);
        }
        StringBuffer sb = new StringBuffer();
        if (this.jugglers > 1) {
            sb.append('<');
        }
        for (int j2 = 0; j2 < this.jugglers; ++j2) {
            for (int i = 0; i < this.l_target; ++i) {
                sb.append(this.out[j2][i]);
            }
            if (sb.length() > 0 && sb.charAt(sb.length() - 1) == '/') {
                sb.deleteCharAt(sb.length() - 1);
            }
            if (j2 >= this.jugglers - 1) continue;
            sb.append('|');
        }
        if (this.jugglers > 1) {
            sb.append('>');
        }
        boolean needs_hands_modifier = false;
        for (j = 0; j < this.jugglers; ++j) {
            if (this.async_hand_right[j][this.l_target]) continue;
            needs_hands_modifier = true;
            break;
        }
        if (needs_hands_modifier) {
            if (this.jugglers > 1) {
                sb.append('<');
            }
            for (j = 0; j < this.jugglers; ++j) {
                sb.append('R');
                if (j >= this.jugglers - 1) continue;
                sb.append('|');
            }
            if (this.jugglers > 1) {
                sb.append('>');
            }
        }
        this.target.writePattern(sb.toString(), "siteswap", sb.toString().trim());
    }

    protected void outputBeat(int pos) {
        if (!this.should_print[pos]) {
            this.should_print[pos + 1] = true;
            for (int j = 0; j < this.jugglers; ++j) {
                this.async_hand_right[j][pos + 1] = !this.async_hand_right[j][pos];
                this.out[j][pos] = "";
            }
            return;
        }
        boolean have_sync_throw = false;
        boolean have_throw_next_beat = false;
        for (int j = 0; j < this.jugglers; ++j) {
            if (this.th[j][0][pos][0] != null && this.th[j][1][pos][0] != null) {
                have_sync_throw = true;
            }
            if (this.state[pos + 1][j][0][0] <= 0 && this.state[pos + 1][j][1][0] <= 0) continue;
            have_throw_next_beat = true;
        }
        boolean print_double_beat = have_sync_throw && !have_throw_next_beat;
        this.should_print[pos + 1] = !print_double_beat;
        for (int j = 0; j < this.jugglers; ++j) {
            StringBuffer sb = new StringBuffer();
            boolean async_hand_right_next = !this.async_hand_right[j][pos];
            int hands_throwing = 0;
            if (this.th[j][0][pos][0] != null) {
                ++hands_throwing;
            }
            if (this.th[j][1][pos][0] != null) {
                ++hands_throwing;
            }
            switch (hands_throwing) {
                case 0: {
                    if (pos == 0 && this.siteswap_prev.hasHandsSpecifier()) {
                        sb.append('R');
                    }
                    sb.append('0');
                    if (!print_double_beat) break;
                    sb.append('0');
                    break;
                }
                case 1: {
                    boolean needs_slash;
                    if (this.th[j][0][pos][0] != null) {
                        if (!this.async_hand_right[j][pos]) {
                            sb.append('R');
                            async_hand_right_next = false;
                        } else if (pos == 0 && this.siteswap_prev.hasHandsSpecifier()) {
                            sb.append('R');
                        }
                        needs_slash = this.outputMultiThrow(pos, j, 0, sb);
                    } else {
                        if (this.async_hand_right[j][pos]) {
                            sb.append('L');
                            async_hand_right_next = true;
                        } else if (pos == 0 && this.siteswap_prev.hasHandsSpecifier()) {
                            sb.append('R');
                        }
                        needs_slash = this.outputMultiThrow(pos, j, 1, sb);
                    }
                    if (needs_slash) {
                        sb.append('/');
                    }
                    if (!print_double_beat) break;
                    sb.append('0');
                    break;
                }
                case 2: {
                    if (pos == 0 && this.siteswap_prev.hasHandsSpecifier()) {
                        sb.append('R');
                    }
                    sb.append('(');
                    this.outputMultiThrow(pos, j, 1, sb);
                    sb.append(',');
                    this.outputMultiThrow(pos, j, 0, sb);
                    sb.append(')');
                    if (print_double_beat && pos != this.l_target - 1) break;
                    sb.append('!');
                }
            }
            this.async_hand_right[j][pos + 1] = async_hand_right_next;
            this.out[j][pos] = sb.toString();
        }
    }

    protected boolean outputMultiThrow(int pos, int j, int h, StringBuffer sb) {
        MHNThrow mhnt;
        int s;
        boolean needs_slash = false;
        int num_throws = 0;
        for (s = 0; s < this.max_occupancy; ++s) {
            if (this.th[j][h][pos][s] == null) continue;
            ++num_throws;
        }
        if (num_throws == 0) {
            return false;
        }
        if (num_throws > 1) {
            sb.append('[');
        }
        for (s = 0; s < this.max_occupancy && (mhnt = this.th[j][h][pos][s]) != null; ++s) {
            boolean is_pass;
            int beats = mhnt.targetindex - mhnt.index;
            boolean is_crossed = mhnt.hand == mhnt.targethand ^ beats % 2 == 0;
            boolean bl = is_pass = mhnt.targetjuggler != mhnt.juggler;
            if (beats < 36) {
                sb.append(Character.toLowerCase(Character.forDigit(beats, 36)));
            } else {
                sb.append('?');
            }
            if (is_crossed) {
                sb.append('x');
            }
            if (is_pass) {
                boolean another_throw;
                sb.append('p');
                if (this.jugglers > 2) {
                    sb.append(mhnt.targetjuggler);
                }
                boolean bl2 = another_throw = s + 1 < this.max_occupancy && this.th[j][h][pos][s + 1] != null;
                if (another_throw) {
                    sb.append('/');
                }
                needs_slash = true;
                continue;
            }
            needs_slash = false;
        }
        if (num_throws > 1) {
            sb.append(']');
            needs_slash = false;
        }
        return needs_slash;
    }

    protected void startBeat(int pos) {
        int j;
        if (pos == 0) {
            this.should_print[0] = true;
            for (j = 0; j < this.jugglers; ++j) {
                this.async_hand_right[j][0] = true;
            }
        }
        for (j = 0; j < this.jugglers; ++j) {
            for (int h = 0; h < 2; ++h) {
                for (int i = 0; i < this.indexes - 1; ++i) {
                    this.state[pos + 1][j][h][i] = this.state[pos][j][h][i + 1];
                }
                this.state[pos + 1][j][h][this.indexes - 1] = 0;
                this.throws_left[pos][j][h] = this.state[pos][j][h][0];
            }
        }
    }

    protected boolean statesEqual(int[][][] s1, int[][][] s2) {
        for (int j = 0; j < this.jugglers; ++j) {
            for (int h = 0; h < 2; ++h) {
                for (int i = 0; i < this.indexes; ++i) {
                    if (s1[j][h][i] == s2[j][h][i]) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void printState(int[][][] state) {
        int h;
        int j;
        int i;
        int last_index = 0;
        for (i = 0; i < this.indexes; ++i) {
            for (j = 0; j < this.jugglers; ++j) {
                for (h = 0; h < 2; ++h) {
                    if (state[j][h][i] == 0) continue;
                    last_index = i;
                }
            }
        }
        for (i = 0; i <= last_index; ++i) {
            for (j = 0; j < this.jugglers; ++j) {
                for (h = 0; h < 2; ++h) {
                    System.out.println("  s[" + j + "][" + h + "][" + i + "] = " + state[j][h][i]);
                }
            }
        }
    }

    protected int findMinLength(int[][][] from_st, int[][][] to_st) {
        int length = 0;
        while (true) {
            boolean done = true;
            for (int j = 0; j < this.jugglers; ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int i = 0; i < this.indexes - length; ++i) {
                        if (from_st[j][h][i + length] <= to_st[j][h][i]) continue;
                        done = false;
                    }
                }
            }
            if (done) {
                return length;
            }
            ++length;
        }
    }

    protected int findMaxLength(int[][][] from_st, int[][][] to_st) {
        int length = 0;
        for (int i = 0; i < this.indexes; ++i) {
            for (int j = 0; j < this.jugglers; ++j) {
                for (int h = 0; h < 2; ++h) {
                    if (from_st[j][h][i] <= 0) continue;
                    length = i + 1;
                }
            }
        }
        return length;
    }

    protected int getMaxFilledIndex(int[][][] to_st) {
        for (int i = this.indexes - 1; i >= 0; --i) {
            for (int j = 0; j < this.jugglers; ++j) {
                for (int h = 0; h < 2; ++h) {
                    if (to_st[j][h][i] <= 0) continue;
                    return i;
                }
            }
        }
        return 0;
    }

    protected void printThrowSet() {
        StringBuffer sb = new StringBuffer();
        for (int pos = 0; pos < this.l_target; ++pos) {
            for (int j = 0; j < this.jugglers; ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int s = 0; s < this.max_occupancy; ++s) {
                        MHNThrow mhnt = this.th[j][h][pos][s];
                        if (mhnt == null) continue;
                        for (int t = 0; t < pos; ++t) {
                            sb.append(".  ");
                        }
                        sb.append(mhnt.toString() + "\n");
                    }
                }
            }
        }
        System.out.println(sb.toString());
    }

    public static void runTransitionerCLI(String[] args, GeneratorTarget target) {
        if (args.length < 2) {
            String template = guistrings.getString("Version");
            Object[] arg1 = new Object[]{"1.6.6"};
            String output = "Juggling Lab " + MessageFormat.format(template, arg1).toLowerCase() + "\n";
            template = guistrings.getString("Copyright_message");
            Object[] arg2 = new Object[]{"2025"};
            output = output + MessageFormat.format(template, arg2) + "\n";
            output = output + guistrings.getString("GPL_message") + "\n\n";
            String intro = guistrings.getString("Transitioner_intro");
            if (JugglingLab.isWindows) {
                intro = intro.replaceAll("'", "\"");
            }
            output = output + intro;
            System.out.println(output);
            return;
        }
        if (target == null) {
            return;
        }
        try {
            SiteswapTransitioner sst = new SiteswapTransitioner();
            sst.initTransitioner(args);
            if (sst.no_limits) {
                sst.runTransitioner(target);
            } else {
                sst.runTransitioner(target, 1000, 15.0);
            }
        }
        catch (JuggleExceptionDone e) {
            System.out.println(e.getMessage());
        }
        catch (Exception e) {
            System.out.println(errorstrings.getString("Error") + ": " + e.getMessage());
        }
    }

    public static void main(String[] args) {
        SiteswapTransitioner.runTransitionerCLI(args, new GeneratorTarget(System.out));
    }
}

