/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.generator;

import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import jugglinglab.JugglingLab;
import jugglinglab.generator.GeneratorTarget;
import jugglinglab.generator.SiteswapTransitioner;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public abstract class Transitioner {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    public static final String[] builtinTransitioners = new String[]{"Siteswap"};

    public static Transitioner newTransitioner(String name) {
        if (name.equalsIgnoreCase("siteswap")) {
            return new SiteswapTransitioner();
        }
        return null;
    }

    public void initTransitioner(String arg) throws JuggleExceptionUser, JuggleExceptionInternal {
        StringTokenizer st = new StringTokenizer(arg, " \n");
        int numargs = st.countTokens();
        String[] args = new String[numargs];
        for (int i = 0; i < numargs; ++i) {
            args[i] = st.nextToken();
        }
        this.initTransitioner(args);
    }

    public abstract String getNotationName();

    public abstract JPanel getTransitionerControl();

    public abstract void resetTransitionerControl();

    public abstract void initTransitioner() throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract void initTransitioner(String[] var1) throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract int runTransitioner(GeneratorTarget var1) throws JuggleExceptionUser, JuggleExceptionInternal;

    public abstract int runTransitioner(GeneratorTarget var1, int var2, double var3) throws JuggleExceptionUser, JuggleExceptionInternal;
}

