/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import jugglinglab.jml.HandLink;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;

public class EventImages {
    protected JMLPattern pat;
    protected int numjugglers;
    protected int numpaths;
    protected double looptime;
    protected Permutation loopperm;
    protected JMLEvent ev = null;
    protected int evjuggler;
    protected int evhand;
    protected int evtransitions;
    protected double evtime;
    protected Permutation[][][] ea;
    protected int numentries;
    protected int[] transitiontype;
    protected int currentloop;
    protected int currentj;
    protected int currenth;
    protected int currententry;

    public EventImages(JMLPattern pat, JMLEvent ev) throws JuggleExceptionUser {
        this.pat = pat;
        this.ev = ev;
        this.calcarray();
        this.resetPosition();
        ev.delay = 0;
        ev.delayunits = this.numentries;
    }

    public JMLEvent getNext() {
        do {
            if (++this.currenth != 2) continue;
            this.currenth = 0;
            if (++this.currentj != this.numjugglers) continue;
            this.currentj = 0;
            if (++this.currententry != this.numentries) continue;
            this.currententry = 0;
            ++this.currentloop;
        } while (this.ea[this.currentj][this.currenth][this.currententry] == null);
        return this.makeEvent();
    }

    public JMLEvent getPrevious() {
        do {
            if (this.currenth-- != 0) continue;
            this.currenth = 1;
            if (this.currentj-- != 0) continue;
            this.currentj = this.numjugglers - 1;
            if (this.currententry-- != 0) continue;
            this.currententry = this.numentries - 1;
            --this.currentloop;
        } while (this.ea[this.currentj][this.currenth][this.currententry] == null);
        return this.makeEvent();
    }

    protected JMLEvent makeEvent() {
        JMLEvent newevent = this.ev.duplicate(this.currententry + this.numentries * this.currentloop, this.numentries);
        newevent.setHand(this.currentj + 1, this.currenth == 0 ? 1 : 2);
        if (this.currenth != this.evhand) {
            Coordinate c1 = newevent.getLocalCoordinate();
            c1.x = -c1.x;
            newevent.setLocalCoordinate(c1);
        }
        Permutation p = this.ea[this.currentj][this.currenth][this.currententry];
        Permutation lp = this.loopperm;
        int pow = this.currentloop;
        if (pow < 0) {
            lp = lp.getInverse();
            pow = -pow;
        }
        while (pow > 0) {
            p = lp.apply(p);
            --pow;
        }
        for (int i = 0; i < this.evtransitions; ++i) {
            JMLTransition tr = newevent.getTransition(i);
            int masterpath = this.ev.getTransition(i).getPath();
            tr.setPath(p.getMapping(masterpath));
        }
        newevent.setPathPermFromMaster(p);
        double t = this.evtime + (double)this.currentloop * this.looptime + (double)this.currententry * (this.looptime / (double)this.numentries);
        newevent.setT(t);
        return newevent;
    }

    public void resetPosition() {
        this.currentloop = 0;
        this.currentj = this.evjuggler;
        this.currenth = this.evhand;
        this.currententry = 0;
    }

    public boolean hasJMLTransitionForHand(int jug, int han) {
        for (int i = 0; i < this.numentries; ++i) {
            if (this.ea[jug - 1][HandLink.index(han)][i] == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasVDJMLTransitionForHand(int jug, int han) {
        int i;
        for (i = 0; i < this.numentries && this.ea[jug - 1][HandLink.index(han)][i] == null; ++i) {
        }
        if (i == this.numentries) {
            return false;
        }
        for (int j = 0; j < this.evtransitions; ++j) {
            if (this.transitiontype[j] != 1 && this.transitiontype[j] != 3) continue;
            return true;
        }
        return false;
    }

    public boolean hasJMLTransitionForPath(int path) {
        int[] cycle = this.loopperm.getCycle(path);
        for (int i = 0; i < this.numjugglers; ++i) {
            for (int j = 0; j < this.numentries; ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int k = 0; k < this.evtransitions; ++k) {
                        if (this.ea[i][h][j] == null) continue;
                        int newp = this.ea[i][h][j].getMapping(this.ev.getTransition(k).getPath());
                        for (int l = 0; l < cycle.length; ++l) {
                            if (newp != cycle[l]) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    public boolean hasVDJMLTransitionForPath(int path) {
        int[] cycle = this.loopperm.getCycle(path);
        for (int k = 0; k < this.evtransitions; ++k) {
            if (this.transitiontype[k] != 1 && this.transitiontype[k] != 3) continue;
            for (int i = 0; i < this.numjugglers; ++i) {
                for (int j = 0; j < this.numentries; ++j) {
                    for (int h = 0; h < 2; ++h) {
                        if (this.ea[i][h][j] == null) continue;
                        int newp = this.ea[i][h][j].getMapping(this.ev.getTransition(k).getPath());
                        for (int l = 0; l < cycle.length; ++l) {
                            if (newp != cycle[l]) continue;
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    protected void calcarray() throws JuggleExceptionUser {
        boolean changed;
        this.numjugglers = this.pat.getNumberOfJugglers();
        this.numpaths = this.pat.getNumberOfPaths();
        this.looptime = this.pat.getLoopEndTime() - this.pat.getLoopStartTime();
        this.loopperm = this.pat.getPathPermutation();
        this.evjuggler = this.ev.getJuggler() - 1;
        this.evhand = HandLink.index(this.ev.getHand());
        this.evtransitions = this.ev.getNumberOfTransitions();
        this.evtime = this.ev.getT();
        int numsyms = this.pat.symmetries().size() - 1;
        JMLSymmetry[] sym = new JMLSymmetry[numsyms];
        int[] symperiod = new int[numsyms];
        int[] deltaentries = new int[numsyms];
        Permutation invdelayperm = null;
        this.numentries = 1;
        int index = 0;
        for (JMLSymmetry temp : this.pat.symmetries()) {
            switch (temp.getType()) {
                case 1: {
                    invdelayperm = temp.getPathPerm().getInverse();
                    break;
                }
                case 2: {
                    sym[index] = temp;
                    symperiod[index] = temp.getJugglerPerm().getOrder();
                    deltaentries[index] = 0;
                    ++index;
                    break;
                }
                case 3: {
                    sym[index] = temp;
                    symperiod[index] = temp.getJugglerPerm().getOrder();
                    this.numentries = Permutation.lcm(this.numentries, symperiod[index]);
                    deltaentries[index] = -1;
                    ++index;
                }
            }
        }
        for (int i = 0; i < numsyms; ++i) {
            if (deltaentries[i] != -1) continue;
            deltaentries[i] = this.numentries / symperiod[i];
        }
        this.ea = new Permutation[this.numjugglers][2][this.numentries];
        this.transitiontype = new int[this.evtransitions];
        Permutation idperm = new Permutation(this.numpaths, false);
        this.ev.setPathPermFromMaster(idperm);
        this.ea[this.evjuggler][this.evhand][0] = idperm;
        for (int i = 0; i < this.evtransitions; ++i) {
            JMLTransition tr = this.ev.getTransition(i);
            this.transitiontype[i] = tr.getType();
        }
        do {
            changed = false;
            for (int i = 0; i < numsyms; ++i) {
                for (int j = 0; j < this.numjugglers; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        for (int l = 0; l < this.numentries; ++l) {
                            int newk;
                            int newj = sym[i].getJugglerPerm().getMapping(j + 1);
                            if (newj == 0) continue;
                            int n = newk = newj < 0 ? 1 - k : k;
                            if (newj < 0) {
                                newj = -newj;
                            }
                            --newj;
                            Permutation p = this.ea[j][k][l];
                            if (p == null) continue;
                            p = sym[i].getPathPerm().apply(p);
                            int newl = l + deltaentries[i];
                            if (newl >= this.numentries) {
                                p = invdelayperm.apply(p);
                                newl -= this.numentries;
                            }
                            if (this.ea[newj][newk][newl] != null) {
                                if (p.equals(this.ea[newj][newk][newl])) continue;
                                throw new JuggleExceptionUser("Symmetries inconsistent");
                            }
                            this.ea[newj][newk][newl] = p;
                            changed = true;
                        }
                    }
                }
            }
        } while (changed);
    }
}

