/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import jugglinglab.curve.Curve;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.VelocityRef;
import jugglinglab.util.Coordinate;

public class HandLink {
    protected int jugglernum;
    protected int handnum;
    protected JMLEvent startevent;
    protected JMLEvent endevent;
    protected VelocityRef startvelref;
    protected VelocityRef endvelref;
    protected Curve hp;
    protected boolean ismaster;
    protected HandLink[] duplicates;
    protected HandLink master;
    public static final int NO_HAND = 0;
    public static final int LEFT_HAND = 1;
    public static final int RIGHT_HAND = 2;

    public HandLink(int jugglernum, int handnum, JMLEvent startevent, JMLEvent endevent) {
        this.jugglernum = jugglernum;
        this.handnum = handnum;
        this.startevent = startevent;
        this.endevent = endevent;
        this.hp = null;
        this.ismaster = true;
        this.duplicates = null;
        this.master = null;
    }

    public static int index(int handdescription) {
        return handdescription == 1 ? 0 : 1;
    }

    public int getJuggler() {
        return this.jugglernum;
    }

    public int getHand() {
        return this.handnum;
    }

    public JMLEvent getStartEvent() {
        return this.startevent;
    }

    public JMLEvent getEndEvent() {
        return this.endevent;
    }

    public VelocityRef getStartVelocityRef() {
        return this.startvelref;
    }

    public void setStartVelocityRef(VelocityRef vr) {
        this.startvelref = vr;
    }

    public VelocityRef getEndVelocityRef() {
        return this.endvelref;
    }

    public void setEndVelocityRef(VelocityRef vr) {
        this.endvelref = vr;
    }

    public void setHandCurve(Curve hp) {
        this.hp = hp;
    }

    public Curve getHandCurve() {
        return this.hp;
    }

    public boolean isMaster() {
        return this.ismaster;
    }

    public String toString() {
        Curve hp;
        Coordinate vel;
        String result = null;
        Coordinate start = this.startevent.getGlobalCoordinate();
        result = "Link from (x=" + start.x + ",y=" + start.y + ",z=" + start.z + ",t=" + this.startevent.getT() + ") ";
        Coordinate end = this.endevent.getGlobalCoordinate();
        result = result + "to (x=" + end.x + ",y=" + end.y + ",z=" + end.z + ",t=" + this.endevent.getT() + ")";
        VelocityRef vr = this.getStartVelocityRef();
        if (vr != null) {
            vel = vr.getVelocity();
            result = result + "\n      start velocity (x=" + vel.x + ",y=" + vel.y + ",z=" + vel.z + ")";
        }
        if ((vr = this.getEndVelocityRef()) != null) {
            vel = vr.getVelocity();
            result = result + "\n      end velocity (x=" + vel.x + ",y=" + vel.y + ",z=" + vel.z + ")";
        }
        if ((hp = this.getHandCurve()) != null) {
            Coordinate maxcoord = hp.getMax(this.startevent.getT(), this.endevent.getT());
            Coordinate mincoord = hp.getMin(this.startevent.getT(), this.endevent.getT());
            result = result + "\n      minimum (x=" + mincoord.x + ",y=" + mincoord.y + ",z=" + mincoord.z + ")";
            result = result + "\n      maximum (x=" + maxcoord.x + ",y=" + maxcoord.y + ",z=" + maxcoord.z + ")";
        } else {
            result = result + "\n      no handpath";
        }
        return result;
    }
}

