/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PathLink;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;

public class JMLEvent {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected double x;
    protected double y;
    protected double z;
    protected double gx;
    protected double gy;
    protected double gz;
    protected boolean globalvalid;
    protected double t;
    protected int juggler;
    protected int hand;
    protected ArrayList<JMLTransition> transitions = new ArrayList();
    protected int[][][] eventarray;
    protected int delay;
    protected int delayunits;
    protected Permutation pathpermfrommaster;
    protected JMLEvent master;
    public boolean calcpos = false;
    protected JMLEvent prev;
    protected JMLEvent next;

    public Coordinate getLocalCoordinate() {
        return new Coordinate(this.x, this.y, this.z);
    }

    public void setLocalCoordinate(Coordinate c) {
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
        this.globalvalid = false;
    }

    public Coordinate getGlobalCoordinate() {
        return this.globalvalid ? new Coordinate(this.gx, this.gy, this.gz) : null;
    }

    public void setGlobalCoordinate(Coordinate c) {
        this.gx = c.x;
        this.gy = c.y;
        this.gz = c.z;
        this.globalvalid = true;
    }

    public double getT() {
        return this.t;
    }

    public void setT(double time) {
        this.t = time;
    }

    public int getHand() {
        return this.hand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setHand(String strhand) throws JuggleExceptionUser {
        int index = strhand.indexOf(":");
        if (index == -1) {
            this.juggler = 1;
            if (strhand.equalsIgnoreCase("left")) {
                this.hand = 1;
                return;
            } else {
                if (!strhand.equalsIgnoreCase("right")) throw new JuggleExceptionUser(errorstrings.getString("Error_hand_name") + " '" + strhand + "'");
                this.hand = 2;
            }
            return;
        } else {
            this.juggler = Integer.valueOf(strhand.substring(0, index));
            String substr = strhand.substring(index + 1);
            if (substr.equalsIgnoreCase("left")) {
                this.hand = 1;
                return;
            } else {
                if (!substr.equalsIgnoreCase("right")) throw new JuggleExceptionUser(errorstrings.getString("Error_hand_name") + " '" + strhand + "'");
                this.hand = 2;
            }
        }
    }

    public void setHand(int j, int h) {
        this.juggler = j;
        this.hand = h;
    }

    public int getJuggler() {
        return this.juggler;
    }

    public int getNumberOfTransitions() {
        return this.transitions.size();
    }

    public JMLTransition getTransition(int index) {
        return this.transitions.get(index);
    }

    public Collection<JMLTransition> transitions() {
        return this.transitions;
    }

    public void addTransition(JMLTransition trans) {
        this.transitions.add(trans);
    }

    public void removeTransition(int index) {
        this.transitions.remove(index);
    }

    public void removeTransition(JMLTransition trans) {
        this.transitions.remove(trans);
    }

    public boolean isMaster() {
        return this.master == null;
    }

    public JMLEvent getMaster() {
        return this.master;
    }

    public void setMaster(JMLEvent master) {
        this.master = master;
    }

    public JMLEvent getPrevious() {
        return this.prev;
    }

    public void setPrevious(JMLEvent prev) {
        this.prev = prev;
    }

    public JMLEvent getNext() {
        return this.next;
    }

    public void setNext(JMLEvent next) {
        this.next = next;
    }

    public JMLEvent getPreviousForHand() {
        JMLEvent ev = this.getPrevious();
        while (ev != null) {
            if (ev.getJuggler() == this.getJuggler() && ev.getHand() == this.getHand()) {
                return ev;
            }
            ev = ev.getPrevious();
        }
        return null;
    }

    public JMLEvent getNextForHand() {
        JMLEvent ev = this.getNext();
        while (ev != null) {
            if (ev.getJuggler() == this.getJuggler() && ev.getHand() == this.getHand()) {
                return ev;
            }
            ev = ev.getNext();
        }
        return null;
    }

    public Permutation getPathPermFromMaster() {
        return this.pathpermfrommaster;
    }

    public void setPathPermFromMaster(Permutation p) {
        this.pathpermfrommaster = p;
    }

    public boolean isDelayOf(JMLEvent ev2) {
        JMLEvent mast2;
        JMLEvent mast1 = this.getMaster() == null ? this : this.getMaster();
        JMLEvent jMLEvent = mast2 = ev2.getMaster() == null ? ev2 : ev2.getMaster();
        if (mast1 != mast2) {
            return false;
        }
        if (this.getJuggler() != ev2.getJuggler() || this.getHand() != ev2.getHand()) {
            return false;
        }
        int totaldelay = this.delay - ev2.delay;
        if (totaldelay < 0) {
            totaldelay = -totaldelay;
        }
        return totaldelay % this.delayunits == 0;
    }

    public boolean hasSameMasterAs(JMLEvent ev2) {
        JMLEvent mast2;
        JMLEvent mast1 = this.getMaster() == null ? this : this.getMaster();
        JMLEvent jMLEvent = mast2 = ev2.getMaster() == null ? ev2 : ev2.getMaster();
        return mast1 == mast2;
    }

    public JMLTransition getPathTransition(int path, int transtype) {
        for (JMLTransition tr : this.transitions) {
            if (tr.getPath() != path || transtype != 6 && transtype != tr.getType()) continue;
            return tr;
        }
        return null;
    }

    public boolean hasThrow() {
        for (JMLTransition tr : this.transitions()) {
            if (tr.getType() != 1) continue;
            return true;
        }
        return false;
    }

    public boolean hasThrowOrCatch() {
        for (JMLTransition tr : this.transitions()) {
            int type = tr.getType();
            if (type != 1 && type != 2 && type != 3 && type != 4) continue;
            return true;
        }
        return false;
    }

    public boolean hasPassingThrow() {
        for (JMLTransition tr : this.transitions()) {
            PathLink pl;
            if (tr.getType() != 1 || (pl = tr.getOutgoingPathLink()) == null || pl.getEndEvent() == null || pl.getEndEvent().getJuggler() == this.getJuggler()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPassingCatch() {
        for (JMLTransition tr : this.transitions()) {
            PathLink pl;
            if (tr.getType() != 2 && tr.getType() != 3 && tr.getType() != 4 || (pl = tr.getIncomingPathLink()) == null || pl.getStartEvent() == null || pl.getStartEvent().getJuggler() == this.getJuggler()) continue;
            return true;
        }
        return false;
    }

    public boolean hasPassingTransition() {
        return this.hasPassingThrow() || this.hasPassingCatch();
    }

    public JMLEvent duplicate(int delay, int delayunits) {
        JMLEvent dup = new JMLEvent();
        dup.setLocalCoordinate(this.getLocalCoordinate());
        dup.setT(this.getT());
        dup.setHand(this.getJuggler(), this.getHand());
        dup.delay = delay;
        dup.delayunits = delayunits;
        dup.calcpos = this.calcpos;
        for (JMLTransition tr : this.transitions()) {
            dup.addTransition(tr.duplicate());
        }
        dup.setMaster(this.isMaster() ? this : this.master);
        return dup;
    }

    public int getHashCode() {
        Coordinate c = this.getLocalCoordinate();
        String s = "<event x=\"" + JLFunc.toStringRounded(c.x, 4) + "\" y=\"" + JLFunc.toStringRounded(c.y, 4) + "\" z=\"" + JLFunc.toStringRounded(c.z, 4) + "\" t=\"" + JLFunc.toStringRounded(this.getT(), 4) + "\" hand=\"" + Integer.toString(this.getJuggler()) + ":" + (this.getHand() == 1 ? "left" : "right") + "\">";
        return s.hashCode();
    }

    public void readJML(JMLNode current, String jmlvers, int njugglers, int npaths) throws JuggleExceptionUser {
        JMLAttributes at = current.getAttributes();
        double tempx = 0.0;
        double tempy = 0.0;
        double tempz = 0.0;
        double tempt = 0.0;
        String handstr = null;
        try {
            int i = 0;
            while (i < at.getNumberOfAttributes()) {
                if (at.getAttributeName(i).equalsIgnoreCase("x")) {
                    tempx = JLFunc.parseDouble(at.getAttributeValue(i));
                } else if (at.getAttributeName(i).equalsIgnoreCase("y")) {
                    tempy = JLFunc.parseDouble(at.getAttributeValue(i));
                } else if (at.getAttributeName(i).equalsIgnoreCase("z")) {
                    tempz = JLFunc.parseDouble(at.getAttributeValue(i));
                } else if (at.getAttributeName(i).equalsIgnoreCase("t")) {
                    tempt = JLFunc.parseDouble(at.getAttributeValue(i));
                } else if (at.getAttributeName(i).equalsIgnoreCase("hand")) {
                    handstr = at.getAttributeValue(i);
                }
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_event_coordinate"));
        }
        if (jmlvers.equals("1.0")) {
            double temp = tempy;
            tempy = tempz;
            tempz = temp;
        }
        this.setLocalCoordinate(new Coordinate(tempx, tempy, tempz));
        this.setT(tempt);
        if (handstr == null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_unspecified_hand"));
        }
        this.setHand(handstr);
        if (this.juggler > njugglers || this.juggler < 1) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_juggler_out_of_range"));
        }
        int i = 0;
        while (i < current.getNumberOfChildren()) {
            JMLNode child = current.getChildNode(i);
            String nodetype = child.getNodeType();
            at = child.getAttributes();
            String path = null;
            String transtype = null;
            String mod = null;
            int j = 0;
            while (j < at.getNumberOfAttributes()) {
                String value = at.getAttributeValue(j);
                if (at.getAttributeName(j).equalsIgnoreCase("path")) {
                    path = value;
                } else if (at.getAttributeName(j).equalsIgnoreCase("type")) {
                    transtype = value;
                } else if (at.getAttributeName(j).equalsIgnoreCase("mod")) {
                    mod = value;
                }
                ++j;
            }
            if (path == null) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_no_path"));
            }
            int pnum = Integer.valueOf(path);
            if (pnum > npaths || pnum < 1) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_path_out_of_range"));
            }
            if (nodetype.equalsIgnoreCase("throw")) {
                this.addTransition(new JMLTransition(1, pnum, transtype, mod));
            } else if (nodetype.equalsIgnoreCase("catch") && transtype.equalsIgnoreCase("soft")) {
                this.addTransition(new JMLTransition(3, pnum, null, null));
            } else if (nodetype.equalsIgnoreCase("catch") && transtype.equalsIgnoreCase("grab")) {
                this.addTransition(new JMLTransition(4, pnum, null, null));
            } else if (nodetype.equalsIgnoreCase("catch")) {
                this.addTransition(new JMLTransition(2, pnum, null, null));
            } else if (nodetype.equalsIgnoreCase("holding")) {
                this.addTransition(new JMLTransition(5, pnum, null, null));
            }
            if (child.getNumberOfChildren() != 0) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_event_subtag"));
            }
            ++i;
        }
    }

    public void writeJML(PrintWriter wr) throws IOException {
        Coordinate c = this.getLocalCoordinate();
        wr.println("<event x=\"" + JLFunc.toStringRounded(c.x, 4) + "\" y=\"" + JLFunc.toStringRounded(c.y, 4) + "\" z=\"" + JLFunc.toStringRounded(c.z, 4) + "\" t=\"" + JLFunc.toStringRounded(this.getT(), 4) + "\" hand=\"" + Integer.toString(this.getJuggler()) + ":" + (this.getHand() == 1 ? "left" : "right") + "\">");
        for (JMLTransition tr : this.transitions()) {
            tr.writeJML(wr);
        }
        wr.println("</event>");
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeJML(new PrintWriter(sw));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

