/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.util.JuggleExceptionInternal;

public class JMLNode {
    protected String nodeType;
    protected String nodeValue;
    protected JMLNode parentNode;
    protected ArrayList<JMLNode> childNodes;
    protected JMLNode previousSibling;
    protected JMLNode nextSibling;
    protected JMLAttributes attributes;

    public JMLNode(String nodeType) {
        this.nodeType = nodeType;
        this.childNodes = new ArrayList();
        this.attributes = new JMLAttributes(this);
    }

    public String getNodeType() {
        return this.nodeType;
    }

    public String getNodeValue() {
        return this.nodeValue;
    }

    public void setNodeValue(String nodeValue) {
        this.nodeValue = nodeValue;
    }

    public JMLNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(JMLNode parent) {
        this.parentNode = parent;
    }

    public int getNumberOfChildren() {
        return this.childNodes.size();
    }

    public JMLNode getChildNode(int index) {
        return this.childNodes.get(index);
    }

    public JMLNode getFirstChild() {
        return this.childNodes.get(0);
    }

    public JMLNode getLastChild() {
        int n = this.childNodes.size();
        if (n > 0) {
            return this.childNodes.get(n - 1);
        }
        return null;
    }

    public JMLNode getPreviousSibling() {
        return this.previousSibling;
    }

    public void setPreviousSibling(JMLNode sibling) {
        this.previousSibling = sibling;
    }

    public JMLNode getNextSibling() {
        return this.nextSibling;
    }

    public void setNextSibling(JMLNode sibling) {
        this.nextSibling = sibling;
    }

    public void addAttribute(String name, String value) {
        this.attributes.addAttribute(name, value);
    }

    public JMLAttributes getAttributes() {
        return this.attributes;
    }

    public void insertBefore(JMLNode newChild, JMLNode refChild) {
        if (refChild != null) {
            int refindex = this.childNodes.indexOf(refChild);
            this.childNodes.add(refindex, newChild);
            newChild.setParentNode(this);
            JMLNode prevsibling = refChild.getPreviousSibling();
            if (prevsibling != null) {
                prevsibling.setNextSibling(newChild);
            }
            newChild.setPreviousSibling(prevsibling);
            newChild.setNextSibling(refChild);
            refChild.setPreviousSibling(newChild);
        } else {
            this.appendChild(newChild);
        }
    }

    public void replaceChild(JMLNode newChild, JMLNode oldChild) throws JuggleExceptionInternal {
        if (!this.childNodes.contains(oldChild)) {
            throw new JuggleExceptionInternal("Node to replace doesn't exist");
        }
        int refindex = this.childNodes.indexOf(oldChild);
        JMLNode prev = oldChild.getPreviousSibling();
        JMLNode next = oldChild.getNextSibling();
        this.childNodes.set(refindex, newChild);
        newChild.setPreviousSibling(prev);
        newChild.setNextSibling(next);
        newChild.setParentNode(this);
    }

    public void removeChild(JMLNode oldChild) throws JuggleExceptionInternal {
        if (this.childNodes.remove(oldChild)) {
            JMLNode prev = oldChild.getPreviousSibling();
            JMLNode next = oldChild.getNextSibling();
            if (prev != null) {
                prev.setNextSibling(next);
            }
            if (next != null) {
                next.setPreviousSibling(prev);
            }
        } else {
            throw new JuggleExceptionInternal("Node to remove doesn't exist");
        }
    }

    public void appendChild(JMLNode newChild) {
        JMLNode lastnode = null;
        if (this.childNodes.size() != 0) {
            lastnode = this.childNodes.get(this.childNodes.size() - 1);
            lastnode.setNextSibling(newChild);
        }
        this.childNodes.add(newChild);
        newChild.setPreviousSibling(lastnode);
        newChild.setNextSibling(null);
        newChild.setParentNode(this);
    }

    public boolean hasChildNodes() {
        return this.childNodes.size() != 0;
    }

    public JMLNode findNode(String type) {
        if (this.getNodeType().equals(type)) {
            return this;
        }
        for (int i = 0; i < this.getNumberOfChildren(); ++i) {
            JMLNode match = this.getChildNode(i).findNode(type);
            if (match == null) continue;
            return match;
        }
        return null;
    }

    public void writeNode(PrintWriter write, int indentlevel) throws IOException {
        int i;
        StringBuffer result = new StringBuffer();
        result.append("<" + this.nodeType);
        for (i = 0; i < this.attributes.getNumberOfAttributes(); ++i) {
            result.append(" " + this.attributes.getAttributeName(i));
            result.append("=\"" + JMLNode.xmlescape(this.attributes.getAttributeValue(i)) + "\"");
        }
        if (this.getNumberOfChildren() == 0) {
            if (this.nodeValue == null) {
                result.append("/>");
            } else {
                result.append(">" + JMLNode.xmlescape(this.nodeValue) + "</" + this.nodeType + ">");
            }
            write.println(result.toString());
            result = new StringBuffer();
        } else {
            result.append('>');
            write.println(result.toString());
            result = new StringBuffer();
            if (this.nodeValue != null) {
                result.append(JMLNode.xmlescape(this.nodeValue));
                write.println(result.toString());
                result = new StringBuffer();
            }
            write.flush();
            for (i = 0; i < this.getNumberOfChildren(); ++i) {
                this.getChildNode(i).writeNode(write, indentlevel + 1);
            }
            result.append("</" + this.nodeType + ">");
            write.println(result.toString());
        }
        write.flush();
    }

    public static String xmlescape(String in) {
        String result = in.replace("&", "&amp;");
        result = result.replace("<", "&lt;");
        result = result.replace(">", "&gt;");
        result = result.replace("'", "&apos;");
        result = result.replace("\"", "&quot;");
        return result;
    }
}

