/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import jugglinglab.jml.JMLNode;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class JMLParser
extends DefaultHandler {
    protected boolean patternStarted;
    protected boolean patternFinished;
    protected JMLNode rootNode;
    protected JMLNode currentNode;
    public static final int JML_INVALID = 0;
    public static final int JML_PATTERN = 1;
    public static final int JML_LIST = 2;

    public void parse(Reader read) throws SAXException, IOException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.newSAXParser().parse(new InputSource(read), (DefaultHandler)this);
        }
        catch (ParserConfigurationException pce) {
            throw new SAXException(pce.getMessage());
        }
    }

    public JMLNode getTree() {
        return this.rootNode;
    }

    public int getFileType() {
        if (this.rootNode.getNodeType().equalsIgnoreCase("jml")) {
            if (this.rootNode.getNumberOfChildren() == 1) {
                String child = this.rootNode.getChildNode(0).getNodeType();
                if (child.equalsIgnoreCase("pattern")) {
                    return 1;
                }
                if (child.equalsIgnoreCase("patternlist")) {
                    return 2;
                }
                return 0;
            }
            return 0;
        }
        return 0;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        if (systemId.equalsIgnoreCase("file://jml.dtd")) {
            return new InputSource(new StringReader("<!ELEMENT jml (pattern|patternlist)>\n<!ATTLIST jml\n          version  CDATA   \"3\">\n\n<!ELEMENT pattern (title?,info?,basepattern?,prop*,setup,symmetry+,(event|position)*)>\n\n<!ELEMENT title (#PCDATA)>\n\n<!ELEMENT info (#PCDATA)>\n<!ATTLIST info\n          tags     CDATA   #IMPLIED>\n\n<!ELEMENT basepattern (#PCDATA)>\n<!ATTLIST basepattern\n          notation CDATA   #REQUIRED>\n\n<!ELEMENT prop EMPTY>\n<!ATTLIST prop\n          type     CDATA   \"ball\"\n          mod      CDATA   #IMPLIED>\n\n<!ELEMENT setup EMPTY>\n<!ATTLIST setup\n          jugglers CDATA   \"1\"\n          paths    CDATA   #REQUIRED\n          props    CDATA   #IMPLIED>\n\n<!ELEMENT symmetry EMPTY>\n<!ATTLIST symmetry\n          type     CDATA   #REQUIRED\n          jperm    CDATA   #IMPLIED\n          pperm    CDATA   #REQUIRED\n          delay    CDATA   #IMPLIED>\n\n<!ELEMENT event (throw|catch|softcatch|holding)*>\n<!ATTLIST event\n          x        CDATA   #REQUIRED\n          y        CDATA   \"0.0\"\n          z        CDATA   \"0.0\"\n          t        CDATA   #REQUIRED\n          hand     CDATA   #REQUIRED>\n\n<!ELEMENT throw EMPTY>\n<!ATTLIST throw\n          path     CDATA   #REQUIRED\n          type     CDATA   \"toss\"\n          mod      CDATA   #IMPLIED>\n\n<!ELEMENT catch EMPTY>\n<!ATTLIST catch\n          path     CDATA   #REQUIRED\n          type     CDATA   \"natural\">\n\n<!ELEMENT holding EMPTY>\n<!ATTLIST holding\n          path     CDATA   #REQUIRED>\n\n<!ELEMENT position EMPTY>\n<!ATTLIST position\n          x        CDATA   #REQUIRED\n          y        CDATA   #REQUIRED\n          z        CDATA   \"100.0\"\n          t        CDATA   #REQUIRED\n          angle    CDATA   \"0.0\"\n          juggler  CDATA   \"1\">\n\n<!ELEMENT patternlist (title?,info?,line*)>\n\n<!ELEMENT line (#PCDATA|pattern|info)*>\n<!ATTLIST line\n          display    CDATA   #REQUIRED\n          animprefs  CDATA   #IMPLIED\n          notation   CDATA   #IMPLIED>\n"));
        }
        return null;
    }

    @Override
    public void notationDecl(String name, String publicId, String systemId) {
    }

    @Override
    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        super.setDocumentLocator(locator);
    }

    @Override
    public void startDocument() throws SAXException {
        try {
            this.startJMLPattern();
        }
        catch (JuggleException je) {
            throw new SAXException(je.getMessage());
        }
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            this.endJMLPattern();
        }
        catch (JuggleException je) {
            throw new SAXException(je.getMessage());
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            this.startJMLElement(qName);
            for (int i = 0; i < atts.getLength(); ++i) {
                this.addJMLAttribute(atts.getQName(i), atts.getValue(i));
            }
        }
        catch (JuggleException je) {
            throw new SAXException(je.getMessage());
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.endJMLElement(qName);
        }
        catch (JuggleException je) {
            throw new SAXException(je.getMessage());
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.addJMLText(new String(ch, start, length));
        }
        catch (JuggleException je) {
            throw new SAXException(je.getMessage());
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    private static void display(char[] ch, int start, int length) {
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    protected void startJMLPattern() throws JuggleExceptionInternal {
        if (this.patternStarted) {
            throw new JuggleExceptionInternal("startJMLPattern(): pattern already started");
        }
        this.patternStarted = true;
    }

    protected void startJMLElement(String name) throws JuggleExceptionInternal {
        if (!this.patternStarted) {
            throw new JuggleExceptionInternal("startJMLEleent(): pattern not started");
        }
        if (this.patternFinished) {
            throw new JuggleExceptionInternal("startJMLElement(): pattern already finished");
        }
        if (this.currentNode == null && this.rootNode != null) {
            throw new JuggleExceptionInternal("startJMLElement(): can only have one root element");
        }
        JMLNode newNode = new JMLNode(name);
        if (this.currentNode != null) {
            this.currentNode.appendChild(newNode);
            this.currentNode = newNode;
        } else {
            this.rootNode = this.currentNode = newNode;
        }
    }

    protected void endJMLElement(String name) throws JuggleExceptionInternal {
        if (!this.patternStarted) {
            throw new JuggleExceptionInternal("endJMLElement(): pattern not started");
        }
        if (this.patternFinished) {
            throw new JuggleExceptionInternal("endJMLElement(): pattern already finished");
        }
        if (this.currentNode == null) {
            throw new JuggleExceptionInternal("endJMLElement(): no correspanding startElement()");
        }
        this.currentNode = this.currentNode.getParentNode();
    }

    protected void addJMLAttribute(String name, String value) throws JuggleExceptionInternal {
        if (!this.patternStarted) {
            throw new JuggleExceptionInternal("addJMLAttribute(): pattern not started");
        }
        if (this.patternFinished) {
            throw new JuggleExceptionInternal("addJMLAttribute(): pattern already finished");
        }
        if (this.currentNode == null) {
            throw new JuggleExceptionInternal("addJMLAttribute(): no element to add to");
        }
        this.currentNode.addAttribute(name, value);
    }

    protected void addJMLText(String text) throws JuggleExceptionInternal {
        if (!this.patternStarted) {
            throw new JuggleExceptionInternal("addJMLText(): pattern not started");
        }
        if (this.patternFinished) {
            throw new JuggleExceptionInternal("addJMLText(): pattern already finished");
        }
        if (this.currentNode == null) {
            throw new JuggleExceptionInternal("addJMLText(): no element to add to");
        }
        Object newvalue = null;
        newvalue = this.currentNode.getNodeValue() == null ? text : this.currentNode.getNodeValue() + text;
        this.currentNode.setNodeValue((String)newvalue);
    }

    protected void endJMLPattern() throws JuggleExceptionInternal {
        if (!this.patternStarted) {
            throw new JuggleExceptionInternal("endJMLPattern(): pattern not started");
        }
        if (this.patternFinished) {
            throw new JuggleExceptionInternal("endJMLPattern(): pattern already finished");
        }
        if (this.rootNode == null) {
            throw new JuggleExceptionInternal("endJMLPattern(): empty pattern");
        }
        if (this.currentNode != null) {
            throw new JuggleExceptionInternal("endJMLPattern(): missing endElement()");
        }
        this.patternFinished = true;
    }
}

