/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import jugglinglab.JugglingLab;
import jugglinglab.curve.Curve;
import jugglinglab.curve.LineCurve;
import jugglinglab.curve.SplineCurve;
import jugglinglab.jml.EventImages;
import jugglinglab.jml.HandLink;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLDefs;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLParser;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PathLink;
import jugglinglab.jml.PropDef;
import jugglinglab.jml.VelocityRef;
import jugglinglab.notation.Pattern;
import jugglinglab.path.BouncePath;
import jugglinglab.path.Path;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import jugglinglab.util.Permutation;
import org.xml.sax.SAXException;

public class JMLPattern {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected String version = "3";
    protected String title;
    protected String info;
    protected ArrayList<String> tags = new ArrayList();
    protected int numjugglers;
    protected int numpaths;
    protected ArrayList<PropDef> props = new ArrayList();
    protected int[] propassignment;
    protected String base_pattern_notation;
    protected String base_pattern_config;
    protected int base_pattern_hashcode;
    protected boolean base_pattern_hashcode_valid;
    protected boolean[] hasVDPathJMLTransition;
    protected boolean[][] hasVDHandJMLTransition;
    protected ArrayList<JMLSymmetry> symmetries = new ArrayList();
    protected JMLEvent eventlist;
    protected JMLPosition positionlist;
    protected ArrayList<ArrayList<PathLink>> pathlinks;
    protected ArrayList<ArrayList<ArrayList<HandLink>>> handlinks;
    protected Curve[] jugglercurve;
    protected Curve[] jugglerangle;
    protected String loadingversion = "3";
    protected boolean laidout = false;
    protected boolean valid = true;

    public JMLPattern() {
    }

    public JMLPattern(JMLNode root) throws JuggleExceptionUser {
        this();
        this.readJML(root);
        this.valid = true;
    }

    public JMLPattern(JMLNode root, String jmlvers) throws JuggleExceptionUser {
        this();
        this.loadingversion = jmlvers;
        this.readJML(root);
        this.valid = true;
    }

    public JMLPattern(Reader read) throws JuggleExceptionUser, JuggleExceptionInternal {
        this();
        try {
            JMLParser parser = new JMLParser();
            parser.parse(read);
            this.readJML(parser.getTree());
            this.valid = true;
        }
        catch (SAXException se) {
            throw new JuggleExceptionUser(se.getMessage());
        }
        catch (IOException ioe) {
            throw new JuggleExceptionInternal(ioe.getMessage());
        }
    }

    public JMLPattern(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        this(new StringReader(pat.toString()));
    }

    public void setTitle(String t) {
        if (t != null) {
            t = t.replaceAll(";", "");
        }
        String string = this.title = t != null && t.strip().length() > 0 ? t.strip() : null;
        if (this.base_pattern_notation == null || this.base_pattern_config == null) {
            return;
        }
        try {
            ParameterList pl = new ParameterList(this.base_pattern_config);
            if (pl.getParameter("pattern").equals(this.title)) {
                pl.removeParameter("title");
            } else {
                pl.addParameter("title", this.title == null ? "" : this.title);
            }
            this.base_pattern_config = pl.toString();
            this.base_pattern_hashcode_valid = false;
        }
        catch (JuggleExceptionUser jeu) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal(jeu.getMessage(), this));
        }
    }

    public void setInfo(String info_string) {
        this.info = info_string != null && info_string.strip().length() > 0 ? info_string.strip() : null;
    }

    public void addTag(String tag) {
        if (tag != null && tag.length() > 0 && !this.isTaggedWith(tag)) {
            this.tags.add(tag);
        }
    }

    public boolean removeTag(String tag) {
        if (tag == null || !this.isTaggedWith(tag)) {
            return false;
        }
        int i = 0;
        while (i < this.tags.size()) {
            if (this.tags.get(i).equalsIgnoreCase(tag)) {
                this.tags.remove(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setNumberOfJugglers(int n) {
        this.numjugglers = n;
        this.setNeedsLayout();
    }

    public void setNumberOfPaths(int n) {
        this.numpaths = n;
        this.setNeedsLayout();
    }

    public void addProp(PropDef pd) {
        this.props.add(pd);
        this.setNeedsLayout();
    }

    public void removeProp(int propnum) {
        this.props.remove(propnum - 1);
        int i = 1;
        while (i <= this.getNumberOfPaths()) {
            if (this.getPropAssignment(i) > propnum) {
                this.setPropAssignment(i, this.getPropAssignment(i) - 1);
            }
            ++i;
        }
        this.setNeedsLayout();
    }

    public void setPropAssignment(int pathnum, int propnum) {
        this.propassignment[pathnum - 1] = propnum;
        this.setNeedsLayout();
    }

    public void setPropAssignments(int[] pa) {
        this.propassignment = pa;
        this.setNeedsLayout();
    }

    public void addSymmetry(JMLSymmetry sym) {
        this.symmetries.add(sym);
        this.setNeedsLayout();
    }

    public void addEvent(JMLEvent ev) {
        this.setNeedsLayout();
        if (this.eventlist == null || ev.getT() < this.eventlist.getT()) {
            ev.setPrevious(null);
            ev.setNext(this.eventlist);
            if (this.eventlist != null) {
                this.eventlist.setPrevious(ev);
            }
            this.eventlist = ev;
            return;
        }
        JMLEvent current = this.eventlist;
        while (true) {
            boolean combine_events;
            boolean bl = combine_events = current.getT() == ev.getT() && current.getHand() == ev.getHand() && current.getJuggler() == ev.getJuggler();
            if (combine_events) {
                ev.setPrevious(current.getPrevious());
                ev.setNext(current.getNext());
                if (current.getNext() != null) {
                    current.getNext().setPrevious(ev);
                }
                if (current.getPrevious() == null) {
                    this.eventlist = ev;
                } else {
                    current.getPrevious().setNext(ev);
                }
                for (JMLTransition tr_current : current.transitions()) {
                    boolean add_transition = true;
                    for (JMLTransition tr : ev.transitions()) {
                        if (tr.getPath() != tr_current.getPath()) continue;
                        add_transition = false;
                    }
                    if (!add_transition) continue;
                    ev.addTransition(tr_current);
                }
                return;
            }
            if (ev.getT() < current.getT()) {
                ev.setNext(current);
                ev.setPrevious(current.getPrevious());
                current.getPrevious().setNext(ev);
                current.setPrevious(ev);
                return;
            }
            if (current.getNext() == null) {
                current.setNext(ev);
                ev.setNext(null);
                ev.setPrevious(current);
                return;
            }
            current = current.getNext();
        }
    }

    public void removeEvent(JMLEvent ev) {
        this.setNeedsLayout();
        if (this.eventlist == ev) {
            this.eventlist = ev.getNext();
            if (this.eventlist != null) {
                this.eventlist.setPrevious(null);
            }
            return;
        }
        JMLEvent next = ev.getNext();
        JMLEvent prev = ev.getPrevious();
        if (next != null) {
            next.setPrevious(prev);
        }
        if (prev != null) {
            prev.setNext(next);
        }
    }

    public JMLEvent getEventList() {
        return this.eventlist;
    }

    public JMLEvent getEventImageInLoop(JMLEvent ev) {
        JMLEvent current = this.eventlist;
        while (current != null) {
            if (current.getT() >= this.getLoopStartTime() && current.getT() < this.getLoopEndTime() && current.getJuggler() == ev.getJuggler() && current.getHand() == ev.getHand() && current.hasSameMasterAs(ev)) {
                return current;
            }
            current = current.getNext();
        }
        return null;
    }

    protected void printEventList() {
        JMLEvent current = this.eventlist;
        PrintWriter pw = new PrintWriter(System.out);
        while (current != null) {
            if (current.isMaster()) {
                System.out.println("  Master event:");
            } else {
                System.out.println("  Slave event; master at t=" + current.getMaster().getT());
            }
            try {
                current.writeJML(pw);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            pw.flush();
            current = current.getNext();
        }
    }

    public ArrayList<ArrayList<PathLink>> getPathLinks() {
        return this.pathlinks;
    }

    public void addPosition(JMLPosition pos) {
        if (pos.getT() < this.getLoopStartTime() || pos.getT() > this.getLoopEndTime()) {
            return;
        }
        this.setNeedsLayout();
        if (this.positionlist == null || this.positionlist.getT() > pos.getT()) {
            pos.setPrevious(null);
            pos.setNext(this.positionlist);
            if (this.positionlist != null) {
                this.positionlist.setPrevious(pos);
            }
            this.positionlist = pos;
            return;
        }
        JMLPosition current = this.positionlist;
        while (current.getNext() != null) {
            if (!((current = current.getNext()).getT() > pos.getT())) continue;
            pos.setNext(current);
            pos.setPrevious(current.getPrevious());
            current.getPrevious().setNext(pos);
            current.setPrevious(pos);
            return;
        }
        current.setNext(pos);
        pos.setNext(null);
        pos.setPrevious(current);
    }

    public void removePosition(JMLPosition pos) {
        this.setNeedsLayout();
        if (this.positionlist == pos) {
            this.positionlist = pos.getNext();
            if (this.positionlist != null) {
                this.positionlist.setPrevious(null);
            }
            return;
        }
        JMLPosition next = pos.getNext();
        JMLPosition prev = pos.getPrevious();
        if (next != null) {
            next.setPrevious(prev);
        }
        if (prev != null) {
            prev.setNext(next);
        }
    }

    public JMLPosition getPositionList() {
        return this.positionlist;
    }

    public int getHashCode() {
        StringWriter sw = new StringWriter();
        try {
            this.writeJML(sw, true, false);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString().hashCode();
    }

    public String getBasePatternNotation() {
        return this.base_pattern_notation;
    }

    public String getBasePatternConfig() {
        return this.base_pattern_config;
    }

    public boolean hasBasePattern() {
        return this.getBasePatternNotation() != null && this.getBasePatternConfig() != null;
    }

    public boolean isBasePatternEdited() {
        if (this.base_pattern_notation == null || this.base_pattern_config == null) {
            return false;
        }
        if (!this.base_pattern_hashcode_valid) {
            try {
                this.base_pattern_hashcode = JMLPattern.fromBasePattern(this.base_pattern_notation, this.base_pattern_config).layoutPattern().getHashCode();
                this.base_pattern_hashcode_valid = true;
            }
            catch (JuggleException je) {
                this.base_pattern_hashcode = 0;
                this.base_pattern_hashcode_valid = false;
                return false;
            }
        }
        return this.getHashCode() != this.base_pattern_hashcode;
    }

    public static JMLPattern fromBasePattern(String notation, String config) throws JuggleExceptionUser, JuggleExceptionInternal {
        Pattern p = Pattern.newPattern(notation).fromString(config);
        JMLPattern pat = p.asJMLPattern();
        pat.base_pattern_notation = p.getNotationName();
        pat.base_pattern_config = p.toString();
        return pat;
    }

    public void scaleTime(double scale) {
        JMLEvent ev = this.getEventList();
        while (ev != null) {
            if (ev.isMaster()) {
                ev.setT(ev.getT() * scale);
            }
            ev = ev.getNext();
        }
        JMLPosition pos = this.getPositionList();
        while (pos != null) {
            pos.setT(pos.getT() * scale);
            pos = pos.getNext();
        }
        for (JMLSymmetry sym : this.symmetries()) {
            double delay = sym.getDelay();
            if (!(delay > 0.0)) continue;
            sym.setDelay(delay * scale);
        }
        this.setNeedsLayout();
    }

    public double scaleTimeToFitThrows(double multiplier) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.layoutPattern();
        double scale_factor = 1.0;
        int path = 1;
        while (path <= this.getNumberOfPaths()) {
            for (PathLink pl : this.getPathLinks().get(path - 1)) {
                double dmin;
                double d;
                Path p = pl.getPath();
                if (p == null || !((d = p.getDuration()) < (dmin = p.getMinDuration())) || !(d > 0.0)) continue;
                scale_factor = Math.max(scale_factor, dmin / d);
            }
            ++path;
        }
        if (scale_factor > 1.0) {
            this.scaleTime(scale_factor *= multiplier);
        }
        return scale_factor;
    }

    public void swapHands() {
        JMLEvent ev = this.getEventList();
        while (ev != null) {
            int hand = ev.getHand();
            hand = hand == 1 ? 2 : 1;
            ev.setHand(ev.getJuggler(), hand);
            ev = ev.getNext();
        }
        this.setNeedsLayout();
    }

    public void invertXAxis() {
        JMLEvent ev = this.getEventList();
        while (ev != null) {
            int hand = ev.getHand();
            Coordinate c = ev.getLocalCoordinate();
            hand = hand == 1 ? 2 : 1;
            c.x = -c.x;
            ev.setHand(ev.getJuggler(), hand);
            ev.setLocalCoordinate(c);
            ev = ev.getNext();
        }
        this.setNeedsLayout();
    }

    public void invertTime() throws JuggleExceptionInternal {
        try {
            try {
                Object next;
                this.layoutPattern();
                double looptime = this.getLoopEndTime();
                Object ev = this.getEventList();
                while (ev != null) {
                    ((JMLEvent)ev).setT(looptime - ((JMLEvent)ev).getT());
                    JMLEvent prev = ((JMLEvent)ev).getPrevious();
                    next = ((JMLEvent)ev).getNext();
                    ((JMLEvent)ev).setPrevious((JMLEvent)next);
                    ((JMLEvent)ev).setNext(prev);
                    if (next == null) {
                        this.eventlist = ev;
                    }
                    ev = next;
                }
                Object pos = this.getPositionList();
                this.positionlist = null;
                while (pos != null) {
                    if (((JMLPosition)pos).getT() != 0.0) {
                        ((JMLPosition)pos).setT(looptime - ((JMLPosition)pos).getT());
                    }
                    next = ((JMLPosition)pos).getNext();
                    this.addPosition((JMLPosition)pos);
                    pos = next;
                }
                for (JMLSymmetry sym : this.symmetries()) {
                    if (sym.getType() == 2) continue;
                    Permutation newpathperm = sym.getPathPerm().getInverse();
                    sym.setPathPerm(sym.getNumberOfPaths(), newpathperm.toString());
                }
                int path = 1;
                while (path <= this.getNumberOfPaths()) {
                    for (PathLink pl : this.getPathLinks().get(path - 1)) {
                        if (pl.isInHand()) continue;
                        JMLEvent start = pl.getStartEvent();
                        JMLEvent end = pl.getEndEvent();
                        JMLTransition start_tr = null;
                        for (JMLTransition tr : start.transitions()) {
                            if (tr.getPath() != path) continue;
                            start_tr = tr;
                            break;
                        }
                        JMLTransition end_tr = null;
                        for (JMLTransition tr : end.transitions()) {
                            if (tr.getPath() != path) continue;
                            end_tr = tr;
                            break;
                        }
                        if (start_tr == null || end_tr == null) {
                            throw new JuggleExceptionInternal("invertTime() error 1", this);
                        }
                        if (start_tr.getOutgoingPathLink() != pl) {
                            throw new JuggleExceptionInternal("invertTime() error 2", this);
                        }
                        if (end_tr.getIncomingPathLink() != pl) {
                            throw new JuggleExceptionInternal("invertTime() error 3", this);
                        }
                        int start_tr_type = start_tr.getType();
                        String start_tr_throw_type = start_tr.getThrowType();
                        String start_tr_throw_mod = start_tr.getMod();
                        start_tr.setType(end_tr.getType());
                        start_tr.setThrowType(end_tr.getThrowType());
                        start_tr.setMod(end_tr.getMod());
                        end_tr.setType(start_tr_type);
                        end_tr.setThrowType(start_tr_throw_type);
                        end_tr.setMod(start_tr_throw_mod);
                    }
                    ++path;
                }
            }
            catch (JuggleExceptionUser jeu) {
                throw new JuggleExceptionInternal("invertTime() error 4: " + jeu.getMessage(), this);
            }
        }
        finally {
            this.setNeedsLayout();
        }
    }

    public void streamlinePatternWithWindow(double twindow) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.layoutPattern();
        int n_events = 0;
        int n_holds = 0;
        int n_removed = 0;
        JMLEvent ev = this.getEventList();
        while (ev != null) {
            boolean remove;
            JMLEvent prev = ev.getPreviousForHand();
            JMLEvent next = ev.getNextForHand();
            boolean holding_only = true;
            for (JMLTransition tr : ev.transitions()) {
                if (tr.getType() == 5) continue;
                holding_only = false;
            }
            boolean different_masters = prev == null || !ev.hasSameMasterAs(prev);
            boolean inside_window = prev != null && ev.getT() - prev.getT() < twindow;
            boolean not_pass_adjacent = prev != null && next != null && !prev.hasPassingTransition() && !next.hasPassingTransition();
            boolean bl = remove = holding_only && different_masters && inside_window && not_pass_adjacent;
            if (remove) {
                this.removeEvent(ev);
                ++n_removed;
            }
            ++n_events;
            if (holding_only) {
                ++n_holds;
            }
            ev = ev.getNext();
        }
    }

    public JMLPattern layoutPattern() throws JuggleExceptionInternal, JuggleExceptionUser {
        if (this.laidout) {
            return this;
        }
        if (!this.valid) {
            throw new JuggleExceptionInternal("Cannot do layout of invalid pattern", this);
        }
        try {
            if (this.getNumberOfProps() == 0 && this.getNumberOfPaths() > 0) {
                this.addProp(new PropDef("ball", null));
            }
            int i = 0;
            while (i < this.getNumberOfProps()) {
                this.props.get(i).layoutProp();
                ++i;
            }
            this.buildEventList();
            this.findMasterEvents();
            this.findPositions();
            this.gotoGlobalCoordinates();
            this.buildLinkLists();
            this.layoutHandPaths();
            this.laidout = true;
        }
        catch (JuggleExceptionUser jeu) {
            this.valid = false;
            throw jeu;
        }
        catch (JuggleExceptionInternal jei) {
            this.valid = false;
            jei.attachPattern(this);
            throw jei;
        }
        return this;
    }

    public void setNeedsLayout() {
        this.laidout = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void buildEventList() throws JuggleExceptionInternal, JuggleExceptionUser {
        int path;
        int han;
        int jug;
        int i;
        int numevents = 0;
        JMLEvent current = this.eventlist;
        while (current != null) {
            if (current.getJuggler() < 1 || current.getJuggler() > this.numjugglers) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_juggler_outofrange"));
            }
            if (current.isMaster()) {
                ++numevents;
            } else {
                this.removeEvent(current);
            }
            current = current.getNext();
        }
        EventImages[] ei = new EventImages[numevents];
        current = this.eventlist;
        int i2 = 0;
        while (i2 < numevents) {
            ei[i2] = new EventImages(this, current);
            current = current.getNext();
            ++i2;
        }
        boolean[][] needHandEvent = new boolean[this.numjugglers][2];
        boolean[][] needVDHandEvent = new boolean[this.numjugglers][2];
        boolean[] needPathEvent = new boolean[this.numpaths];
        boolean[] needSpecialPathEvent = new boolean[this.numpaths];
        this.hasVDHandJMLTransition = new boolean[this.numjugglers][2];
        this.hasVDPathJMLTransition = new boolean[this.numpaths];
        int i3 = 0;
        while (i3 < this.numjugglers) {
            boolean hasJMLTransitionForLeft = false;
            boolean hasJMLTransitionForRight = false;
            this.hasVDHandJMLTransition[i3][1] = false;
            this.hasVDHandJMLTransition[i3][0] = false;
            int j = 0;
            while (j < numevents) {
                if (!hasJMLTransitionForLeft) {
                    hasJMLTransitionForLeft = ei[j].hasJMLTransitionForHand(i3 + 1, 1);
                }
                if (!hasJMLTransitionForRight) {
                    hasJMLTransitionForRight = ei[j].hasJMLTransitionForHand(i3 + 1, 2);
                }
                if (!this.hasVDHandJMLTransition[i3][0]) {
                    this.hasVDHandJMLTransition[i3][0] = ei[j].hasVDJMLTransitionForHand(i3 + 1, 1);
                }
                if (!this.hasVDHandJMLTransition[i3][1]) {
                    this.hasVDHandJMLTransition[i3][1] = ei[j].hasVDJMLTransitionForHand(i3 + 1, 2);
                }
                ++j;
            }
            if (!hasJMLTransitionForLeft) {
                String template = errorstrings.getString("Error_no_left_events");
                Object[] arguments = new Object[]{i3 + 1};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
            if (!hasJMLTransitionForRight) {
                String template = errorstrings.getString("Error_no_right_events");
                Object[] arguments = new Object[]{i3 + 1};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
            needVDHandEvent[i3][0] = this.hasVDHandJMLTransition[i3][0];
            needVDHandEvent[i3][1] = this.hasVDHandJMLTransition[i3][1];
            needHandEvent[i3][1] = true;
            needHandEvent[i3][0] = true;
            ++i3;
        }
        i3 = 0;
        while (i3 < this.numpaths) {
            boolean hasPathJMLTransition = false;
            this.hasVDPathJMLTransition[i3] = false;
            int j = 0;
            while (j < numevents) {
                if (!hasPathJMLTransition) {
                    hasPathJMLTransition = ei[j].hasJMLTransitionForPath(i3 + 1);
                }
                if (!this.hasVDPathJMLTransition[i3]) {
                    this.hasVDPathJMLTransition[i3] = ei[j].hasVDJMLTransitionForPath(i3 + 1);
                }
                ++j;
            }
            if (!hasPathJMLTransition) {
                String template = errorstrings.getString("Error_no_path_events");
                Object[] arguments = new Object[]{i3 + 1};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
            needPathEvent[i3] = true;
            needSpecialPathEvent[i3] = false;
            ++i3;
        }
        JMLEvent[] eventqueue = new JMLEvent[numevents];
        int i4 = 0;
        while (i4 < numevents) {
            eventqueue[i4] = ei[i4].getPrevious();
            ++i4;
        }
        boolean contin = false;
        do {
            JMLEvent maxevent = eventqueue[0];
            double maxtime = maxevent.getT();
            int maxnum = 0;
            i = 1;
            while (i < numevents) {
                if (eventqueue[i].getT() > maxtime) {
                    maxevent = eventqueue[i];
                    maxtime = maxevent.getT();
                    maxnum = i;
                }
                ++i;
            }
            this.addEvent(maxevent);
            eventqueue[maxnum] = ei[maxnum].getPrevious();
            if (maxtime < this.getLoopStartTime()) {
                jug = maxevent.getJuggler() - 1;
                if (!this.hasVDHandJMLTransition[jug][han = HandLink.index(maxevent.getHand())]) {
                    needHandEvent[jug][han] = false;
                }
                block21: for (JMLTransition tr : maxevent.transitions()) {
                    path = tr.getPath() - 1;
                    switch (tr.getType()) {
                        case 1: {
                            needPathEvent[path] = false;
                            needHandEvent[jug][han] = false;
                            needVDHandEvent[jug][han] = false;
                            needSpecialPathEvent[path] = false;
                            break;
                        }
                        case 2: 
                        case 4: {
                            break;
                        }
                        case 3: {
                            if (needVDHandEvent[jug][han]) {
                                needSpecialPathEvent[path] = true;
                            }
                            needHandEvent[jug][han] = false;
                            needVDHandEvent[jug][han] = false;
                            break;
                        }
                        case 5: {
                            if (this.hasVDPathJMLTransition[path]) continue block21;
                            needPathEvent[path] = false;
                            break;
                        }
                        default: {
                            throw new JuggleExceptionInternal("Unrecognized transition type in buildEventList()", this);
                        }
                    }
                }
            }
            contin = false;
            i = 0;
            while (i < this.numjugglers) {
                contin |= needHandEvent[i][0];
                contin |= needHandEvent[i][1];
                contin |= needVDHandEvent[i][0];
                contin |= needVDHandEvent[i][1];
                ++i;
            }
            i = 0;
            while (i < this.numpaths) {
                contin |= needPathEvent[i];
                contin |= needSpecialPathEvent[i];
                ++i;
            }
        } while (contin);
        int i5 = 0;
        while (i5 < this.numjugglers) {
            needVDHandEvent[i5][0] = this.hasVDHandJMLTransition[i5][0];
            needVDHandEvent[i5][1] = this.hasVDHandJMLTransition[i5][1];
            needHandEvent[i5][1] = true;
            needHandEvent[i5][0] = true;
            ++i5;
        }
        i5 = 0;
        while (i5 < this.numpaths) {
            needPathEvent[i5] = true;
            needSpecialPathEvent[i5] = false;
            ++i5;
        }
        i5 = 0;
        while (i5 < numevents) {
            ei[i5].resetPosition();
            eventqueue[i5] = ei[i5].getNext();
            ++i5;
        }
        do {
            JMLEvent minevent = eventqueue[0];
            double mintime = minevent.getT();
            int minnum = 0;
            i = 1;
            while (i < numevents) {
                if (eventqueue[i].getT() < mintime) {
                    minevent = eventqueue[i];
                    mintime = minevent.getT();
                    minnum = i;
                }
                ++i;
            }
            this.addEvent(minevent);
            eventqueue[minnum] = ei[minnum].getNext();
            if (mintime > this.getLoopEndTime()) {
                jug = minevent.getJuggler() - 1;
                if (!this.hasVDHandJMLTransition[jug][han = HandLink.index(minevent.getHand())] && mintime > 2.0 * this.getLoopEndTime() - this.getLoopStartTime()) {
                    needHandEvent[jug][han] = false;
                }
                block29: for (JMLTransition tr : minevent.transitions()) {
                    path = tr.getPath() - 1;
                    switch (tr.getType()) {
                        case 1: {
                            needPathEvent[path] = false;
                            if (needVDHandEvent[jug][han]) {
                                needSpecialPathEvent[path] = true;
                            }
                            needHandEvent[jug][han] = false;
                            needVDHandEvent[jug][han] = false;
                            break;
                        }
                        case 2: 
                        case 4: {
                            needPathEvent[path] = false;
                            needSpecialPathEvent[path] = false;
                            break;
                        }
                        case 3: {
                            needPathEvent[path] = false;
                            needHandEvent[jug][han] = false;
                            needVDHandEvent[jug][han] = false;
                            needSpecialPathEvent[path] = false;
                            break;
                        }
                        case 5: {
                            if (this.hasVDPathJMLTransition[path]) continue block29;
                            needPathEvent[path] = false;
                            break;
                        }
                        default: {
                            throw new JuggleExceptionInternal("Unrecognized transition type in buildEventList()", this);
                        }
                    }
                }
            }
            contin = false;
            i = 0;
            while (i < this.numjugglers) {
                contin |= needHandEvent[i][0];
                contin |= needHandEvent[i][1];
                contin |= needVDHandEvent[i][0];
                contin |= needVDHandEvent[i][1];
                ++i;
            }
            i = 0;
            while (i < this.numpaths) {
                contin |= needPathEvent[i];
                contin |= needSpecialPathEvent[i];
                ++i;
            }
        } while (contin);
    }

    public void findMasterEvents() throws JuggleExceptionInternal, JuggleExceptionUser {
        boolean rebuildList = false;
        JMLEvent ev = this.eventlist;
        while (ev != null) {
            if (ev.isMaster()) {
                JMLEvent newmaster = ev;
                double tmaster = this.getLoopEndTime();
                if (ev.getT() >= this.getLoopStartTime() && ev.getT() < tmaster) {
                    tmaster = ev.getT();
                }
                JMLEvent ev2 = this.eventlist;
                while (ev2 != null) {
                    if (ev2.getMaster() == ev && ev2.getT() >= this.getLoopStartTime() && ev2.getT() < tmaster) {
                        newmaster = ev2;
                        tmaster = ev2.getT();
                    }
                    ev2 = ev2.getNext();
                }
                if (newmaster != ev) {
                    rebuildList = true;
                    ev2 = this.eventlist;
                    while (ev2 != null) {
                        if (ev2.getMaster() == ev) {
                            ev2.setMaster(newmaster);
                        }
                        ev2 = ev2.getNext();
                    }
                    newmaster.setMaster(null);
                    ev.setMaster(newmaster);
                }
            }
            ev = ev.getNext();
        }
        if (rebuildList) {
            this.buildEventList();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void findPositions() throws JuggleExceptionInternal {
        this.jugglercurve = new SplineCurve[this.getNumberOfJugglers()];
        this.jugglerangle = new LineCurve[this.getNumberOfJugglers()];
        i = 1;
        while (i <= this.getNumberOfJugglers()) {
            block12: {
                block11: {
                    num = 0;
                    current = this.positionlist;
                    while (current != null) {
                        if (current.getJuggler() == i) {
                            ++num;
                        }
                        current = current.getNext();
                    }
                    if (num != 0) break block11;
                    this.jugglercurve[i - 1] = new SplineCurve();
                    this.jugglerangle[i - 1] = new LineCurve();
                    times = new double[]{this.getLoopStartTime(), this.getLoopEndTime()};
                    positions = new Coordinate[2];
                    angles = new Coordinate[2];
                    positions[0] = new Coordinate();
                    angles[0] = new Coordinate();
                    if (this.getNumberOfJugglers() == 1) {
                        positions[0].setCoordinate(0.0, 0.0, 100.0);
                        angles[0].setCoordinate(0.0, 0.0, 0.0);
                    } else {
                        r = 70.0;
                        theta = 360.0 / (double)this.getNumberOfJugglers();
                        if (r * Math.sin(Math.toRadians(0.5 * theta)) < 65.0) {
                            r = 65.0 / Math.sin(Math.toRadians(0.5 * theta));
                        }
                        positions[0].setCoordinate(r * Math.cos(Math.toRadians(theta * (double)(i - 1))), r * Math.sin(Math.toRadians(theta * (double)(i - 1))), 100.0);
                        angles[0].setCoordinate(90.0 + theta * (double)(i - 1), 0.0, 0.0);
                    }
                    positions[1] = positions[0];
                    angles[1] = angles[0];
                    this.jugglercurve[i - 1].setCurve(times, positions, new Coordinate[2]);
                    this.jugglercurve[i - 1].calcCurve();
                    this.jugglerangle[i - 1].setCurve(times, angles, new Coordinate[2]);
                    this.jugglerangle[i - 1].calcCurve();
                    break block12;
                }
                this.jugglercurve[i - 1] = new SplineCurve();
                this.jugglerangle[i - 1] = new LineCurve();
                times = new double[num + 1];
                positions = new Coordinate[num + 1];
                angles = new Coordinate[num + 1];
                current = this.positionlist;
                j = 0;
                while (current != null) {
                    if (current.getJuggler() == i) {
                        times[j] = current.getT();
                        positions[j] = current.getCoordinate();
                        angles[j] = new Coordinate(current.getAngle(), 0.0, 0.0);
                        ++j;
                    }
                    current = current.getNext();
                }
                times[num] = times[0] + this.getLoopEndTime() - this.getLoopStartTime();
                positions[num] = positions[0];
                angles[num] = new Coordinate(angles[0]);
                j = 1;
                ** GOTO lbl65
                {
                    angles[j].x -= 360.0;
                    do {
                        if (angles[j].x - angles[j - 1].x > 180.0) continue block3;
                        while (angles[j].x - angles[j - 1].x < -180.0) {
                            angles[j].x += 360.0;
                        }
                        ++j;
lbl65:
                        // 2 sources

                    } while (j <= num);
                }
                this.jugglercurve[i - 1].setCurve(times, positions, new Coordinate[num + 1]);
                this.jugglercurve[i - 1].calcCurve();
                this.jugglerangle[i - 1].setCurve(times, angles, new Coordinate[num + 1]);
                this.jugglerangle[i - 1].calcCurve();
            }
            ++i;
        }
    }

    public void gotoGlobalCoordinates() {
        JMLEvent ev = this.eventlist;
        while (ev != null) {
            Coordinate lc = ev.getLocalCoordinate();
            Coordinate gc = this.convertLocalToGlobal(lc, ev.getJuggler(), ev.getT());
            ev.setGlobalCoordinate(gc);
            ev = ev.getNext();
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void buildLinkLists() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.pathlinks = new ArrayList<E>(this.getNumberOfPaths());
        i = 0;
        while (i < this.getNumberOfPaths()) {
            this.pathlinks.add(new ArrayList<E>());
            ev = this.eventlist;
            lastev = null;
            lasttr = null;
            block5: do {
                tr = null;
                while ((tr = ev.getPathTransition(i + 1, 6)) == null) {
                    if ((ev = ev.getNext()) != null) continue;
                    break block5;
                }
                if (lastev != null) {
                    pl = new PathLink(i + 1, lastev, ev);
                    switch (tr.getType()) {
                        case 1: 
                        case 5: {
                            if (lasttr.getType() == 1) {
                                template = JMLPattern.errorstrings.getString("Error_successive_throws");
                                arguments = new Object[]{i + 1};
                                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                            }
                            if (lastev.getJuggler() != ev.getJuggler()) {
                                template = JMLPattern.errorstrings.getString("Error_juggler_changed");
                                arguments = new Object[]{i + 1};
                                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                            }
                            if (lastev.getHand() != ev.getHand()) {
                                template = JMLPattern.errorstrings.getString("Error_hand_changed");
                                arguments = new Object[]{i + 1};
                                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                            }
                            pl.setInHand(ev.getJuggler(), ev.getHand());
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            if (lasttr.getType() != 1) {
                                template = JMLPattern.errorstrings.getString("Error_successive_catches");
                                arguments = new Object[]{i + 1};
                                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                            }
                            pl.setThrow(lasttr.getThrowType(), lasttr.getMod());
                            break;
                        }
                        default: {
                            throw new JuggleExceptionInternal("unrecognized transition type in buildLinkLists()", this);
                        }
                    }
                    this.pathlinks.get(i).add(pl);
                    if (lasttr != null) {
                        lasttr.setOutgoingPathLink(pl);
                    }
                    tr.setIncomingPathLink(pl);
                }
                lastev = ev;
                lasttr = tr;
            } while ((ev = ev.getNext()) != null);
            if (this.pathlinks.get(i).size() == 0) {
                throw new JuggleExceptionInternal("No event found for path " + (i + 1), this);
            }
            ++i;
        }
        this.handlinks = new ArrayList<E>();
        i = 0;
        while (i < this.getNumberOfJugglers()) {
            this.handlinks.add(new ArrayList<E>());
            j = 0;
            while (j < 2) {
                handnum = j == 0 ? 1 : 2;
                this.handlinks.get(i).add(new ArrayList<E>());
                ev = this.eventlist;
                lastev = null;
                vr = null;
                lastvr = null;
                do lbl-1000:
                // 3 sources

                {
                    block22: {
                        if (ev.getJuggler() == i + 1 && ev.getHand() == handnum) break block22;
                        if ((ev = ev.getNext()) != null) ** GOTO lbl-1000
                        break;
                    }
                    vr = null;
                    if (ev.getJuggler() == i + 1 && ev.getHand() == handnum) {
                        for (JMLTransition tr : ev.transitions()) {
                            if (tr.getType() == 1) {
                                pl = tr.getOutgoingPathLink();
                                if (pl == null) continue;
                                vr = new VelocityRef(pl.getPath(), VelocityRef.VR_THROW);
                                continue;
                            }
                            if (tr.getType() == 3) {
                                pl = tr.getIncomingPathLink();
                                if (pl == null) continue;
                                vr = new VelocityRef(pl.getPath(), VelocityRef.VR_SOFTCATCH);
                                continue;
                            }
                            if (tr.getType() != 2 || (pl = tr.getIncomingPathLink()) == null) continue;
                            vr = new VelocityRef(pl.getPath(), VelocityRef.VR_CATCH);
                        }
                    }
                    if (lastev != null) {
                        hl = new HandLink(i, handnum, lastev, ev);
                        hl.setStartVelocityRef(lastvr);
                        hl.setEndVelocityRef(vr);
                        this.handlinks.get(i).get(j).add(hl);
                    }
                    lastev = ev;
                    lastvr = vr;
                } while ((ev = ev.getNext()) != null);
                ++j;
            }
            ++i;
        }
    }

    protected void layoutHandPaths() throws JuggleExceptionInternal {
        int j = 0;
        while (j < this.getNumberOfJugglers()) {
            int h = 0;
            while (h < 2) {
                HandLink hl2;
                int l;
                SplineCurve hp;
                if (this.hasVDHandJMLTransition[j][h]) {
                    HandLink startlink = null;
                    int num = 0;
                    int k = 0;
                    while (k < this.handlinks.get(j).get(h).size()) {
                        HandLink hl = this.handlinks.get(j).get(h).get(k);
                        VelocityRef vr = hl.getStartVelocityRef();
                        if (vr != null && (vr.getSource() == VelocityRef.VR_THROW || vr.getSource() == VelocityRef.VR_SOFTCATCH)) {
                            startlink = hl;
                            num = 1;
                        }
                        vr = hl.getEndVelocityRef();
                        if (startlink != null && vr != null && (vr.getSource() == VelocityRef.VR_THROW || vr.getSource() == VelocityRef.VR_SOFTCATCH)) {
                            double[] times = new double[num + 1];
                            Coordinate[] pos = new Coordinate[num + 1];
                            Coordinate[] velocities = new Coordinate[num + 1];
                            hp = new SplineCurve();
                            l = 0;
                            while (l < num) {
                                hl2 = this.handlinks.get(j).get(h).get(k - num + 1 + l);
                                times[l] = hl2.getStartEvent().getT();
                                pos[l] = hl2.getStartEvent().getGlobalCoordinate();
                                VelocityRef vr2 = hl2.getStartVelocityRef();
                                if (l > 0 && vr2 != null && vr2.getSource() == VelocityRef.VR_CATCH) {
                                    velocities[l] = vr2.getVelocity();
                                }
                                hl2.setHandCurve(hp);
                                ++l;
                            }
                            times[num] = hl.getEndEvent().getT();
                            pos[num] = hl.getEndEvent().getGlobalCoordinate();
                            velocities[0] = startlink.getStartVelocityRef().getVelocity();
                            velocities[num] = hl.getEndVelocityRef().getVelocity();
                            hp.setCurve(times, pos, velocities);
                            ((Curve)hp).calcCurve();
                            startlink = null;
                        }
                        ++num;
                        ++k;
                    }
                } else {
                    int k = 0;
                    HandLink hl = null;
                    while (k < this.handlinks.get(j).get(h).size()) {
                        hl = this.handlinks.get(j).get(h).get(k);
                        if (hl.getEndEvent().getT() > this.getLoopStartTime()) break;
                        ++k;
                    }
                    int chain = 0;
                    while (chain < 2) {
                        HandLink startlink = hl;
                        JMLEvent startevent = startlink.getStartEvent();
                        int num = 1;
                        while (!hl.getEndEvent().isDelayOf(startevent)) {
                            hl = this.handlinks.get(j).get(h).get(++k);
                            ++num;
                        }
                        double[] times = new double[num + 1];
                        Coordinate[] pos = new Coordinate[num + 1];
                        hp = new SplineCurve();
                        l = 0;
                        while (l < num) {
                            hl2 = this.handlinks.get(j).get(h).get(k - num + 1 + l);
                            pos[l] = hl2.getStartEvent().getGlobalCoordinate();
                            times[l] = hl2.getStartEvent().getT();
                            hl2.setHandCurve(hp);
                            ++l;
                        }
                        pos[num] = hl.getEndEvent().getGlobalCoordinate();
                        times[num] = hl.getEndEvent().getT();
                        hp.setCurve(times, pos, new Coordinate[num + 1]);
                        ((Curve)hp).calcCurve();
                        if (chain == 0) {
                            hl = this.handlinks.get(j).get(h).get(++k);
                        }
                        ++chain;
                    }
                }
                ++h;
            }
            ++j;
        }
    }

    public String getTitle() {
        return this.title;
    }

    public String getInfo() {
        return this.info;
    }

    public ArrayList<String> getTags() {
        return this.tags;
    }

    public boolean isTaggedWith(String tag) {
        if (tag == null) {
            return false;
        }
        for (String t : this.tags) {
            if (!t.equalsIgnoreCase(tag)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfJugglers() {
        return this.numjugglers;
    }

    public int getNumberOfPaths() {
        return this.numpaths;
    }

    public int getNumberOfProps() {
        return this.props.size();
    }

    public Prop getProp(int propnum) {
        return this.getPropDef(propnum).getProp();
    }

    public PropDef getPropDef(int propnum) {
        return this.props.get(propnum - 1);
    }

    public int getPropAssignment(int path) {
        return this.propassignment[path - 1];
    }

    public Collection<JMLSymmetry> symmetries() {
        return this.symmetries;
    }

    public double getLoopStartTime() {
        return 0.0;
    }

    public double getLoopEndTime() {
        for (JMLSymmetry sym : this.symmetries()) {
            if (sym.getType() != 1) continue;
            return sym.getDelay();
        }
        return -1.0;
    }

    public void getPathCoordinate(int path, double time, Coordinate newPosition) throws JuggleExceptionInternal {
        for (PathLink pl : this.pathlinks.get(path - 1)) {
            if (!(time >= pl.getStartEvent().getT()) || !(time <= pl.getEndEvent().getT())) continue;
            if (pl.isInHand()) {
                int jug = pl.getHoldingJuggler();
                int hand = pl.getHoldingHand();
                this.getHandCoordinate(jug, hand, time, newPosition);
                return;
            }
            pl.getPath().getCoordinate(time, newPosition);
            return;
        }
        throw new JuggleExceptionInternal("time t=" + time + " is out of path range", this);
    }

    public boolean isHandHoldingPath(int juggler, int hand, double time, int path) {
        for (PathLink pl : this.pathlinks.get(path - 1)) {
            if (!pl.isInHand() || pl.getHoldingJuggler() != juggler || pl.getHoldingHand() != hand || !(time >= pl.getStartEvent().getT()) || !(time <= pl.getEndEvent().getT())) continue;
            return true;
        }
        return false;
    }

    public boolean isHandHolding(int juggler, int hand, double time) {
        int path = 1;
        while (path <= this.getNumberOfPaths()) {
            if (this.isHandHoldingPath(juggler, hand, time, path)) {
                return true;
            }
            ++path;
        }
        return false;
    }

    public double getPathOrientation(int path, double time, Coordinate axis) {
        axis.x = 0.0;
        axis.y = 0.0;
        axis.z = 1.0;
        return 3.0 * time;
    }

    public void getJugglerPosition(int juggler, double time, Coordinate newPosition) {
        Curve p = this.jugglercurve[juggler - 1];
        while (time < p.getStartTime()) {
            time += this.getLoopEndTime() - this.getLoopStartTime();
        }
        while (time > p.getEndTime()) {
            time -= this.getLoopEndTime() - this.getLoopStartTime();
        }
        p.getCoordinate(time, newPosition);
    }

    public double getJugglerAngle(int juggler, double time) {
        Curve p = this.jugglerangle[juggler - 1];
        while (time < p.getStartTime()) {
            time += this.getLoopEndTime() - this.getLoopStartTime();
        }
        while (time > p.getEndTime()) {
            time -= this.getLoopEndTime() - this.getLoopStartTime();
        }
        Coordinate coord = new Coordinate();
        p.getCoordinate(time, coord);
        return coord.x;
    }

    public Coordinate convertLocalToGlobal(Coordinate lc, int juggler, double time) {
        Coordinate origin = new Coordinate();
        this.getJugglerPosition(juggler, time, origin);
        double angle = Math.toRadians(this.getJugglerAngle(juggler, time));
        lc.y += 30.0;
        Coordinate gc = new Coordinate(origin.x + lc.x * Math.cos(angle) - lc.y * Math.sin(angle), origin.y + lc.x * Math.sin(angle) + lc.y * Math.cos(angle), origin.z + lc.z);
        return gc;
    }

    public Coordinate convertGlobalToLocal(Coordinate gc, int juggler, double t) {
        Coordinate origin = new Coordinate();
        this.getJugglerPosition(juggler, t, origin);
        double angle = Math.toRadians(this.getJugglerAngle(juggler, t));
        Coordinate c2 = Coordinate.sub(gc, origin);
        Coordinate lc = new Coordinate(c2.x * Math.cos(angle) + c2.y * Math.sin(angle), -c2.x * Math.sin(angle) + c2.y * Math.cos(angle), c2.z);
        lc.y -= 30.0;
        return lc;
    }

    public void getHandCoordinate(int juggler, int hand, double time, Coordinate newPosition) throws JuggleExceptionInternal {
        int handindex = hand == 1 ? 0 : 1;
        while (time < this.getLoopStartTime()) {
            time += this.getLoopEndTime() - this.getLoopStartTime();
        }
        while (time >= this.getLoopEndTime()) {
            time -= this.getLoopEndTime() - this.getLoopStartTime();
        }
        for (HandLink hl : this.handlinks.get(juggler - 1).get(handindex)) {
            if (!(time >= hl.getStartEvent().getT()) || !(time < hl.getEndEvent().getT())) continue;
            Curve hp = hl.getHandCurve();
            if (hp == null) {
                throw new JuggleExceptionInternal("getHandCoordinate() null pointer at t=" + time, this);
            }
            hp.getCoordinate(time, newPosition);
            return;
        }
        throw new JuggleExceptionInternal("time t=" + time + " (j=" + juggler + ",h=" + handindex + ") is out of handpath range", this);
    }

    public double getPathCatchVolume(int path, double time1, double time2) {
        PathLink pl1 = null;
        PathLink pl2 = null;
        boolean wasinair = false;
        boolean gotcatch = false;
        int i = 0;
        while (i < this.pathlinks.get(path - 1).size()) {
            pl1 = this.pathlinks.get(path - 1).get(i);
            if (time1 >= pl1.getStartEvent().getT() && time1 <= pl1.getEndEvent().getT()) break;
            ++i;
        }
        if (i == this.pathlinks.get(path - 1).size()) {
            return 0.0;
        }
        while (true) {
            if (!(pl2 = this.pathlinks.get(path - 1).get(i)).isInHand()) {
                wasinair = true;
            }
            if (pl2.isInHand() && wasinair) {
                gotcatch = true;
                break;
            }
            if (time2 >= pl2.getStartEvent().getT() && time2 <= pl2.getEndEvent().getT()) break;
            if (++i != this.pathlinks.get(path - 1).size()) continue;
            i = 0;
        }
        if (gotcatch) {
            return 1.0;
        }
        return 0.0;
    }

    public double getPathBounceVolume(int path, double time1, double time2) {
        PathLink pl = null;
        int i = 0;
        while (i < this.pathlinks.get(path - 1).size()) {
            pl = this.pathlinks.get(path - 1).get(i);
            if (time1 >= pl.getStartEvent().getT() && time1 <= pl.getEndEvent().getT()) break;
            ++i;
        }
        if (i == this.pathlinks.get(path - 1).size()) {
            return 0.0;
        }
        while (true) {
            BouncePath bp;
            double vol;
            Path p;
            if ((p = (pl = this.pathlinks.get(path - 1).get(i)).getPath()) instanceof BouncePath && (vol = (bp = (BouncePath)p).getBounceVolume(time1, time2)) > 0.0) {
                return vol;
            }
            if (time2 >= pl.getStartEvent().getT() && time2 <= pl.getEndEvent().getT()) break;
            if (++i != this.pathlinks.get(path - 1).size()) continue;
            i = 0;
        }
        return 0.0;
    }

    public Coordinate getPathMax(int path) {
        Coordinate result = null;
        double t1 = this.getLoopStartTime();
        double t2 = this.getLoopEndTime();
        int i = 0;
        while (i < this.pathlinks.get(path - 1).size()) {
            PathLink pl = this.pathlinks.get(path - 1).get(i);
            result = pl.isInHand() ? Coordinate.max(result, this.getHandMax(pl.getHoldingJuggler(), pl.getHoldingHand())) : Coordinate.max(result, pl.getPath().getMax(t1, t2));
            ++i;
        }
        return result;
    }

    public Coordinate getPathMin(int path) {
        Coordinate result = null;
        double t1 = this.getLoopStartTime();
        double t2 = this.getLoopEndTime();
        int i = 0;
        while (i < this.pathlinks.get(path - 1).size()) {
            PathLink pl = this.pathlinks.get(path - 1).get(i);
            result = pl.isInHand() ? Coordinate.min(result, this.getHandMin(pl.getHoldingJuggler(), pl.getHoldingHand())) : Coordinate.min(result, pl.getPath().getMin(t1, t2));
            ++i;
        }
        return result;
    }

    public Coordinate getHandMax(int juggler, int hand) {
        Coordinate result = null;
        double t1 = this.getLoopStartTime();
        double t2 = this.getLoopEndTime();
        int handnum = hand == 1 ? 0 : 1;
        int i = 0;
        while (i < this.handlinks.get(juggler - 1).get(handnum).size()) {
            HandLink hl = this.handlinks.get(juggler - 1).get(handnum).get(i);
            Curve hp = hl.getHandCurve();
            if (hp != null) {
                result = Coordinate.max(result, hp.getMax(t1, t2));
            }
            ++i;
        }
        return result;
    }

    public Coordinate getHandMin(int juggler, int hand) {
        Coordinate result = null;
        double t1 = this.getLoopStartTime();
        double t2 = this.getLoopEndTime();
        int handnum = hand == 1 ? 0 : 1;
        int i = 0;
        while (i < this.handlinks.get(juggler - 1).get(handnum).size()) {
            HandLink hl = this.handlinks.get(juggler - 1).get(handnum).get(i);
            Curve hp = hl.getHandCurve();
            if (hp != null) {
                result = Coordinate.min(result, hp.getMin(t1, t2));
            }
            ++i;
        }
        return result;
    }

    public Coordinate getJugglerMax(int juggler) {
        return this.jugglercurve[juggler - 1].getMax();
    }

    public Coordinate getJugglerMin(int juggler) {
        return this.jugglercurve[juggler - 1].getMin();
    }

    public Permutation getPathPermutation() {
        for (JMLSymmetry sym : this.symmetries()) {
            if (sym.getType() != 1) continue;
            return sym.getPathPerm();
        }
        return null;
    }

    public int getPeriod() {
        return JMLPattern.getPeriod(this.getPathPermutation(), this.propassignment);
    }

    public static int getPeriod(Permutation perm, int[] propassign) {
        int period = 1;
        int size = perm.getSize();
        boolean[] notdone = new boolean[size];
        int i = 0;
        while (i < size) {
            notdone[i] = true;
            ++i;
        }
        i = 0;
        while (i < size) {
            if (notdone[i]) {
                int[] cycle = perm.getCycle(i + 1);
                int j = 0;
                while (j < cycle.length) {
                    notdone[cycle[j] - 1] = false;
                    cycle[j] = propassign[cycle[j] - 1];
                    ++j;
                }
                int cperiod = 1;
                while (cperiod < cycle.length) {
                    if (cycle.length % cperiod == 0) {
                        boolean matches = true;
                        int k = 0;
                        while (k < cycle.length) {
                            if (cycle[k] != cycle[(k + cperiod) % cycle.length]) {
                                matches = false;
                                break;
                            }
                            ++k;
                        }
                        if (matches) break;
                    }
                    ++cperiod;
                }
                period = Permutation.lcm(period, cperiod);
            }
            ++i;
        }
        return period;
    }

    public boolean isBouncePattern() {
        int path = 1;
        while (path <= this.getNumberOfPaths()) {
            for (PathLink pl : this.pathlinks.get(path - 1)) {
                if (!(pl.getPath() instanceof BouncePath)) continue;
                return true;
            }
            ++path;
        }
        return false;
    }

    protected void readJML(JMLNode current) throws JuggleExceptionUser {
        String type = current.getNodeType();
        if (type.equalsIgnoreCase("jml")) {
            String vers = current.getAttributes().getAttribute("version");
            if (vers != null) {
                if (JLFunc.compareVersions(vers, "3") > 0) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_JML_version"));
                }
                this.loadingversion = vers;
            }
        } else if (!type.equalsIgnoreCase("pattern")) {
            if (type.equalsIgnoreCase("title")) {
                this.setTitle(current.getNodeValue());
            } else if (type.equalsIgnoreCase("info")) {
                this.setInfo(current.getNodeValue());
                String tagstr = current.getAttributes().getAttribute("tags");
                if (tagstr != null) {
                    String[] stringArray = tagstr.split(",");
                    int n = stringArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String t = stringArray[n2];
                        this.addTag(t.strip());
                        ++n2;
                    }
                }
            } else if (type.equalsIgnoreCase("basepattern")) {
                this.base_pattern_notation = Pattern.canonicalNotation(current.getAttributes().getAttribute("notation"));
                this.base_pattern_config = current.getNodeValue().strip();
            } else if (type.equalsIgnoreCase("prop")) {
                PropDef pd = new PropDef();
                pd.readJML(current, this.loadingversion);
                this.addProp(pd);
            } else if (type.equalsIgnoreCase("setup")) {
                JMLAttributes at = current.getAttributes();
                String jugglerstring = at.getAttribute("jugglers");
                String pathstring = at.getAttribute("paths");
                String propstring = at.getAttribute("props");
                try {
                    if (jugglerstring != null) {
                        this.setNumberOfJugglers(Integer.valueOf(jugglerstring));
                    } else {
                        this.setNumberOfJugglers(1);
                    }
                    this.setNumberOfPaths(Integer.valueOf(pathstring));
                }
                catch (Exception ex) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_setup_tag"));
                }
                int[] pa = new int[this.numpaths];
                if (propstring != null) {
                    StringTokenizer st = new StringTokenizer(propstring, ",");
                    if (st.countTokens() != this.numpaths) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_prop_assignments"));
                    }
                    try {
                        int i = 0;
                        while (i < this.numpaths) {
                            pa[i] = Integer.valueOf(st.nextToken());
                            if (pa[i] < 1 || pa[i] > this.getNumberOfProps()) {
                                throw new JuggleExceptionUser(errorstrings.getString("Error_prop_number"));
                            }
                            ++i;
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_prop_format"));
                    }
                } else {
                    int i = 0;
                    while (i < this.numpaths) {
                        pa[i] = 1;
                        ++i;
                    }
                }
                this.setPropAssignments(pa);
            } else if (type.equalsIgnoreCase("symmetry")) {
                JMLSymmetry sym = new JMLSymmetry();
                sym.readJML(current, this.numjugglers, this.numpaths, this.loadingversion);
                this.addSymmetry(sym);
            } else {
                if (type.equalsIgnoreCase("event")) {
                    JMLEvent ev = new JMLEvent();
                    ev.readJML(current, this.loadingversion, this.getNumberOfJugglers(), this.getNumberOfPaths());
                    this.addEvent(ev);
                    return;
                }
                if (type.equalsIgnoreCase("position")) {
                    JMLPosition pos = new JMLPosition();
                    pos.readJML(current, this.loadingversion);
                    this.addPosition(pos);
                    return;
                }
                String template = errorstrings.getString("Error_unknown_tag");
                Object[] arguments = new Object[]{type};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        int i = 0;
        while (i < current.getNumberOfChildren()) {
            this.readJML(current.getChildNode(i));
            ++i;
        }
        if (current.getNodeType().equalsIgnoreCase("jml")) {
            this.setTitle(this.title);
        }
    }

    public void writeJML(Writer wr, boolean write_title, boolean write_info) throws IOException {
        int i;
        PrintWriter write = new PrintWriter(wr);
        int i2 = 0;
        while (i2 < JMLDefs.jmlprefix.length) {
            write.println(JMLDefs.jmlprefix[i2]);
            ++i2;
        }
        write.println("<jml version=\"" + JMLNode.xmlescape(this.version) + "\">");
        write.println("<pattern>");
        if (write_title && this.title != null) {
            write.println("<title>" + JMLNode.xmlescape(this.title) + "</title>");
        }
        if (write_info && (this.info != null || this.tags.size() > 0)) {
            String tagstr = String.join((CharSequence)",", this.tags);
            if (this.info != null) {
                if (tagstr.length() == 0) {
                    write.println("<info>" + JMLNode.xmlescape(this.info) + "</info>");
                } else {
                    write.println("<info tags=\"" + JMLNode.xmlescape(tagstr) + "\">" + JMLNode.xmlescape(this.info) + "</info>");
                }
            } else {
                write.println("<info tags=\"" + JMLNode.xmlescape(tagstr) + "\"/>");
            }
        }
        if (this.base_pattern_notation != null && this.base_pattern_config != null) {
            write.println("<basepattern notation=\"" + JMLNode.xmlescape(this.base_pattern_notation.toLowerCase()) + "\">");
            write.println(JMLNode.xmlescape(this.base_pattern_config.replaceAll(";", ";\n")));
            write.println("</basepattern>");
        }
        i = 0;
        while (i < this.props.size()) {
            this.props.get(i).writeJML(write);
            ++i;
        }
        String out = "<setup jugglers=\"" + this.getNumberOfJugglers() + "\" paths=\"" + this.getNumberOfPaths() + "\" props=\"";
        if (this.getNumberOfPaths() > 0) {
            out = out + this.getPropAssignment(1);
            i = 2;
            while (i <= this.getNumberOfPaths()) {
                out = out + "," + this.getPropAssignment(i);
                ++i;
            }
        }
        write.println(out + "\"/>");
        i = 0;
        while (i < this.symmetries.size()) {
            this.symmetries.get(i).writeJML(write);
            ++i;
        }
        JMLPosition pos = this.positionlist;
        while (pos != null) {
            pos.writeJML(write);
            pos = pos.getNext();
        }
        JMLEvent ev = this.eventlist;
        while (ev != null) {
            if (ev.isMaster()) {
                ev.writeJML(write);
            }
            ev = ev.getNext();
        }
        write.println("</pattern>");
        write.println("</jml>");
        int i3 = 0;
        while (i3 < JMLDefs.jmlsuffix.length) {
            write.println(JMLDefs.jmlsuffix[i3]);
            ++i3;
        }
        write.flush();
    }

    public JMLNode getRootNode() throws JuggleExceptionInternal {
        try {
            JMLParser parser = new JMLParser();
            parser.parse(new StringReader(this.toString()));
            return parser.getTree();
        }
        catch (SAXException se) {
            throw new JuggleExceptionInternal(se.getMessage(), this);
        }
        catch (IOException ioe) {
            throw new JuggleExceptionInternal(ioe.getMessage(), this);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeJML(sw, true, true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

