/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.DefaultListModel;
import jugglinglab.JugglingLab;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLDefs;
import jugglinglab.jml.JMLNode;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;

public class JMLPatternList {
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    public static final boolean BLANK_AT_END = true;
    public String version = "3";
    public String loadingversion = "3";
    protected String title;
    protected String info;
    protected DefaultListModel<PatternRecord> model = new DefaultListModel();

    public JMLPatternList() {
        this.clearModel();
    }

    public JMLPatternList(JMLNode root) throws JuggleExceptionUser {
        this();
        this.readJML(root);
    }

    public DefaultListModel<PatternRecord> getModel() {
        return this.model;
    }

    public void clearModel() {
        this.model.clear();
        this.model.addElement(new PatternRecord(" ", null, null, null, null, null, null));
    }

    public int size() {
        return this.model.size() - 1;
    }

    public void addLine(int row, String display, String animprefs, String notation, String anim, JMLNode patnode, JMLNode infonode) {
        if (display == null) {
            display = "";
        }
        if (animprefs != null) {
            animprefs = animprefs.strip();
        }
        if (notation != null) {
            notation = notation.strip();
        }
        if (anim != null) {
            anim = anim.strip();
        }
        String info = null;
        ArrayList<String> tags = null;
        if (infonode != null) {
            info = infonode.getNodeValue();
            info = info != null && info.strip().length() > 0 ? info.strip() : null;
            String tagstr = infonode.getAttributes().getAttribute("tags");
            if (tagstr != null) {
                tags = new ArrayList<String>();
                for (String t : tagstr.split(",")) {
                    t = t.strip();
                    boolean is_new = true;
                    for (String t2 : tags) {
                        if (!t2.equalsIgnoreCase(t)) continue;
                        is_new = false;
                    }
                    if (!is_new) continue;
                    tags.add(t);
                }
            }
        }
        PatternRecord rec = new PatternRecord(display, animprefs, notation, anim, patnode, info, tags);
        if (row < 0) {
            this.model.add(this.model.size() - 1, rec);
        } else {
            this.model.add(row, rec);
        }
    }

    public PatternRecord getLine(int row) {
        return row >= 0 && row < this.size() ? this.model.get(row) : null;
    }

    public JMLPattern getPatternForLine(int row) throws JuggleExceptionUser, JuggleExceptionInternal {
        PatternRecord rec = this.model.get(row);
        if (rec.notation == null) {
            return null;
        }
        JMLPattern pat = null;
        if (rec.notation.equalsIgnoreCase("jml") && rec.patnode != null) {
            pat = new JMLPattern(rec.patnode, this.loadingversion);
        } else if (rec.anim != null) {
            pat = JMLPattern.fromBasePattern(rec.notation, rec.anim);
            if (rec.info != null) {
                pat.setInfo(rec.info);
            }
            if (rec.tags != null) {
                for (String tag : rec.tags) {
                    pat.addTag(tag);
                }
            }
        } else {
            return null;
        }
        return pat;
    }

    public AnimationPrefs getAnimationPrefsForLine(int row) throws JuggleExceptionUser {
        PatternRecord rec = this.model.get(row);
        if (rec.animprefs == null) {
            return null;
        }
        AnimationPrefs ap = new AnimationPrefs();
        ParameterList params = new ParameterList(rec.animprefs);
        ap.fromParameters(params);
        params.errorIfParametersLeft();
        return ap;
    }

    public void setTitle(String t) {
        this.title = t == null || t.length() == 0 ? null : t.strip();
    }

    public String getTitle() {
        return this.title;
    }

    public void readJML(JMLNode root) throws JuggleExceptionUser {
        JMLNode listnode;
        if (!root.getNodeType().equalsIgnoreCase("jml")) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_missing_JML_tag"));
        }
        String vers = root.getAttributes().getAttribute("version");
        if (vers != null) {
            if (JLFunc.compareVersions(vers, "3") > 0) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_JML_version"));
            }
            this.loadingversion = vers;
        }
        if (!(listnode = root.getChildNode(0)).getNodeType().equalsIgnoreCase("patternlist")) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_missing_patternlist_tag"));
        }
        int linenumber = 0;
        for (int i = 0; i < listnode.getNumberOfChildren(); ++i) {
            JMLNode child = listnode.getChildNode(i);
            if (child.getNodeType().equalsIgnoreCase("title")) {
                this.title = child.getNodeValue().strip();
                continue;
            }
            if (child.getNodeType().equalsIgnoreCase("info")) {
                this.info = child.getNodeValue().strip();
                continue;
            }
            if (child.getNodeType().equalsIgnoreCase("line")) {
                ++linenumber;
                JMLAttributes attr = child.getAttributes();
                String display = attr.getAttribute("display");
                String animprefs = attr.getAttribute("animprefs");
                String notation = attr.getAttribute("notation");
                String anim = null;
                JMLNode patnode = null;
                JMLNode infonode = null;
                if (notation != null) {
                    if (notation.equalsIgnoreCase("jml")) {
                        patnode = child.findNode("pattern");
                        if (patnode == null) {
                            String template = errorstrings.getString("Error_missing_pattern");
                            Object[] arguments = new Object[]{linenumber};
                            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                        }
                        infonode = patnode.findNode("info");
                    } else {
                        anim = child.getNodeValue().strip();
                        infonode = child.findNode("info");
                    }
                }
                this.addLine(-1, display, animprefs, notation, anim, patnode, infonode);
                continue;
            }
            throw new JuggleExceptionUser(errorstrings.getString("Error_illegal_tag"));
        }
    }

    public void writeJML(Writer wr) throws IOException {
        int i;
        boolean empty;
        PrintWriter write = new PrintWriter(wr);
        for (int i2 = 0; i2 < JMLDefs.jmlprefix.length; ++i2) {
            write.println(JMLDefs.jmlprefix[i2]);
        }
        write.println("<jml version=\"" + JMLNode.xmlescape(this.version) + "\">");
        write.println("<patternlist>");
        if (this.title != null && this.title.length() > 0) {
            write.println("<title>" + JMLNode.xmlescape(this.title) + "</title>");
        }
        if (this.info != null && this.info.length() > 0) {
            write.println("<info>" + JMLNode.xmlescape(this.info) + "</info>");
        }
        boolean bl = empty = this.model.size() == 1;
        if (!empty) {
            write.println();
        }
        boolean previousLineWasAnimation = false;
        for (i = 0; i < this.model.size() - 1; ++i) {
            PatternRecord rec = this.model.get(i);
            String line = "<line display=\"" + JMLNode.xmlescape(rec.display.stripTrailing()) + "\"";
            boolean hasAnimation = false;
            if (rec.notation != null) {
                line = line + " notation=\"" + JMLNode.xmlescape(rec.notation.toLowerCase()) + "\"";
                hasAnimation = true;
            }
            if (rec.animprefs != null) {
                line = line + " animprefs=\"" + JMLNode.xmlescape(rec.animprefs) + "\"";
                hasAnimation = true;
            }
            if (hasAnimation) {
                line = line + ">";
                if (i > 0) {
                    write.println();
                }
                write.println(line);
                if (rec.notation != null && rec.notation.equalsIgnoreCase("jml") && rec.patnode != null) {
                    rec.patnode.writeNode(write, 0);
                } else if (rec.anim != null) {
                    write.println(JMLNode.xmlescape(rec.anim));
                    if (rec.info != null || rec.tags != null && rec.tags.size() > 0) {
                        String tagstr;
                        String string = tagstr = rec.tags != null ? String.join((CharSequence)",", rec.tags) : "";
                        if (rec.info != null) {
                            if (tagstr.length() == 0) {
                                write.println("<info>" + JMLNode.xmlescape(rec.info) + "</info>");
                            } else {
                                write.println("<info tags=\"" + JMLNode.xmlescape(tagstr) + "\">" + JMLNode.xmlescape(rec.info) + "</info>");
                            }
                        } else {
                            write.println("<info tags=\"" + JMLNode.xmlescape(tagstr) + "\"/>");
                        }
                    }
                }
                write.println("</line>");
            } else {
                line = line + "/>";
                if (previousLineWasAnimation && i > 0) {
                    write.println();
                }
                write.println(line);
            }
            previousLineWasAnimation = hasAnimation;
        }
        if (!empty) {
            write.println();
        }
        write.println("</patternlist>");
        write.println("</jml>");
        for (i = 0; i < JMLDefs.jmlsuffix.length; ++i) {
            write.println(JMLDefs.jmlsuffix[i]);
        }
        write.flush();
    }

    public void writeText(Writer wr) throws IOException {
        PrintWriter write = new PrintWriter(wr);
        for (int i = 0; i < this.model.size() - 1; ++i) {
            PatternRecord rec = this.model.get(i);
            write.println(rec.display);
        }
        write.flush();
    }

    public static class PatternRecord {
        public String display;
        public String animprefs;
        public String notation;
        public String anim;
        public JMLNode patnode;
        public String info;
        public ArrayList<String> tags;

        public PatternRecord(String dis, String ap, String not, String ani, JMLNode pat, String inf, ArrayList<String> t) {
            this.display = dis;
            this.animprefs = ap;
            this.notation = not;
            this.anim = ani;
            this.patnode = pat;
            this.info = inf;
            this.tags = t;
        }

        public PatternRecord(PatternRecord pr) {
            this.display = pr.display;
            this.animprefs = pr.animprefs;
            this.notation = pr.notation;
            this.anim = pr.anim;
            this.patnode = pr.patnode;
            this.info = pr.info;
            if (pr.tags != null) {
                this.tags = new ArrayList();
                for (String tag : pr.tags) {
                    this.tags.add(tag);
                }
            } else {
                this.tags = null;
            }
        }
    }
}

