/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLNode;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;

public class JMLPosition {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected double x;
    protected double y;
    protected double z;
    protected double t;
    protected double angle;
    protected int juggler;
    protected JMLPosition prev;
    protected JMLPosition next;

    public Coordinate getCoordinate() {
        return new Coordinate(this.x, this.y, this.z);
    }

    public void setCoordinate(Coordinate c) {
        this.x = c.x;
        this.y = c.y;
        this.z = c.z;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
    }

    public double getT() {
        return this.t;
    }

    public void setT(double t) {
        this.t = t;
    }

    public int getJuggler() {
        return this.juggler;
    }

    public void setJuggler(String strjuggler) {
        this.juggler = Integer.parseInt(strjuggler);
    }

    public void setJuggler(int j) {
        this.juggler = j;
    }

    public JMLPosition getPrevious() {
        return this.prev;
    }

    public void setPrevious(JMLPosition prev) {
        this.prev = prev;
    }

    public JMLPosition getNext() {
        return this.next;
    }

    public void setNext(JMLPosition next) {
        this.next = next;
    }

    public int getHashCode() {
        return this.toString().hashCode();
    }

    public void readJML(JMLNode current, String jmlvers) throws JuggleExceptionUser {
        JMLAttributes at = current.getAttributes();
        double tempx = 0.0;
        double tempy = 0.0;
        double tempz = 0.0;
        double tempt = 0.0;
        double tempangle = 0.0;
        String jugglerstr = "1";
        try {
            int i = 0;
            while (i < at.getNumberOfAttributes()) {
                if (at.getAttributeName(i).equalsIgnoreCase("x")) {
                    tempx = JLFunc.parseDouble(at.getAttributeValue(i));
                } else if (at.getAttributeName(i).equalsIgnoreCase("y")) {
                    tempy = JLFunc.parseDouble(at.getAttributeValue(i));
                } else if (at.getAttributeName(i).equalsIgnoreCase("z")) {
                    tempz = JLFunc.parseDouble(at.getAttributeValue(i));
                } else if (at.getAttributeName(i).equalsIgnoreCase("t")) {
                    tempt = JLFunc.parseDouble(at.getAttributeValue(i));
                } else if (at.getAttributeName(i).equalsIgnoreCase("angle")) {
                    tempangle = JLFunc.parseDouble(at.getAttributeValue(i));
                } else if (at.getAttributeName(i).equalsIgnoreCase("juggler")) {
                    jugglerstr = at.getAttributeValue(i);
                }
                ++i;
            }
        }
        catch (NumberFormatException nfe) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_position_coordinate"));
        }
        this.setCoordinate(new Coordinate(tempx, tempy, tempz));
        this.setT(tempt);
        this.setAngle(tempangle);
        if (jugglerstr == null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_position_nojuggler"));
        }
        this.setJuggler(jugglerstr);
        if (current.getNumberOfChildren() != 0) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_position_subtag"));
        }
    }

    public void writeJML(PrintWriter wr) throws IOException {
        Coordinate c = this.getCoordinate();
        wr.println("<position x=\"" + JLFunc.toStringRounded(c.x, 4) + "\" y=\"" + JLFunc.toStringRounded(c.y, 4) + "\" z=\"" + JLFunc.toStringRounded(c.z, 4) + "\" t=\"" + JLFunc.toStringRounded(this.getT(), 4) + "\" angle=\"" + JLFunc.toStringRounded(this.getAngle(), 4) + "\" juggler=\"" + Integer.toString(this.getJuggler()) + "\"/>");
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        try {
            this.writeJML(new PrintWriter(sw));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sw.toString();
    }
}

