/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLAttributes;
import jugglinglab.jml.JMLNode;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleException;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;

public class JMLSymmetry {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    int type;
    int numjugglers;
    int numpaths;
    Permutation jugglerperm = null;
    Permutation pathperm = null;
    double delay = -1.0;
    public static final int TYPE_DELAY = 1;
    public static final int TYPE_SWITCH = 2;
    public static final int TYPE_SWITCHDELAY = 3;

    public JMLSymmetry() {
    }

    public JMLSymmetry(int type, int numjugglers, String jugperm, int numpaths, String pathperm, double delay) throws JuggleExceptionUser {
        this.setType(type);
        this.setJugglerPerm(numjugglers, jugperm);
        this.setPathPerm(numpaths, pathperm);
        this.setDelay(delay);
    }

    public int getType() {
        return this.type;
    }

    protected void setType(int type) {
        this.type = type;
    }

    public int getNumberOfJugglers() {
        return this.numjugglers;
    }

    public Permutation getJugglerPerm() {
        return this.jugglerperm;
    }

    protected void setJugglerPerm(int nj, String jp) throws JuggleExceptionUser {
        this.numjugglers = nj;
        try {
            this.jugglerperm = jp == null ? new Permutation(this.numjugglers, true) : new Permutation(this.numjugglers, jp, true);
        }
        catch (JuggleException je) {
            throw new JuggleExceptionUser(je.getMessage());
        }
    }

    public int getNumberOfPaths() {
        return this.numpaths;
    }

    public Permutation getPathPerm() {
        return this.pathperm;
    }

    protected void setPathPerm(int np, String pp) throws JuggleExceptionUser {
        this.numpaths = np;
        try {
            this.pathperm = pp == null ? new Permutation(this.numpaths, false) : new Permutation(this.numpaths, pp, false);
        }
        catch (JuggleException je) {
            throw new JuggleExceptionUser(je.getMessage());
        }
    }

    public double getDelay() {
        return this.delay;
    }

    public void setDelay(double del) {
        this.delay = del;
    }

    public void readJML(JMLNode current, int numjug, int numpat, String version) throws JuggleExceptionUser {
        int symtypenum;
        JMLAttributes at = current.getAttributes();
        double delay = -1.0;
        String symtype = at.getAttribute("type");
        String jugglerperm = at.getAttribute("jperm");
        String pathperm = at.getAttribute("pperm");
        String delaystring = at.getAttribute("delay");
        if (delaystring != null) {
            try {
                delay = JLFunc.parseDouble(delaystring);
            }
            catch (NumberFormatException nfe) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_symmetry_format"));
            }
        }
        if (symtype == null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_symmetry_notype"));
        }
        if (symtype.equalsIgnoreCase("delay")) {
            symtypenum = 1;
        } else if (symtype.equalsIgnoreCase("switch")) {
            symtypenum = 2;
        } else if (symtype.equalsIgnoreCase("switchdelay")) {
            symtypenum = 3;
        } else {
            throw new JuggleExceptionUser(errorstrings.getString("Error_symmetry_type"));
        }
        this.setType(symtypenum);
        this.setJugglerPerm(numjug, jugglerperm);
        this.setPathPerm(numpat, pathperm);
        this.setDelay(delay);
    }

    public void writeJML(PrintWriter wr) throws IOException {
        Object out = "<symmetry type=\"";
        switch (this.getType()) {
            case 1: {
                out = (String)out + "delay\" pperm=\"" + this.pathperm.toString(true) + "\" delay=\"" + JLFunc.toStringRounded(this.getDelay(), 4) + "\"/>";
                break;
            }
            case 2: {
                out = (String)out + "switch\" jperm=\"" + this.jugglerperm.toString(true) + "\" pperm=\"" + this.pathperm.toString(true) + "\"/>";
                break;
            }
            case 3: {
                out = (String)out + "switchdelay\" jperm=\"" + this.jugglerperm.toString(true) + "\" pperm=\"" + this.pathperm.toString(true) + "\"/>";
            }
        }
        wr.println((String)out);
    }
}

