/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import java.io.IOException;
import java.io.PrintWriter;
import jugglinglab.jml.PathLink;

public class JMLTransition {
    protected int path;
    protected String type;
    protected String mod;
    protected PathLink ipl;
    protected PathLink opl;
    protected int transitiontype;
    public static final int TRANS_NONE = 0;
    public static final int TRANS_THROW = 1;
    public static final int TRANS_CATCH = 2;
    public static final int TRANS_SOFTCATCH = 3;
    public static final int TRANS_GRABCATCH = 4;
    public static final int TRANS_HOLDING = 5;
    public static final int TRANS_ANY = 6;

    public JMLTransition(int transtype, int path, String type, String mod) {
        this.transitiontype = transtype;
        this.type = type;
        this.mod = mod;
        this.path = path;
    }

    public int getType() {
        return this.transitiontype;
    }

    public void setType(int t) {
        this.transitiontype = t;
    }

    public int getPath() {
        return this.path;
    }

    public void setPath(int p) {
        this.path = p;
    }

    public String getThrowType() {
        return this.type;
    }

    public void setThrowType(String type) {
        this.type = type;
    }

    public String getMod() {
        return this.mod;
    }

    public void setMod(String mod) {
        this.mod = mod;
    }

    public void setIncomingPathLink(PathLink ipl) {
        this.ipl = ipl;
    }

    public PathLink getIncomingPathLink() {
        return this.ipl;
    }

    public void setOutgoingPathLink(PathLink opl) {
        this.opl = opl;
    }

    public PathLink getOutgoingPathLink() {
        return this.opl;
    }

    public JMLTransition duplicate() {
        JMLTransition tr = new JMLTransition(this.transitiontype, this.path, this.type, this.mod);
        return tr;
    }

    public void writeJML(PrintWriter wr) throws IOException {
        switch (this.getType()) {
            case 1: {
                String out = "<throw path=\"" + Integer.toString(this.getPath()) + "\"";
                if (this.getThrowType() != null) {
                    out = out + " type=\"" + this.getThrowType() + "\"";
                }
                if (this.getMod() != null) {
                    out = out + " mod=\"" + this.getMod() + "\"";
                }
                wr.println(out + "/>");
                break;
            }
            case 2: {
                wr.println("<catch path=\"" + Integer.toString(this.getPath()) + "\"/>");
                break;
            }
            case 3: {
                wr.println("<catch path=\"" + Integer.toString(this.getPath()) + "\" type=\"soft\"/>");
                break;
            }
            case 4: {
                wr.println("<catch path=\"" + Integer.toString(this.getPath()) + "\" type=\"grab\"/>");
                break;
            }
            case 5: {
                wr.println("<holding path=\"" + Integer.toString(this.getPath()) + "\"/>");
            }
        }
    }
}

