/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.jml;

import jugglinglab.jml.JMLEvent;
import jugglinglab.path.Path;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class PathLink {
    protected int pathnum;
    protected JMLEvent startevent;
    protected JMLEvent endevent;
    protected int catchtype;
    protected String throwtype;
    protected String mod;
    protected Path proppath;
    protected boolean inhand;
    protected int juggler;
    protected int hand;
    protected boolean ismaster;
    protected PathLink[] duplicates;
    protected PathLink master;

    public PathLink(int pathnum, JMLEvent startevent, JMLEvent endevent) {
        this.pathnum = pathnum;
        this.startevent = startevent;
        this.endevent = endevent;
        this.proppath = null;
        this.inhand = false;
    }

    public void setThrow(String type, String mod) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.proppath = Path.newPath(type);
        this.proppath.initPath(mod);
        this.proppath.setStart(this.startevent.getGlobalCoordinate(), this.startevent.getT());
        this.proppath.setEnd(this.endevent.getGlobalCoordinate(), this.endevent.getT());
        this.proppath.calcPath();
        this.throwtype = type;
        this.mod = mod;
        this.inhand = false;
    }

    public void setInHand(int juggler, int hand) {
        this.inhand = true;
        this.juggler = juggler;
        this.hand = hand;
    }

    public Path getPath() {
        return this.proppath;
    }

    public int getCatch() {
        return this.catchtype;
    }

    public void setCatch(int catchtype) {
        this.catchtype = catchtype;
    }

    public int getPathNum() {
        return this.pathnum;
    }

    public JMLEvent getStartEvent() {
        return this.startevent;
    }

    public JMLEvent getEndEvent() {
        return this.endevent;
    }

    public boolean isInHand() {
        return this.inhand;
    }

    public int getHoldingJuggler() {
        return this.juggler;
    }

    public int getHoldingHand() {
        return this.hand;
    }

    public boolean isMaster() {
        return this.ismaster;
    }

    public String toString() {
        Object result = null;
        result = this.inhand ? "In hand, " : "Not in hand (type=\"" + this.throwtype + "\", mod=\"" + this.mod + "\"), ";
        Coordinate start = this.startevent.getGlobalCoordinate();
        result = (String)result + "from (x=" + start.x + ",y=" + start.y + ",z=" + start.z + ",t=" + this.startevent.getT() + ") ";
        Coordinate end = this.endevent.getGlobalCoordinate();
        result = (String)result + "to (x=" + end.x + ",y=" + end.y + ",z=" + end.z + ",t=" + this.endevent.getT() + ")";
        return result;
    }
}

