/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.notation.HssParms;
import jugglinglab.notation.ModParms;
import jugglinglab.notation.OssPatBnc;
import jugglinglab.notation.PatParms;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.Permutation;

public class HSS {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected static double hss_dwell_default = 0.3;

    public static ModParms processHSS(String p, String h, boolean hld, boolean dwlmax, String hndspc, double dwl) throws JuggleExceptionUser {
        ModParms modinf = new ModParms();
        ArrayList<Object> ossPat = new ArrayList();
        ArrayList<Object> hssPat = new ArrayList();
        ArrayList<ArrayList<String>> bounc = new ArrayList();
        OssPatBnc ossinfo = HSS.ossSyntax(p);
        ossPat = ossinfo.objPat;
        bounc = ossinfo.bnc;
        HssParms hssinfo = HSS.hssSyntax(h);
        hssPat = hssinfo.pat;
        int numHnd = hssinfo.hands;
        int ossPer = ossPat.size();
        int hssPer = hssPat.size();
        HSS.ossPermTest(ossPat, ossPer);
        int hssOrb = HSS.hssPermTest(hssPat, hssPer);
        int[][] handmap = hndspc != null ? HSS.parseHandspec(hndspc, numHnd) : HSS.defHandspec(numHnd);
        int numJug = 1;
        for (int i = 0; i < numHnd; ++i) {
            if (handmap[i][0] <= numJug) continue;
            numJug = handmap[i][0];
        }
        PatParms patinfo = HSS.convNotation(ossPat, hssPat, hssOrb, handmap, numJug, hld, dwlmax, dwl, bounc);
        modinf.convertedPattern = patinfo.newPat;
        if (modinf.convertedPattern == null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_no_pattern"));
        }
        modinf.dwellBeatsArray = patinfo.dwellBt;
        return modinf;
    }

    private static OssPatBnc ossSyntax(String ss) throws JuggleExceptionUser {
        int i;
        boolean muxThrow = false;
        boolean muxThrowFound = false;
        boolean minOneThrow = false;
        boolean b1 = false;
        boolean b2 = false;
        boolean b3 = false;
        int throwSum = 0;
        int numBeats = 0;
        int subBeats = 0;
        int numObj = 0;
        ArrayList oPat = new ArrayList();
        ArrayList bncinfo = new ArrayList();
        for (i = 0; i < ss.length(); ++i) {
            char c = ss.charAt(i);
            if (muxThrow) {
                if (Character.toString(c).matches("[0-9,a-z]")) {
                    minOneThrow = true;
                    muxThrowFound = true;
                    ((ArrayList)oPat.get(numBeats - 1)).add(subBeats, Character.valueOf(c));
                    ((ArrayList)bncinfo.get(numBeats - 1)).add(subBeats, "null");
                    ++subBeats;
                    throwSum += Character.getNumericValue(c);
                    b1 = true;
                    b2 = false;
                    b3 = false;
                    continue;
                }
                if (c == ']') {
                    if (muxThrowFound) {
                        muxThrow = false;
                        muxThrowFound = false;
                        subBeats = 0;
                        b1 = false;
                        b2 = false;
                        b3 = false;
                        continue;
                    }
                    String template = errorstrings.getString("Error_hss_object_syntax_error_at_pos");
                    Object[] arguments = new Object[]{i + 1};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
                if (Character.isWhitespace(c)) {
                    b1 = false;
                    b2 = false;
                    b3 = false;
                    continue;
                }
                if (c == 'B') {
                    if (b1) {
                        ((ArrayList)bncinfo.get(numBeats - 1)).set(subBeats - 1, "B");
                        b1 = false;
                        b2 = true;
                        continue;
                    }
                    String template = errorstrings.getString("Error_hss_object_syntax_error_at_pos");
                    Object[] arguments = new Object[]{i + 1};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
                if (c == 'F' || c == 'L') {
                    if (b2) {
                        ((ArrayList)bncinfo.get(numBeats - 1)).set(subBeats - 1, "B" + Character.toString(c));
                        b2 = false;
                        continue;
                    }
                    if (b3) {
                        ((ArrayList)bncinfo.get(numBeats - 1)).set(subBeats - 1, "BH" + Character.toString(c));
                        b3 = false;
                        continue;
                    }
                    String template = errorstrings.getString("Error_hss_object_syntax_error_at_pos");
                    Object[] arguments = new Object[]{i + 1};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
                if (c == 'H') {
                    if (b2) {
                        ((ArrayList)bncinfo.get(numBeats - 1)).set(subBeats - 1, "BH");
                        b2 = false;
                        b3 = true;
                        continue;
                    }
                    String template = errorstrings.getString("Error_hss_object_syntax_error_at_pos");
                    Object[] arguments = new Object[]{i + 1};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
                String template = errorstrings.getString("Error_hss_object_syntax_error_at_pos");
                Object[] arguments = new Object[]{i + 1};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
            if (Character.toString(c).matches("[0-9,a-z]")) {
                minOneThrow = true;
                oPat.add(numBeats, new ArrayList());
                ((ArrayList)oPat.get(numBeats)).add(subBeats, Character.valueOf(c));
                bncinfo.add(numBeats, new ArrayList());
                ((ArrayList)bncinfo.get(numBeats)).add(subBeats, "null");
                ++numBeats;
                throwSum += Character.getNumericValue(c);
                b1 = true;
                b2 = false;
                b3 = false;
                continue;
            }
            if (c == '[') {
                muxThrow = true;
                oPat.add(numBeats, new ArrayList());
                bncinfo.add(numBeats, new ArrayList());
                ++numBeats;
                b1 = false;
                b2 = false;
                b3 = false;
                continue;
            }
            if (Character.isWhitespace(c)) {
                b1 = false;
                b2 = false;
                b3 = false;
                continue;
            }
            if (c == 'B') {
                if (b1) {
                    ((ArrayList)bncinfo.get(numBeats - 1)).set(subBeats, "B");
                    b1 = false;
                    b2 = true;
                    continue;
                }
                String template = errorstrings.getString("Error_hss_object_syntax_error_at_pos");
                Object[] arguments = new Object[]{i + 1};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
            if (c == 'F' || c == 'L') {
                if (b2) {
                    ((ArrayList)bncinfo.get(numBeats - 1)).set(subBeats, "B" + Character.toString(c));
                    b2 = false;
                    continue;
                }
                if (b3) {
                    ((ArrayList)bncinfo.get(numBeats - 1)).set(subBeats, "BH" + Character.toString(c));
                    b3 = false;
                    continue;
                }
                String template = errorstrings.getString("Error_hss_object_syntax_error_at_pos");
                Object[] arguments = new Object[]{i + 1};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
            if (c == 'H') {
                if (b2) {
                    ((ArrayList)bncinfo.get(numBeats - 1)).set(subBeats, "BH");
                    b2 = false;
                    b3 = true;
                    continue;
                }
                String template = errorstrings.getString("Error_hss_object_syntax_error_at_pos");
                Object[] arguments = new Object[]{i + 1};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
            String template = errorstrings.getString("Error_hss_object_syntax_error_at_pos");
            Object[] arguments = new Object[]{i + 1};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        if (!muxThrow && minOneThrow) {
            if (throwSum % numBeats != 0) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_hss_bad_average_object"));
            }
        } else {
            throw new JuggleExceptionUser(errorstrings.getString("Error_hss_syntax_error"));
        }
        numObj = throwSum / numBeats;
        for (i = 0; i < bncinfo.size(); ++i) {
            for (int j = 0; j < ((ArrayList)bncinfo.get(i)).size(); ++j) {
                if (((ArrayList)bncinfo.get(i)).get(j) == "null") {
                    ((ArrayList)bncinfo.get(i)).set(j, " ");
                    continue;
                }
                ((ArrayList)bncinfo.get(i)).set(j, (String)((ArrayList)bncinfo.get(i)).get(j) + " ");
            }
        }
        OssPatBnc ossinf = new OssPatBnc();
        ossinf.objPat = oPat;
        ossinf.bnc = bncinfo;
        return ossinf;
    }

    private static HssParms hssSyntax(String ss) throws JuggleExceptionUser {
        int throwSum = 0;
        int numBeats = 0;
        int nHnds = 0;
        ArrayList<Character> hPat = new ArrayList<Character>();
        for (int i = 0; i < ss.length(); ++i) {
            char c = ss.charAt(i);
            if (Character.toString(c).matches("[0-9,a-z]")) {
                hPat.add(numBeats, Character.valueOf(c));
                ++numBeats;
                throwSum += Character.getNumericValue(c);
                continue;
            }
            if (Character.isWhitespace(c)) continue;
            String template = errorstrings.getString("Error_hss_hand_syntax_error_at_pos");
            Object[] arguments = new Object[]{i + 1};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        if (throwSum % numBeats != 0) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_hss_bad_average_hand"));
        }
        nHnds = throwSum / numBeats;
        HssParms hssinf = new HssParms();
        hssinf.pat = hPat;
        hssinf.hands = nHnds;
        return hssinf;
    }

    private static void ossPermTest(ArrayList<ArrayList<Character>> os, int op) throws JuggleExceptionUser {
        int i;
        ArrayList mods = new ArrayList();
        int[] cmp = new int[op];
        for (i = 0; i < op; ++i) {
            mods.add(i, new ArrayList());
            for (int j = 0; j < os.get(i).size(); ++j) {
                int modulo = (Character.getNumericValue(os.get(i).get(j).charValue()) + i) % op;
                ((ArrayList)mods.get(i)).add(j, modulo);
                int n = modulo;
                cmp[n] = cmp[n] + 1;
            }
        }
        for (i = 0; i < op; ++i) {
            if (cmp[i] == os.get(i).size()) continue;
            throw new JuggleExceptionUser(errorstrings.getString("Error_hss_object_pattern_invalid"));
        }
    }

    private static int hssPermTest(ArrayList<Character> hs, int hp) throws JuggleExceptionUser {
        int i;
        int[] mods = new int[hp];
        int[] cmp = new int[hp];
        int[] orb = new int[hp];
        boolean[] touched = new boolean[hp];
        for (i = 0; i < hp; ++i) {
            int modulo;
            mods[i] = modulo = (Character.getNumericValue(hs.get(i).charValue()) + i) % hp;
            int n = modulo;
            cmp[n] = cmp[n] + 1;
        }
        for (i = 0; i < hp; ++i) {
            if (cmp[i] == 1) continue;
            throw new JuggleExceptionUser(errorstrings.getString("Error_hss_hand_pattern_invalid"));
        }
        int ho = 1;
        for (i = 0; i < hp; ++i) {
            if (!touched[i]) {
                int j = i;
                orb[i] = Character.getNumericValue(hs.get(i).charValue());
                touched[i] = true;
                j = mods[i];
                while (j != i) {
                    int n = i;
                    orb[n] = orb[n] + Character.getNumericValue(hs.get(j).charValue());
                    touched[j] = true;
                    j = mods[j];
                }
            }
            if (orb[i] == ho || orb[i] == 0) continue;
            ho = Permutation.lcm(orb[i], ho);
        }
        return ho;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int[][] parseHandspec(String hspec, int nh) throws JuggleExceptionUser {
        int i;
        int[][] hmap = new int[nh][2];
        boolean assignLH = false;
        boolean assignRH = false;
        boolean jugAct = false;
        boolean pass = false;
        boolean handPresent = false;
        boolean numFormStart = false;
        boolean matchFnd = false;
        int jugNum = 0;
        Object buildHndNum = null;
        for (i = 0; i < hspec.length(); ++i) {
            block30: {
                char c = hspec.charAt(i);
                if (!jugAct) {
                    if (c == '(') {
                        jugAct = true;
                        assignLH = true;
                        numFormStart = true;
                        buildHndNum = null;
                        pass = false;
                        handPresent = false;
                        ++jugNum;
                        continue;
                    }
                    if (Character.isWhitespace(c)) continue;
                    String template = errorstrings.getString("Error_hss_handspec_syntax_error_at_pos");
                    Object[] arguments = new Object[]{i + 1};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
                if (assignLH) {
                    block29: {
                        if (Character.toString(c).matches("[0-9]")) {
                            if (!numFormStart) {
                                String template = errorstrings.getString("Error_hss_handspec_syntax_error_at_pos");
                                Object[] arguments = new Object[]{i + 1};
                                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                            }
                            if (buildHndNum == null) {
                                buildHndNum = Character.toString(c);
                                continue;
                            }
                            buildHndNum = (String)buildHndNum + Character.toString(c);
                            continue;
                        }
                        if (Character.isWhitespace(c)) {
                            if (buildHndNum == null || ((String)buildHndNum).length() < 1) continue;
                            numFormStart = false;
                            continue;
                        }
                        if (c != ',') {
                            String template = errorstrings.getString("Error_hss_handspec_syntax_error_at_pos");
                            Object[] arguments = new Object[]{i + 1};
                            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                        }
                        assignLH = false;
                        assignRH = true;
                        numFormStart = true;
                        if (buildHndNum != null) {
                            if (Integer.parseInt((String)buildHndNum) >= 1 && Integer.parseInt((String)buildHndNum) <= nh) {
                                if (hmap[Integer.parseInt((String)buildHndNum) - 1][0] != 0) {
                                    String template = errorstrings.getString("Error_hss_hand_assigned_more_than_once");
                                    Object[] arguments = new Object[]{Integer.valueOf((String)buildHndNum)};
                                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                                }
                                hmap[Integer.parseInt((String)buildHndNum) - 1][0] = jugNum;
                                hmap[Integer.parseInt((String)buildHndNum) - 1][1] = 0;
                                handPresent = true;
                                break block29;
                            } else {
                                String template = errorstrings.getString("Error_hss_hand_number_out_of_range");
                                Object[] arguments = new Object[]{Integer.valueOf((String)buildHndNum)};
                                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                            }
                        }
                        handPresent = false;
                    }
                    buildHndNum = null;
                    continue;
                }
                if (!assignRH) continue;
                if (Character.toString(c).matches("[0-9]")) {
                    if (!numFormStart) {
                        String template = errorstrings.getString("Error_hss_handspec_syntax_error_at_pos");
                        Object[] arguments = new Object[]{i + 1};
                        throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                    }
                    if (buildHndNum == null) {
                        buildHndNum = Character.toString(c);
                        continue;
                    }
                    buildHndNum = (String)buildHndNum + Character.toString(c);
                    continue;
                }
                if (Character.isWhitespace(c)) {
                    if (buildHndNum == null || ((String)buildHndNum).length() < 1) continue;
                    numFormStart = false;
                    continue;
                }
                if (c != ')') {
                    String template = errorstrings.getString("Error_hss_handspec_syntax_error_at_pos");
                    Object[] arguments = new Object[]{i + 1};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
                assignRH = false;
                jugAct = false;
                if (buildHndNum != null) {
                    if (Integer.parseInt((String)buildHndNum) >= 1 && Integer.parseInt((String)buildHndNum) <= nh) {
                        hmap[Integer.parseInt((String)buildHndNum) - 1][0] = jugNum;
                        hmap[Integer.parseInt((String)buildHndNum) - 1][1] = 1;
                        break block30;
                    } else {
                        String template = errorstrings.getString("Error_hss_hand_number_out_of_range");
                        Object[] arguments = new Object[]{Integer.valueOf((String)buildHndNum)};
                        throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                    }
                }
                if (!handPresent) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_hss_at_least_one_hand_per_juggler"));
                }
            }
            buildHndNum = null;
            pass = true;
        }
        if (jugNum > nh) {
            String template = errorstrings.getString("Error_hss_handspec_too_many_jugglers");
            Object[] arguments = new Object[]{nh};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        if (!pass) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_hss_handspec_syntax_error"));
        }
        for (i = 0; i < nh; ++i) {
            if (hmap[i][0] != 0) {
                matchFnd = true;
                break;
            }
            if (matchFnd) continue;
            String template = errorstrings.getString("Error_hss_handspec_hand_missing");
            Object[] arguments = new Object[]{i + 1};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        i = 0;
        while (i < nh) {
            if (hmap[i][0] == 0) {
                String template = errorstrings.getString("Error_hss_juggler_not_assigned_to_hand");
                Object[] arguments = new Object[]{i + 1};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
            ++i;
        }
        return hmap;
    }

    private static int[][] defHandspec(int nh) {
        int[][] hmap = new int[nh][2];
        int nJugs = nh % 2 == 0 ? nh / 2 : (nh + 1) / 2;
        for (int i = 0; i < nh; ++i) {
            if (i < nJugs) {
                hmap[i][0] = i + 1;
                hmap[i][1] = 1;
                continue;
            }
            hmap[i][0] = i + 1 - nJugs;
            hmap[i][1] = 0;
        }
        return hmap;
    }

    private static PatParms convNotation(ArrayList<ArrayList<Character>> os, ArrayList<Character> hs, int ho, int[][] hm, int nj, boolean hldOpt, boolean dwlMaxOpt, double defDwl, ArrayList<ArrayList<String>> bncStr) throws JuggleExceptionUser {
        int j;
        int i;
        int j2;
        int i2;
        int i3;
        Object modPat = null;
        PatParms patinf = new PatParms();
        boolean flag = false;
        ArrayList iph = new ArrayList();
        int objPer = os.size();
        int hndPer = hs.size();
        int patPer = Permutation.lcm(objPer, ho);
        int[] ah = new int[patPer];
        boolean[] assignDone = new boolean[patPer];
        int[][] ji = new int[patPer][2];
        double[] dwlBts = new double[patPer];
        if (patPer > objPer) {
            for (i3 = objPer; i3 < patPer; ++i3) {
                os.add(i3, os.get(i3 - objPer));
            }
        }
        if (patPer > objPer) {
            for (i3 = objPer; i3 < patPer; ++i3) {
                bncStr.add(i3, bncStr.get(i3 - objPer));
            }
        }
        if (patPer > hndPer) {
            for (i3 = hndPer; i3 < patPer; ++i3) {
                hs.add(i3, hs.get(i3 - hndPer));
            }
        }
        int currHand = 0;
        for (i3 = 0; i3 < patPer; ++i3) {
            if (hs.get(i3).charValue() == '0') {
                for (int j3 = 0; j3 < os.get(i3).size(); ++j3) {
                    if (os.get(i3).get(j3).charValue() == '0') continue;
                    String template = errorstrings.getString("Error_hss_no_hand_to_throw_at_beat");
                    Object[] arguments = new Object[]{i3 + 1};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
                ji[i3][0] = 0;
                ji[i3][1] = -1;
                assignDone[i3] = true;
                continue;
            }
            if (!assignDone[i3]) {
                ah[i3] = ++currHand;
                assignDone[i3] = true;
                int next = (i3 + Character.getNumericValue(hs.get(i3).charValue())) % patPer;
                while (next != i3) {
                    ah[next] = currHand;
                    assignDone[next] = true;
                    next = (next + Character.getNumericValue(hs.get(next).charValue())) % patPer;
                }
            }
            ji[i3][0] = hm[ah[i3] - 1][0];
            ji[i3][1] = hm[ah[i3] - 1][1];
        }
        flag = false;
        int[] mincaught = new int[patPer];
        int tgtIdx = 0;
        for (i2 = 0; i2 < patPer; ++i2) {
            for (j2 = 0; j2 < os.get(i2).size(); ++j2) {
                int curThrow = Character.getNumericValue(os.get(i2).get(j2).charValue());
                tgtIdx = (i2 + curThrow) % patPer;
                if (curThrow <= 0) continue;
                if (mincaught[tgtIdx] == 0) {
                    mincaught[tgtIdx] = curThrow;
                    continue;
                }
                if (curThrow >= mincaught[tgtIdx]) continue;
                mincaught[tgtIdx] = curThrow;
            }
        }
        if (!dwlMaxOpt) {
            for (i2 = 0; i2 < patPer; ++i2) {
                if (ji[i2][0] != ji[(i2 + 1) % patPer][0] || ji[i2][1] != ji[(i2 + 1) % patPer][1]) continue;
                flag = true;
                break;
            }
            if (flag) {
                for (i2 = 0; i2 < patPer; ++i2) {
                    dwlBts[i2] = hss_dwell_default;
                }
            } else {
                for (i2 = 0; i2 < patPer; ++i2) {
                    dwlBts[i2] = defDwl;
                }
            }
            for (i2 = 0; i2 < patPer; ++i2) {
                if (!(dwlBts[i2] >= (double)mincaught[i2])) continue;
                dwlBts[i2] = (double)mincaught[i2] - (1.0 - hss_dwell_default);
            }
        } else {
            for (i2 = 0; i2 < patPer; ++i2) {
                j2 = (i2 + 1) % patPer;
                int diff = 1;
                while (ji[i2][0] != ji[j2][0] || ji[i2][1] != ji[j2][1]) {
                    j2 = (j2 + 1) % patPer;
                    ++diff;
                }
                dwlBts[j2] = (double)diff - (1.0 - hss_dwell_default);
            }
            for (i2 = 0; i2 < patPer; ++i2) {
                if (dwlBts[i2] >= (double)mincaught[i2]) {
                    dwlBts[i2] = (double)mincaught[i2] - (1.0 - hss_dwell_default);
                    continue;
                }
                if (!(dwlBts[i2] <= 0.0)) continue;
                dwlBts[i2] = hss_dwell_default;
            }
        }
        boolean[] clash = new boolean[patPer];
        int clashcnt = 0;
        for (i = 0; i < patPer; ++i) {
            for (j = 1; j < patPer; ++j) {
                if ((dwlBts[(i + j) % patPer] - dwlBts[i] - (double)j) % (double)patPer != 0.0) continue;
                clash[(i + j) % patPer] = true;
                ++clashcnt;
            }
            while (clashcnt != 0) {
                for (int k = 0; k < patPer; ++k) {
                    if (!clash[k]) continue;
                    dwlBts[k] = dwlBts[k] + hss_dwell_default / (double)clashcnt;
                    --clashcnt;
                    clash[k] = false;
                }
            }
        }
        patinf.dwellBt = dwlBts;
        for (i = 0; i < patPer; ++i) {
            iph.add(i, new ArrayList());
            for (j = 0; j < os.get(i).size(); ++j) {
                ((ArrayList)iph.get(i)).add(j, null);
                int throwVal = Character.getNumericValue(os.get(i).get(j).charValue());
                int sourceJug = ji[i][0];
                int sourceHnd = ji[i][1];
                int targetJug = ji[(i + throwVal) % patPer][0];
                int targetHnd = ji[(i + throwVal) % patPer][1];
                if (throwVal % 2 == 0 && sourceHnd != targetHnd) {
                    ((ArrayList)iph.get(i)).set(j, "x");
                } else if (throwVal % 2 != 0 && sourceHnd == targetHnd) {
                    ((ArrayList)iph.get(i)).set(j, "x");
                }
                if (sourceJug != targetJug) {
                    if (((ArrayList)iph.get(i)).get(j) != "x") {
                        ((ArrayList)iph.get(i)).set(j, "p" + targetJug);
                        continue;
                    }
                    ((ArrayList)iph.get(i)).set(j, "xp" + targetJug);
                    continue;
                }
                if (!hldOpt || throwVal != Character.getNumericValue(hs.get(i).charValue())) continue;
                if (((ArrayList)iph.get(i)).get(j) != "x") {
                    ((ArrayList)iph.get(i)).set(j, "H");
                    continue;
                }
                ((ArrayList)iph.get(i)).set(j, "xH");
            }
        }
        for (i = 0; i < patPer; ++i) {
            for (j = 0; j < bncStr.get(i).size(); ++j) {
                if (((ArrayList)iph.get(i)).get(j) == null) {
                    ((ArrayList)iph.get(i)).set(j, bncStr.get(i).get(j));
                    continue;
                }
                ((ArrayList)iph.get(i)).set(j, (String)((ArrayList)iph.get(i)).get(j) + bncStr.get(i).get(j));
            }
        }
        for (i = 0; i < patPer; ++i) {
            int currJug = 0;
            while (currJug < nj) {
                if (modPat == null) {
                    modPat = "<";
                } else if (currJug == 0) {
                    modPat = (String)modPat + "<";
                }
                if (ji[i][1] == 0) {
                    modPat = (String)modPat + "(";
                    if (ji[i][0] == currJug + 1) {
                        if (os.get(i).size() > 1) {
                            modPat = (String)modPat + "[";
                            for (j = 0; j < os.get(i).size(); ++j) {
                                modPat = (String)modPat + Character.toString(os.get(i).get(j).charValue());
                                if (((ArrayList)iph.get(i)).get(j) == null) continue;
                                modPat = (String)modPat + (String)((ArrayList)iph.get(i)).get(j);
                            }
                            modPat = (String)modPat + "]";
                        } else {
                            modPat = (String)modPat + Character.toString(os.get(i).get(0).charValue());
                            if (((ArrayList)iph.get(i)).get(0) != null) {
                                modPat = (String)modPat + (String)((ArrayList)iph.get(i)).get(0);
                            }
                        }
                        modPat = (String)modPat + ",0)!";
                        modPat = currJug == nj - 1 ? (String)modPat + ">" : (String)modPat + "|";
                        ++currJug;
                        continue;
                    }
                    modPat = (String)modPat + "0,0)!";
                    modPat = currJug == nj - 1 ? (String)modPat + ">" : (String)modPat + "|";
                    ++currJug;
                    continue;
                }
                modPat = (String)modPat + "(0,";
                if (ji[i][0] == currJug + 1) {
                    if (os.get(i).size() > 1) {
                        modPat = (String)modPat + "[";
                        for (j = 0; j < os.get(i).size(); ++j) {
                            modPat = (String)modPat + Character.toString(os.get(i).get(j).charValue());
                            if (((ArrayList)iph.get(i)).get(j) == null) continue;
                            modPat = (String)modPat + (String)((ArrayList)iph.get(i)).get(j);
                        }
                        modPat = (String)modPat + "]";
                    } else {
                        modPat = (String)modPat + Character.toString(os.get(i).get(0).charValue());
                        if (((ArrayList)iph.get(i)).get(0) != null) {
                            modPat = (String)modPat + (String)((ArrayList)iph.get(i)).get(0);
                        }
                    }
                    modPat = (String)modPat + ")!";
                    modPat = currJug == nj - 1 ? (String)modPat + ">" : (String)modPat + "|";
                    ++currJug;
                    continue;
                }
                modPat = (String)modPat + "0)!";
                modPat = currJug == nj - 1 ? (String)modPat + ">" : (String)modPat + "|";
                ++currJug;
            }
        }
        patinf.newPat = modPat;
        return patinf;
    }
}

