/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLPosition;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class MHNBody {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected int jugglers = 0;
    protected int[] size;
    protected int[][] coords;
    protected double[][][][] bodypath;

    public MHNBody(String str) throws JuggleExceptionUser, JuggleExceptionInternal {
        str = JLFunc.expandRepeats(str);
        String pat = "[" + Pattern.quote("<>{}") + "]";
        str = str.replaceAll(pat, "");
        for (int pass = 0; pass < 4; ++pass) {
            int juggler = 0;
            int beat = 0;
            int coordnum = 0;
            int pos = 0;
            while (pos < str.length()) {
                char ch = str.charAt(pos);
                if (ch == ' ') {
                    ++pos;
                    continue;
                }
                if (ch == '.') {
                    if (pass == 2) {
                        if (coordnum == 0) {
                            this.coords[juggler][beat] = 1;
                            this.bodypath[juggler][beat] = new double[1][];
                            this.bodypath[juggler][beat][0] = null;
                        } else {
                            this.coords[juggler][beat] = coordnum;
                            this.bodypath[juggler][beat] = new double[coordnum][];
                        }
                    }
                    ++beat;
                    coordnum = 0;
                    ++pos;
                    continue;
                }
                if (ch == '-') {
                    if (pass == 3) {
                        this.bodypath[juggler][beat][coordnum] = null;
                    }
                    ++coordnum;
                    ++pos;
                    continue;
                }
                if (ch == '(') {
                    int closeindex = str.indexOf(41, pos + 1);
                    if (closeindex < 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_body_noparen"));
                    }
                    if (pass == 3) {
                        this.bodypath[juggler][beat][coordnum] = new double[4];
                        this.bodypath[juggler][beat][coordnum][3] = 100.0;
                        String str2 = str.substring(pos + 1, closeindex);
                        try {
                            StringTokenizer st4 = new StringTokenizer(str2, ",", false);
                            this.bodypath[juggler][beat][coordnum][0] = JLFunc.parseDouble(st4.nextToken());
                            if (st4.hasMoreTokens()) {
                                this.bodypath[juggler][beat][coordnum][1] = JLFunc.parseDouble(st4.nextToken());
                            }
                            if (st4.hasMoreTokens()) {
                                this.bodypath[juggler][beat][coordnum][2] = JLFunc.parseDouble(st4.nextToken());
                            }
                            if (st4.hasMoreTokens()) {
                                this.bodypath[juggler][beat][coordnum][3] = JLFunc.parseDouble(st4.nextToken());
                            }
                        }
                        catch (NumberFormatException e) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_body_coordinate"));
                        }
                        catch (NoSuchElementException e) {
                            throw new JuggleExceptionInternal("No such element exception in MHNBody");
                        }
                    }
                    ++coordnum;
                    pos = closeindex + 1;
                    continue;
                }
                if (ch == '|' || ch == '!') {
                    if (coordnum != 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_body_badending"));
                    }
                    if (pass == 1) {
                        this.size[juggler] = beat;
                        this.coords[juggler] = new int[beat];
                        this.bodypath[juggler] = new double[beat][][];
                    }
                    beat = 0;
                    ++juggler;
                    ++pos;
                    continue;
                }
                String template = errorstrings.getString("Error_body_character");
                Object[] arguments = new Object[]{Character.toString(ch)};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
            if (coordnum != 0) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_body_badending"));
            }
            if (pass == 0) {
                this.jugglers = juggler + 1;
                this.size = new int[this.jugglers];
                this.coords = new int[this.jugglers][];
                this.bodypath = new double[this.jugglers][][][];
                continue;
            }
            if (pass != 1) continue;
            this.size[juggler] = beat;
            this.coords[juggler] = new int[beat];
            this.bodypath[juggler] = new double[beat][][];
        }
    }

    public int getNumberOfJugglers() {
        return this.jugglers;
    }

    public int getPeriod(int juggler) {
        int j = (juggler - 1) % this.jugglers;
        return this.size[j];
    }

    public int getNumberOfPositions(int juggler, int pos) {
        int j = (juggler - 1) % this.jugglers;
        return this.coords[j][pos];
    }

    public JMLPosition getPosition(int juggler, int pos, int index) {
        if (pos >= this.getPeriod(juggler) || index >= this.getNumberOfPositions(juggler, pos)) {
            return null;
        }
        int j = (juggler - 1) % this.jugglers;
        if (this.bodypath[j][pos][index] == null) {
            return null;
        }
        JMLPosition result = new JMLPosition();
        result.setJuggler(juggler);
        result.setCoordinate(new Coordinate(this.bodypath[j][pos][index][1], this.bodypath[j][pos][index][2], this.bodypath[j][pos][index][3]));
        result.setAngle(this.bodypath[j][pos][index][0]);
        return result;
    }
}

