/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import jugglinglab.JugglingLab;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class MHNHands {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected int jugglers;
    protected int[] size;
    protected int[][] coords;
    protected int[][] catches;
    protected double[][][][] handpath;

    public MHNHands(String str) throws JuggleExceptionUser, JuggleExceptionInternal {
        str = JLFunc.expandRepeats(str);
        String pat = "[" + Pattern.quote("<>{}") + "]";
        str = str.replaceAll(pat, "");
        for (int pass = 0; pass < 4; ++pass) {
            int juggler = 0;
            int beat = 0;
            int coordnum = 0;
            boolean gotthrow = false;
            boolean gotcatch = false;
            int pos = 0;
            while (pos < str.length()) {
                char ch = str.charAt(pos);
                if (ch == ' ') {
                    ++pos;
                    continue;
                }
                if (ch == '.') {
                    if (pass == 2) {
                        this.coords[juggler][beat] = coordnum;
                        if (this.coords[juggler][beat] < 2) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_hands_toofewcoords"));
                        }
                        this.handpath[juggler][beat] = new double[coordnum][];
                    } else if (pass == 3) {
                        if (!gotcatch) {
                            this.catches[juggler][beat] = this.coords[juggler][beat] - 1;
                        }
                        if (this.handpath[juggler][beat][0] == null) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_hands_nothrow"));
                        }
                        if (this.handpath[juggler][beat][this.catches[juggler][beat]] == null) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_hands_nocatch"));
                        }
                    }
                    gotcatch = false;
                    gotthrow = false;
                    ++beat;
                    coordnum = 0;
                    ++pos;
                    continue;
                }
                if (ch == '-') {
                    if (pass == 3) {
                        this.handpath[juggler][beat][coordnum] = null;
                    }
                    ++coordnum;
                    ++pos;
                    continue;
                }
                if (ch == 'T' || ch == 't') {
                    if (coordnum != 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_Tnotstart"));
                    }
                    if (gotthrow) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_toomanycoords"));
                    }
                    gotthrow = true;
                    ++pos;
                    continue;
                }
                if (ch == 'C' || ch == 'c') {
                    if (coordnum == 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_Catstart"));
                    }
                    if (gotcatch) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_toomanycatches"));
                    }
                    if (pass == 2) {
                        this.catches[juggler][beat] = coordnum;
                    }
                    gotcatch = true;
                    ++pos;
                    continue;
                }
                if (ch == '(') {
                    int closeindex = str.indexOf(41, pos + 1);
                    if (closeindex < 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_noparen"));
                    }
                    if (pass == 3) {
                        this.handpath[juggler][beat][coordnum] = new double[3];
                        String str2 = str.substring(pos + 1, closeindex);
                        try {
                            StringTokenizer st4 = new StringTokenizer(str2, ",", false);
                            this.handpath[juggler][beat][coordnum][0] = JLFunc.parseDouble(st4.nextToken());
                            if (st4.hasMoreTokens()) {
                                this.handpath[juggler][beat][coordnum][2] = JLFunc.parseDouble(st4.nextToken());
                            }
                            if (st4.hasMoreTokens()) {
                                this.handpath[juggler][beat][coordnum][1] = JLFunc.parseDouble(st4.nextToken());
                            }
                        }
                        catch (NumberFormatException e) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_hands_coordinate"));
                        }
                        catch (NoSuchElementException e) {
                            throw new JuggleExceptionInternal("No such element exception in \"hands\"");
                        }
                    }
                    ++coordnum;
                    pos = closeindex + 1;
                    continue;
                }
                if (ch == '|' || ch == '!') {
                    if (coordnum != 0) {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_hands_badending"));
                    }
                    if (pass == 1) {
                        this.size[juggler] = beat;
                        this.catches[juggler] = new int[beat];
                        this.coords[juggler] = new int[beat];
                        this.handpath[juggler] = new double[beat][][];
                    }
                    beat = 0;
                    ++juggler;
                    ++pos;
                    continue;
                }
                String template = errorstrings.getString("Error_hands_character");
                Object[] arguments = new Object[]{Character.toString(ch)};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
            if (coordnum != 0) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_hands_badending"));
            }
            if (pass == 0) {
                this.jugglers = juggler + 1;
                this.size = new int[this.jugglers];
                this.coords = new int[this.jugglers][];
                this.catches = new int[this.jugglers][];
                this.handpath = new double[this.jugglers][][][];
                continue;
            }
            if (pass != 1) continue;
            this.size[juggler] = beat;
            this.catches[juggler] = new int[beat];
            this.coords[juggler] = new int[beat];
            this.handpath[juggler] = new double[beat][][];
        }
    }

    public int getPeriod(int juggler) {
        int j = (juggler - 1) % this.jugglers;
        return this.size[j];
    }

    public int getNumberOfCoordinates(int juggler, int pos) {
        int j = (juggler - 1) % this.jugglers;
        return this.coords[j][pos];
    }

    public int getCatchIndex(int juggler, int pos) {
        int j = (juggler - 1) % this.jugglers;
        return this.catches[j][pos];
    }

    public Coordinate getCoordinate(int juggler, int pos, int index) {
        if (pos >= this.getPeriod(juggler) || index >= this.getNumberOfCoordinates(juggler, pos)) {
            return null;
        }
        int j = (juggler - 1) % this.jugglers;
        if (this.handpath[j][pos][index] == null) {
            return null;
        }
        return new Coordinate(this.handpath[j][pos][index][0], this.handpath[j][pos][index][1], this.handpath[j][pos][index][2]);
    }
}

