/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import jugglinglab.notation.MHNPattern;
import jugglinglab.notation.NotationControl;
import jugglinglab.prop.Prop;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;

public abstract class MHNNotationControl
extends NotationControl {
    protected static final String[] builtinHandsNames = new String[]{"inside", "outside", "half", "Mills"};
    protected static final String[] builtinHandsStrings = new String[]{"(10)(32.5).", "(32.5)(10).", "(32.5)(10).(10)(32.5).", "(-25)(2.5).(25)(-2.5).(-25)(0)."};
    protected static final String[] builtinBodyNames = new String[]{"line", "feed", "backtoback", "sidetoside", "circles"};
    protected static final String[] builtinBodyStrings = new String[]{"<(90).|(270,-125).|(90,125).|(270,-250).|(90,250).|(270,-375).>", "<(90,75).|(270,-75,50).|(270,-75,-50).|(270,-75,150).|(270,-75,-150).>", "<(270,35).|(90,-35).|(0,0,35).|(180,0,-35).>", "<(0).|(0,100).|(0,-100).|(0,200).|(0,-200).|(0,300).>", "(0,75,0)...(90,0,75)...(180,-75,0)...(270,0,-75)..."};
    protected JTextField tf1;
    protected JTextField tf2;
    protected JTextField tf3;
    protected JTextField tf4;
    protected JTextField tf5;
    protected JTextField tf6;
    protected JComboBox<String> cb1;
    protected JComboBox<String> cb2;
    protected JComboBox<String> cb3;
    protected boolean cb1_selected = false;
    protected boolean cb2_selected = false;
    protected static final int border = 10;
    protected static final int hspacing = 5;
    protected static final int vspacing = 12;

    public MHNNotationControl() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        JPanel p1 = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        p1.setLayout(gb);
        JLabel lab1 = new JLabel(guistrings.getString("Pattern"));
        p1.add(lab1);
        gb.setConstraints(lab1, MHNNotationControl.make_constraints(22, 0, 0, new Insets(10, 10, 0, 5)));
        this.tf1 = new JTextField(15);
        p1.add(this.tf1);
        gb.setConstraints(this.tf1, MHNNotationControl.make_constraints(21, 1, 0, new Insets(10, 0, 0, 10)));
        JLabel lab3 = new JLabel(guistrings.getString("Beats_per_second"));
        p1.add(lab3);
        gb.setConstraints(lab3, MHNNotationControl.make_constraints(22, 0, 1, new Insets(24, 10, 0, 5)));
        this.tf3 = new JTextField(4);
        p1.add(this.tf3);
        gb.setConstraints(this.tf3, MHNNotationControl.make_constraints(21, 1, 1, new Insets(24, 0, 0, 10)));
        JLabel lab2 = new JLabel(guistrings.getString("Dwell_beats"));
        p1.add(lab2);
        gb.setConstraints(lab2, MHNNotationControl.make_constraints(22, 0, 2, new Insets(12, 10, 0, 5)));
        this.tf2 = new JTextField(4);
        p1.add(this.tf2);
        gb.setConstraints(this.tf2, MHNNotationControl.make_constraints(21, 1, 2, new Insets(12, 0, 0, 10)));
        JLabel lab4 = new JLabel(guistrings.getString("Hand_movement"));
        p1.add(lab4);
        gb.setConstraints(lab4, MHNNotationControl.make_constraints(22, 0, 3, new Insets(12, 10, 0, 5)));
        this.cb1 = new JComboBox();
        this.cb1.addItem(guistrings.getString("MHNHands_name_default"));
        for (int i = 0; i < builtinHandsNames.length; ++i) {
            String item = "MHNHands_name_" + builtinHandsNames[i];
            this.cb1.addItem(guistrings.getString(item));
        }
        this.cb1.addItem(guistrings.getString("MHNHands_name_custom"));
        p1.add(this.cb1);
        gb.setConstraints(this.cb1, MHNNotationControl.make_constraints(21, 1, 3, new Insets(12, 0, 0, 10)));
        this.tf4 = new JTextField(15);
        p1.add(this.tf4);
        gb.setConstraints(this.tf4, MHNNotationControl.make_constraints(21, 1, 4, new Insets(5, 0, 0, 10)));
        this.cb1.addActionListener(new ActionListener(this){
            final /* synthetic */ MHNNotationControl this$0;
            {
                MHNNotationControl mHNNotationControl = this$0;
                Objects.requireNonNull(mHNNotationControl);
                this.this$0 = mHNNotationControl;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                int index = this.this$0.cb1.getSelectedIndex();
                this.this$0.cb1_selected = true;
                if (index == 0) {
                    this.this$0.tf4.setText("");
                    this.this$0.tf4.setEnabled(false);
                } else if (index == builtinHandsNames.length + 1) {
                    this.this$0.tf4.setEnabled(true);
                } else {
                    this.this$0.tf4.setText(builtinHandsStrings[index - 1]);
                    this.this$0.tf4.setCaretPosition(0);
                    this.this$0.tf4.setEnabled(true);
                }
            }
        });
        this.tf4.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ MHNNotationControl this$0;
            {
                MHNNotationControl mHNNotationControl = this$0;
                Objects.requireNonNull(mHNNotationControl);
                this.this$0 = mHNNotationControl;
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                if (!this.this$0.cb1_selected) {
                    this.this$0.cb1.setSelectedIndex(builtinHandsNames.length + 1);
                }
                this.this$0.cb1_selected = false;
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                if (!this.this$0.cb1_selected) {
                    this.this$0.cb1.setSelectedIndex(builtinHandsNames.length + 1);
                }
            }
        });
        JLabel lab5 = new JLabel(guistrings.getString("Body_movement"));
        p1.add(lab5);
        gb.setConstraints(lab5, MHNNotationControl.make_constraints(22, 0, 5, new Insets(12, 10, 0, 5)));
        this.cb2 = new JComboBox();
        this.cb2.addItem(guistrings.getString("MHNBody_name_default"));
        for (int i = 0; i < builtinBodyNames.length; ++i) {
            String item = "MHNBody_name_" + builtinBodyNames[i];
            this.cb2.addItem(guistrings.getString(item));
        }
        this.cb2.addItem(guistrings.getString("MHNBody_name_custom"));
        p1.add(this.cb2);
        gb.setConstraints(this.cb2, MHNNotationControl.make_constraints(21, 1, 5, new Insets(12, 0, 0, 10)));
        this.tf5 = new JTextField(15);
        p1.add(this.tf5);
        gb.setConstraints(this.tf5, MHNNotationControl.make_constraints(21, 1, 6, new Insets(5, 0, 0, 10)));
        this.cb2.addActionListener(new ActionListener(this){
            final /* synthetic */ MHNNotationControl this$0;
            {
                MHNNotationControl mHNNotationControl = this$0;
                Objects.requireNonNull(mHNNotationControl);
                this.this$0 = mHNNotationControl;
            }

            @Override
            public void actionPerformed(ActionEvent ae) {
                int index = this.this$0.cb2.getSelectedIndex();
                this.this$0.cb2_selected = true;
                if (index == 0) {
                    this.this$0.tf5.setText("");
                    this.this$0.tf5.setEnabled(false);
                } else if (index == builtinBodyNames.length + 1) {
                    this.this$0.tf5.setEnabled(true);
                } else {
                    this.this$0.tf5.setText(builtinBodyStrings[index - 1]);
                    this.this$0.tf5.setCaretPosition(0);
                    this.this$0.tf5.setEnabled(true);
                }
            }
        });
        this.tf5.getDocument().addDocumentListener(new DocumentListener(this){
            final /* synthetic */ MHNNotationControl this$0;
            {
                MHNNotationControl mHNNotationControl = this$0;
                Objects.requireNonNull(mHNNotationControl);
                this.this$0 = mHNNotationControl;
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                if (!this.this$0.cb2_selected) {
                    this.this$0.cb2.setSelectedIndex(builtinBodyNames.length + 1);
                }
                this.this$0.cb2_selected = false;
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                if (!this.this$0.cb2_selected) {
                    this.this$0.cb2.setSelectedIndex(builtinBodyNames.length + 1);
                }
            }
        });
        JLabel prop_label = new JLabel(guistrings.getString("Prop_type"));
        p1.add(prop_label);
        gb.setConstraints(prop_label, MHNNotationControl.make_constraints(22, 0, 7, new Insets(12, 10, 0, 5)));
        this.cb3 = new JComboBox();
        for (int i = 0; i < Prop.builtinProps.length; ++i) {
            String item = "Prop_name_" + Prop.builtinProps[i].toLowerCase();
            this.cb3.addItem(guistrings.getString(item));
        }
        p1.add(this.cb3);
        gb.setConstraints(this.cb3, MHNNotationControl.make_constraints(21, 1, 7, new Insets(12, 0, 0, 10)));
        JLabel lab6 = new JLabel(guistrings.getString("Manual_settings"));
        p1.add(lab6);
        gb.setConstraints(lab6, MHNNotationControl.make_constraints(21, 0, 8, new Insets(24, 10, 0, 5)));
        this.tf6 = new JTextField(25);
        p1.add(this.tf6);
        GridBagConstraints gbc6 = MHNNotationControl.make_constraints(22, 0, 9, new Insets(5, 15, 0, 10));
        gbc6.gridwidth = 2;
        gb.setConstraints(this.tf6, gbc6);
        this.resetControl();
        this.add((Component)p1, "First");
    }

    protected static GridBagConstraints make_constraints(int location, int gridx, int gridy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = location;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        return gbc;
    }

    protected static GridBagConstraints make_constraints(int location, int gridx, int gridy, Insets ins) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = location;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.insets = ins;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        return gbc;
    }

    @Override
    public void resetControl() {
        this.tf1.setText("3");
        this.tf2.setText(JLFunc.toStringRounded(MHNPattern.dwell_default, 2));
        this.tf3.setText("");
        this.tf4.setText("");
        this.cb1.setSelectedIndex(0);
        this.tf5.setText("");
        this.cb2.setSelectedIndex(0);
        this.tf6.setText("");
        this.cb3.setSelectedIndex(0);
    }

    @Override
    public ParameterList getParameterList() throws JuggleExceptionUser {
        ParameterList pl;
        StringBuffer sb = new StringBuffer(256);
        sb.append("pattern=");
        sb.append(this.tf1.getText());
        if (this.cb3.getSelectedIndex() != 0) {
            sb.append(";prop=" + Prop.builtinProps[this.cb3.getSelectedIndex()].toLowerCase());
        }
        if (this.tf2.getText().length() > 0 && !this.tf2.getText().equals(JLFunc.toStringRounded(MHNPattern.dwell_default, 2))) {
            sb.append(";dwell=");
            sb.append(this.tf2.getText());
        }
        if (this.tf3.getText().length() > 0) {
            sb.append(";bps=");
            sb.append(this.tf3.getText());
        }
        if (this.tf4.getText().length() > 0) {
            sb.append(";hands=");
            sb.append(this.tf4.getText());
        }
        if (this.tf5.getText().length() > 0) {
            sb.append(";body=");
            sb.append(this.tf5.getText());
        }
        if (this.tf6.getText().length() > 0) {
            sb.append(";");
            sb.append(this.tf6.getText());
        }
        if ((pl = new ParameterList(sb.toString())).getParameter("title") == null) {
            String hss = pl.getParameter("hss");
            int hands_index = this.cb1.getSelectedIndex();
            int body_index = this.cb2.getSelectedIndex();
            if (hss != null) {
                String title = "oss: " + pl.getParameter("pattern") + "  hss: " + hss;
                pl.addParameter("title", title);
            } else if (hands_index > 0) {
                String title = pl.getParameter("pattern") + " " + this.cb1.getItemAt(hands_index);
                pl.addParameter("title", title);
            } else if (body_index > 0) {
                String title = pl.getParameter("pattern") + " " + this.cb2.getItemAt(body_index);
                pl.addParameter("title", title);
            }
        }
        return pl;
    }
}

