/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.IllegalFormatException;
import java.util.StringTokenizer;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PropDef;
import jugglinglab.notation.MHNBody;
import jugglinglab.notation.MHNHands;
import jugglinglab.notation.MHNSymmetry;
import jugglinglab.notation.MHNThrow;
import jugglinglab.notation.Pattern;
import jugglinglab.util.Coordinate;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import jugglinglab.util.Permutation;

public abstract class MHNPattern
extends Pattern {
    protected static double bps_default = -1.0;
    protected static double dwell_default = 1.3;
    protected static double gravity_default = 980.0;
    protected static double propdiam_default = 10.0;
    protected static double bouncefrac_default = 0.9;
    protected static double squeezebeats_default = 0.4;
    protected static String prop_default = "ball";
    protected static boolean hold_default = false;
    protected static boolean dwellmax_default = true;
    protected String config;
    protected String pattern;
    protected double bps_set = bps_default;
    protected double dwell = dwell_default;
    protected double gravity = gravity_default;
    protected double propdiam = propdiam_default;
    protected double bouncefrac = bouncefrac_default;
    protected double squeezebeats = squeezebeats_default;
    protected String prop = prop_default;
    protected String[] color;
    protected String title;
    protected String hss;
    protected boolean hold = hold_default;
    protected boolean dwellmax = dwellmax_default;
    protected String handspec;
    protected double[] dwellarray;
    protected int numjugglers;
    protected int numpaths;
    protected int period;
    protected int max_occupancy;
    protected MHNThrow[][][][] th;
    protected MHNHands hands;
    protected MHNBody bodies;
    protected int max_throw;
    protected int indexes;
    protected ArrayList<MHNSymmetry> symmetry;
    protected double bps;
    public static final int RIGHT_HAND = 0;
    public static final int LEFT_HAND = 1;
    protected static final double[] samethrowx = new double[]{0.0, 20.0, 25.0, 12.0, 10.0, 7.5, 5.0, 5.0, 5.0};
    protected static final double[] crossingthrowx = new double[]{0.0, 17.0, 17.0, 12.0, 10.0, 18.0, 25.0, 25.0, 30.0};
    protected static final double[] catchx = new double[]{0.0, 17.0, 25.0, 30.0, 40.0, 45.0, 45.0, 50.0, 50.0};
    protected static final double restingx = 25.0;
    protected static double BEATS_ONE_THROW_EARLY = 0.0;
    protected static final double BEATS_AIRTIME_MIN = 0.3;
    protected static final double BEATS_THROW_CATCH_MIN = 0.3;
    protected static final double BEATS_CATCH_THROW_MIN = 0.02;
    protected static final double SECS_EVENT_GAP_MAX = 0.5;
    protected static final double[] throwspersec = new double[]{2.0, 2.0, 2.0, 2.9, 3.4, 4.1, 4.25, 5.0, 5.0, 5.5};

    public int getNumberOfJugglers() {
        return this.numjugglers;
    }

    public int getNumberOfPaths() {
        return this.numpaths;
    }

    public int getPeriod() {
        return this.period;
    }

    public int getIndexes() {
        return this.indexes;
    }

    public int getMaxOccupancy() {
        return this.max_occupancy;
    }

    public int getMaxThrow() {
        return this.max_throw;
    }

    public MHNThrow[][][][] getThrows() {
        return this.th;
    }

    public int getNumberOfSymmetries() {
        return this.symmetry.size();
    }

    public String getPropName() {
        return this.prop;
    }

    public void addSymmetry(MHNSymmetry ss) {
        this.symmetry.add(ss);
    }

    public MHNSymmetry getSymmetry(int i) {
        return this.symmetry.get(i);
    }

    public Iterable<MHNSymmetry> symmetries() {
        return this.symmetry;
    }

    @Override
    public MHNPattern fromParameters(ParameterList pl) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.config = pl.toString();
        this.pattern = pl.removeParameter("pattern");
        if (this.pattern == null) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_no_pattern"));
        }
        String temp = null;
        temp = pl.removeParameter("bps");
        if (temp != null) {
            try {
                this.bps = this.bps_set = Double.parseDouble(temp);
            }
            catch (NumberFormatException nfe) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_bps_value"));
            }
        }
        if ((temp = pl.removeParameter("dwell")) != null) {
            try {
                this.dwell = Double.parseDouble(temp);
                if (this.dwell <= 0.0 || this.dwell >= 2.0) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_dwell_range"));
                }
            }
            catch (NumberFormatException nfe) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_dwell_value"));
            }
        }
        if ((temp = pl.removeParameter("hands")) != null) {
            this.hands = new MHNHands(temp);
        }
        if ((temp = pl.removeParameter("body")) != null) {
            this.bodies = new MHNBody(temp);
        }
        if ((temp = pl.removeParameter("gravity")) != null) {
            try {
                this.gravity = Double.parseDouble(temp);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((temp = pl.removeParameter("propdiam")) != null) {
            try {
                this.propdiam = Double.parseDouble(temp);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((temp = pl.removeParameter("bouncefrac")) != null) {
            try {
                this.bouncefrac = Double.parseDouble(temp);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((temp = pl.removeParameter("squeezebeats")) != null) {
            try {
                this.squeezebeats = Double.parseDouble(temp);
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        if ((temp = pl.removeParameter("prop")) != null) {
            this.prop = temp;
        }
        if ((temp = pl.removeParameter("colors")) != null) {
            temp = temp.strip().equals("mixed") ? "{red}{green}{blue}{yellow}{cyan}{magenta}{orange}{pink}{gray}{black}" : JLFunc.expandRepeats(temp);
            StringTokenizer st1 = new StringTokenizer(temp, "}", false);
            StringTokenizer st2 = null;
            String str = null;
            int numcolors = st1.countTokens();
            this.color = new String[numcolors];
            block20: for (int i = 0; i < numcolors; ++i) {
                str = st1.nextToken().replace('{', ' ').strip();
                st2 = new StringTokenizer(str, ",", false);
                switch (st2.countTokens()) {
                    case 1: {
                        this.color[i] = st2.nextToken().strip().toLowerCase();
                        continue block20;
                    }
                    case 3: {
                        this.color[i] = "{" + str + "}";
                        continue block20;
                    }
                    default: {
                        throw new JuggleExceptionUser(errorstrings.getString("Error_color_format"));
                    }
                }
            }
        }
        if ((temp = pl.removeParameter("hss")) != null) {
            this.hss = temp;
        }
        if (this.hss != null) {
            temp = pl.removeParameter("hold");
            if (temp != null) {
                try {
                    this.hold = Boolean.parseBoolean(temp);
                }
                catch (IllegalFormatException ife) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_hss_hold_value_error"));
                }
            }
            if ((temp = pl.removeParameter("dwellmax")) != null) {
                try {
                    this.dwellmax = Boolean.parseBoolean(temp);
                }
                catch (IllegalFormatException ife) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_hss_dwellmax_value_error"));
                }
            }
            if ((temp = pl.removeParameter("handspec")) != null) {
                this.handspec = temp;
            }
        }
        if ((temp = pl.removeParameter("title")) != null) {
            this.title = temp.strip();
        }
        return this;
    }

    @Override
    public String toString() {
        if (this.config == null) {
            return null;
        }
        Object result = "";
        try {
            String[] keys;
            ParameterList pl = new ParameterList(this.config);
            for (String key : keys = new String[]{"pattern", "bps", "dwell", "hands", "body", "gravity", "propdiam", "bouncefrac", "squeezebeats", "prop", "colors", "hss", "hold", "dwellmax", "handspec", "title"}) {
                String value = pl.getParameter(key);
                if (value == null) continue;
                result = (String)result + key + "=" + value + ";";
            }
            if (((String)result).length() > 0) {
                result = ((String)result).substring(0, ((String)result).length() - 1);
            }
        }
        catch (JuggleExceptionUser jeu) {
            ErrorDialog.handleFatalException(new JuggleExceptionInternal(jeu.getMessage()));
        }
        return result;
    }

    protected void buildJugglingMatrix() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.findMasterThrows();
        this.assignPaths();
        this.addThrowSources();
        this.setCatchOrder();
        this.findDwellWindows();
    }

    protected void findMasterThrows() throws JuggleExceptionInternal {
        for (int i = 0; i < this.indexes; ++i) {
            for (int j = 0; j < this.numjugglers; ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int slot = 0; slot < this.max_occupancy; ++slot) {
                        MHNThrow mhnt = this.th[j][h][i][slot];
                        if (mhnt == null) continue;
                        mhnt.master = mhnt;
                        mhnt.source = null;
                    }
                }
            }
        }
        boolean changed = true;
        while (changed) {
            changed = false;
            for (MHNSymmetry sym : this.symmetries()) {
                Permutation jperm = sym.getJugglerPerm();
                int delay = sym.getDelay();
                for (int i = 0; i < this.indexes; ++i) {
                    int imagei = i + delay;
                    if (imagei >= this.indexes) continue;
                    for (int j = 0; j < this.numjugglers; ++j) {
                        for (int h = 0; h < 2; ++h) {
                            for (int slot = 0; slot < this.max_occupancy; ++slot) {
                                MHNThrow mhnt = this.th[j][h][i][slot];
                                if (mhnt == null) continue;
                                int imagej = jperm.getMapping(j + 1);
                                int imageh = imagej > 0 ? h : 1 - h;
                                MHNThrow imaget = this.th[imagej = Math.abs(imagej) - 1][imageh][imagei][slot];
                                if (imaget == null) {
                                    throw new JuggleExceptionInternal("Problem finding master throws");
                                }
                                MHNThrow m = mhnt.master;
                                MHNThrow im = imaget.master;
                                if (m == im) continue;
                                MHNThrow newm = m;
                                if (m.index > im.index) {
                                    newm = im;
                                } else if (m.index == im.index) {
                                    if (m.juggler > im.juggler) {
                                        newm = im;
                                    } else if (m.juggler == im.juggler && m.hand > im.hand) {
                                        newm = im;
                                    }
                                }
                                mhnt.master = imaget.master = newm;
                                changed = true;
                            }
                        }
                    }
                }
            }
        }
    }

    protected void assignPaths() throws JuggleExceptionUser, JuggleExceptionInternal {
        for (int i = 0; i < this.indexes; ++i) {
            for (int j = 0; j < this.numjugglers; ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int slot = 0; slot < this.max_occupancy; ++slot) {
                        int targetslot;
                        MHNThrow sst = this.th[j][h][i][slot];
                        if (sst == null || sst.master != sst) continue;
                        for (targetslot = 0; targetslot < this.max_occupancy; ++targetslot) {
                            boolean itworks = true;
                            for (int i2 = 0; i2 < this.indexes; ++i2) {
                                for (int j2 = 0; j2 < this.numjugglers; ++j2) {
                                    for (int h2 = 0; h2 < 2; ++h2) {
                                        for (int slot2 = 0; slot2 < this.max_occupancy; ++slot2) {
                                            MHNThrow sst2 = this.th[j2][h2][i2][slot2];
                                            if (sst2 == null || sst2.master != sst || sst2.targetindex >= this.indexes) continue;
                                            MHNThrow target = this.th[sst2.targetjuggler - 1][sst2.targethand][sst2.targetindex][targetslot];
                                            if (target == null) {
                                                itworks = false;
                                                continue;
                                            }
                                            itworks &= target.source == null;
                                        }
                                    }
                                }
                            }
                            if (itworks) break;
                        }
                        if (targetslot == this.max_occupancy) {
                            String template = errorstrings.getString("Error_badpattern_landings");
                            String hand = sst.targethand == 0 ? errorstrings.getString("Error_right_hand") : errorstrings.getString("Error_left_hand");
                            Object[] arguments = new Object[]{sst.targetindex + 1, sst.targetjuggler, hand};
                            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                        }
                        for (int i2 = 0; i2 < this.indexes; ++i2) {
                            for (int j2 = 0; j2 < this.numjugglers; ++j2) {
                                for (int h2 = 0; h2 < 2; ++h2) {
                                    for (int slot2 = 0; slot2 < this.max_occupancy; ++slot2) {
                                        MHNThrow sst2 = this.th[j2][h2][i2][slot2];
                                        if (sst2 == null || sst2.master != sst || sst2.targetindex >= this.indexes) continue;
                                        MHNThrow target2 = this.th[sst2.targetjuggler - 1][sst2.targethand][sst2.targetindex][targetslot];
                                        if (target2 == null) {
                                            throw new JuggleExceptionInternal("Got null target in assignPaths()");
                                        }
                                        sst2.target = target2;
                                        target2.source = sst2;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        int currentpath = 1;
        for (int i = 0; i < this.indexes; ++i) {
            for (int j = 0; j < this.numjugglers; ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int slot = 0; slot < this.max_occupancy; ++slot) {
                        MHNThrow sst = this.th[j][h][i][slot];
                        if (sst == null) continue;
                        if (sst.source != null) {
                            sst.pathnum = sst.source.pathnum;
                            continue;
                        }
                        if (currentpath > this.numpaths) {
                            throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern"));
                        }
                        sst.pathnum = currentpath++;
                    }
                }
            }
        }
        if (currentpath <= this.numpaths) {
            throw new JuggleExceptionInternal("Problem assigning path numbers 2");
        }
    }

    protected void addThrowSources() throws JuggleExceptionInternal {
        for (int i = this.indexes - 1; i >= 0; --i) {
            for (int j = 0; j < this.numjugglers; ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int slot = 0; slot < this.max_occupancy; ++slot) {
                        MHNThrow sst = this.th[j][h][i][slot];
                        if (sst == null || sst.source != null) continue;
                        if (i + this.getPeriod() >= this.indexes) {
                            throw new JuggleExceptionInternal("Could not get throw source 2");
                        }
                        MHNThrow sst2 = this.th[j][h][i + this.getPeriod()][slot].source;
                        if (sst2 == null) {
                            throw new JuggleExceptionInternal("Could not get throw source 1");
                        }
                        MHNThrow sst3 = new MHNThrow();
                        sst3.juggler = sst2.juggler;
                        sst3.hand = sst2.hand;
                        sst3.index = sst2.index - this.getPeriod();
                        sst3.slot = sst2.slot;
                        sst3.targetjuggler = j;
                        sst3.targethand = h;
                        sst3.targetindex = i;
                        sst3.targetslot = slot;
                        sst3.handsindex = -1;
                        sst3.pathnum = sst.pathnum;
                        sst3.mod = sst2.mod;
                        sst3.master = sst2.master;
                        sst3.source = null;
                        sst3.target = sst;
                        sst.source = sst3;
                    }
                }
            }
        }
    }

    protected void setCatchOrder() throws JuggleExceptionInternal {
        int h;
        int j;
        int k;
        for (k = 0; k < this.getIndexes(); ++k) {
            for (j = 0; j < this.getNumberOfJugglers(); ++j) {
                for (h = 0; h < 2; ++h) {
                    MHNThrow sst1;
                    MHNThrow sst;
                    int slotcatches = 0;
                    for (int slot = 0; slot < this.getMaxOccupancy() && (sst = this.th[j][h][k][slot]) != null; ++slot) {
                        boolean bl = sst.catching = sst.source.mod.charAt(0) != 'H';
                        if (!sst.catching) continue;
                        sst.catchnum = slotcatches++;
                    }
                    if (slotcatches < 2) continue;
                    for (int slot1 = 0; slot1 < this.getMaxOccupancy() && (sst1 = this.th[j][h][k][slot1]) != null && sst1.master == sst1; ++slot1) {
                        MHNThrow sst2;
                        if (!sst1.catching) continue;
                        for (int slot2 = slot1 + 1; slot2 < this.getMaxOccupancy() && (sst2 = this.th[j][h][k][slot2]) != null && sst2.master == sst2; ++slot2) {
                            if (!sst2.catching) continue;
                            boolean switchcatches = false;
                            switchcatches = sst1.catchnum < sst2.catchnum ? MHNPattern.isCatchOrderIncorrect(sst1, sst2) : MHNPattern.isCatchOrderIncorrect(sst2, sst1);
                            if (!switchcatches) continue;
                            int temp = sst1.catchnum;
                            sst1.catchnum = sst2.catchnum;
                            sst2.catchnum = temp;
                        }
                    }
                }
            }
        }
        for (k = 0; k < this.getIndexes(); ++k) {
            for (j = 0; j < this.getNumberOfJugglers(); ++j) {
                for (h = 0; h < 2; ++h) {
                    MHNThrow sst;
                    for (int slot = 0; slot < this.getMaxOccupancy() && (sst = this.th[j][h][k][slot]) != null && sst.master != sst; ++slot) {
                        sst.catchnum = sst.master.catchnum;
                    }
                }
            }
        }
    }

    protected static boolean isCatchOrderIncorrect(MHNThrow t1, MHNThrow t2) {
        int hdiff2;
        int jdiff2;
        if (t1.source.index > t2.source.index) {
            return true;
        }
        if (t1.source.index < t2.source.index) {
            return false;
        }
        int jdiff1 = Math.abs(t1.juggler - t1.source.juggler);
        if (jdiff1 < (jdiff2 = Math.abs(t2.juggler - t2.source.juggler))) {
            return true;
        }
        if (jdiff1 > jdiff2) {
            return false;
        }
        int hdiff1 = Math.abs(t1.hand - t1.source.hand);
        if (hdiff1 > (hdiff2 = Math.abs(t2.hand - t2.source.hand))) {
            return true;
        }
        if (hdiff1 < hdiff2) {
            return false;
        }
        return false;
    }

    protected void findDwellWindows() {
        for (int k = 0; k < this.getIndexes(); ++k) {
            for (int j = 0; j < this.getNumberOfJugglers(); ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int slot = 0; slot < this.getMaxOccupancy(); ++slot) {
                        MHNThrow sst = this.th[j][h][k][slot];
                        if (sst == null) continue;
                        int index = k - 1;
                        if (index < 0) {
                            index += this.getPeriod();
                        }
                        boolean prev_beat_throw = false;
                        for (int slot2 = 0; slot2 < this.getMaxOccupancy(); ++slot2) {
                            MHNThrow sst2 = this.th[j][h][index][slot2];
                            if (sst2 == null || sst2.isZero()) continue;
                            prev_beat_throw = true;
                        }
                        sst.dwellwindow = prev_beat_throw ? 1 : 2;
                    }
                }
            }
        }
    }

    protected String getInternalRepresentation() {
        StringBuffer sb = new StringBuffer();
        sb.append("numjugglers = " + this.getNumberOfJugglers() + "\n");
        sb.append("numpaths = " + this.getNumberOfPaths() + "\n");
        sb.append("period = " + this.getPeriod() + "\n");
        sb.append("max_occupancy = " + this.getMaxOccupancy() + "\n");
        sb.append("max_throw = " + this.getMaxThrow() + "\n");
        sb.append("indexes = " + this.getIndexes() + "\n");
        sb.append("throws:\n");
        for (int i = 0; i < this.getIndexes(); ++i) {
            for (int j = 0; j < this.numjugglers; ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int s = 0; s < this.getMaxOccupancy(); ++s) {
                        sb.append("  th[" + j + "][" + h + "][" + i + "][" + s + "] = ");
                        MHNThrow mhnt = this.th[j][h][i][s];
                        if (mhnt == null) {
                            sb.append("null\n");
                            continue;
                        }
                        sb.append(mhnt.toString() + "\n");
                    }
                }
            }
        }
        sb.append("symmetries:\n");
        sb.append("hands:\n");
        sb.append("bodies:\n");
        return sb.toString();
    }

    public int[][][] getStartingState(int indexes) {
        int[][][] result = new int[this.getNumberOfJugglers()][2][indexes];
        for (int i = this.getPeriod(); i < this.getIndexes(); ++i) {
            for (int j = 0; j < this.numjugglers; ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int s = 0; s < this.getMaxOccupancy(); ++s) {
                        MHNThrow mhnt = this.th[j][h][i][s];
                        if (mhnt == null || mhnt.source.index >= this.getPeriod() || i - this.getPeriod() >= indexes) continue;
                        int[] nArray = result[j][h];
                        int n = i - this.getPeriod();
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
        }
        return result;
    }

    @Override
    public JMLPattern asJMLPattern() throws JuggleExceptionUser, JuggleExceptionInternal {
        double scale_factor;
        if (this.bps_set <= 0.0) {
            this.bps = this.calcBps();
        }
        BEATS_ONE_THROW_EARLY = Math.max(0.0, this.dwell + 0.3 - 1.0);
        JMLPattern result = new JMLPattern();
        result.setNumberOfJugglers(this.getNumberOfJugglers());
        this.addPropsToJML(result);
        this.addSymmetriesToJML(result);
        this.findCatchThrowTimes();
        boolean[][] handtouched = new boolean[this.getNumberOfJugglers()][2];
        boolean[] pathtouched = new boolean[this.getNumberOfPaths()];
        this.addPrimaryEventsToJML(result, handtouched, pathtouched);
        this.addJugglerPositionsToJML(result);
        this.addEventsForUntouchedHandsToJML(result, handtouched);
        this.addEventsForUntouchedPathsToJML(result, pathtouched);
        result.buildEventList();
        if (this.hands == null) {
            this.addEventsForGapsToJML(result);
        }
        this.addLocationsForIncompleteEventsToJML(result);
        this.addMissingHoldsToJML(result);
        if (this.bps_set <= 0.0 && (scale_factor = result.scaleTimeToFitThrows(1.01)) > 1.0) {
            this.bps /= scale_factor;
            if (this.hands == null) {
                this.addEventsForGapsToJML(result);
                this.addLocationsForIncompleteEventsToJML(result);
                this.addMissingHoldsToJML(result);
            }
        }
        result.setTitle(this.title == null ? this.pattern : this.title);
        return result;
    }

    protected double calcBps() {
        double result = 0.0;
        int numberaveraged = 0;
        for (int k = 0; k < this.getPeriod(); ++k) {
            for (int j = 0; j < this.getNumberOfJugglers(); ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int slot = 0; slot < this.getMaxOccupancy(); ++slot) {
                        int throwval;
                        MHNThrow sst = this.th[j][h][k][slot];
                        if (sst == null || (throwval = sst.targetindex - k) <= 2) continue;
                        result += throwspersec[throwval > 9 ? 9 : throwval];
                        ++numberaveraged;
                    }
                }
            }
        }
        result = numberaveraged > 0 ? (result /= (double)numberaveraged) : 2.0;
        return result;
    }

    protected void addPropsToJML(JMLPattern pat) {
        int balls = this.getNumberOfPaths();
        pat.setNumberOfPaths(balls);
        int props = this.color == null ? Math.min(balls, 1) : Math.min(balls, this.color.length);
        for (int i = 0; i < props; ++i) {
            String mod = null;
            if (this.propdiam != propdiam_default) {
                mod = "diam=" + this.propdiam;
            }
            if (this.color != null) {
                String colorstr = "color=" + this.color[i];
                mod = mod == null ? colorstr : mod + ";" + colorstr;
            }
            pat.addProp(new PropDef(this.getPropName(), mod));
        }
        int[] pa = new int[balls];
        for (int i = 0; i < balls; ++i) {
            pa[i] = 1 + i % props;
        }
        pat.setPropAssignments(pa);
    }

    protected void addSymmetriesToJML(JMLPattern pat) throws JuggleExceptionUser {
        int balls = this.getNumberOfPaths();
        for (MHNSymmetry sss : this.symmetries()) {
            int symtype;
            int[] pathmap = new int[balls + 1];
            switch (sss.getType()) {
                case 1: {
                    symtype = 1;
                    MHNThrow[][][][] th = this.getThrows();
                    for (int k = 0; k < this.getIndexes() - sss.getDelay(); ++k) {
                        for (int j = 0; j < this.getNumberOfJugglers(); ++j) {
                            for (int h = 0; h < 2; ++h) {
                                for (int slot = 0; slot < this.getMaxOccupancy(); ++slot) {
                                    MHNThrow sst = th[j][h][k][slot];
                                    if (sst == null || sst.pathnum == -1) continue;
                                    MHNThrow sst2 = th[j][h][k + sss.getDelay()][slot];
                                    if (sst2 == null) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (sst.pathnum == 0 || sst2.pathnum == 0) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (pathmap[sst.pathnum] == 0) {
                                        pathmap[sst.pathnum] = sst2.pathnum;
                                        continue;
                                    }
                                    if (pathmap[sst.pathnum] == sst2.pathnum) continue;
                                    throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_delay"));
                                }
                            }
                        }
                    }
                    break;
                }
                case 2: {
                    symtype = 2;
                    break;
                }
                case 3: {
                    symtype = 3;
                    Permutation jugperm = sss.getJugglerPerm();
                    MHNThrow[][][][] th = this.getThrows();
                    for (int k = 0; k < this.getIndexes() - sss.getDelay(); ++k) {
                        for (int j = 0; j < this.getNumberOfJugglers(); ++j) {
                            for (int h = 0; h < 2; ++h) {
                                for (int slot = 0; slot < this.getMaxOccupancy(); ++slot) {
                                    int newh;
                                    MHNThrow sst = th[j][h][k][slot];
                                    if (sst == null || sst.pathnum == -1) continue;
                                    int map = jugperm.getMapping(j + 1);
                                    int newj = Math.abs(map) - 1;
                                    MHNThrow sst2 = th[newj][newh = map > 0 ? h : 1 - h][k + sss.getDelay()][slot];
                                    if (sst2 == null) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (sst.pathnum == 0 || sst2.pathnum == 0) {
                                        throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_paths"));
                                    }
                                    if (pathmap[sst.pathnum] == 0) {
                                        pathmap[sst.pathnum] = sst2.pathnum;
                                        continue;
                                    }
                                    if (pathmap[sst.pathnum] == sst2.pathnum) continue;
                                    throw new JuggleExceptionUser(errorstrings.getString("Error_badpattern_switchdelay"));
                                }
                            }
                        }
                    }
                    break;
                }
                default: {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_unknown_symmetry"));
                }
            }
            Object pathmapstring = "";
            for (int j = 1; j < balls; ++j) {
                pathmapstring = (String)pathmapstring + pathmap[j] + ",";
            }
            if (balls > 0) {
                pathmapstring = (String)pathmapstring + pathmap[balls];
            }
            JMLSymmetry sym = new JMLSymmetry(symtype, sss.getNumberOfJugglers(), sss.getJugglerPerm().toString(), this.getNumberOfPaths(), (String)pathmapstring, (double)sss.getDelay() / this.bps);
            pat.addSymmetry(sym);
        }
    }

    public void findCatchThrowTimes() {
        for (int k = 0; k < this.getPeriod(); ++k) {
            for (int j = 0; j < this.getNumberOfJugglers(); ++j) {
                for (int h = 0; h < 2; ++h) {
                    MHNThrow sst2;
                    int tempindex;
                    MHNThrow sst22;
                    MHNThrow sst23;
                    int slot;
                    MHNThrow sst = this.th[j][h][k][0];
                    if (sst == null) continue;
                    boolean onethrown = false;
                    for (slot = 0; slot < this.getMaxOccupancy(); ++slot) {
                        sst23 = this.th[j][h][k][slot];
                        if (sst23 == null || !sst23.isThrownOne()) continue;
                        onethrown = true;
                    }
                    for (slot = 0; slot < this.getMaxOccupancy() && (sst23 = this.th[j][h][k][slot]) != null; ++slot) {
                        sst23.throwtime = onethrown ? ((double)k - BEATS_ONE_THROW_EARLY) / this.bps : (double)k / this.bps;
                        if (this.hss == null) continue;
                        sst23.throwtime = (double)k / this.bps;
                    }
                    int num_catches = 0;
                    boolean onecaught = false;
                    for (int slot2 = 0; slot2 < this.getMaxOccupancy() && (sst22 = this.th[j][h][k][slot2]) != null; ++slot2) {
                        if (!sst22.catching) continue;
                        ++num_catches;
                        if (!sst22.source.isThrownOne()) continue;
                        onecaught = true;
                    }
                    boolean prev_onethrown = false;
                    for (tempindex = k - sst.dwellwindow; tempindex < 0; tempindex += this.getPeriod()) {
                    }
                    for (int slot3 = 0; slot3 < this.getMaxOccupancy(); ++slot3) {
                        MHNThrow sst24 = this.th[j][h][tempindex][slot3];
                        if (sst24 == null || !sst24.isThrownOne()) continue;
                        prev_onethrown = true;
                    }
                    double firstcatchtime = ((double)k - this.dwell) / this.bps;
                    firstcatchtime = Math.max(firstcatchtime, ((double)(k - sst.dwellwindow) - (prev_onethrown ? BEATS_ONE_THROW_EARLY : 0.0) + 0.3) / this.bps);
                    if (onecaught) {
                        firstcatchtime = Math.max(firstcatchtime, ((double)(k - 1) - BEATS_ONE_THROW_EARLY + 0.3) / this.bps);
                    }
                    firstcatchtime = Math.min(firstcatchtime, sst.throwtime - 0.02 / this.bps);
                    for (int slot4 = 0; slot4 < this.getMaxOccupancy() && (sst2 = this.th[j][h][k][slot4]) != null; ++slot4) {
                        double catchtime = firstcatchtime;
                        if (num_catches > 1) {
                            catchtime += (double)sst2.catchnum / (double)(num_catches - 1) * (this.squeezebeats / this.bps);
                        }
                        if (this.hss != null) {
                            int newk = k % this.dwellarray.length;
                            catchtime = ((double)k - this.dwellarray[newk]) / this.bps;
                            if (num_catches > 1) {
                                catchtime += (double)sst2.catchnum / (double)(num_catches - 1) * this.squeezebeats / this.bps;
                            }
                        }
                        sst2.catchtime = catchtime = Math.min(catchtime, sst.throwtime - 0.02 / this.bps);
                    }
                }
            }
        }
    }

    protected void addPrimaryEventsToJML(JMLPattern pat, boolean[][] handtouched, boolean[] pathtouched) throws JuggleExceptionUser, JuggleExceptionInternal {
        int j;
        for (j = 0; j < this.getNumberOfJugglers(); ++j) {
            for (int h = 0; h < 2; ++h) {
                handtouched[j][h] = false;
            }
        }
        for (j = 0; j < this.getNumberOfPaths(); ++j) {
            pathtouched[j] = false;
        }
        for (int k = 0; k < this.getPeriod(); ++k) {
            for (int j2 = 0; j2 < this.getNumberOfJugglers(); ++j2) {
                for (int h = 0; h < 2; ++h) {
                    Coordinate c;
                    int pos;
                    MHNThrow sst2;
                    MHNThrow sst = this.th[j2][h][k][0];
                    if (sst == null || sst.master != sst) continue;
                    JMLEvent ev = new JMLEvent();
                    double throwxsum = 0.0;
                    int num_throws = 0;
                    for (int slot = 0; slot < this.getMaxOccupancy() && (sst2 = this.th[j2][h][k][slot]) != null; ++slot) {
                        String type = null;
                        Object mod = null;
                        switch (sst2.mod.charAt(0)) {
                            case 'B': {
                                type = "bounce";
                                mod = null;
                                if (sst2.mod.indexOf("F") != -1) {
                                    mod = "forced=true";
                                }
                                if (sst2.mod.indexOf("H") != -1) {
                                    mod = mod == null ? "hyper=true" : (String)mod + ";hyper=true";
                                }
                                int bounces = 1;
                                for (int i = 1; i < sst2.mod.length(); ++i) {
                                    if (sst2.mod.charAt(i) != 'B') continue;
                                    ++bounces;
                                }
                                if (bounces > 1) {
                                    mod = mod == null ? "bounces=" + bounces : (String)mod + ";bounces=" + bounces;
                                }
                                if (this.bouncefrac != bouncefrac_default) {
                                    mod = mod == null ? "bouncefrac=" + this.bouncefrac : (String)mod + ";bouncefrac=" + this.bouncefrac;
                                }
                                if (this.gravity == gravity_default) break;
                                if (mod == null) {
                                    mod = "g=" + this.gravity;
                                    break;
                                }
                                mod = (String)mod + ";g=" + this.gravity;
                                break;
                            }
                            case 'F': {
                                type = "bounce";
                                mod = "forced=true";
                                if (this.bouncefrac != bouncefrac_default) {
                                    mod = (String)mod + ";bouncefrac=" + this.bouncefrac;
                                }
                                if (this.gravity == gravity_default) break;
                                mod = (String)mod + ";g=" + this.gravity;
                                break;
                            }
                            case 'H': {
                                type = "hold";
                                mod = null;
                                break;
                            }
                            default: {
                                type = "toss";
                                mod = null;
                                if (this.gravity == gravity_default) break;
                                mod = "g=" + this.gravity;
                            }
                        }
                        if (sst2.mod.charAt(0) != 'H') {
                            if (sst2.isZero()) {
                                String template = errorstrings.getString("Error_modifier_on_0");
                                Object[] arguments = new Object[]{sst2.mod, k + 1};
                                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                            }
                            ev.addTransition(new JMLTransition(1, sst2.pathnum, type, (String)mod));
                            int throwval = sst2.targetindex - k;
                            throwxsum = sst2.targethand == h ? (throwxsum += throwval > 8 ? samethrowx[8] : samethrowx[throwval]) : (throwxsum += throwval > 8 ? crossingthrowx[8] : crossingthrowx[throwval]);
                            ++num_throws;
                            continue;
                        }
                        if (this.hands == null || sst2.isZero()) continue;
                        ev.addTransition(new JMLTransition(5, sst2.pathnum, type, (String)mod));
                        pathtouched[sst2.pathnum - 1] = true;
                    }
                    if (this.hands != null || num_throws != 0) {
                        if (this.hands == null) {
                            if (num_throws > 0) {
                                double throwxav = throwxsum / (double)num_throws;
                                if (h == 1) {
                                    throwxav = -throwxav;
                                }
                                ev.setLocalCoordinate(new Coordinate(throwxav, 0.0, 0.0));
                                ev.calcpos = false;
                            } else {
                                ev.calcpos = true;
                            }
                        } else {
                            Coordinate c2 = this.hands.getCoordinate(sst.juggler, sst.handsindex, 0);
                            if (h == 1) {
                                c2.x = -c2.x;
                            }
                            ev.setLocalCoordinate(c2);
                            ev.calcpos = false;
                        }
                        ev.setT(sst.throwtime);
                        ev.setHand(j2 + 1, h == 0 ? 2 : 1);
                        pat.addEvent(ev);
                        for (int i2 = 0; i2 < this.getIndexes(); ++i2) {
                            for (int j22 = 0; j22 < this.getNumberOfJugglers(); ++j22) {
                                for (int h2 = 0; h2 < 2; ++h2) {
                                    for (int slot2 = 0; slot2 < this.getMaxOccupancy(); ++slot2) {
                                        MHNThrow sst22 = this.th[j22][h2][i2][slot2];
                                        if (sst22 == null || sst22.master != sst) continue;
                                        handtouched[j22][h2] = true;
                                    }
                                }
                            }
                        }
                    }
                    double catchxsum = 0.0;
                    int num_catches = 0;
                    for (int slot = 0; slot < this.getMaxOccupancy(); ++slot) {
                        MHNThrow sst23 = this.th[j2][h][k][slot];
                        if (sst23 == null || !sst23.catching) continue;
                        int catchpath = sst23.pathnum;
                        int catchval = k - sst23.source.index;
                        pathtouched[catchpath - 1] = true;
                        catchxsum += catchval > 8 ? catchx[8] : catchx[catchval];
                        ++num_catches;
                    }
                    if (this.hands == null && num_catches == 0) continue;
                    double lastcatchtime = 0.0;
                    if (this.squeezebeats == 0.0 || num_catches < 2) {
                        MHNThrow sst24;
                        ev = new JMLEvent();
                        if (this.hands == null) {
                            if (num_catches > 0) {
                                double cx = catchxsum / (double)num_catches;
                                ev.setLocalCoordinate(new Coordinate(h == 0 ? cx : -cx, 0.0, 0.0));
                                ev.calcpos = false;
                            } else {
                                ev.calcpos = true;
                            }
                        } else {
                            for (pos = sst.handsindex - 2; pos < 0; pos += this.hands.getPeriod(sst.juggler)) {
                            }
                            int index = this.hands.getCatchIndex(sst.juggler, pos);
                            Coordinate c3 = this.hands.getCoordinate(sst.juggler, pos, index);
                            if (h == 1) {
                                c3.x = -c3.x;
                            }
                            ev.setLocalCoordinate(c3);
                            ev.calcpos = false;
                        }
                        ev.setT(sst.catchtime);
                        lastcatchtime = sst.catchtime;
                        ev.setHand(j2 + 1, h == 0 ? 2 : 1);
                        for (slot = 0; slot < this.getMaxOccupancy() && (sst24 = this.th[j2][h][k][slot]) != null; ++slot) {
                            if (sst24.catching) {
                                ev.addTransition(new JMLTransition(2, sst24.pathnum, null, null));
                                continue;
                            }
                            if (this.hands == null || sst24.pathnum == -1) continue;
                            ev.addTransition(new JMLTransition(5, sst24.pathnum, null, null));
                            pathtouched[sst24.pathnum - 1] = true;
                        }
                        pat.addEvent(ev);
                    } else {
                        for (slot = 0; slot < this.getMaxOccupancy(); ++slot) {
                            MHNThrow sst25 = this.th[j2][h][k][slot];
                            if (sst25 == null || !sst25.catching) continue;
                            ev = new JMLEvent();
                            if (this.hands == null) {
                                double cx = catchxsum / (double)num_catches;
                                ev.setLocalCoordinate(new Coordinate(h == 0 ? cx : -cx, 0.0, 0.0));
                            } else {
                                int pos2;
                                for (pos2 = sst.handsindex - 2; pos2 < 0; pos2 += this.hands.getPeriod(sst.juggler)) {
                                }
                                int index = this.hands.getCatchIndex(sst.juggler, pos2);
                                c = this.hands.getCoordinate(sst.juggler, pos2, index);
                                if (h == 1) {
                                    c.x = -c.x;
                                }
                                ev.setLocalCoordinate(c);
                            }
                            ev.calcpos = false;
                            ev.setT(sst25.catchtime);
                            if (sst25.catchnum == num_catches - 1) {
                                lastcatchtime = sst25.catchtime;
                            }
                            ev.setHand(j2 + 1, h == 0 ? 2 : 1);
                            ev.addTransition(new JMLTransition(2, sst25.pathnum, null, null));
                            pat.addEvent(ev);
                        }
                    }
                    if (this.hands == null) continue;
                    for (pos = sst.handsindex - 2; pos < 0; pos += this.hands.getPeriod(sst.juggler)) {
                    }
                    int catchindex = this.hands.getCatchIndex(sst.juggler, pos);
                    int numcoords = this.hands.getNumberOfCoordinates(sst.juggler, pos) - catchindex;
                    for (int di = 1; di < numcoords; ++di) {
                        c = this.hands.getCoordinate(sst.juggler, pos, catchindex + di);
                        if (c == null) continue;
                        ev = new JMLEvent();
                        if (h == 1) {
                            c.x = -c.x;
                        }
                        ev.setLocalCoordinate(c);
                        ev.calcpos = false;
                        ev.setT(lastcatchtime + (double)di * (sst.throwtime - lastcatchtime) / (double)numcoords);
                        ev.setHand(sst.juggler, h == 0 ? 2 : 1);
                        pat.addEvent(ev);
                    }
                    double nextcatchtime = lastcatchtime;
                    int k2 = k + 1;
                    while (nextcatchtime == lastcatchtime) {
                        MHNThrow tempsst;
                        int tempk = k2;
                        int wrap = 0;
                        while (tempk >= this.getIndexes()) {
                            tempk -= this.getIndexes();
                            ++wrap;
                        }
                        if (wrap > 1) {
                            throw new JuggleExceptionInternal("Couldn't find next catch/hold past t=" + lastcatchtime);
                        }
                        for (int tempslot = 0; tempslot < this.getMaxOccupancy() && (tempsst = this.th[j2][h][tempk][tempslot]) != null; ++tempslot) {
                            double catcht = tempsst.catchtime + (double)(wrap * this.getIndexes()) / this.bps;
                            nextcatchtime = tempslot == 0 ? catcht : Math.min(nextcatchtime, catcht);
                        }
                        ++k2;
                    }
                    pos = sst.handsindex;
                    numcoords = this.hands.getCatchIndex(sst.juggler, pos);
                    for (int di = 1; di < numcoords; ++di) {
                        Coordinate c4 = this.hands.getCoordinate(sst.juggler, pos, di);
                        if (c4 == null) continue;
                        ev = new JMLEvent();
                        if (h == 1) {
                            c4.x = -c4.x;
                        }
                        ev.setLocalCoordinate(c4);
                        ev.calcpos = false;
                        ev.setT(sst.throwtime + (double)di * (nextcatchtime - sst.throwtime) / (double)numcoords);
                        ev.setHand(sst.juggler, h == 0 ? 2 : 1);
                        pat.addEvent(ev);
                    }
                }
            }
        }
    }

    protected void addJugglerPositionsToJML(JMLPattern pat) {
        if (this.bodies == null) {
            return;
        }
        for (int k = 0; k < this.getPeriod(); ++k) {
            for (int j = 0; j < this.getNumberOfJugglers(); ++j) {
                int index = k % this.bodies.getPeriod(j + 1);
                int coords = this.bodies.getNumberOfPositions(j + 1, index);
                for (int z = 0; z < coords; ++z) {
                    JMLPosition jmlp = this.bodies.getPosition(j + 1, index, z);
                    if (jmlp == null) continue;
                    jmlp.setT(((double)k + (double)z / (double)coords) / this.bps);
                    pat.addPosition(jmlp);
                }
            }
        }
    }

    protected void addEventsForUntouchedHandsToJML(JMLPattern pat, boolean[][] handtouched) {
        for (int j = 0; j < this.getNumberOfJugglers(); ++j) {
            for (int h = 0; h < 2; ++h) {
                if (handtouched[j][h]) continue;
                JMLEvent ev = new JMLEvent();
                ev.setLocalCoordinate(new Coordinate(h == 0 ? 25.0 : -25.0, 0.0, 0.0));
                ev.setT(-1.0);
                ev.setHand(j + 1, h == 0 ? 2 : 1);
                ev.calcpos = false;
                pat.addEvent(ev);
            }
        }
    }

    protected void addEventsForUntouchedPathsToJML(JMLPattern pat, boolean[] pathtouched) {
        for (JMLSymmetry sym : pat.symmetries()) {
            Permutation perm = sym.getPathPerm();
            for (int k = 0; k < this.getNumberOfPaths(); ++k) {
                if (!pathtouched[k]) continue;
                for (int l = 1; l < perm.getOrder(k + 1); ++l) {
                    pathtouched[perm.getMapping((int)(k + 1), (int)l) - 1] = true;
                }
            }
        }
        for (int k = 0; k < this.getNumberOfPaths(); ++k) {
            if (pathtouched[k]) continue;
            int hand = 1;
            int juggler = 0;
            block4: for (int tempk = 0; tempk < this.getIndexes(); ++tempk) {
                for (int tempj = 0; tempj < this.getNumberOfJugglers(); ++tempj) {
                    for (int temph = 0; temph < 2; ++temph) {
                        for (int slot = 0; slot < this.getMaxOccupancy(); ++slot) {
                            MHNThrow sst = this.th[tempj][temph][tempk][slot];
                            if (sst == null || sst.pathnum != k + 1) continue;
                            hand = temph == 0 ? 2 : 1;
                            juggler = tempj;
                            break block4;
                        }
                    }
                }
            }
            for (JMLEvent ev = pat.getEventList(); ev != null; ev = ev.getNext()) {
                if (ev.getHand() != hand || ev.getJuggler() != juggler + 1) continue;
                ev.addTransition(new JMLTransition(5, k + 1, null, null));
                pathtouched[k] = true;
                for (JMLSymmetry sym : pat.symmetries()) {
                    Permutation perm = sym.getPathPerm();
                    for (int l = 1; l < perm.getOrder(k + 1); ++l) {
                        pathtouched[perm.getMapping((int)(k + 1), (int)l) - 1] = true;
                    }
                }
            }
        }
    }

    protected void addEventsForGapsToJML(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        for (int h = 0; h < 2; ++h) {
            int hand;
            int n = hand = h == 0 ? 2 : 1;
            if (h == 1) {
                pat.buildEventList();
            }
            for (int j = 1; j <= this.getNumberOfJugglers(); ++j) {
                JMLEvent start = null;
                for (JMLEvent ev = pat.getEventList(); ev != null; ev = ev.getNext()) {
                    double gap;
                    if (ev.getJuggler() != j || ev.getHand() != hand) continue;
                    if (start != null && (gap = ev.getT() - start.getT()) > 0.5) {
                        int add = (int)(gap / 0.5);
                        double deltat = gap / (double)(add + 1);
                        for (int i = 1; i <= add; ++i) {
                            double evtime = start.getT() + (double)i * deltat;
                            if (evtime < pat.getLoopStartTime() || evtime >= pat.getLoopEndTime()) continue;
                            JMLEvent ev2 = new JMLEvent();
                            ev2.setT(evtime);
                            ev2.setHand(j, hand);
                            ev2.calcpos = true;
                            pat.addEvent(ev2);
                        }
                    }
                    start = ev;
                }
            }
        }
    }

    protected void addLocationsForIncompleteEventsToJML(JMLPattern pat) {
        for (int j = 1; j <= this.getNumberOfJugglers(); ++j) {
            for (int h = 0; h < 2; ++h) {
                JMLEvent ev;
                int hand = h == 0 ? 2 : 1;
                JMLEvent start = null;
                int scanstate = 1;
                for (ev = pat.getEventList(); ev != null; ev = ev.getNext()) {
                    if (ev.getJuggler() != j || ev.getHand() != hand) continue;
                    if (ev.calcpos) {
                        scanstate = 3;
                        continue;
                    }
                    switch (scanstate) {
                        case 1: {
                            scanstate = 2;
                            break;
                        }
                        case 2: {
                            break;
                        }
                        case 3: {
                            if (start != null) {
                                JMLEvent end = ev;
                                double t_end = end.getT();
                                Coordinate pos_end = end.getLocalCoordinate();
                                double t_start = start.getT();
                                Coordinate pos_start = start.getLocalCoordinate();
                                for (ev = start.getNext(); ev != end; ev = ev.getNext()) {
                                    if (ev.getJuggler() != j || ev.getHand() != hand) continue;
                                    double t = ev.getT();
                                    double x = pos_start.x + (t - t_start) * (pos_end.x - pos_start.x) / (t_end - t_start);
                                    double y = pos_start.y + (t - t_start) * (pos_end.y - pos_start.y) / (t_end - t_start);
                                    double z = pos_start.z + (t - t_start) * (pos_end.z - pos_start.z) / (t_end - t_start);
                                    ev.setLocalCoordinate(new Coordinate(x, y, z));
                                    ev.calcpos = false;
                                }
                            }
                            scanstate = 2;
                        }
                    }
                    start = ev;
                }
                for (ev = pat.getEventList(); ev != null; ev = ev.getNext()) {
                    if (ev.getJuggler() != j || ev.getHand() != hand || !ev.calcpos) continue;
                    ev.setLocalCoordinate(new Coordinate(h == 0 ? 25.0 : -25.0, 0.0, 0.0));
                    ev.calcpos = false;
                }
            }
        }
    }

    protected void addMissingHoldsToJML(JMLPattern pat) {
        for (int k = 0; k < this.getNumberOfPaths(); ++k) {
            boolean add_mode = false;
            boolean found_event = false;
            int add_juggler = 0;
            int add_hand = 0;
            JMLEvent ev = pat.getEventList();
            block6: while (ev != null) {
                JMLTransition tr = ev.getPathTransition(k + 1, 6);
                if (tr != null) {
                    switch (tr.getType()) {
                        case 1: {
                            if (!found_event && !add_mode) {
                                add_mode = true;
                                add_juggler = ev.getJuggler();
                                add_hand = ev.getHand();
                                ev = pat.getEventList();
                                continue block6;
                            }
                            add_mode = false;
                            break;
                        }
                        case 2: 
                        case 3: 
                        case 4: {
                            add_mode = true;
                            add_juggler = ev.getJuggler();
                            add_hand = ev.getHand();
                            break;
                        }
                        case 5: {
                            if (!found_event && !add_mode) {
                                add_mode = true;
                                add_juggler = ev.getJuggler();
                                add_hand = ev.getHand();
                                ev = pat.getEventList();
                                continue block6;
                            }
                            add_mode = true;
                            add_juggler = ev.getJuggler();
                            add_hand = ev.getHand();
                        }
                    }
                    found_event = true;
                } else if (add_mode && ev.getJuggler() == add_juggler && ev.getHand() == add_hand && ev.isMaster()) {
                    ev.addTransition(new JMLTransition(5, k + 1, null, null));
                }
                ev = ev.getNext();
            }
        }
    }
}

