/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

public class MHNThrow {
    public int juggler;
    public int hand;
    public int index;
    public int slot;
    public int targetjuggler;
    public int targethand;
    public int targetindex;
    public int targetslot;
    public String mod;
    public MHNThrow master;
    public MHNThrow source;
    public MHNThrow target;
    public int pathnum = -1;
    public boolean catching = false;
    public int catchnum = -1;
    public int dwellwindow;
    public double throwtime;
    public double catchtime;
    public int handsindex;

    public MHNThrow() {
    }

    public MHNThrow(int j, int h, int i, int s, int tj, int th, int ti, int ts, String m) {
        this.juggler = j;
        this.hand = h;
        this.index = i;
        this.slot = s;
        this.targetjuggler = tj;
        this.targethand = th;
        this.targetindex = ti;
        this.targetslot = ts;
        this.mod = m;
    }

    public String toString() {
        String s = "(" + this.juggler + ", " + this.hand + ", " + this.index + ", " + this.slot;
        s = s + " -> " + this.targetjuggler + ", " + this.targethand + ", " + this.targetindex + ", " + this.targetslot + ")";
        if (this.master == this) {
            s = s + "*";
        }
        return s;
    }

    public boolean isHold() {
        if (this.targetindex - this.index > 2 || this.hand != this.targethand || this.juggler != this.targetjuggler) {
            return false;
        }
        return this.mod == null || this.mod.indexOf(84) == -1;
    }

    public boolean isZero() {
        return this.throwValue() == 0;
    }

    public int throwValue() {
        return this.targetindex - this.index;
    }

    public boolean isThrownOne() {
        return this.mod != null && this.mod.charAt(0) != 'H' && this.throwValue() == 1;
    }

    public static int compareThrows(MHNThrow mhnt1, MHNThrow mhnt2) {
        boolean has_mod2;
        int beats1 = mhnt1.targetindex - mhnt1.index;
        int beats2 = mhnt2.targetindex - mhnt2.index;
        if (beats1 > beats2) {
            return 1;
        }
        if (beats1 < beats2) {
            return -1;
        }
        boolean is_pass1 = mhnt1.targetjuggler != mhnt1.juggler;
        boolean is_pass2 = mhnt2.targetjuggler != mhnt2.juggler;
        boolean is_cross1 = mhnt1.targethand == mhnt1.hand ^ beats1 % 2 == 0;
        boolean is_cross2 = mhnt2.targethand == mhnt2.hand ^ beats2 % 2 == 0;
        if (is_pass1 && !is_pass2) {
            return 1;
        }
        if (!is_pass1 && is_pass2) {
            return -1;
        }
        if (is_pass1) {
            if (mhnt1.targetjuggler < mhnt2.targetjuggler) {
                return 1;
            }
            if (mhnt1.targetjuggler > mhnt2.targetjuggler) {
                return -1;
            }
        }
        if (is_cross1 && !is_cross2) {
            return 1;
        }
        if (!is_cross1 && is_cross2) {
            return -1;
        }
        boolean has_mod1 = mhnt1.mod != null;
        boolean bl = has_mod2 = mhnt2.mod != null;
        if (has_mod1 && !has_mod2) {
            return 1;
        }
        if (!has_mod1 && has_mod2) {
            return -1;
        }
        if (has_mod1 && has_mod2) {
            int c = mhnt1.mod.compareTo(mhnt2.mod);
            if (c < 0) {
                return 1;
            }
            if (c > 0) {
                return -1;
            }
        }
        return 0;
    }
}

