/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.notation;

import java.text.MessageFormat;
import java.util.ArrayList;
import jugglinglab.notation.HSS;
import jugglinglab.notation.MHNPattern;
import jugglinglab.notation.MHNSymmetry;
import jugglinglab.notation.MHNThrow;
import jugglinglab.notation.ModParms;
import jugglinglab.notation.ssparser.ParseException;
import jugglinglab.notation.ssparser.SiteswapParser;
import jugglinglab.notation.ssparser.SiteswapTreeItem;
import jugglinglab.notation.ssparser.TokenMgrError;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;
import jugglinglab.util.Permutation;

public class SiteswapPattern
extends MHNPattern {
    protected boolean oddperiod = false;
    protected boolean has_hands_specifier = false;
    boolean[] right_on_even;

    @Override
    public String getNotationName() {
        return "Siteswap";
    }

    @Override
    public SiteswapPattern fromString(String conf) throws JuggleExceptionUser, JuggleExceptionInternal {
        if (((String)conf).indexOf(61) == -1) {
            conf = "pattern=" + (String)conf;
        }
        ParameterList pl = new ParameterList((String)conf);
        this.fromParameters(pl);
        pl.errorIfParametersLeft();
        return this;
    }

    @Override
    public SiteswapPattern fromParameters(ParameterList pl) throws JuggleExceptionUser, JuggleExceptionInternal {
        super.fromParameters(pl);
        if (this.hss != null) {
            ModParms modinfo = HSS.processHSS(this.pattern, this.hss, this.hold, this.dwellmax, this.handspec, this.dwell);
            this.pattern = modinfo.convertedPattern;
            this.dwellarray = modinfo.dwellBeatsArray;
        }
        this.parseSiteswapNotation();
        if (this.hands != null || this.bodies != null) {
            int patperiod = this.getNorepPeriod();
            int handperiod = 1;
            if (this.hands != null) {
                for (int i = 1; i <= this.getNumberOfJugglers(); ++i) {
                    handperiod = Permutation.lcm(handperiod, this.hands.getPeriod(i));
                }
            }
            int bodyperiod = 1;
            if (this.bodies != null) {
                for (int i = 1; i <= this.getNumberOfJugglers(); ++i) {
                    bodyperiod = Permutation.lcm(bodyperiod, this.bodies.getPeriod(i));
                }
            }
            int totalperiod = patperiod;
            totalperiod = Permutation.lcm(totalperiod, handperiod);
            if ((totalperiod = Permutation.lcm(totalperiod, bodyperiod)) != patperiod) {
                int repeats = totalperiod / patperiod;
                this.pattern = "(" + this.pattern + "^" + repeats + ")";
                this.parseSiteswapNotation();
            }
        }
        super.buildJugglingMatrix();
        return this;
    }

    public boolean hasHandsSpecifier() {
        return this.has_hands_specifier;
    }

    protected int getNorepPeriod() {
        return this.oddperiod ? this.getPeriod() / 2 : this.getPeriod();
    }

    protected void parseSiteswapNotation() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.th = null;
        this.symmetry = new ArrayList();
        SiteswapTreeItem tree = null;
        try {
            tree = SiteswapParser.parsePattern(this.pattern);
        }
        catch (ParseException pe) {
            if (pe.currentToken == null) {
                String template = errorstrings.getString("Error_pattern_parsing");
                Object[] arguments = new Object[]{pe.getMessage()};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
            String template = errorstrings.getString("Error_pattern_syntax");
            String problem = ParseException.add_escapes(pe.currentToken.next.image);
            Object[] arguments = new Object[]{problem, pe.currentToken.next.beginColumn};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        catch (TokenMgrError tme) {
            String template = errorstrings.getString("Error_pattern_syntax");
            String problem = TokenMgrError.addEscapes(String.valueOf(tme.curChar));
            Object[] arguments = new Object[]{problem, tme.errorColumn - 1};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        this.numjugglers = tree.jugglers;
        this.max_occupancy = 0;
        this.max_throw = 0;
        this.right_on_even = new boolean[this.numjugglers];
        for (int i = 0; i < this.numjugglers; ++i) {
            this.right_on_even[i] = true;
        }
        tree.beatnum = 0;
        this.doFirstPass(tree);
        if (!tree.switchrepeat && tree.vanilla_async && tree.beats % 2 == 1) {
            tree.switchrepeat = true;
            tree.beats *= 2;
            tree.throw_sum *= 2;
            this.oddperiod = true;
        }
        this.period = tree.beats;
        if (tree.throw_sum % tree.beats != 0) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_siteswap_bad_average"));
        }
        this.numpaths = tree.throw_sum / tree.beats;
        this.indexes = this.max_throw + this.period + 1;
        this.th = new MHNThrow[this.numjugglers][2][this.indexes][this.max_occupancy];
        this.doSecondPass(tree, false, 0);
        this.resolveModifiers();
        this.addSymmetry(new MHNSymmetry(1, this.numjugglers, null, this.period));
        if (tree.switchrepeat) {
            StringBuffer sb = new StringBuffer();
            for (int i = 1; i <= this.numjugglers; ++i) {
                sb.append("(" + i + "," + i + "*)");
            }
            this.addSymmetry(new MHNSymmetry(3, this.numjugglers, sb.toString(), this.period / 2));
        }
        if (this.bodies != null && this.bodies.getNumberOfJugglers() < this.getNumberOfJugglers()) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_jugglers_body"));
        }
    }

    protected void doFirstPass(SiteswapTreeItem sti) throws JuggleExceptionUser, JuggleExceptionInternal {
        SiteswapTreeItem child = null;
        sti.throw_sum = 0;
        sti.vanilla_async = true;
        switch (sti.type) {
            case 1: {
                sti.beats = 0;
                for (int i = 0; i < sti.getNumberOfChildren(); ++i) {
                    child = sti.getChild(i);
                    child.beatnum = sti.beatnum + sti.beats;
                    this.doFirstPass(child);
                    sti.beats += child.beats;
                    sti.throw_sum += child.throw_sum;
                    sti.vanilla_async &= child.vanilla_async;
                }
                if (!sti.switchrepeat) break;
                sti.beats *= 2;
                sti.throw_sum *= 2;
                break;
            }
            case 2: {
                child = sti.getChild(0);
                if (sti.getNumberOfChildren() > 1) {
                    sti.removeChildren();
                    sti.addChild(child);
                }
                child.beatnum = sti.beatnum;
                this.doFirstPass(child);
                for (int i = 1; i < sti.repeats; ++i) {
                    SiteswapTreeItem child2 = (SiteswapTreeItem)child.clone();
                    sti.addChild(child2);
                    child2.beatnum = sti.beatnum + i * child.beats;
                    this.doFirstPass(child2);
                }
                sti.beats = child.beats * sti.repeats;
                sti.throw_sum = child.throw_sum * sti.repeats;
                sti.vanilla_async &= child.vanilla_async;
                break;
            }
            case 3: {
                for (int i = 0; i < sti.getNumberOfChildren(); ++i) {
                    child = sti.getChild(i);
                    child.beatnum = sti.beatnum + child.seq_beatnum;
                    this.doFirstPass(child);
                    sti.throw_sum += child.throw_sum;
                    sti.vanilla_async &= child.vanilla_async;
                }
                break;
            }
            case 4: {
                for (int i = 0; i < sti.getNumberOfChildren(); ++i) {
                    child = sti.getChild(i);
                    child.beatnum = sti.beatnum;
                    this.doFirstPass(child);
                    child.left = i == 0;
                    child.sync_throw = true;
                    sti.throw_sum += child.throw_sum;
                }
                sti.vanilla_async = false;
                break;
            }
            case 5: {
                for (int i = 0; i < sti.getNumberOfChildren(); ++i) {
                    child = sti.getChild(i);
                    child.beatnum = sti.beatnum;
                    this.doFirstPass(child);
                    sti.throw_sum += child.value;
                    sti.vanilla_async &= child.vanilla_async;
                }
                sti.left = sti.beatnum % 2 == 0 ? !this.right_on_even[sti.source_juggler - 1] : this.right_on_even[sti.source_juggler - 1];
                if (sti.getNumberOfChildren() <= this.max_occupancy) break;
                this.max_occupancy = sti.getNumberOfChildren();
                break;
            }
            case 6: {
                if (sti.value > this.max_throw) {
                    this.max_throw = sti.value;
                }
                sti.vanilla_async = !sti.x;
                break;
            }
            case 7: 
            case 8: {
                for (int i = 0; i < sti.getNumberOfChildren(); ++i) {
                    child = sti.getChild(i);
                    child.beatnum = sti.beatnum;
                    this.doFirstPass(child);
                    sti.throw_sum += child.throw_sum;
                    sti.vanilla_async &= child.vanilla_async;
                }
                break;
            }
            case 9: {
                for (int i = 0; i < sti.getNumberOfChildren(); ++i) {
                    child = sti.getChild(i);
                    child.beatnum = sti.beatnum + child.seq_beatnum;
                    this.doFirstPass(child);
                    sti.throw_sum += child.throw_sum;
                    sti.vanilla_async &= child.vanilla_async;
                }
                break;
            }
            case 10: {
                for (int i = 0; i < sti.getNumberOfChildren(); ++i) {
                    child = sti.getChild(i);
                    child.beatnum = sti.beatnum;
                    this.doFirstPass(child);
                    child.left = i == 0;
                    child.sync_throw = true;
                    sti.throw_sum += child.throw_sum;
                }
                sti.vanilla_async = false;
                break;
            }
            case 11: {
                for (int i = 0; i < sti.getNumberOfChildren(); ++i) {
                    child = sti.getChild(i);
                    child.beatnum = sti.beatnum;
                    this.doFirstPass(child);
                    sti.throw_sum += child.value;
                    sti.vanilla_async &= child.vanilla_async;
                }
                sti.left = sti.beatnum % 2 == 0 ? !this.right_on_even[sti.source_juggler - 1] : this.right_on_even[sti.source_juggler - 1];
                if (sti.getNumberOfChildren() <= this.max_occupancy) break;
                this.max_occupancy = sti.getNumberOfChildren();
                break;
            }
            case 12: {
                if (sti.value > this.max_throw) {
                    this.max_throw = sti.value;
                }
                sti.vanilla_async = !sti.x;
                break;
            }
            case 13: {
                if (sti.transition != null) {
                    sti.transition.beatnum = sti.beatnum;
                    this.doFirstPass(sti.transition);
                    sti.throw_sum = sti.transition.throw_sum;
                    sti.vanilla_async = sti.transition.vanilla_async;
                    sti.beats = sti.transition.beats;
                    break;
                }
                throw new JuggleExceptionInternal("Wildcard not resolved");
            }
            case 14: {
                this.right_on_even[sti.source_juggler - 1] = sti.beatnum % 2 == 0 ? !sti.spec_left : sti.spec_left;
                sti.throw_sum = 0;
                if (sti.beatnum > 0) {
                    sti.vanilla_async = false;
                }
                this.has_hands_specifier = true;
            }
        }
    }

    protected void doSecondPass(SiteswapTreeItem sti, boolean switchhands, int beatoffset) throws JuggleExceptionUser {
        SiteswapTreeItem child = null;
        switch (sti.type) {
            case 1: {
                int i;
                for (i = 0; i < sti.getNumberOfChildren(); ++i) {
                    child = sti.getChild(i);
                    this.doSecondPass(child, switchhands, beatoffset);
                }
                if (!sti.switchrepeat) break;
                for (i = 0; i < sti.getNumberOfChildren(); ++i) {
                    child = sti.getChild(i);
                    this.doSecondPass(child, !switchhands, beatoffset + sti.beats / 2);
                }
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                for (int i = 0; i < sti.getNumberOfChildren(); ++i) {
                    child = sti.getChild(i);
                    this.doSecondPass(child, switchhands, beatoffset);
                }
                break;
            }
            case 5: 
            case 11: {
                for (int index = sti.beatnum + beatoffset; index < this.indexes; index += this.period) {
                    for (int i = 0; i < sti.getNumberOfChildren(); ++i) {
                        int dest_juggler;
                        String mod;
                        int dest_hand;
                        child = sti.getChild(i);
                        int source_hand = switchhands ? (sti.left ? 0 : 1) : (sti.left ? 1 : 0);
                        int n = dest_hand = child.value % 2 == 0 ? source_hand : 1 - source_hand;
                        if (child.x) {
                            dest_hand = 1 - dest_hand;
                        }
                        if ((mod = child.mod) == null) {
                            mod = "T";
                            if (child.source_juggler == child.dest_juggler && source_hand == dest_hand) {
                                if (child.value <= 1) {
                                    mod = "H";
                                } else if (child.value == 2) {
                                    mod = "?";
                                }
                            }
                        }
                        if ((dest_juggler = child.dest_juggler) > this.getNumberOfJugglers()) {
                            dest_juggler = 1 + (dest_juggler - 1) % this.getNumberOfJugglers();
                        }
                        MHNThrow t = new MHNThrow(child.source_juggler, source_hand, index, i, dest_juggler, dest_hand, index + child.value, -1, mod);
                        if (this.hands != null) {
                            int idx = index;
                            if (sti.sync_throw && source_hand == 0) {
                                ++idx;
                            }
                            t.handsindex = idx %= this.hands.getPeriod(child.source_juggler);
                        }
                        this.th[child.source_juggler - 1][source_hand][index][i] = t;
                    }
                }
                break;
            }
        }
    }

    protected void resolveModifiers() {
        for (int i = 0; i < this.indexes; ++i) {
            for (int j = 0; j < this.numjugglers; ++j) {
                for (int h = 0; h < 2; ++h) {
                    for (int slot = 0; slot < this.max_occupancy; ++slot) {
                        MHNThrow mhnt = this.th[j][h][i][slot];
                        if (mhnt == null || !mhnt.mod.equals("?")) continue;
                        boolean do_hold = true;
                        if (i + 1 < this.indexes) {
                            for (int slot2 = 0; slot2 < this.max_occupancy; ++slot2) {
                                MHNThrow mhnt2 = this.th[j][h][i + 1][slot2];
                                if (mhnt2 == null || mhnt2.targetindex == i + 1) continue;
                                do_hold = false;
                                break;
                            }
                        }
                        mhnt.mod = do_hold ? "H" : "T";
                    }
                }
            }
        }
    }
}

