/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Objects;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.jml.PathLink;
import jugglinglab.optimizer.LinearEquation;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterList;

public class MarginEquations {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected static final double EPSILON = 1.0E-6;
    public int varsNum = 0;
    public JMLEvent[] varsEvents = null;
    public double[] varsValues = null;
    public double[] varsMin = null;
    public double[] varsMax = null;
    public int marginsNum = 0;
    public LinearEquation[] marginsEqs = null;

    public MarginEquations() {
    }

    public MarginEquations(JMLPattern pat) throws JuggleExceptionInternal, JuggleExceptionUser {
        this();
        this.findeqs(pat);
    }

    public double getNumberOfEquations() {
        return this.marginsNum;
    }

    public double getMargin(int eqn) {
        double m = 0.0;
        for (int i = 0; i < this.varsNum; ++i) {
            m += this.marginsEqs[eqn].coef(i) * this.varsValues[i];
        }
        return Math.abs(m) + this.marginsEqs[eqn].constant();
    }

    public double getMargin() {
        if (this.marginsNum == 0) {
            return -100.0;
        }
        double minmargin = this.getMargin(0);
        for (int i = 1; i < this.marginsNum; ++i) {
            double m = this.getMargin(i);
            if (!(m < minmargin)) continue;
            minmargin = m;
        }
        return minmargin;
    }

    protected void findeqs(JMLPattern pat) throws JuggleExceptionInternal, JuggleExceptionUser {
        int i;
        int type;
        JMLEvent ev;
        if (pat.getNumberOfJugglers() > 1) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_optimizer_no_passing"));
        }
        if (pat.isBouncePattern()) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_optimizer_no_bouncing"));
        }
        pat.layoutPattern();
        JMLEvent events = pat.getEventList();
        ArrayList<ArrayList<PathLink>> pathlinks = pat.getPathLinks();
        ArrayList<JMLEvent> variableEvents = new ArrayList<JMLEvent>();
        double maxValue = 0.0;
        double g = 980.0;
        block7: for (ev = events; ev != null; ev = ev.getNext()) {
            if (!ev.isMaster()) continue;
            for (JMLTransition tr : ev.transitions()) {
                ParameterList pl;
                String gparam;
                type = tr.getType();
                if (type != 1 && type != 2 && type != 3 && type != 4) continue;
                ++this.varsNum;
                variableEvents.add(ev);
                Coordinate coord = ev.getLocalCoordinate();
                if (Math.abs(coord.x) > maxValue) {
                    maxValue = Math.abs(coord.x);
                }
                if (type != 1 || (gparam = (pl = new ParameterList(tr.getMod())).getParameter("g")) == null) continue block7;
                try {
                    g = JLFunc.parseDouble(gparam);
                }
                catch (NumberFormatException numberFormatException) {}
                continue block7;
            }
        }
        this.varsEvents = new JMLEvent[this.varsNum];
        this.varsValues = new double[this.varsNum];
        this.varsMin = new double[this.varsNum];
        this.varsMax = new double[this.varsNum];
        for (int i2 = 0; i2 < this.varsNum; ++i2) {
            ev = (JMLEvent)variableEvents.get(i2);
            Coordinate coord = ev.getLocalCoordinate();
            type = ev.getTransition(0).getType();
            this.varsEvents[i2] = ev;
            this.varsValues[i2] = coord.x;
            if (this.varsValues[i2] > 0.0) {
                this.varsMin[i2] = 0.1 * maxValue;
                this.varsMax[i2] = maxValue;
                if (type != 1) continue;
                int n = i2;
                this.varsMax[n] = this.varsMax[n] * 0.9;
                continue;
            }
            this.varsMin[i2] = -maxValue;
            this.varsMax[i2] = -0.1 * maxValue;
            if (type != 1) continue;
            int n = i2;
            this.varsMin[n] = this.varsMin[n] * 0.9;
        }
        double propradius = 0.0;
        for (int i3 = 0; i3 < pat.getNumberOfProps(); ++i3) {
            double thisprop = 0.5 * pat.getProp(i3 + 1).getWidth();
            if (!(thisprop > propradius)) continue;
            propradius = thisprop;
        }
        int masterplNum = 0;
        PathLink[] masterpl = null;
        for (int pass = 1; pass < 3; ++pass) {
            int k = 0;
            for (int i4 = 0; i4 < pathlinks.size(); ++i4) {
                for (int j = 0; j < pathlinks.get(i4).size(); ++j) {
                    PathLink pl = pathlinks.get(i4).get(j);
                    if (pl.isInHand() || !pl.getStartEvent().isMaster()) continue;
                    if (pass == 1) {
                        ++masterplNum;
                        continue;
                    }
                    masterpl[k++] = pl;
                }
            }
            if (pass != 1) continue;
            masterpl = new PathLink[masterplNum];
        }
        double sym_delay = -1.0;
        boolean sym_switchdelay = false;
        for (JMLSymmetry sym : pat.symmetries()) {
            switch (sym.getType()) {
                case 1: {
                    sym_delay = sym.getDelay();
                    break;
                }
                case 3: {
                    sym_switchdelay = true;
                    break;
                }
                case 2: {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_no_optimize_switch"));
                }
            }
        }
        ArrayList<double[]> eqns = new ArrayList<double[]>();
        for (int i5 = 0; i5 < masterplNum; ++i5) {
            for (int j = 0; j < masterplNum; ++j) {
                PathLink mpl1 = masterpl[i5];
                PathLink mpl2 = masterpl[j];
                double mpl1_start = mpl1.getStartEvent().getT();
                double mpl1_end = mpl1.getEndEvent().getT();
                double mpl2_start = mpl2.getStartEvent().getT();
                double mpl2_end = mpl2.getEndEvent().getT();
                double delay = 0.0;
                boolean invert_mpl2 = false;
                do {
                    boolean can_collide = true;
                    if (delay == 0.0 && mpl1.getStartEvent() == mpl2.getStartEvent()) {
                        can_collide = false;
                    }
                    if (mpl1_start > mpl2_start + delay) {
                        can_collide = false;
                    } else if (mpl1_start == mpl2_start + delay) {
                        if (mpl1_end > mpl2_end + delay) {
                            can_collide = false;
                        } else if (mpl1_end == mpl2_end + delay) {
                            if (mpl1.getStartEvent().getJuggler() > mpl2.getStartEvent().getJuggler()) {
                                can_collide = false;
                            } else if (mpl1.getStartEvent().getJuggler() == mpl2.getStartEvent().getJuggler() && mpl1.getStartEvent().getHand() == 1) {
                                can_collide = false;
                            }
                        }
                    }
                    double tsame = -1.0;
                    double tsame_denom = mpl2_start + mpl2_end + 2.0 * delay - (mpl1_start + mpl1_end);
                    if (tsame_denom == 0.0) {
                        can_collide = false;
                    }
                    if (can_collide && ((tsame = ((mpl2_start + delay) * (mpl2_end + delay) - mpl1_start * mpl1_end) / tsame_denom) < mpl1_start || tsame > mpl1_end || tsame < mpl2_start + delay || tsame > mpl2_end + delay)) {
                        can_collide = false;
                    }
                    if (can_collide) {
                        double[] coefs = new double[this.varsNum + 1];
                        double t_c1 = mpl1_end;
                        double t_t1 = mpl1_start;
                        double v_y1 = 0.5 * g * (t_c1 - t_t1);
                        double t_c2 = mpl2_end + delay;
                        double t_t2 = mpl2_start + delay;
                        double v_y2 = 0.5 * g * (t_c2 - t_t2);
                        double denom = v_y1 * (tsame - t_t1) + v_y2 * (tsame - t_t2);
                        if (denom > 1.0E-6) {
                            int k;
                            double coef_t1 = (t_c1 - tsame) / ((t_c1 - t_t1) * (denom *= Math.PI / 180));
                            double coef_c1 = (tsame - t_t1) / ((t_c1 - t_t1) * denom);
                            double coef_t2 = -(t_c2 - tsame) / ((t_c2 - t_t2) * denom);
                            double coef_c2 = -(tsame - t_t2) / ((t_c2 - t_t2) * denom);
                            double coef_0 = -2.0 * propradius / denom;
                            JMLEvent mplev = mpl1.getStartEvent();
                            if (!mplev.isMaster()) {
                                if (mplev.getHand() != mplev.getMaster().getHand()) {
                                    coef_t1 = -coef_t1;
                                }
                                mplev = mplev.getMaster();
                            }
                            int t1_varnum = variableEvents.indexOf(mplev);
                            mplev = mpl1.getEndEvent();
                            if (!mplev.isMaster()) {
                                if (mplev.getHand() != mplev.getMaster().getHand()) {
                                    coef_c1 = -coef_c1;
                                }
                                mplev = mplev.getMaster();
                            }
                            int c1_varnum = variableEvents.indexOf(mplev);
                            mplev = mpl2.getStartEvent();
                            if (!mplev.isMaster()) {
                                if (mplev.getHand() != mplev.getMaster().getHand()) {
                                    coef_t2 = -coef_t2;
                                }
                                mplev = mplev.getMaster();
                            }
                            int t2_varnum = variableEvents.indexOf(mplev);
                            mplev = mpl2.getEndEvent();
                            if (!mplev.isMaster()) {
                                if (mplev.getHand() != mplev.getMaster().getHand()) {
                                    coef_c2 = -coef_c2;
                                }
                                mplev = mplev.getMaster();
                            }
                            int c2_varnum = variableEvents.indexOf(mplev);
                            if (t1_varnum < 0 || c1_varnum < 0 || t2_varnum < 0 || c2_varnum < 0) {
                                throw new JuggleExceptionInternal("Could not find master event in variableEvents");
                            }
                            if (invert_mpl2) {
                                coef_t2 = -coef_t2;
                                coef_c2 = -coef_c2;
                            }
                            int n = t1_varnum;
                            coefs[n] = coefs[n] + coef_t1;
                            int n2 = c1_varnum;
                            coefs[n2] = coefs[n2] + coef_c1;
                            int n3 = t2_varnum;
                            coefs[n3] = coefs[n3] + coef_t2;
                            int n4 = c2_varnum;
                            coefs[n4] = coefs[n4] + coef_c2;
                            coefs[this.varsNum] = coef_0;
                            double dist = 0.0;
                            for (k = 0; k < this.varsNum; ++k) {
                                dist += coefs[k] * this.varsValues[k];
                            }
                            if (dist < 0.0) {
                                for (k = 0; k < this.varsNum; ++k) {
                                    if (coefs[k] == 0.0) continue;
                                    coefs[k] = -coefs[k];
                                }
                            }
                            eqns.add(coefs);
                            ++this.marginsNum;
                        }
                    }
                    if (sym_switchdelay) {
                        delay += 0.5 * sym_delay;
                        invert_mpl2 = !invert_mpl2;
                        continue;
                    }
                    delay += sym_delay;
                } while (mpl1_end > mpl2_start + delay);
            }
        }
        boolean orig_row = true;
        for (i = 1; i < this.marginsNum; ++i) {
            boolean duprow;
            boolean dupoverall = false;
            double[] rowi = (double[])eqns.get(i);
            for (int j = 0; !dupoverall && j < i; dupoverall |= duprow, ++j) {
                double[] rowj = (double[])eqns.get(j);
                duprow = true;
                for (int k = 0; duprow && k <= this.varsNum; ++k) {
                    if (!(rowi[k] < rowj[k] - 1.0E-6) && !(rowi[k] > rowj[k] + 1.0E-6)) continue;
                    duprow = false;
                }
            }
            if (!dupoverall) continue;
            eqns.remove(i);
            --i;
            --this.marginsNum;
        }
        this.marginsEqs = new LinearEquation[this.marginsNum];
        for (i = 0; i < this.marginsNum; ++i) {
            this.marginsEqs[i] = new LinearEquation(this.varsNum);
            this.marginsEqs[i].setCoefficients((double[])eqns.get(i));
        }
        this.sort();
    }

    public void sort() {
        Comparator<LinearEquation> comp = new Comparator<LinearEquation>(this){
            final /* synthetic */ MarginEquations this$0;
            {
                MarginEquations marginEquations = this$0;
                Objects.requireNonNull(marginEquations);
                this.this$0 = marginEquations;
            }

            @Override
            public int compare(LinearEquation eq1, LinearEquation eq2) {
                if (eq1.done() && !eq2.done()) {
                    return -1;
                }
                if (!eq1.done() && eq2.done()) {
                    return 1;
                }
                double m1 = eq1.constant();
                double m2 = eq2.constant();
                for (int i = 0; i < this.this$0.varsNum; ++i) {
                    m1 += eq1.coef(i) * this.this$0.varsValues[i];
                    m2 += eq2.coef(i) * this.this$0.varsValues[i];
                }
                if (m1 < m2) {
                    return -1;
                }
                if (m1 > m2) {
                    return 1;
                }
                return 0;
            }

            @Override
            public boolean equals(Object eq) {
                return false;
            }
        };
        Arrays.sort(this.marginsEqs, comp);
    }
}

