/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.optimizer;

import com.google.ortools.linearsolver.MPConstraint;
import com.google.ortools.linearsolver.MPObjective;
import com.google.ortools.linearsolver.MPSolver;
import com.google.ortools.linearsolver.MPVariable;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.optimizer.MarginEquations;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class Optimizer {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected static final double EPSILON = 1.0E-7;
    protected static final double INFINITY = Double.POSITIVE_INFINITY;
    protected static boolean optimizer_loaded;
    protected static boolean optimizer_available;
    protected JMLPattern pat;
    protected MarginEquations me;
    protected boolean[] pinned;

    public static boolean optimizerAvailable() {
        Optimizer.loadOptimizer();
        return optimizer_available;
    }

    private static void loadOptimizer() {
        block3: {
            if (optimizer_loaded) {
                return;
            }
            optimizer_loaded = true;
            try {
                System.loadLibrary("jniortools");
                optimizer_available = true;
            }
            catch (UnsatisfiedLinkError e) {
                if (!JugglingLab.isLinux) break block3;
                System.out.println(e);
            }
        }
    }

    public static JMLPattern optimize(JMLPattern pat) throws JuggleExceptionInternal, JuggleExceptionUser {
        if (!Optimizer.optimizerAvailable()) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_optimizer_unavailable"));
        }
        Optimizer opt = new Optimizer(pat);
        if (opt.me.marginsNum > 0) {
            boolean success = opt.doOptimizationMILP();
            if (success) {
                opt.updatePattern();
            } else {
                throw new JuggleExceptionUser(errorstrings.getString("Error_optimizer_failed"));
            }
        }
        return pat;
    }

    protected Optimizer(JMLPattern p) throws JuggleExceptionInternal, JuggleExceptionUser {
        this.pat = p;
        this.me = new MarginEquations(p);
        if (this.me.marginsNum == 0) {
            return;
        }
        this.pinned = new boolean[this.me.varsNum];
    }

    protected boolean runMILP() {
        MPSolver solver = new MPSolver("JugglingLab", MPSolver.OptimizationProblemType.CBC_MIXED_INTEGER_PROGRAMMING);
        MPVariable[] x = new MPVariable[this.me.varsNum];
        for (int i = 0; i < this.me.varsNum; ++i) {
            if (this.pinned[i]) continue;
            x[i] = solver.makeNumVar(this.me.varsMin[i], this.me.varsMax[i], "x" + i);
        }
        MPVariable[] z = new MPVariable[this.me.marginsNum];
        for (int i = 0; i < this.me.marginsNum; ++i) {
            if (this.me.marginsEqs[i].done()) continue;
            z[i] = solver.makeBoolVar("z" + i);
        }
        MPVariable err = solver.makeNumVar(Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, "err");
        MPConstraint[] c = new MPConstraint[this.me.marginsNum * 2];
        for (int i = 0; i < this.me.marginsNum; ++i) {
            double coef;
            int j;
            if (this.me.marginsEqs[i].done()) continue;
            double maxAx = 0.0;
            double minAx = 0.0;
            for (int j2 = 0; j2 < this.me.varsNum; ++j2) {
                double coef2 = this.me.marginsEqs[i].coef(j2);
                if (coef2 > 0.0) {
                    maxAx += coef2 * this.me.varsMax[j2];
                    minAx += coef2 * this.me.varsMin[j2];
                    continue;
                }
                maxAx += coef2 * this.me.varsMin[j2];
                minAx += coef2 * this.me.varsMax[j2];
            }
            double bound = 2.0 * Math.max(Math.abs(maxAx), Math.abs(minAx)) + 1.0;
            double rhs = this.me.marginsEqs[i].constant();
            for (j = 0; j < this.me.varsNum; ++j) {
                if (!this.pinned[j]) continue;
                rhs += this.me.marginsEqs[i].coef(j) * this.me.varsValues[j];
            }
            c[2 * i] = solver.makeConstraint(Double.NEGATIVE_INFINITY, rhs, "c" + i + "a");
            c[2 * i].setCoefficient(err, 1.0);
            c[2 * i].setCoefficient(z[i], -bound);
            for (j = 0; j < this.me.varsNum; ++j) {
                if (this.pinned[j] || (coef = this.me.marginsEqs[i].coef(j)) == 0.0) continue;
                c[2 * i].setCoefficient(x[j], -coef);
            }
            rhs = this.me.marginsEqs[i].constant() + bound;
            for (j = 0; j < this.me.varsNum; ++j) {
                if (!this.pinned[j]) continue;
                rhs -= this.me.marginsEqs[i].coef(j) * this.me.varsValues[j];
            }
            c[2 * i + 1] = solver.makeConstraint(Double.NEGATIVE_INFINITY, rhs, "c" + i + "b");
            c[2 * i + 1].setCoefficient(err, 1.0);
            c[2 * i + 1].setCoefficient(z[i], bound);
            for (j = 0; j < this.me.varsNum; ++j) {
                if (this.pinned[j] || (coef = this.me.marginsEqs[i].coef(j)) == 0.0) continue;
                c[2 * i + 1].setCoefficient(x[j], coef);
            }
        }
        MPObjective objective = solver.objective();
        objective.setCoefficient(err, 1.0);
        objective.setMaximization();
        MPSolver.ResultStatus resultStatus = solver.solve();
        if (resultStatus != MPSolver.ResultStatus.OPTIMAL) {
            return false;
        }
        for (int i = 0; i < this.me.varsNum; ++i) {
            if (this.pinned[i]) continue;
            this.me.varsValues[i] = x[i].solutionValue();
        }
        return true;
    }

    protected void markFinished() {
        int i;
        double minmargin = Double.POSITIVE_INFINITY;
        for (i = 0; i < this.me.marginsNum; ++i) {
            if (this.me.marginsEqs[i].done() || !(this.me.getMargin(i) < minmargin)) continue;
            minmargin = this.me.getMargin(i);
        }
        for (i = 0; i < this.me.marginsNum; ++i) {
            double mar;
            double diff;
            if (this.me.marginsEqs[i].done() || (diff = (mar = this.me.getMargin(i)) - minmargin) < -1.0E-7 || diff > 1.0E-7) continue;
            for (int j = 0; j < this.me.varsNum; ++j) {
                double cj = this.me.marginsEqs[i].coef(j);
                if (this.pinned[j] || !(cj > 1.0E-7) && !(cj < -1.0E-7)) continue;
                this.pinned[j] = true;
            }
        }
        for (int row = 0; row < this.me.marginsNum; ++row) {
            if (this.me.marginsEqs[row].done()) continue;
            boolean eqndone = true;
            for (int i2 = 0; i2 < this.me.varsNum; ++i2) {
                double ci = this.me.marginsEqs[row].coef(i2);
                if (this.pinned[i2] || !(ci > 1.0E-7) && !(ci < -1.0E-7)) continue;
                eqndone = false;
                break;
            }
            if (!eqndone) continue;
            this.me.marginsEqs[row].setDone(true);
        }
    }

    protected boolean doOptimizationMILP() {
        int stage = 1;
        while (true) {
            boolean optimal;
            if (!(optimal = this.runMILP())) {
                return false;
            }
            this.markFinished();
            boolean done = true;
            for (int i = 0; i < this.me.marginsNum; ++i) {
                if (this.me.marginsEqs[i].done()) continue;
                done = false;
                break;
            }
            if (done) break;
            ++stage;
        }
        return true;
    }

    protected void updatePattern() {
        for (int i = 0; i < this.me.varsNum; ++i) {
            if (!this.pinned[i]) continue;
            JMLEvent ev = this.me.varsEvents[i];
            double newx = (double)Math.round(this.me.varsValues[i] * 100.0) / 100.0;
            Coordinate coord = ev.getLocalCoordinate();
            coord.x = newx;
            ev.setLocalCoordinate(coord);
        }
        this.pat.setNeedsLayout();
    }
}

