/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.path;

import java.text.MessageFormat;
import jugglinglab.path.Path;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;

public class BouncePath
extends Path {
    protected static final int BOUNCES_DEF = 1;
    protected static final boolean FORCED_DEF = false;
    protected static final boolean HYPER_DEF = false;
    protected static final double BOUNCEPLANE_DEF = 0.0;
    protected static final double BOUNCEFRAC_DEF = 0.9;
    protected static final double G_DEF = 980.0;
    protected double bx;
    protected double cx;
    protected double by;
    protected double cy;
    protected double[] az;
    protected double[] bz;
    protected double[] cz;
    protected double[] endtime;
    protected int bounces = 1;
    protected boolean forced = false;
    protected boolean hyper = false;
    protected double bounceplane = 0.0;
    protected double bouncefrac = 0.9;
    protected double g = 980.0;
    protected double bouncefracsqrt;
    protected double bouncetime;
    protected int numbounces;

    @Override
    public String getType() {
        return "Bounce";
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] result = new ParameterDescriptor[]{new ParameterDescriptor("bounces", 4, null, 1, this.bounces), new ParameterDescriptor("forced", 1, null, false, this.forced), new ParameterDescriptor("hyper", 1, null, false, this.hyper), new ParameterDescriptor("bounceplane", 2, null, 0.0, this.bounceplane), new ParameterDescriptor("bouncefrac", 2, null, 0.9, this.bouncefrac), new ParameterDescriptor("g", 2, null, 980.0, this.g)};
        return result;
    }

    @Override
    public void initPath(String st) throws JuggleExceptionUser {
        int bounces = 1;
        boolean forced = false;
        boolean hyper = false;
        double bounceplane = 0.0;
        double bouncefrac = 0.9;
        double g = 980.0;
        ParameterList pl = new ParameterList(st);
        for (int i = 0; i < pl.getNumberOfParameters(); ++i) {
            String pname = pl.getParameterName(i);
            String pvalue = pl.getParameterValue(i);
            if (pname.equalsIgnoreCase("bounces")) {
                try {
                    bounces = Integer.valueOf(pvalue);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String template = errorstrings.getString("Error_number_format");
                    Object[] arguments = new Object[]{"bounces"};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
            }
            if (pname.equalsIgnoreCase("forced")) {
                forced = Boolean.valueOf(pvalue);
                continue;
            }
            if (pname.equalsIgnoreCase("hyper")) {
                hyper = Boolean.valueOf(pvalue);
                continue;
            }
            if (pname.equalsIgnoreCase("bounceplane")) {
                try {
                    bounceplane = JLFunc.parseDouble(pvalue);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String template = errorstrings.getString("Error_number_format");
                    Object[] arguments = new Object[]{"bounceplane"};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
            }
            if (pname.equalsIgnoreCase("bouncefrac")) {
                try {
                    bouncefrac = JLFunc.parseDouble(pvalue);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String template = errorstrings.getString("Error_number_format");
                    Object[] arguments = new Object[]{"bouncefrac"};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
            }
            if (pname.equalsIgnoreCase("g")) {
                try {
                    g = JLFunc.parseDouble(pvalue);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String template = errorstrings.getString("Error_number_format");
                    Object[] arguments = new Object[]{"g"};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
            }
            throw new JuggleExceptionUser(errorstrings.getString("Error_path_badmod") + ": '" + pname + "'");
        }
        this.bounces = bounces;
        this.forced = forced;
        this.hyper = hyper;
        this.bounceplane = bounceplane;
        this.bouncefrac = bouncefrac;
        try {
            this.bouncefracsqrt = Math.sqrt(bouncefrac);
        }
        catch (ArithmeticException e) {
            this.bouncefracsqrt = 1.0;
        }
        this.g = g;
        this.az = new double[bounces + 1];
        this.bz = new double[bounces + 1];
        this.cz = new double[bounces + 1];
        this.endtime = new double[bounces + 1];
        for (int i = 0; i <= bounces; ++i) {
            this.az[i] = -0.5 * g;
        }
    }

    @Override
    public void calcPath() throws JuggleExceptionInternal {
        if (this.start_coord == null || this.end_coord == null) {
            return;
        }
        for (int n = this.bounces; n > 0; --n) {
            int i;
            double[] root = new double[4];
            boolean[] liftcatch = new boolean[4];
            int numroots = this.solveBounceEquation(n, this.getDuration(), root, liftcatch);
            if (numroots == 0) continue;
            boolean choseroot = false;
            double v0 = root[0];
            for (i = 0; i < numroots; ++i) {
                if (this.forced ^ root[i] < 0.0 || this.hyper ^ liftcatch[i] ^ this.forced) continue;
                v0 = root[i];
                choseroot = true;
                break;
            }
            if (!choseroot) {
                for (i = 0; i < numroots; ++i) {
                    if (this.forced ^ root[i] < 0.0) continue;
                    v0 = root[i];
                    choseroot = true;
                    break;
                }
            }
            if (!choseroot) {
                for (i = 0; i < numroots; ++i) {
                    if (this.hyper ^ liftcatch[i] ^ root[i] < 0.0) continue;
                    v0 = root[i];
                    choseroot = true;
                    break;
                }
            }
            this.numbounces = n;
            this.bz[0] = v0;
            this.cz[0] = this.start_coord.z;
            this.endtime[0] = this.az[0] < 0.0 ? (-v0 - Math.sqrt(v0 * v0 - 4.0 * this.az[0] * (this.cz[0] - this.bounceplane))) / (2.0 * this.az[0]) : (-v0 + Math.sqrt(v0 * v0 - 4.0 * this.az[0] * (this.cz[0] - this.bounceplane))) / (2.0 * this.az[0]);
            double vrebound = (-v0 - 2.0 * this.az[0] * this.endtime[0]) * this.bouncefracsqrt;
            for (int i2 = 1; i2 <= n; ++i2) {
                this.bz[i2] = vrebound - 2.0 * this.az[i2] * this.endtime[i2 - 1];
                this.cz[i2] = this.bounceplane - this.az[i2] * this.endtime[i2 - 1] * this.endtime[i2 - 1] - this.bz[i2] * this.endtime[i2 - 1];
                this.endtime[i2] = this.endtime[i2 - 1] - vrebound / this.az[i2];
                vrebound = this.bouncefracsqrt * vrebound;
            }
            this.endtime[n] = this.getDuration();
            this.cx = this.start_coord.x;
            this.bx = (this.end_coord.x - this.start_coord.x) / this.getDuration();
            this.cy = this.start_coord.y;
            this.by = (this.end_coord.y - this.start_coord.y) / this.getDuration();
            return;
        }
        throw new JuggleExceptionInternal("No root found in BouncePath");
    }

    protected int solveBounceEquation(int n, double duration, double[] root, boolean[] liftcatch) {
        double f1 = this.bouncefracsqrt;
        for (int i = 1; i < n; ++i) {
            f1 *= this.bouncefracsqrt;
        }
        double k = this.bouncefracsqrt == 1.0 ? 2.0 * (double)n : 1.0 + f1 + 2.0 * this.bouncefracsqrt * (1.0 - f1 / this.bouncefracsqrt) / (1.0 - this.bouncefracsqrt);
        double u = 2.0 * this.g * (this.start_coord.z - this.bounceplane);
        double l = 2.0 * this.g * (this.end_coord.z - this.bounceplane);
        double f2 = f1 * f1;
        double c = u - l / f2;
        double kk = k * k;
        double gt = this.g * duration;
        double[] coef = new double[5];
        coef[4] = 1.0 + kk * kk + f2 * f2 - 2.0 * kk - 2.0 * f2 - 2.0 * kk * f2;
        coef[3] = -4.0 * gt + 4.0 * f2 * gt + 4.0 * kk * gt;
        coef[2] = 6.0 * gt * gt + 2.0 * kk * kk * u + 2.0 * f2 * f2 * c - 2.0 * f2 * c - 2.0 * f2 * gt * gt - 2.0 * kk * gt * gt - 2.0 * kk * u - 2.0 * kk * f2 * c - 2.0 * kk * f2 * u;
        coef[1] = -4.0 * gt * gt * gt + 4.0 * f2 * gt * c + 4.0 * kk * gt * u;
        coef[0] = gt * gt * gt * gt + kk * kk * u * u + f2 * f2 * c * c - 2.0 * gt * gt * f2 * c - 2.0 * kk * gt * gt * u - 2.0 * kk * f2 * u * c;
        double[] realroot = new double[4];
        int numrealroots = 0;
        if (n > 1) {
            i = 0;
            while (i < 4) {
                int n2 = i++;
                coef[n2] = coef[n2] / coef[4];
            }
            numrealroots = BouncePath.findRealRootsPolynomial(coef, 4, realroot);
        } else {
            i = 0;
            while (i < 3) {
                int n3 = i++;
                coef[n3] = coef[n3] / coef[3];
            }
            numrealroots = BouncePath.findRealRootsPolynomial(coef, 3, realroot);
        }
        int numroots = 0;
        for (int i = 0; i < numrealroots; ++i) {
            double v0 = realroot[i];
            if (!(v0 * v0 + c >= 0.0)) continue;
            root[numroots] = v0;
            liftcatch[numroots] = gt - v0 - k * Math.sqrt(v0 * v0 + u) > 0.0;
            ++numroots;
        }
        return numroots;
    }

    protected boolean isFeasibleDuration(double duration) {
        double[] root = new double[4];
        boolean[] liftcatch = new boolean[4];
        int numroots = this.solveBounceEquation(this.bounces, duration, root, liftcatch);
        for (int i = 0; i < numroots; ++i) {
            if (this.forced ^ root[i] < 0.0 || this.hyper ^ liftcatch[i] ^ this.forced) continue;
            return true;
        }
        return false;
    }

    @Override
    public double getMinDuration() {
        if (this.bounces == 1 && this.hyper && this.forced) {
            return 0.0;
        }
        double dlower = 0.0;
        double dupper = 1.0;
        while (!this.isFeasibleDuration(dupper)) {
            dlower = dupper;
            dupper *= 2.0;
        }
        while (dupper - dlower > 1.0E-4) {
            double davg = 0.5 * (dlower + dupper);
            if (this.isFeasibleDuration(davg)) {
                dupper = davg;
                continue;
            }
            dlower = davg;
        }
        return dupper;
    }

    @Override
    public Coordinate getStartVelocity() {
        return new Coordinate(this.bx, this.by, this.bz[0]);
    }

    @Override
    public Coordinate getEndVelocity() {
        return new Coordinate(this.bx, this.by, this.bz[this.numbounces] + 2.0 * this.az[this.numbounces] * (this.end_time - this.start_time));
    }

    @Override
    public void getCoordinate(double time, Coordinate newPosition) {
        if (time < this.start_time || time > this.end_time) {
            return;
        }
        time -= this.start_time;
        double zpos = 0.0;
        for (int i = 0; i <= this.numbounces; ++i) {
            if (!(time < this.endtime[i]) && i != this.numbounces) continue;
            zpos = this.cz[i] + time * (this.bz[i] + this.az[i] * time);
            break;
        }
        newPosition.setCoordinate(this.cx + this.bx * time, this.cy + this.by * time, zpos);
    }

    @Override
    protected Coordinate getMax2(double start, double end) {
        double te;
        Coordinate result = null;
        double tlow = Math.max(this.start_time, start);
        double thigh = Math.min(this.end_time, end);
        result = this.check(result, tlow, true);
        result = this.check(result, thigh, true);
        if (this.az[0] < 0.0 && tlow < (te = -this.bz[0] / (2.0 * this.az[0]) + this.start_time) && te < Math.min(thigh, this.start_time + this.endtime[0])) {
            result = this.check(result, te, true);
        }
        if (this.az[this.numbounces] < 0.0) {
            te = -this.bz[this.numbounces] / (2.0 * this.az[this.numbounces]) + this.start_time;
            if (Math.max(tlow, this.start_time + this.endtime[this.numbounces - 1]) < te && te < thigh) {
                result = this.check(result, te, true);
            }
        }
        if (tlow < this.start_time + this.endtime[0] && this.start_time + this.endtime[0] < thigh) {
            result = this.check(result, this.start_time + this.endtime[0], true);
        }
        for (int i = 1; i < this.numbounces; ++i) {
            if (this.az[i] < 0.0) {
                double te2 = -this.bz[i] / (2.0 * this.az[i]) + this.start_time;
                if (Math.max(tlow, this.start_time + this.endtime[i - 1]) < te2 && te2 < Math.min(thigh, this.start_time + this.endtime[i])) {
                    result = this.check(result, te2, true);
                }
            }
            if (!(tlow < this.start_time + this.endtime[i]) || !(this.start_time + this.endtime[i] < thigh)) continue;
            result = this.check(result, this.start_time + this.endtime[i], true);
        }
        return result;
    }

    @Override
    protected Coordinate getMin2(double start, double end) {
        double te;
        Coordinate result = null;
        double tlow = Math.max(this.start_time, start);
        double thigh = Math.min(this.end_time, end);
        result = this.check(result, tlow, false);
        result = this.check(result, thigh, false);
        if (this.az[0] > 0.0 && tlow < (te = -this.bz[0] / (2.0 * this.az[0]) + this.start_time) && te < Math.min(thigh, this.start_time + this.endtime[0])) {
            result = this.check(result, te, false);
        }
        if (this.az[this.numbounces] > 0.0) {
            te = -this.bz[this.numbounces] / (2.0 * this.az[this.numbounces]) + this.start_time;
            if (Math.max(tlow, this.start_time + this.endtime[this.numbounces - 1]) < te && te < thigh) {
                result = this.check(result, te, false);
            }
        }
        if (tlow < this.start_time + this.endtime[0] && this.start_time + this.endtime[0] < thigh) {
            result = this.check(result, this.start_time + this.endtime[0], false);
        }
        for (int i = 1; i < this.numbounces; ++i) {
            if (this.az[i] > 0.0) {
                double te2 = -this.bz[i] / (2.0 * this.az[i]) + this.start_time;
                if (Math.max(tlow, this.start_time + this.endtime[i - 1]) < te2 && te2 < Math.min(thigh, this.start_time + this.endtime[i])) {
                    result = this.check(result, te2, false);
                }
            }
            if (!(tlow < this.start_time + this.endtime[i]) || !(this.start_time + this.endtime[i] < thigh)) continue;
            result = this.check(result, this.start_time + this.endtime[i], false);
        }
        return result;
    }

    protected static double evalPolynomial(double[] coef, int degree, double x) {
        double result = coef[0];
        double term = x;
        for (int i = 1; i < degree; ++i) {
            result += coef[i] * term;
            term *= x;
        }
        return result + term;
    }

    protected static double bracketOpenInterval(double[] coef, int degree, double endpoint, boolean pinf) {
        boolean endpointpositive = BouncePath.evalPolynomial(coef, degree, endpoint) > 0.0;
        double result = endpoint;
        double adder = pinf ? 1.0 : -1.0;
        while (BouncePath.evalPolynomial(coef, degree, result += (adder *= 2.0)) > 0.0 == endpointpositive) {
        }
        return result;
    }

    protected static double findRoot(double[] coef, int degree, double xlow, double xhigh) {
        double val2;
        double val1 = BouncePath.evalPolynomial(coef, degree, xlow);
        if (val1 * (val2 = BouncePath.evalPolynomial(coef, degree, xhigh)) > 0.0) {
            return 0.5 * (xlow + xhigh);
        }
        while (Math.abs(xlow - xhigh) > 1.0E-6) {
            double t = 0.5 * (xlow + xhigh);
            double valtemp = BouncePath.evalPolynomial(coef, degree, t);
            if (valtemp * val1 > 0.0) {
                xlow = t;
                val1 = valtemp;
                continue;
            }
            xhigh = t;
            val2 = valtemp;
        }
        return xlow;
    }

    protected static int findRealRootsPolynomial(double[] coef, int degree, double[] result) {
        if (degree == 0) {
            return 0;
        }
        if (degree == 1) {
            result[0] = -coef[0];
            return 1;
        }
        if (degree == 2) {
            double D = coef[1] * coef[1] - 4.0 * coef[0];
            if (D < 0.0) {
                return 0;
            }
            if (D == 0.0) {
                result[0] = -0.5 * coef[1];
                return 1;
            }
            double t = Math.sqrt(D);
            result[0] = -0.5 * (coef[1] + t);
            result[1] = -0.5 * (coef[1] - t);
            return 2;
        }
        if (degree == 3) {
            double r = coef[2] * coef[2] * coef[2] / 27.0 - coef[1] * coef[2] / 6.0 + coef[0] / 2.0;
            double q = coef[2] * coef[2] / 9.0 - coef[1] / 3.0;
            double D = r * r - q * q * q;
            if (D > 0.0) {
                double k = Math.pow(Math.sqrt(D) + Math.abs(r), 0.3333333333333333);
                result[0] = (r > 0.0 ? -(k + q / k) : k + q / k) - coef[2] / 3.0;
                return 1;
            }
            double theta = Math.acos(r / Math.sqrt(q * q * q)) / 3.0;
            double k = -2.0 * Math.sqrt(q);
            double p = 2.0943951023931953;
            result[0] = k * Math.cos(theta) - coef[2] / 3.0;
            result[1] = k * Math.cos(theta + p) - coef[2] / 3.0;
            result[2] = k * Math.cos(theta + 2.0 * p) - coef[2] / 3.0;
            return 3;
        }
        double[] dcoef = new double[degree - 1];
        double[] extremum = new double[degree - 1];
        for (int i = 0; i < degree - 1; ++i) {
            dcoef[i] = (double)(i + 1) * coef[i + 1] / (double)degree;
        }
        int numextrema = BouncePath.findRealRootsPolynomial(dcoef, degree - 1, extremum);
        boolean pinfpositive = true;
        boolean minfpositive = degree % 2 == 0;
        int numroots = 0;
        if (numextrema == 0) {
            double endpoint2;
            boolean zeropositive;
            boolean bl = zeropositive = coef[0] > 0.0;
            if (zeropositive != pinfpositive) {
                endpoint2 = BouncePath.bracketOpenInterval(coef, degree, 0.0, true);
                result[numroots++] = BouncePath.findRoot(coef, degree, 0.0, endpoint2);
            }
            if (zeropositive != minfpositive) {
                endpoint2 = BouncePath.bracketOpenInterval(coef, degree, 0.0, false);
                result[numroots++] = BouncePath.findRoot(coef, degree, endpoint2, 0.0);
            }
            return numroots;
        }
        for (int i = 0; i < numextrema; ++i) {
            for (int j = i; j < numextrema; ++j) {
                if (!(extremum[i] > extremum[j])) continue;
                double temp = extremum[i];
                extremum[i] = extremum[j];
                extremum[j] = temp;
            }
        }
        boolean[] extremumpositive = new boolean[numextrema];
        for (int i = 0; i < numextrema; ++i) {
            extremumpositive[i] = BouncePath.evalPolynomial(coef, degree, extremum[i]) > 0.0;
        }
        if (minfpositive != extremumpositive[0]) {
            double endpoint2 = BouncePath.bracketOpenInterval(coef, degree, extremum[0], false);
            result[numroots++] = BouncePath.findRoot(coef, degree, endpoint2, extremum[0]);
        }
        for (int i = 0; i < numextrema - 1; ++i) {
            if (extremumpositive[i] == extremumpositive[i + 1]) continue;
            result[numroots++] = BouncePath.findRoot(coef, degree, extremum[i], extremum[i + 1]);
        }
        if (pinfpositive != extremumpositive[numextrema - 1]) {
            double endpoint2 = BouncePath.bracketOpenInterval(coef, degree, extremum[numextrema - 1], true);
            result[numroots++] = BouncePath.findRoot(coef, degree, extremum[numextrema - 1], endpoint2);
        }
        return numroots;
    }

    public double getBounceVolume(double time1, double time2) {
        if (time2 < this.start_time || time1 > this.end_time) {
            return 0.0;
        }
        time1 -= this.start_time;
        time2 -= this.start_time;
        for (int i = 0; i < this.numbounces; ++i) {
            if (!(time1 < this.endtime[i])) continue;
            if (time2 > this.endtime[i]) {
                return 1.0;
            }
            return 0.0;
        }
        return 0.0;
    }
}

