/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.path;

import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.path.BouncePath;
import jugglinglab.path.TossPath;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;

public abstract class Path {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected double start_time;
    protected double end_time;
    protected Coordinate start_coord;
    protected Coordinate end_coord;
    public static final String[] builtinPaths = new String[]{"Toss", "Bounce"};

    public static Path newPath(String type) throws JuggleExceptionUser {
        if (type == null) {
            throw new JuggleExceptionUser("Path type not specified");
        }
        if (type.equalsIgnoreCase("toss")) {
            return new TossPath();
        }
        if (type.equalsIgnoreCase("bounce")) {
            return new BouncePath();
        }
        throw new JuggleExceptionUser("Path type '" + type + "' not recognized");
    }

    public void setStart(Coordinate position, double time) {
        this.start_coord = position;
        this.start_time = time;
    }

    public void setEnd(Coordinate position, double time) {
        this.end_coord = position;
        this.end_time = time;
    }

    public double getStartTime() {
        return this.start_time;
    }

    public double getEndTime() {
        return this.end_time;
    }

    public double getDuration() {
        return this.end_time - this.start_time;
    }

    public double getMinDuration() {
        return 0.0;
    }

    public void translateTime(double deltat) {
        this.start_time += deltat;
        this.end_time += deltat;
    }

    public Coordinate getMax() {
        return this.getMax2(this.start_time, this.end_time);
    }

    public Coordinate getMin() {
        return this.getMin2(this.start_time, this.end_time);
    }

    public Coordinate getMax(double begin, double end) {
        if (end < this.start_time || begin > this.end_time) {
            return null;
        }
        return this.getMax2(begin, end);
    }

    public Coordinate getMin(double begin, double end) {
        if (end < this.start_time || begin > this.end_time) {
            return null;
        }
        return this.getMin2(begin, end);
    }

    protected Coordinate check(Coordinate result, double t, boolean findmax) {
        Coordinate loc = new Coordinate(0.0, 0.0, 0.0);
        this.getCoordinate(t, loc);
        result = findmax ? Coordinate.max(result, loc) : Coordinate.min(result, loc);
        return result;
    }

    public abstract String getType();

    public abstract ParameterDescriptor[] getParameterDescriptors();

    public abstract void initPath(String var1) throws JuggleExceptionUser;

    public abstract void calcPath() throws JuggleExceptionInternal;

    public abstract Coordinate getStartVelocity();

    public abstract Coordinate getEndVelocity();

    public abstract void getCoordinate(double var1, Coordinate var3);

    protected abstract Coordinate getMax2(double var1, double var3);

    protected abstract Coordinate getMin2(double var1, double var3);
}

