/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.path;

import java.text.MessageFormat;
import jugglinglab.path.Path;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;

public class TossPath
extends Path {
    protected static final double G_DEF = 980.0;
    protected double bx;
    protected double cx;
    protected double by;
    protected double cy;
    protected double az;
    protected double bz;
    protected double cz;
    protected double g = 980.0;

    @Override
    public String getType() {
        return "Toss";
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] result = new ParameterDescriptor[]{new ParameterDescriptor("g", 2, null, 980.0, this.g)};
        return result;
    }

    @Override
    public void initPath(String st) throws JuggleExceptionUser {
        double g = 980.0;
        ParameterList pl = new ParameterList(st);
        for (int i = 0; i < pl.getNumberOfParameters(); ++i) {
            String pname = pl.getParameterName(i);
            String pvalue = pl.getParameterValue(i);
            if (pname.equalsIgnoreCase("g")) {
                try {
                    g = JLFunc.parseDouble(pvalue);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    String template = errorstrings.getString("Error_number_format");
                    Object[] arguments = new Object[]{"g"};
                    throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
                }
            }
            throw new JuggleExceptionUser(errorstrings.getString("Error_path_badmod") + ": '" + pname + "'");
        }
        this.g = g;
        this.az = -0.5 * g;
    }

    @Override
    public void calcPath() throws JuggleExceptionInternal {
        if (this.start_coord == null || this.end_coord == null) {
            throw new JuggleExceptionInternal("Error in parabolic path: endpoints not set");
        }
        double t = this.getDuration();
        this.cx = this.start_coord.x;
        this.bx = (this.end_coord.x - this.start_coord.x) / t;
        this.cy = this.start_coord.y;
        this.by = (this.end_coord.y - this.start_coord.y) / t;
        this.cz = this.start_coord.z;
        this.bz = (this.end_coord.z - this.start_coord.z) / t - this.az * t;
    }

    @Override
    public Coordinate getStartVelocity() {
        return new Coordinate(this.bx, this.by, this.bz);
    }

    @Override
    public Coordinate getEndVelocity() {
        return new Coordinate(this.bx, this.by, this.bz + 2.0 * this.az * this.getDuration());
    }

    @Override
    public void getCoordinate(double time, Coordinate newPosition) {
        if (time < this.start_time || time > this.end_time) {
            return;
        }
        newPosition.setCoordinate(this.cx + this.bx * (time -= this.start_time), this.cy + this.by * time, this.cz + time * (this.bz + this.az * time));
    }

    @Override
    protected Coordinate getMax2(double begin, double end) {
        double te;
        Coordinate result = null;
        double tlow = Math.max(this.start_time, begin);
        double thigh = Math.min(this.end_time, end);
        result = this.check(result, tlow, true);
        result = this.check(result, thigh, true);
        if (this.az < 0.0 && tlow < (te = -this.bz / (2.0 * this.az) + this.start_time) && te < thigh) {
            result = this.check(result, te, true);
        }
        return result;
    }

    @Override
    protected Coordinate getMin2(double begin, double end) {
        double te;
        Coordinate result = null;
        double tlow = Math.max(this.start_time, begin);
        double thigh = Math.min(this.end_time, end);
        result = this.check(result, tlow, false);
        result = this.check(result, thigh, false);
        if (this.az > 0.0 && tlow < (te = -this.by / (2.0 * this.az) + this.start_time) && te < thigh) {
            result = this.check(result, te, false);
        }
        return result;
    }
}

