/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;

public class BallProp
extends Prop {
    public static final String[] COLOR_NAMES = new String[]{"transparent", "black", "blue", "cyan", "gray", "green", "magenta", "orange", "pink", "red", "white", "yellow"};
    public static final Color[] COLOR_VALS = new Color[]{new Color(0, 0, 0, 0), Color.black, Color.blue, Color.cyan, Color.gray, Color.green, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    protected static final Color COLOR_DEF = Color.red;
    protected static final int COLORNUM_DEF = 9;
    protected static final double DIAM_DEF = 10.0;
    protected static final boolean HIGHLIGHT_DEF = false;
    protected double diam = 10.0;
    protected Color color = COLOR_DEF;
    protected int colornum = 9;
    protected boolean highlight = false;
    protected BufferedImage ballimage;
    protected double lastzoom;
    protected Dimension size;
    protected Dimension center;
    protected Dimension grip;

    @Override
    public String getType() {
        return "Ball";
    }

    @Override
    public Color getEditorColor() {
        return this.color;
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] result = new ParameterDescriptor[3];
        ArrayList<String> range = new ArrayList<String>();
        for (int i = 0; i < COLOR_NAMES.length; ++i) {
            range.add(COLOR_NAMES[i]);
        }
        result[0] = new ParameterDescriptor("color", 3, range, COLOR_NAMES[9], COLOR_NAMES[this.colornum]);
        result[1] = new ParameterDescriptor("diam", 2, null, 10.0, this.diam);
        result[2] = new ParameterDescriptor("highlight", 1, null, false, this.highlight);
        return result;
    }

    @Override
    protected void init(String st) throws JuggleExceptionUser {
        String highlightstr;
        String diamstr;
        if (st == null) {
            return;
        }
        ParameterList pl = new ParameterList(st);
        String colorstr = pl.getParameter("color");
        if (colorstr != null) {
            Color temp = null;
            if (colorstr.indexOf(44) == -1) {
                for (int i = 0; i < COLOR_NAMES.length; ++i) {
                    if (!COLOR_NAMES[i].equalsIgnoreCase(colorstr)) continue;
                    temp = COLOR_VALS[i];
                    this.colornum = i;
                    break;
                }
            } else {
                int pos;
                Object str = colorstr;
                while ((pos = ((String)str).indexOf(123)) >= 0) {
                    str = ((String)str).substring(0, pos) + ((String)str).substring(pos + 1, ((String)str).length());
                }
                while ((pos = ((String)str).indexOf(125)) >= 0) {
                    str = ((String)str).substring(0, pos) + ((String)str).substring(pos + 1, ((String)str).length());
                }
                StringTokenizer st2 = new StringTokenizer((String)str, ",", false);
                int tokens = st2.countTokens();
                if (tokens == 3 || tokens == 4) {
                    int red = 0;
                    int green = 0;
                    int blue = 0;
                    int alpha = 255;
                    String token = null;
                    try {
                        token = st2.nextToken().trim();
                        red = Integer.valueOf(token);
                        token = st2.nextToken().trim();
                        green = Integer.valueOf(token);
                        token = st2.nextToken().trim();
                        blue = Integer.valueOf(token);
                        if (tokens == 4) {
                            token = st2.nextToken().trim();
                            alpha = Integer.valueOf(token);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        String template = errorstrings.getString("Error_number_format");
                        Object[] arguments = new Object[]{token};
                        throw new JuggleExceptionUser("Ball prop color: " + MessageFormat.format(template, arguments));
                    }
                    temp = new Color(red, green, blue, alpha);
                } else {
                    throw new JuggleExceptionUser("Ball prop color: " + errorstrings.getString("Error_token_count"));
                }
            }
            if (temp != null) {
                this.color = temp;
            } else {
                String template = errorstrings.getString("Error_prop_color");
                Object[] arguments = new Object[]{colorstr};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        if ((diamstr = pl.getParameter("diam")) != null) {
            try {
                double temp = JLFunc.parseDouble(diamstr.trim());
                if (!(temp > 0.0)) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_prop_diameter"));
                }
                this.diam = temp;
            }
            catch (NumberFormatException nfe) {
                String template = errorstrings.getString("Error_number_format");
                Object[] arguments = new Object[]{"diam"};
                throw new JuggleExceptionUser("Ball prop diameter: " + MessageFormat.format(template, arguments));
            }
        }
        if ((highlightstr = pl.getParameter("highlight")) != null) {
            Boolean bhighlight = Boolean.valueOf(highlightstr);
            this.highlight = bhighlight;
        }
    }

    @Override
    public Coordinate getMax() {
        return new Coordinate(this.diam / 2.0, 0.0, this.diam / 2.0);
    }

    @Override
    public Coordinate getMin() {
        return new Coordinate(-this.diam / 2.0, 0.0, -this.diam / 2.0);
    }

    @Override
    public double getWidth() {
        return this.diam;
    }

    @Override
    public Image getProp2DImage(double zoom, double[] camangle) {
        if (this.ballimage == null || zoom != this.lastzoom) {
            this.recalc2D(zoom);
        }
        return this.ballimage;
    }

    @Override
    public Dimension getProp2DSize(double zoom) {
        if (this.size == null || zoom != this.lastzoom) {
            this.recalc2D(zoom);
        }
        return this.size;
    }

    @Override
    public Dimension getProp2DCenter(double zoom) {
        if (this.center == null || zoom != this.lastzoom) {
            this.recalc2D(zoom);
        }
        return this.center;
    }

    @Override
    public Dimension getProp2DGrip(double zoom) {
        if (this.grip == null || zoom != this.lastzoom) {
            this.recalc2D(zoom);
        }
        return this.grip;
    }

    protected void recalc2D(double zoom) {
        int ball_pixel_size = (int)(0.5 + zoom * this.diam);
        ball_pixel_size = Math.max(ball_pixel_size, 1);
        this.ballimage = new BufferedImage(ball_pixel_size + 1, ball_pixel_size + 1, 3);
        Graphics2D ballg = this.ballimage.createGraphics();
        if (this.highlight) {
            int i;
            float highlightOvals = (float)ball_pixel_size / 1.2f;
            float[] rgb = new float[]{(float)this.color.getRed() / 255.0f, (float)this.color.getGreen() / 255.0f, (float)this.color.getBlue() / 255.0f, (float)this.color.getAlpha() / 255.0f};
            for (i = 0; i < 3; ++i) {
                rgb[i] = rgb[i] / 2.5f;
            }
            ballg.setColor(new Color(rgb[0], rgb[1], rgb[2], rgb[3]));
            ballg.fillOval(0, 0, ball_pixel_size, ball_pixel_size);
            i = 0;
            while ((float)i < highlightOvals) {
                for (int j = 0; j < 3; ++j) {
                    rgb[j] = Math.min(rgb[j] + 1.0f / highlightOvals, 1.0f);
                }
                ballg.setColor(new Color(rgb[0], rgb[1], rgb[2], rgb[3]));
                ballg.fillOval((int)((double)i / 1.1), (int)((double)i / 2.5), ball_pixel_size - (int)((double)i * 1.3), ball_pixel_size - (int)((double)i * 1.3));
                ++i;
            }
        } else {
            ballg.setColor(this.color);
            ballg.fillOval(0, 0, ball_pixel_size, ball_pixel_size);
        }
        this.size = new Dimension(ball_pixel_size, ball_pixel_size);
        this.center = new Dimension(ball_pixel_size / 2, ball_pixel_size / 2);
        this.grip = new Dimension(ball_pixel_size / 2, ball_pixel_size / 2);
        this.lastzoom = zoom;
    }
}

