/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Objects;
import javax.imageio.ImageIO;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;

public class ImageProp
extends Prop {
    static URL image_url_default = ImageProp.class.getResource("/ball.png");
    protected URL url;
    protected BufferedImage image;
    protected BufferedImage scaled_image;
    protected final double WIDTH_DEF = 10.0;
    protected double width;
    protected double height;
    protected Dimension size;
    protected Dimension center;
    protected Dimension grip;
    private double last_zoom;

    public ImageProp() throws JuggleExceptionUser {
        if (image_url_default == null) {
            throw new JuggleExceptionUser("ImageProp error: Default image not set");
        }
        this.url = image_url_default;
        this.loadImage();
        this.rescaleImage(1.0);
    }

    private void loadImage() throws JuggleExceptionUser {
        try {
            MediaTracker mt = new MediaTracker(new Component(this){
                final /* synthetic */ ImageProp this$0;
                {
                    ImageProp imageProp = this$0;
                    Objects.requireNonNull(imageProp);
                    this.this$0 = imageProp;
                }
            });
            this.image = ImageIO.read(this.url);
            mt.addImage(this.image, 0);
            try {
                mt.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (mt.isErrorAny()) {
                this.image = null;
                throw new JuggleExceptionUser(errorstrings.getString("Error_bad_file"));
            }
            double aspectRatio = (double)this.image.getHeight() / (double)this.image.getWidth();
            this.width = 10.0;
            this.height = 10.0 * aspectRatio;
        }
        catch (IOException e) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_bad_file"));
        }
        catch (SecurityException se) {
            throw new JuggleExceptionUser(errorstrings.getString("Error_security_restriction"));
        }
    }

    private void rescaleImage(double zoom) {
        int image_pixel_height;
        int image_pixel_width = (int)(0.5 + zoom * this.width);
        if (image_pixel_width < 1) {
            image_pixel_width = 1;
        }
        if ((image_pixel_height = (int)(0.5 + zoom * this.height)) < 1) {
            image_pixel_height = 1;
        }
        this.size = new Dimension(image_pixel_width, image_pixel_height);
        this.center = new Dimension(image_pixel_width / 2, image_pixel_height / 2);
        int offsetx = image_pixel_width / 2;
        int offsety = image_pixel_height;
        this.grip = new Dimension(offsetx, offsety);
        this.last_zoom = zoom;
        this.scaled_image = new BufferedImage(image_pixel_width, image_pixel_height, this.image.getType());
        Graphics2D g = this.scaled_image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g.drawImage(this.image, 0, 0, image_pixel_width, image_pixel_height, 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        g.dispose();
    }

    @Override
    public String getType() {
        return "Image";
    }

    @Override
    public Color getEditorColor() {
        return Color.white;
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] result = new ParameterDescriptor[]{new ParameterDescriptor("image", 5, null, image_url_default, this.url), new ParameterDescriptor("width", 2, null, 10.0, this.width)};
        return result;
    }

    @Override
    protected void init(String st) throws JuggleExceptionUser {
        String widthstr;
        if (st == null) {
            return;
        }
        ParameterList pl = new ParameterList(st);
        String sourcestr = pl.getParameter("image");
        if (sourcestr != null) {
            try {
                this.url = new URL(sourcestr);
                this.loadImage();
            }
            catch (MalformedURLException ex) {
                throw new JuggleExceptionUser(errorstrings.getString("Error_malformed_URL"));
            }
        }
        if ((widthstr = pl.getParameter("width")) != null) {
            try {
                double temp = JLFunc.parseDouble(widthstr);
                if (!(temp > 0.0)) {
                    throw new NumberFormatException();
                }
                this.width = temp;
                double aspectRatio = (double)this.image.getHeight(null) / (double)this.image.getWidth(null);
                this.height = this.width * aspectRatio;
            }
            catch (NumberFormatException nfe) {
                String template = errorstrings.getString("Error_number_format");
                Object[] arguments = new Object[]{"width"};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
    }

    @Override
    public Image getProp2DImage(double zoom, double[] camangle) {
        if (zoom != this.last_zoom) {
            this.rescaleImage(zoom);
        }
        return this.scaled_image;
    }

    @Override
    public Coordinate getMax() {
        return new Coordinate(this.width / 2.0, 0.0, this.width);
    }

    @Override
    public Coordinate getMin() {
        return new Coordinate(-this.width / 2.0, 0.0, 0.0);
    }

    @Override
    public double getWidth() {
        return this.width;
    }

    @Override
    public Dimension getProp2DSize(double zoom) {
        if (this.size == null || zoom != this.last_zoom) {
            this.rescaleImage(zoom);
        }
        return this.size;
    }

    @Override
    public Dimension getProp2DCenter(double zoom) {
        if (this.center == null || zoom != this.last_zoom) {
            this.rescaleImage(zoom);
        }
        return this.center;
    }

    @Override
    public Dimension getProp2DGrip(double zoom) {
        if (this.grip == null || zoom != this.last_zoom) {
            this.rescaleImage(zoom);
        }
        return this.grip;
    }
}

