/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.prop;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jugglinglab.prop.Prop;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.util.ParameterDescriptor;
import jugglinglab.util.ParameterList;

public class RingProp
extends Prop {
    public static final String[] COLOR_NAMES = new String[]{"transparent", "black", "blue", "cyan", "gray", "green", "magenta", "orange", "pink", "red", "white", "yellow"};
    public static final Color[] COLOR_VALS = new Color[]{new Color(0, 0, 0, 0), Color.black, Color.blue, Color.cyan, Color.gray, Color.green, Color.magenta, Color.orange, Color.pink, Color.red, Color.white, Color.yellow};
    protected static final Color COLOR_DEF = Color.red;
    protected static final int COLORNUM_DEF = 9;
    protected static final double OUTSIDE_DIAM_DEF = 25.0;
    protected static final double INSIDE_DIAM_DEF = 20.0;
    protected static final int POLYSIDES = 200;
    protected double outside_diam = 25.0;
    protected double inside_diam = 20.0;
    protected Color color = COLOR_DEF;
    protected int colornum = 9;
    protected BufferedImage image;
    protected double lastzoom;
    protected double[] lastcamangle = new double[]{0.0, 0.0};
    protected Dimension size;
    protected Dimension center;
    protected Dimension grip;
    protected int[] px;
    protected int[] py;

    @Override
    public String getType() {
        return "Ring";
    }

    @Override
    public Color getEditorColor() {
        return this.color;
    }

    @Override
    public ParameterDescriptor[] getParameterDescriptors() {
        ParameterDescriptor[] result = new ParameterDescriptor[3];
        ArrayList<String> range = new ArrayList<String>();
        for (int i = 0; i < COLOR_NAMES.length; ++i) {
            range.add(COLOR_NAMES[i]);
        }
        result[0] = new ParameterDescriptor("color", 3, range, COLOR_NAMES[9], COLOR_NAMES[this.colornum]);
        result[1] = new ParameterDescriptor("outside", 2, null, 25.0, this.outside_diam);
        result[2] = new ParameterDescriptor("inside", 2, null, 20.0, this.inside_diam);
        return result;
    }

    @Override
    protected void init(String st) throws JuggleExceptionUser {
        String insidestr;
        String outsidestr;
        this.px = new int[200];
        this.py = new int[200];
        if (st == null) {
            return;
        }
        ParameterList pl = new ParameterList(st);
        String colorstr = pl.getParameter("color");
        if (colorstr != null) {
            Color temp = null;
            if (colorstr.indexOf(44) == -1) {
                for (int i = 0; i < COLOR_NAMES.length; ++i) {
                    if (!COLOR_NAMES[i].equalsIgnoreCase(colorstr)) continue;
                    temp = COLOR_VALS[i];
                    this.colornum = i;
                    break;
                }
            } else {
                int pos;
                Object str = colorstr;
                while ((pos = ((String)str).indexOf(123)) >= 0) {
                    str = ((String)str).substring(0, pos) + ((String)str).substring(pos + 1, ((String)str).length());
                }
                while ((pos = ((String)str).indexOf(125)) >= 0) {
                    str = ((String)str).substring(0, pos) + ((String)str).substring(pos + 1, ((String)str).length());
                }
                StringTokenizer st2 = new StringTokenizer((String)str, ",", false);
                int tokens = st2.countTokens();
                if (tokens == 3 || tokens == 4) {
                    int red = 0;
                    int green = 0;
                    int blue = 0;
                    int alpha = 255;
                    String token = null;
                    try {
                        token = st2.nextToken().trim();
                        red = Integer.valueOf(token);
                        token = st2.nextToken().trim();
                        green = Integer.valueOf(token);
                        token = st2.nextToken().trim();
                        blue = Integer.valueOf(token);
                        if (tokens == 4) {
                            token = st2.nextToken().trim();
                            alpha = Integer.valueOf(token);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        String template = errorstrings.getString("Error_number_format");
                        Object[] arguments = new Object[]{token};
                        throw new JuggleExceptionUser("Ring prop color: " + MessageFormat.format(template, arguments));
                    }
                    temp = new Color(red, green, blue, alpha);
                } else {
                    throw new JuggleExceptionUser("Ring prop color: " + errorstrings.getString("Error_token_count"));
                }
            }
            if (temp != null) {
                this.color = temp;
            } else {
                String template = errorstrings.getString("Error_prop_color");
                Object[] arguments = new Object[]{colorstr};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        if ((outsidestr = pl.getParameter("outside")) != null) {
            try {
                double temp = JLFunc.parseDouble(outsidestr);
                if (!(temp > 0.0)) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_prop_diameter"));
                }
                this.outside_diam = temp;
            }
            catch (NumberFormatException nfe) {
                String template = errorstrings.getString("Error_number_format");
                Object[] arguments = new Object[]{"diam"};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
        if ((insidestr = pl.getParameter("inside")) != null) {
            try {
                double temp = JLFunc.parseDouble(insidestr);
                if (!(temp > 0.0)) {
                    throw new JuggleExceptionUser(errorstrings.getString("Error_prop_diameter"));
                }
                this.inside_diam = temp;
            }
            catch (NumberFormatException nfe) {
                String template = errorstrings.getString("Error_number_format");
                Object[] arguments = new Object[]{"diam"};
                throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
            }
        }
    }

    @Override
    public Coordinate getMax() {
        return new Coordinate(this.outside_diam / 2.0, 0.0, this.outside_diam / 2.0);
    }

    @Override
    public Coordinate getMin() {
        return new Coordinate(-this.outside_diam / 2.0, 0.0, -this.outside_diam / 2.0);
    }

    @Override
    public double getWidth() {
        return 0.05 * this.outside_diam;
    }

    @Override
    public Image getProp2DImage(double zoom, double[] camangle) {
        if (this.image == null || zoom != this.lastzoom || camangle[0] != this.lastcamangle[0] || camangle[1] != this.lastcamangle[1]) {
            this.redrawImage(zoom, camangle);
        }
        return this.image;
    }

    @Override
    public Dimension getProp2DSize(double zoom) {
        if (this.size == null || zoom != this.lastzoom) {
            this.redrawImage(zoom, this.lastcamangle);
        }
        return this.size;
    }

    @Override
    public Dimension getProp2DCenter(double zoom) {
        if (this.center == null || zoom != this.lastzoom) {
            this.redrawImage(zoom, this.lastcamangle);
        }
        return this.center;
    }

    @Override
    public Dimension getProp2DGrip(double zoom) {
        if (this.grip == null || zoom != this.lastzoom) {
            this.redrawImage(zoom, this.lastcamangle);
        }
        return this.grip;
    }

    private void redrawImage(double zoom, double[] camangle) {
        double d;
        double term1;
        double angle;
        int inside_height;
        int outside_pixel_diam = (int)(0.5 + zoom * this.outside_diam);
        int inside_pixel_diam = (int)(0.5 + zoom * this.inside_diam);
        double c0 = Math.cos(camangle[0]);
        double s0 = Math.sin(camangle[0]);
        double s1 = Math.sin(camangle[1]);
        int width = Math.max(2, (int)((double)outside_pixel_diam * Math.abs(s0 * s1)));
        int height = Math.max(2, outside_pixel_diam);
        int inside_width = (int)((double)inside_pixel_diam * Math.abs(s0 * s1));
        if (inside_width == width) {
            inside_width -= 2;
        }
        if ((inside_height = inside_pixel_diam) == height) {
            inside_height -= 2;
        }
        double d2 = angle = (term1 = Math.sqrt(c0 * c0 / (1.0 - s0 * s0 * s1 * s1))) < 1.0 ? Math.acos(term1) : 0.0;
        if (c0 * s0 > 0.0) {
            angle = -angle;
        }
        double sa = Math.sin(angle);
        double ca = Math.cos(angle);
        int pxmin = 0;
        int pxmax = 0;
        int pymin = 0;
        int pymax = 0;
        for (int i = 0; i < 200; ++i) {
            double theta = (double)i * 2.0 * Math.PI / 200.0;
            double x = (double)width * Math.cos(theta) * 0.5;
            double y = (double)height * Math.sin(theta) * 0.5;
            this.px[i] = (int)(ca * x - sa * y + 0.5);
            this.py[i] = (int)(ca * y + sa * x + 0.5);
            if (i == 0 || this.px[i] < pxmin) {
                pxmin = this.px[i];
            }
            if (i == 0 || this.px[i] > pxmax) {
                pxmax = this.px[i];
            }
            if (i == 0 || this.py[i] < pymin) {
                pymin = this.py[i];
            }
            if (i != 0 && this.py[i] <= pymax) continue;
            pymax = this.py[i];
        }
        int bbwidth = pxmax - pxmin + 1;
        int bbheight = pymax - pymin + 1;
        this.size = new Dimension(bbwidth, bbheight);
        this.image = new BufferedImage(bbwidth, bbheight, 3);
        Graphics2D g = this.image.createGraphics();
        g.setColor(this.color);
        int i = 0;
        while (i < 200) {
            int n = i;
            this.px[n] = this.px[n] - pxmin;
            int n2 = i++;
            this.py[n2] = this.py[n2] - pymin;
        }
        g.fillPolygon(this.px, this.py, 200);
        g.setComposite(AlphaComposite.Src);
        g.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        for (i = 0; i < 200; ++i) {
            double theta = (double)i * 2.0 * Math.PI / 200.0;
            double x = (double)inside_width * Math.cos(theta) * 0.5;
            double y = (double)inside_height * Math.sin(theta) * 0.5;
            this.px[i] = (int)(ca * x - sa * y + 0.5) - pxmin;
            this.py[i] = (int)(ca * y + sa * x + 0.5) - pymin;
        }
        g.fillPolygon(this.px, this.py, 200);
        this.center = new Dimension(bbwidth / 2, bbheight / 2);
        int gripx = s0 < 0.0 ? bbwidth - 1 : 0;
        double bbw = sa * sa + ca * ca * Math.abs(s0 * s1);
        double dsq = s0 * s0 * s1 * s1 * ca * ca + sa * sa - bbw * bbw;
        double d3 = d = dsq > 0.0 ? Math.sqrt(dsq) : 0.0;
        if (c0 > 0.0) {
            d = -d;
        }
        int gripy = (int)((double)outside_pixel_diam * d) + bbheight / 2;
        this.grip = new Dimension(gripx, gripy);
        this.lastzoom = zoom;
        this.lastcamangle = new double[]{camangle[0], camangle[1]};
    }
}

