/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.renderer;

import jugglinglab.renderer.JLVector;

public class JLMatrix {
    public double m00 = 1.0;
    public double m01 = 0.0;
    public double m02 = 0.0;
    public double m03 = 0.0;
    public double m10 = 0.0;
    public double m11 = 1.0;
    public double m12 = 0.0;
    public double m13 = 0.0;
    public double m20 = 0.0;
    public double m21 = 0.0;
    public double m22 = 1.0;
    public double m23 = 0.0;
    public double m30 = 0.0;
    public double m31 = 0.0;
    public double m32 = 0.0;
    public double m33 = 1.0;

    public JLMatrix() {
    }

    public JLMatrix(JLVector right, JLVector up, JLVector forward) {
        this.m00 = right.x;
        this.m10 = right.y;
        this.m20 = right.z;
        this.m01 = up.x;
        this.m11 = up.y;
        this.m21 = up.z;
        this.m02 = forward.x;
        this.m12 = forward.y;
        this.m22 = forward.z;
    }

    public static JLMatrix shiftMatrix(double dx, double dy, double dz) {
        JLMatrix m = new JLMatrix();
        m.m03 = dx;
        m.m13 = dy;
        m.m23 = dz;
        return m;
    }

    public static JLMatrix scaleMatrix(double dx, double dy, double dz) {
        JLMatrix m = new JLMatrix();
        m.m00 = dx;
        m.m11 = dy;
        m.m22 = dz;
        return m;
    }

    public static JLMatrix scaleMatrix(double d) {
        return JLMatrix.scaleMatrix(d, d, d);
    }

    public static JLMatrix rotateMatrix(double dx, double dy, double dz) {
        double COS;
        double SIN;
        JLMatrix m;
        JLMatrix out = new JLMatrix();
        if (dx != 0.0) {
            m = new JLMatrix();
            SIN = Math.sin(dx);
            m.m11 = COS = Math.cos(dx);
            m.m12 = SIN;
            m.m21 = -SIN;
            m.m22 = COS;
            out.transform(m);
        }
        if (dy != 0.0) {
            m = new JLMatrix();
            SIN = Math.sin(dy);
            m.m00 = COS = Math.cos(dy);
            m.m02 = SIN;
            m.m20 = -SIN;
            m.m22 = COS;
            out.transform(m);
        }
        if (dz != 0.0) {
            m = new JLMatrix();
            SIN = Math.sin(dz);
            m.m00 = COS = Math.cos(dz);
            m.m01 = SIN;
            m.m10 = -SIN;
            m.m11 = COS;
            out.transform(m);
        }
        return out;
    }

    public void shift(double dx, double dy, double dz) {
        this.transform(JLMatrix.shiftMatrix(dx, dy, dz));
    }

    public void scale(double dx, double dy, double dz) {
        this.transform(JLMatrix.scaleMatrix(dx, dy, dz));
    }

    public void scale(double d) {
        this.transform(JLMatrix.scaleMatrix(d));
    }

    public void rotate(double dx, double dy, double dz) {
        this.transform(JLMatrix.rotateMatrix(dx, dy, dz));
    }

    public void transform(JLMatrix n) {
        JLMatrix m = this.getClone();
        this.m00 = n.m00 * m.m00 + n.m01 * m.m10 + n.m02 * m.m20;
        this.m01 = n.m00 * m.m01 + n.m01 * m.m11 + n.m02 * m.m21;
        this.m02 = n.m00 * m.m02 + n.m01 * m.m12 + n.m02 * m.m22;
        this.m03 = n.m00 * m.m03 + n.m01 * m.m13 + n.m02 * m.m23 + n.m03;
        this.m10 = n.m10 * m.m00 + n.m11 * m.m10 + n.m12 * m.m20;
        this.m11 = n.m10 * m.m01 + n.m11 * m.m11 + n.m12 * m.m21;
        this.m12 = n.m10 * m.m02 + n.m11 * m.m12 + n.m12 * m.m22;
        this.m13 = n.m10 * m.m03 + n.m11 * m.m13 + n.m12 * m.m23 + n.m13;
        this.m20 = n.m20 * m.m00 + n.m21 * m.m10 + n.m22 * m.m20;
        this.m21 = n.m20 * m.m01 + n.m21 * m.m11 + n.m22 * m.m21;
        this.m22 = n.m20 * m.m02 + n.m21 * m.m12 + n.m22 * m.m22;
        this.m23 = n.m20 * m.m03 + n.m21 * m.m13 + n.m22 * m.m23 + n.m23;
    }

    public JLMatrix getClone() {
        JLMatrix m = new JLMatrix();
        m.m00 = this.m00;
        m.m01 = this.m01;
        m.m02 = this.m02;
        m.m03 = this.m03;
        m.m10 = this.m10;
        m.m11 = this.m11;
        m.m12 = this.m12;
        m.m13 = this.m13;
        m.m20 = this.m20;
        m.m21 = this.m21;
        m.m22 = this.m22;
        m.m23 = this.m23;
        m.m30 = this.m30;
        m.m31 = this.m31;
        m.m32 = this.m32;
        m.m33 = this.m33;
        return m;
    }

    public JLMatrix inverse() {
        JLMatrix m = new JLMatrix();
        double q1 = this.m12;
        double q6 = this.m10 * this.m01;
        double q7 = this.m10 * this.m21;
        double q8 = this.m02;
        double q13 = this.m20 * this.m01;
        double q14 = this.m20 * this.m11;
        double q21 = this.m02 * this.m21;
        double q22 = this.m03 * this.m21;
        double q25 = this.m01 * this.m12;
        double q26 = this.m01 * this.m13;
        double q27 = this.m02 * this.m11;
        double q28 = this.m03 * this.m11;
        double q29 = this.m10 * this.m22;
        double q30 = this.m10 * this.m23;
        double q31 = this.m20 * this.m12;
        double q32 = this.m20 * this.m13;
        double q35 = this.m00 * this.m22;
        double q36 = this.m00 * this.m23;
        double q37 = this.m20 * this.m02;
        double q38 = this.m20 * this.m03;
        double q41 = this.m00 * this.m12;
        double q42 = this.m00 * this.m13;
        double q43 = this.m10 * this.m02;
        double q44 = this.m10 * this.m03;
        double q45 = this.m00 * this.m11;
        double q48 = this.m00 * this.m21;
        double q49 = q45 * this.m22 - q48 * q1 - q6 * this.m22 + q7 * q8;
        double q50 = q13 * q1 - q14 * q8;
        double q51 = 1.0 / (q49 + q50);
        m.m00 = (this.m11 * this.m22 * this.m33 - this.m11 * this.m23 * this.m32 - this.m21 * this.m12 * this.m33 + this.m21 * this.m13 * this.m32 + this.m31 * this.m12 * this.m23 - this.m31 * this.m13 * this.m22) * q51;
        m.m01 = -(this.m01 * this.m22 * this.m33 - this.m01 * this.m23 * this.m32 - q21 * this.m33 + q22 * this.m32) * q51;
        m.m02 = (q25 * this.m33 - q26 * this.m32 - q27 * this.m33 + q28 * this.m32) * q51;
        m.m03 = -(q25 * this.m23 - q26 * this.m22 - q27 * this.m23 + q28 * this.m22 + q21 * this.m13 - q22 * this.m12) * q51;
        m.m10 = -(q29 * this.m33 - q30 * this.m32 - q31 * this.m33 + q32 * this.m32) * q51;
        m.m11 = (q35 * this.m33 - q36 * this.m32 - q37 * this.m33 + q38 * this.m32) * q51;
        m.m12 = -(q41 * this.m33 - q42 * this.m32 - q43 * this.m33 + q44 * this.m32) * q51;
        m.m13 = (q41 * this.m23 - q42 * this.m22 - q43 * this.m23 + q44 * this.m22 + q37 * this.m13 - q38 * this.m12) * q51;
        m.m20 = (q7 * this.m33 - q30 * this.m31 - q14 * this.m33 + q32 * this.m31) * q51;
        m.m21 = -(q48 * this.m33 - q36 * this.m31 - q13 * this.m33 + q38 * this.m31) * q51;
        m.m22 = (q45 * this.m33 - q42 * this.m31 - q6 * this.m33 + q44 * this.m31) * q51;
        m.m23 = -(q45 * this.m23 - q42 * this.m21 - q6 * this.m23 + q44 * this.m21 + q13 * this.m13 - q38 * this.m11) * q51;
        return m;
    }
}

