/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.renderer;

import jugglinglab.renderer.JLMatrix;
import jugglinglab.util.Coordinate;

public class JLVector {
    public double x;
    public double y;
    public double z;

    public JLVector() {
    }

    public JLVector(double xpos, double ypos, double zpos) {
        this.x = xpos;
        this.y = ypos;
        this.z = zpos;
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public JLVector transform(JLMatrix m) {
        double newx = this.x * m.m00 + this.y * m.m01 + this.z * m.m02 + m.m03;
        double newy = this.x * m.m10 + this.y * m.m11 + this.z * m.m12 + m.m13;
        double newz = this.x * m.m20 + this.y * m.m21 + this.z * m.m22 + m.m23;
        return new JLVector(newx, newy, newz);
    }

    public static JLVector add(JLVector a, JLVector b) {
        return new JLVector(a.x + b.x, a.y + b.y, a.z + b.z);
    }

    public static JLVector sub(JLVector a, JLVector b) {
        return new JLVector(a.x - b.x, a.y - b.y, a.z - b.z);
    }

    public static JLVector scale(double f, JLVector a) {
        return new JLVector(f * a.x, f * a.y, f * a.z);
    }

    public static JLVector fromCoordinate(Coordinate c, JLVector result) {
        result.x = c.x;
        result.y = c.z;
        result.z = c.y;
        return result;
    }
}

