/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.renderer;

import jugglinglab.jml.JMLPattern;
import jugglinglab.renderer.JLVector;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;

public class Juggler {
    public static final double SHOULDER_HW = 23.0;
    public static final double SHOULDER_H = 40.0;
    public static final double WAIST_HW = 17.0;
    public static final double WAIST_H = -5.0;
    public static final double HAND_OUT = 5.0;
    public static final double HAND_IN = 5.0;
    public static final double HEAD_HW = 10.0;
    public static final double HEAD_H = 26.0;
    public static final double NECK_H = 5.0;
    public static final double SHOULDER_Y = 0.0;
    public static final double PATTERN_Y = 30.0;
    public static final double UPPER_LENGTH = 41.0;
    public static final double LOWER_LENGTH = 40.0;
    public static final double LOWER_GAP_WRIST = 1.0;
    public static final double LOWER_GAP_ELBOW = 0.0;
    public static final double LOWER_HAND_HEIGHT = 0.0;
    public static final double UPPER_GAP_ELBOW = 0.0;
    public static final double UPPER_GAP_SHOULDER = 0.0;
    protected static final double LOWER_TOTAL = 41.0;
    protected static final double UPPER_TOTAL = 41.0;

    public static void findJugglerCoordinates(JMLPattern pat, double time, JLVector[][] result) throws JuggleExceptionInternal {
        for (int juggler = 1; juggler <= pat.getNumberOfJugglers(); ++juggler) {
            JLVector rightelbow;
            JLVector leftelbow;
            Coordinate coord0 = new Coordinate();
            Coordinate coord1 = new Coordinate();
            Coordinate coord2 = new Coordinate();
            pat.getHandCoordinate(juggler, 1, time, coord0);
            pat.getHandCoordinate(juggler, 2, time, coord1);
            JLVector lefthand = new JLVector(coord0.x, coord0.z + 0.0, coord0.y);
            JLVector righthand = new JLVector(coord1.x, coord1.z + 0.0, coord1.y);
            pat.getJugglerPosition(juggler, time, coord2);
            double angle = Math.toRadians(pat.getJugglerAngle(juggler, time));
            double s = Math.sin(angle);
            double c = Math.cos(angle);
            JLVector leftshoulder = new JLVector(coord2.x - 23.0 * c - 0.0 * s, coord2.z + 40.0, coord2.y - 23.0 * s + 0.0 * c);
            JLVector rightshoulder = new JLVector(coord2.x + 23.0 * c - 0.0 * s, coord2.z + 40.0, coord2.y + 23.0 * s + 0.0 * c);
            JLVector leftwaist = new JLVector(coord2.x - 17.0 * c - 0.0 * s, coord2.z + -5.0, coord2.y - 17.0 * s + 0.0 * c);
            JLVector rightwaist = new JLVector(coord2.x + 17.0 * c - 0.0 * s, coord2.z + -5.0, coord2.y + 17.0 * s + 0.0 * c);
            JLVector leftheadbottom = new JLVector(coord2.x - 10.0 * c - 0.0 * s, coord2.z + 40.0 + 5.0, coord2.y - 10.0 * s + 0.0 * c);
            JLVector leftheadtop = new JLVector(coord2.x - 10.0 * c - 0.0 * s, coord2.z + 40.0 + 5.0 + 26.0, coord2.y - 10.0 * s + 0.0 * c);
            JLVector rightheadbottom = new JLVector(coord2.x + 10.0 * c - 0.0 * s, coord2.z + 40.0 + 5.0, coord2.y + 10.0 * s + 0.0 * c);
            JLVector rightheadtop = new JLVector(coord2.x + 10.0 * c - 0.0 * s, coord2.z + 40.0 + 5.0 + 26.0, coord2.y + 10.0 * s + 0.0 * c);
            double L = 41.0;
            double U = 41.0;
            JLVector deltaL = JLVector.sub(lefthand, leftshoulder);
            double D = deltaL.length();
            if (D <= L + U) {
                double Lr = Math.sqrt((4.0 * U * U * L * L - (U * U + L * L - D * D) * (U * U + L * L - D * D)) / (4.0 * D * D));
                if (Double.isNaN(Lr)) {
                    throw new JuggleExceptionInternal("NaN in renderer 1");
                }
                double factor = Math.sqrt(U * U - Lr * Lr) / D;
                if (Double.isNaN(factor)) {
                    throw new JuggleExceptionInternal("NaN in renderer 2");
                }
                JLVector Lxsc = JLVector.scale(factor, deltaL);
                double Lalpha = Math.asin(deltaL.y / D);
                if (Double.isNaN(Lalpha)) {
                    throw new JuggleExceptionInternal("NaN in renderer 3");
                }
                factor = 1.0 + Lr * Math.tan(Lalpha) / (factor * D);
                leftelbow = new JLVector(leftshoulder.x + Lxsc.x * factor, leftshoulder.y + Lxsc.y - Lr * Math.cos(Lalpha), leftshoulder.z + Lxsc.z * factor);
            } else {
                leftelbow = null;
            }
            JLVector deltaR = JLVector.sub(righthand, rightshoulder);
            D = deltaR.length();
            if (D <= L + U) {
                double Rr = Math.sqrt((4.0 * U * U * L * L - (U * U + L * L - D * D) * (U * U + L * L - D * D)) / (4.0 * D * D));
                if (Double.isNaN(Rr)) {
                    throw new JuggleExceptionInternal("NaN in renderer 4");
                }
                double factor = Math.sqrt(U * U - Rr * Rr) / D;
                if (Double.isNaN(factor)) {
                    throw new JuggleExceptionInternal("NaN in renderer 5");
                }
                JLVector Rxsc = JLVector.scale(factor, deltaR);
                double Ralpha = Math.asin(deltaR.y / D);
                if (Double.isNaN(Ralpha)) {
                    throw new JuggleExceptionInternal("NaN in renderer 6");
                }
                factor = 1.0 + Rr * Math.tan(Ralpha) / (factor * D);
                rightelbow = new JLVector(rightshoulder.x + Rxsc.x * factor, rightshoulder.y + Rxsc.y - Rr * Math.cos(Ralpha), rightshoulder.z + Rxsc.z * factor);
            } else {
                rightelbow = null;
            }
            result[juggler - 1][0] = lefthand;
            result[juggler - 1][1] = righthand;
            result[juggler - 1][2] = leftshoulder;
            result[juggler - 1][3] = rightshoulder;
            result[juggler - 1][4] = leftelbow;
            result[juggler - 1][5] = rightelbow;
            result[juggler - 1][6] = leftwaist;
            result[juggler - 1][7] = rightwaist;
            result[juggler - 1][8] = leftheadbottom;
            result[juggler - 1][9] = leftheadtop;
            result[juggler - 1][10] = rightheadbottom;
            result[juggler - 1][11] = rightheadtop;
        }
    }
}

