/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.renderer;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Objects;
import jugglinglab.jml.JMLPattern;
import jugglinglab.prop.Prop;
import jugglinglab.renderer.JLMatrix;
import jugglinglab.renderer.JLVector;
import jugglinglab.renderer.Juggler;
import jugglinglab.renderer.Renderer;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;

public class Renderer2D
extends Renderer {
    public static final int RENDER_POINT_FIELD = 0;
    public static final int RENDER_WIRE_FRAME = 1;
    public static final int RENDER_FLAT_SOLID = 2;
    protected int render_type = 2;
    protected Color background = Color.white;
    protected Coordinate left;
    protected Coordinate right;
    protected JLVector cameracenter;
    protected double[] cameraangle = new double[2];
    protected JLMatrix m;
    protected int width;
    protected int height;
    protected Rectangle viewport;
    protected JMLPattern pat;
    protected double zoom;
    protected double zoom_orig;
    protected double zoomfactor;
    protected int originx;
    protected int originz;
    protected int polysides = 40;
    protected double[] headcos = new double[this.polysides];
    protected double[] headsin = new double[this.polysides];
    protected int[] headx = new int[this.polysides];
    protected int[] heady = new int[this.polysides];
    protected DrawObject2D[] obj;
    protected DrawObject2D[] obj2;
    protected JLVector[][] jugglervec;
    protected double propmin;
    protected Coordinate tempc;
    protected JLVector tempv1;
    protected JLVector tempv2;

    public Renderer2D() {
        for (int i = 0; i < this.polysides; ++i) {
            this.headcos[i] = Math.cos((double)i * 2.0 * Math.PI / (double)this.polysides);
            this.headsin[i] = Math.sin((double)i * 2.0 * Math.PI / (double)this.polysides);
        }
        this.tempc = new Coordinate();
        this.tempv1 = new JLVector();
        this.tempv2 = new JLVector();
        this.zoomfactor = 1.0;
    }

    @Override
    public void setPattern(JMLPattern p) {
        this.pat = p;
        int maxobjects = 5 * this.pat.getNumberOfJugglers() + this.pat.getNumberOfPaths() + 18;
        this.obj = new DrawObject2D[maxobjects];
        for (int i = 0; i < maxobjects; ++i) {
            this.obj[i] = new DrawObject2D(this, maxobjects);
        }
        this.obj2 = new DrawObject2D[maxobjects];
        this.jugglervec = new JLVector[this.pat.getNumberOfJugglers()][12];
    }

    @Override
    public Color getBackground() {
        return this.background;
    }

    @Override
    public void initDisplay(Dimension dim, int border, Coordinate overallmax, Coordinate overallmin) {
        this.width = dim.width;
        this.height = dim.height;
        this.viewport = new Rectangle(border, border, this.width - 2 * border, this.height - 2 * border);
        Coordinate adjusted_max = new Coordinate(overallmax);
        Coordinate adjusted_min = new Coordinate(overallmin);
        boolean ORIGINAL_ZOOM = true;
        if (this.pat.getNumberOfJugglers() == 1) {
            adjusted_min.z -= 0.3 * Math.max(Math.abs(adjusted_min.y), Math.abs(adjusted_max.y));
            adjusted_max.z += 5.0;
        } else {
            double tempx = Math.max(Math.abs(adjusted_min.x), Math.abs(adjusted_max.x));
            double tempy = Math.max(Math.abs(adjusted_min.y), Math.abs(adjusted_max.y));
            adjusted_min.z -= 0.4 * Math.max(tempx, tempy);
            adjusted_max.z += 0.4 * Math.max(tempx, tempy);
        }
        double maxabsx = Math.max(Math.abs(adjusted_min.x), Math.abs(adjusted_max.x));
        adjusted_min.x = -maxabsx;
        adjusted_max.x = maxabsx;
        this.zoom_orig = Math.min((double)this.viewport.width / (adjusted_max.x - adjusted_min.x), (double)this.viewport.height / (adjusted_max.z - adjusted_min.z));
        this.cameracenter = new JLVector(0.5 * (adjusted_max.x + adjusted_min.x), 0.5 * (adjusted_max.z + adjusted_min.z), 0.5 * (adjusted_max.y + adjusted_min.y));
        this.setZoomLevel(this.getZoomLevel());
    }

    @Override
    public double getZoomLevel() {
        return this.zoomfactor;
    }

    @Override
    public void setZoomLevel(double z) {
        this.zoomfactor = z;
        this.zoom = this.zoom_orig * this.zoomfactor;
        this.originx = this.viewport.x + (int)Math.round(0.5 * (double)this.viewport.width - this.zoom * this.cameracenter.x);
        this.originz = this.viewport.y + (int)Math.round(0.5 * (double)this.viewport.height + this.zoom * this.cameracenter.y);
        this.calculateCameraMatrix();
    }

    @Override
    public void setCameraAngle(double[] camangle) {
        this.cameraangle[0] = camangle[0];
        this.cameraangle[1] = camangle[1];
        if (this.cameracenter == null) {
            return;
        }
        this.calculateCameraMatrix();
    }

    protected void calculateCameraMatrix() {
        this.m = JLMatrix.shiftMatrix(-this.cameracenter.x, -this.cameracenter.y, -this.cameracenter.z);
        this.m.transform(JLMatrix.rotateMatrix(0.0, Math.PI - this.cameraangle[0], 0.0));
        this.m.transform(JLMatrix.rotateMatrix(1.5707963267948966 - this.cameraangle[1], 0.0, 0.0));
        this.m.transform(JLMatrix.shiftMatrix(this.cameracenter.x, this.cameracenter.y, this.cameracenter.z));
        this.m.transform(JLMatrix.scaleMatrix(1.0, -1.0, 1.0));
        this.m.transform(JLMatrix.scaleMatrix(this.zoom));
        this.m.transform(JLMatrix.shiftMatrix(this.originx, this.originz, 0.0));
    }

    @Override
    public double[] getCameraAngle() {
        double[] ca = new double[]{this.cameraangle[0], this.cameraangle[1]};
        return ca;
    }

    @Override
    public int[] getXY(Coordinate c) {
        return this.getXY(new JLVector(c.x, c.z, c.y));
    }

    protected int[] getXY(JLVector vec) {
        JLVector v = vec.transform(this.m);
        int[] val = new int[]{(int)Math.round(v.x), (int)Math.round(v.y)};
        return val;
    }

    protected JLVector getXYZ(JLVector vec, JLVector result) {
        result.x = vec.x * this.m.m00 + vec.y * this.m.m01 + vec.z * this.m.m02 + this.m.m03;
        result.y = vec.x * this.m.m10 + vec.y * this.m.m11 + vec.z * this.m.m12 + this.m.m13;
        result.z = vec.x * this.m.m20 + vec.y * this.m.m21 + vec.z * this.m.m22 + this.m.m23;
        return result;
    }

    @Override
    public Coordinate getScreenTranslatedCoordinate(Coordinate c, int dx, int dy) {
        JLVector v = new JLVector(c.x, c.z, c.y);
        JLVector s = v.transform(this.m);
        JLVector news = JLVector.add(s, new JLVector(dx, dy, 0.0));
        JLVector newv = news.transform(this.m.inverse());
        return new Coordinate(newv.x, newv.z, newv.y);
    }

    @Override
    public void drawFrame(double time, int[] pnum, int[] hideJugglers, Graphics g) throws JuggleExceptionInternal {
        int i;
        int y;
        int x;
        int i2;
        int numobjects = 5 * this.pat.getNumberOfJugglers() + this.pat.getNumberOfPaths() + 18;
        for (int i3 = 0; i3 < numobjects; ++i3) {
            this.obj[i3].covering.clear();
        }
        int index = 0;
        double propmin = 0.0;
        for (i2 = 1; i2 <= this.pat.getNumberOfPaths(); ++i2) {
            this.obj[index].type = 1;
            this.obj[index].number = i2;
            this.pat.getPathCoordinate(i2, time, this.tempc);
            if (!this.tempc.isValid()) {
                this.tempc.setCoordinate(0.0, 0.0, 0.0);
            }
            this.getXYZ(JLVector.fromCoordinate(this.tempc, this.tempv1), this.obj[index].coord[0]);
            x = (int)Math.round(this.obj[index].coord[0].x);
            y = (int)Math.round(this.obj[index].coord[0].y);
            Prop pr = this.pat.getProp(pnum[i2 - 1]);
            if (pr.getProp2DImage(this.zoom, this.cameraangle) != null) {
                Dimension center = pr.getProp2DCenter(this.zoom);
                Dimension size = pr.getProp2DSize(this.zoom);
                this.obj[index].boundingbox.x = x - center.width;
                this.obj[index].boundingbox.y = y - center.height;
                this.obj[index].boundingbox.width = size.width;
                this.obj[index].boundingbox.height = size.height;
            }
            propmin = Math.min(propmin, pr.getMin().z);
            ++index;
        }
        if (this.showground) {
            for (i2 = 0; i2 < 18; ++i2) {
                this.obj[index].type = 3;
                this.obj[index].number = 0;
                if (i2 < 9) {
                    this.tempv1.x = -50.0 + 100.0 * (double)i2 / 8.0;
                    this.tempv1.z = -50.0;
                    this.tempv2.x = this.tempv1.x;
                    this.tempv2.z = 50.0;
                } else {
                    this.tempv1.x = -50.0;
                    this.tempv1.z = -50.0 + 100.0 * (double)(i2 - 9) / 8.0;
                    this.tempv2.x = 50.0;
                    this.tempv2.z = this.tempv1.z;
                }
                this.tempv1.y = this.tempv2.y = propmin;
                this.getXYZ(this.tempv1, this.obj[index].coord[0]);
                this.getXYZ(this.tempv2, this.obj[index].coord[1]);
                x = Math.min((int)Math.round(this.obj[index].coord[0].x), (int)Math.round(this.obj[index].coord[1].x));
                y = Math.min((int)Math.round(this.obj[index].coord[0].y), (int)Math.round(this.obj[index].coord[1].y));
                int width = Math.abs((int)Math.round(this.obj[index].coord[0].x) - (int)Math.round(this.obj[index].coord[1].x)) + 1;
                int height = Math.abs((int)Math.round(this.obj[index].coord[0].y) - (int)Math.round(this.obj[index].coord[1].y)) + 1;
                this.obj[index].boundingbox.x = x;
                this.obj[index].boundingbox.y = y;
                this.obj[index].boundingbox.width = width;
                this.obj[index].boundingbox.height = height;
                ++index;
            }
        }
        Juggler.findJugglerCoordinates(this.pat, time, this.jugglervec);
        for (i2 = 1; i2 <= this.pat.getNumberOfJugglers(); ++i2) {
            int y2;
            int x2;
            int j;
            int ymax;
            int xmax;
            if (hideJugglers != null) {
                boolean hide = false;
                for (int j2 = 0; j2 < hideJugglers.length; ++j2) {
                    if (hideJugglers[j2] != i2) continue;
                    hide = true;
                }
                if (hide) continue;
            }
            this.obj[index].type = 2;
            this.obj[index].number = i2;
            this.getXYZ(this.jugglervec[i2 - 1][2], this.obj[index].coord[0]);
            this.getXYZ(this.jugglervec[i2 - 1][3], this.obj[index].coord[1]);
            this.getXYZ(this.jugglervec[i2 - 1][7], this.obj[index].coord[2]);
            this.getXYZ(this.jugglervec[i2 - 1][6], this.obj[index].coord[3]);
            this.getXYZ(this.jugglervec[i2 - 1][8], this.obj[index].coord[4]);
            this.getXYZ(this.jugglervec[i2 - 1][9], this.obj[index].coord[5]);
            this.getXYZ(this.jugglervec[i2 - 1][10], this.obj[index].coord[6]);
            this.getXYZ(this.jugglervec[i2 - 1][11], this.obj[index].coord[7]);
            int xmin = xmax = (int)Math.round(this.obj[index].coord[0].x);
            int ymin = ymax = (int)Math.round(this.obj[index].coord[0].y);
            for (j = 1; j < 8; ++j) {
                x2 = (int)Math.round(this.obj[index].coord[j].x);
                y2 = (int)Math.round(this.obj[index].coord[j].y);
                if (x2 < xmin) {
                    xmin = x2;
                }
                if (x2 > xmax) {
                    xmax = x2;
                }
                if (y2 < ymin) {
                    ymin = y2;
                }
                if (y2 <= ymax) continue;
                ymax = y2;
            }
            this.obj[index].boundingbox.x = xmin + 1;
            this.obj[index].boundingbox.y = ymin + 1;
            this.obj[index].boundingbox.width = xmax - xmin - 1;
            this.obj[index].boundingbox.height = ymax - ymin - 1;
            ++index;
            for (j = 0; j < 2; ++j) {
                int height;
                int width;
                if (this.jugglervec[i2 - 1][4 + j] == null) {
                    this.obj[index].type = 3;
                    this.obj[index].number = i2;
                    this.getXYZ(this.jugglervec[i2 - 1][2 + j], this.obj[index].coord[0]);
                    this.getXYZ(this.jugglervec[i2 - 1][0 + j], this.obj[index].coord[1]);
                    x2 = Math.min((int)Math.round(this.obj[index].coord[0].x), (int)Math.round(this.obj[index].coord[1].x));
                    y2 = Math.min((int)Math.round(this.obj[index].coord[0].y), (int)Math.round(this.obj[index].coord[1].y));
                    width = Math.abs((int)Math.round(this.obj[index].coord[0].x) - (int)Math.round(this.obj[index].coord[1].x)) + 1;
                    height = Math.abs((int)Math.round(this.obj[index].coord[0].y) - (int)Math.round(this.obj[index].coord[1].y)) + 1;
                    this.obj[index].boundingbox.x = x2;
                    this.obj[index].boundingbox.y = y2;
                    this.obj[index].boundingbox.width = width;
                    this.obj[index].boundingbox.height = height;
                    ++index;
                    continue;
                }
                this.obj[index].type = 3;
                this.obj[index].number = i2;
                this.getXYZ(this.jugglervec[i2 - 1][2 + j], this.obj[index].coord[0]);
                this.getXYZ(this.jugglervec[i2 - 1][4 + j], this.obj[index].coord[1]);
                x2 = Math.min((int)Math.round(this.obj[index].coord[0].x), (int)Math.round(this.obj[index].coord[1].x));
                y2 = Math.min((int)Math.round(this.obj[index].coord[0].y), (int)Math.round(this.obj[index].coord[1].y));
                width = Math.abs((int)Math.round(this.obj[index].coord[0].x) - (int)Math.round(this.obj[index].coord[1].x)) + 1;
                height = Math.abs((int)Math.round(this.obj[index].coord[0].y) - (int)Math.round(this.obj[index].coord[1].y)) + 1;
                this.obj[index].boundingbox.x = x2;
                this.obj[index].boundingbox.y = y2;
                this.obj[index].boundingbox.width = width;
                this.obj[index].boundingbox.height = height;
                this.obj[++index].type = 3;
                this.obj[index].number = i2;
                this.getXYZ(this.jugglervec[i2 - 1][4 + j], this.obj[index].coord[0]);
                this.getXYZ(this.jugglervec[i2 - 1][0 + j], this.obj[index].coord[1]);
                x2 = Math.min((int)Math.round(this.obj[index].coord[0].x), (int)Math.round(this.obj[index].coord[1].x));
                y2 = Math.min((int)Math.round(this.obj[index].coord[0].y), (int)Math.round(this.obj[index].coord[1].y));
                width = Math.abs((int)Math.round(this.obj[index].coord[0].x) - (int)Math.round(this.obj[index].coord[1].x)) + 1;
                height = Math.abs((int)Math.round(this.obj[index].coord[0].y) - (int)Math.round(this.obj[index].coord[1].y)) + 1;
                this.obj[index].boundingbox.x = x2;
                this.obj[index].boundingbox.y = y2;
                this.obj[index].boundingbox.width = width;
                this.obj[index].boundingbox.height = height;
                ++index;
            }
        }
        numobjects = index;
        for (i2 = 0; i2 < numobjects; ++i2) {
            for (int j = 0; j < numobjects; ++j) {
                if (j == i2 || !this.obj[i2].isCovering(this.obj[j])) continue;
                this.obj[i2].covering.add(this.obj[j]);
            }
            this.obj[i2].drawn = false;
        }
        index = 0;
        boolean changed = true;
        while (changed) {
            changed = false;
            for (i = 0; i < numobjects; ++i) {
                if (this.obj[i].drawn) continue;
                boolean candraw = true;
                for (int j = 0; j < this.obj[i].covering.size(); ++j) {
                    DrawObject2D temp = this.obj[i].covering.get(j);
                    if (temp.drawn) continue;
                    candraw = false;
                    break;
                }
                if (!candraw) continue;
                this.obj2[index] = this.obj[i];
                this.obj[i].drawn = true;
                ++index;
                changed = true;
            }
        }
        for (i = 0; i < numobjects; ++i) {
            if (this.obj[i].drawn) continue;
            this.obj2[index] = this.obj[i];
            this.obj[i].drawn = true;
            ++index;
        }
        block18: for (i = 0; i < numobjects; ++i) {
            DrawObject2D ob = this.obj2[i];
            switch (ob.type) {
                case 1: {
                    Prop pr = this.pat.getProp(pnum[ob.number - 1]);
                    int x3 = (int)Math.round(ob.coord[0].x);
                    int y3 = (int)Math.round(ob.coord[0].y);
                    Image propimage = pr.getProp2DImage(this.zoom, this.cameraangle);
                    if (propimage == null) continue block18;
                    Dimension grip = pr.getProp2DGrip(this.zoom);
                    g.drawImage(propimage, x3 - grip.width, y3 - grip.height, null);
                    continue block18;
                }
                case 2: {
                    int[] bodyx = new int[4];
                    int[] bodyy = new int[4];
                    for (int j = 0; j < 4; ++j) {
                        bodyx[j] = (int)Math.round(ob.coord[j].x);
                        bodyy[j] = (int)Math.round(ob.coord[j].y);
                    }
                    g.setColor(this.background);
                    g.fillPolygon(bodyx, bodyy, 4);
                    g.setColor(Color.black);
                    g.drawPolygon(bodyx, bodyy, 4);
                    double LheadBx = ob.coord[4].x;
                    double LheadBy = ob.coord[4].y;
                    double LheadTy = ob.coord[5].y;
                    double RheadBx = ob.coord[6].x;
                    double RheadBy = ob.coord[6].y;
                    if (Math.abs(RheadBx - LheadBx) > 2.0) {
                        for (int j = 0; j < this.polysides; ++j) {
                            this.headx[j] = (int)Math.round(0.5 * (LheadBx + RheadBx + this.headcos[j] * (RheadBx - LheadBx)));
                            this.heady[j] = (int)Math.round(0.5 * (LheadBy + LheadTy + this.headsin[j] * (LheadBy - LheadTy)) + ((double)this.headx[j] - LheadBx) * (RheadBy - LheadBy) / (RheadBx - LheadBx));
                        }
                        g.setColor(this.background);
                        g.fillPolygon(this.headx, this.heady, this.polysides);
                        g.setColor(Color.black);
                        g.drawPolygon(this.headx, this.heady, this.polysides);
                        continue block18;
                    }
                    double h = Math.sqrt((LheadBy - LheadTy) * (LheadBy - LheadTy) + (RheadBy - LheadBy) * (RheadBy - LheadBy));
                    int headx = (int)Math.round(0.5 * (LheadBx + RheadBx));
                    int heady1 = (int)Math.round(0.5 * (LheadTy + RheadBy + h));
                    int heady2 = (int)Math.round(0.5 * (LheadTy + RheadBy - h));
                    g.setColor(Color.black);
                    g.drawLine(headx, heady1, headx, heady2);
                    continue block18;
                }
                case 3: {
                    g.setColor(Color.black);
                    int x1 = (int)Math.round(ob.coord[0].x);
                    int y1 = (int)Math.round(ob.coord[0].y);
                    int x2 = (int)Math.round(ob.coord[1].x);
                    int y2 = (int)Math.round(ob.coord[1].y);
                    g.drawLine(x1, y1, x2, y2);
                }
            }
        }
    }

    @Override
    public Coordinate getHandWindowMax() {
        return new Coordinate(5.0, 0.0, 1.0);
    }

    @Override
    public Coordinate getHandWindowMin() {
        return new Coordinate(-5.0, 0.0, -1.0);
    }

    @Override
    public Coordinate getJugglerWindowMax() {
        Coordinate max = this.pat.getJugglerMax(1);
        for (int i = 2; i <= this.pat.getNumberOfJugglers(); ++i) {
            max = Coordinate.max(max, this.pat.getJugglerMax(i));
        }
        max = Coordinate.add(max, new Coordinate(23.0, 23.0, 71.0));
        return max;
    }

    @Override
    public Coordinate getJugglerWindowMin() {
        Coordinate min = this.pat.getJugglerMin(1);
        for (int i = 2; i <= this.pat.getNumberOfJugglers(); ++i) {
            min = Coordinate.min(min, this.pat.getJugglerMin(i));
        }
        min = Coordinate.add(min, new Coordinate(-23.0, -23.0, 0.0));
        return min;
    }

    class DrawObject2D {
        public static final int TYPE_PROP = 1;
        public static final int TYPE_BODY = 2;
        public static final int TYPE_LINE = 3;
        protected static final double SLOP = 3.0;
        public int type;
        public int number;
        public JLVector[] coord;
        public Rectangle boundingbox;
        public ArrayList<DrawObject2D> covering;
        public boolean drawn;
        public JLVector tempv;

        public DrawObject2D(Renderer2D this$0, int numobjects) {
            Objects.requireNonNull(this$0);
            this.coord = new JLVector[8];
            for (int i = 0; i < 8; ++i) {
                this.coord[i] = new JLVector();
            }
            this.boundingbox = new Rectangle();
            this.covering = new ArrayList(numobjects);
            this.tempv = new JLVector();
        }

        public boolean isCovering(DrawObject2D obj) {
            if (!this.boundingbox.intersects(obj.boundingbox)) {
                return false;
            }
            switch (this.type) {
                case 1: {
                    switch (obj.type) {
                        case 1: {
                            return this.coord[0].z < obj.coord[0].z;
                        }
                        case 2: {
                            this.vectorProduct(obj.coord[0], obj.coord[1], obj.coord[2], this.tempv);
                            if (this.tempv.z == 0.0) {
                                return false;
                            }
                            double z = obj.coord[0].z - (this.tempv.x * (this.coord[0].x - obj.coord[0].x) + this.tempv.y * (this.coord[0].y - obj.coord[0].y)) / this.tempv.z;
                            return this.coord[0].z < z;
                        }
                        case 3: {
                            return this.isBoxCoveringLine(this, obj) == 1;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (obj.type) {
                        case 1: {
                            this.vectorProduct(this.coord[0], this.coord[1], this.coord[2], this.tempv);
                            if (this.tempv.z == 0.0) {
                                return false;
                            }
                            double z = this.coord[0].z - (this.tempv.x * (obj.coord[0].x - this.coord[0].x) + this.tempv.y * (obj.coord[0].y - this.coord[0].y)) / this.tempv.z;
                            return z < obj.coord[0].z;
                        }
                        case 2: {
                            double d = 0.0;
                            for (int i = 0; i < 4; ++i) {
                                d += this.coord[i].z - obj.coord[i].z;
                            }
                            return d < 0.0;
                        }
                        case 3: {
                            return this.isBoxCoveringLine(this, obj) == 1;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (obj.type) {
                        case 1: 
                        case 2: {
                            return this.isBoxCoveringLine(obj, this) == -1;
                        }
                        case 3: {
                            return false;
                        }
                    }
                }
            }
            return false;
        }

        protected int isBoxCoveringLine(DrawObject2D box, DrawObject2D line) {
            double zl;
            int i;
            double zb;
            double y;
            if (box.type == 2) {
                this.vectorProduct(box.coord[0], box.coord[1], box.coord[2], this.tempv);
            } else {
                this.tempv.x = 0.0;
                this.tempv.y = 0.0;
                this.tempv.z = 1.0;
            }
            if (this.tempv.z == 0.0) {
                return 0;
            }
            boolean endinbb = false;
            for (int i2 = 0; i2 < 2; ++i2) {
                double x = line.coord[i2].x;
                y = line.coord[i2].y;
                if (!box.boundingbox.contains((int)(x + 0.5), (int)(y + 0.5))) continue;
                zb = box.coord[0].z - (this.tempv.x * (x - box.coord[0].x) + this.tempv.y * (y - box.coord[0].y)) / this.tempv.z;
                if (line.coord[i2].z < zb - 3.0) {
                    return -1;
                }
                endinbb = true;
            }
            if (endinbb) {
                return 1;
            }
            boolean intersection = false;
            for (i = 0; i < 2; ++i) {
                int x;
                int n = x = i == 0 ? box.boundingbox.x : box.boundingbox.x + box.boundingbox.width - 1;
                if ((double)x < Math.min(line.coord[0].x, line.coord[1].x) || (double)x > Math.max(line.coord[0].x, line.coord[1].x) || line.coord[1].x == line.coord[0].x || (y = line.coord[0].y + (line.coord[1].y - line.coord[0].y) * ((double)x - line.coord[0].x) / (line.coord[1].x - line.coord[0].x)) < (double)box.boundingbox.y || y > (double)(box.boundingbox.y + box.boundingbox.height - 1)) continue;
                intersection = true;
                zl = line.coord[0].z + (line.coord[1].z - line.coord[0].z) * ((double)x - line.coord[0].x) / (line.coord[1].x - line.coord[0].x);
                zb = box.coord[0].z - (this.tempv.x * ((double)x - box.coord[0].x) + this.tempv.y * (y - box.coord[0].y)) / this.tempv.z;
                if (!(zl < zb - 3.0)) continue;
                return -1;
            }
            for (i = 0; i < 2; ++i) {
                double x;
                int y2;
                int n = y2 = i == 0 ? box.boundingbox.y : box.boundingbox.y + box.boundingbox.height - 1;
                if ((double)y2 < Math.min(line.coord[0].y, line.coord[1].y) || (double)y2 > Math.max(line.coord[0].y, line.coord[1].y) || line.coord[1].y == line.coord[0].y || (x = line.coord[0].x + (line.coord[1].x - line.coord[0].x) * ((double)y2 - line.coord[0].y) / (line.coord[1].y - line.coord[0].y)) < (double)box.boundingbox.x || x > (double)(box.boundingbox.x + box.boundingbox.width - 1)) continue;
                intersection = true;
                zl = line.coord[0].z + (line.coord[1].z - line.coord[0].z) * (x - line.coord[0].x) / (line.coord[1].x - line.coord[0].x);
                zb = box.coord[0].z - (this.tempv.x * (x - box.coord[0].x) + this.tempv.y * ((double)y2 - box.coord[0].y)) / this.tempv.z;
                if (!(zl < zb - 3.0)) continue;
                return -1;
            }
            return intersection ? 1 : 0;
        }

        public JLVector vectorProduct(JLVector v1, JLVector v2, JLVector v3, JLVector result) {
            double ax = v2.x - v1.x;
            double ay = v2.y - v1.y;
            double az = v2.z - v1.z;
            double bx = v3.x - v1.x;
            double by = v3.y - v1.y;
            double bz = v3.z - v1.z;
            result.x = ay * bz - by * az;
            result.y = az * bx - bz * ax;
            result.z = ax * by - bx * ay;
            return result;
        }
    }
}

