/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.Socket;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.core.ApplicationWindow;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

class Connection
extends Thread {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected Socket client;
    protected BufferedReader in;
    protected PrintStream out;

    public Connection(Socket client_socket) {
        this.client = client_socket;
        try {
            this.in = new BufferedReader(new InputStreamReader(this.client.getInputStream()));
            this.out = new PrintStream(this.client.getOutputStream());
        }
        catch (IOException ioe) {
            try {
                this.client.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ErrorDialog.handleFatalException(ioe);
            return;
        }
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (true) {
                String line;
                if ((line = this.in.readLine()) == null) {
                    return;
                }
                if (line.startsWith("open ")) {
                    String filepath = line.substring(5, line.length());
                    final File file = new File(filepath);
                    this.out.println("opening " + filepath);
                    SwingUtilities.invokeLater(new Runnable(){
                        {
                            Objects.requireNonNull(this$0);
                        }

                        @Override
                        public void run() {
                            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_REQUEST_FOREGROUND)) {
                                Desktop.getDesktop().requestForeground(true);
                            }
                            try {
                                ApplicationWindow.openJMLFile(file);
                            }
                            catch (JuggleExceptionUser jeu) {
                                String template = errorstrings.getString("Error_reading_file");
                                Object[] arguments = new Object[]{file.getName()};
                                String msg = MessageFormat.format(template, arguments) + ":\n" + jeu.getMessage();
                                new ErrorDialog(null, msg);
                            }
                            catch (JuggleExceptionInternal jei) {
                                ErrorDialog.handleFatalException(jei);
                            }
                        }
                    });
                    continue;
                }
                if (line.startsWith("identify")) {
                    this.out.println("Juggling Lab version 1.6.6");
                    continue;
                }
                if (line.startsWith("done")) {
                    this.out.println("goodbye");
                    return;
                }
                this.out.println(line);
                continue;
                break;
            }
        }
        catch (IOException iOException) {
            return;
        }
        finally {
            try {
                this.client.close();
            }
            catch (IOException iOException) {}
        }
    }
}

