/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.JLFunc;
import jugglinglab.util.JuggleExceptionInternal;

public class ErrorDialog {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;

    public ErrorDialog(final Component parent, final String msg) {
        SwingUtilities.invokeLater(new Runnable(){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public void run() {
                JOptionPane.showMessageDialog(parent, msg, "Error", 0);
            }
        });
    }

    public static void handleFatalException(final Exception e) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ErrorDialog.showInternalErrorWindow(e);
            }
        });
    }

    private static void showInternalErrorWindow(Exception e) {
        JMLPattern pat;
        String exmsg1 = errorstrings.getString("Error_internal_part1");
        String exmsg2 = errorstrings.getString("Error_internal_part2");
        String exmsg3 = errorstrings.getString("Error_internal_part3");
        String exmsg4 = errorstrings.getString("Error_internal_part4");
        String exmsg5 = errorstrings.getString("Error_internal_part5");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        sw.write(errorstrings.getString("Error_internal_msg_part1") + "\n\n");
        sw.write(errorstrings.getString("Error_internal_msg_part2") + "\n" + errorstrings.getString("Error_internal_msg_part3") + "\n\n");
        sw.write("Juggling Lab version: 1.6.6\n\n");
        e.printStackTrace(pw);
        if (e instanceof JuggleExceptionInternal && (pat = ((JuggleExceptionInternal)e).pat) != null) {
            sw.write("\nJML pattern:\n");
            sw.write(pat.toString());
        }
        sw.write("\n");
        final JFrame exframe = new JFrame(errorstrings.getString("Error_internal_title"));
        exframe.setDefaultCloseOperation(0);
        JPanel exp = new JPanel();
        exp.setOpaque(true);
        GridBagLayout gb = new GridBagLayout();
        exp.setLayout(gb);
        JLabel text1 = new JLabel(exmsg1);
        text1.setFont(new Font("SansSerif", 1, 12));
        exp.add(text1);
        gb.setConstraints(text1, JLFunc.constraints(21, 0, 0, new Insets(10, 10, 0, 10)));
        JLabel text2 = new JLabel(exmsg2);
        text2.setFont(new Font("SansSerif", 0, 12));
        exp.add(text2);
        gb.setConstraints(text2, JLFunc.constraints(21, 0, 1, new Insets(10, 10, 0, 10)));
        JLabel text3 = new JLabel(exmsg3);
        text3.setFont(new Font("SansSerif", 0, 12));
        exp.add(text3);
        gb.setConstraints(text3, JLFunc.constraints(21, 0, 2, new Insets(0, 10, 0, 10)));
        JLabel text4 = new JLabel(exmsg4);
        text4.setFont(new Font("SansSerif", 0, 12));
        exp.add(text4);
        gb.setConstraints(text4, JLFunc.constraints(21, 0, 3, new Insets(0, 10, 0, 10)));
        JLabel text5 = new JLabel(exmsg5);
        text5.setFont(new Font("SansSerif", 1, 12));
        exp.add(text5);
        gb.setConstraints(text5, JLFunc.constraints(21, 0, 4, new Insets(10, 10, 10, 10)));
        JTextArea dumpta = new JTextArea();
        dumpta.setText(sw.toString());
        dumpta.setCaretPosition(0);
        JScrollPane jsp = new JScrollPane(dumpta);
        jsp.setPreferredSize(new Dimension(450, 300));
        exp.add(jsp);
        gb.setConstraints(jsp, JLFunc.constraints(10, 0, 5, new Insets(10, 10, 10, 10)));
        JPanel butp = new JPanel();
        butp.setLayout(new FlowLayout(3));
        JButton quitbutton = new JButton(guistrings.getString("Quit"));
        quitbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        butp.add(quitbutton);
        JButton okbutton = new JButton(guistrings.getString("Continue"));
        okbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                exframe.setVisible(false);
                exframe.dispose();
            }
        });
        butp.add(okbutton);
        exp.add(butp);
        gb.setConstraints(butp, JLFunc.constraints(22, 0, 6, new Insets(10, 10, 10, 10)));
        exframe.setContentPane(exp);
        Locale loc = Locale.getDefault();
        exframe.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        exframe.pack();
        exframe.setResizable(false);
        exframe.setLocationRelativeTo(null);
        exframe.setVisible(true);
    }
}

