/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import jugglinglab.JugglingLab;
import jugglinglab.util.JuggleExceptionUser;

public class JLFunc {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected static NumberFormat nf;
    protected static JFileChooser jfc;

    public static int binomial(int a, int b) {
        int result = 1;
        for (int i = 0; i < b; ++i) {
            result *= a - i;
            result /= i + 1;
        }
        return result;
    }

    public static String expandRepeats(String str) {
        StringBuffer sb = new StringBuffer();
        JLFunc.addExpansionToBuffer(str, sb);
        return sb.toString();
    }

    protected static void addExpansionToBuffer(String str, StringBuffer sb) {
        int pos = 0;
        while (pos < str.length()) {
            char ch = str.charAt(pos);
            if (ch == '(') {
                int[] result = JLFunc.tryParseRepeat(str, pos);
                if (result == null) {
                    sb.append(ch);
                    ++pos;
                    continue;
                }
                int repeat_end = result[0];
                int repeats = result[1];
                int resume_start = result[2];
                String str2 = str.substring(pos + 1, repeat_end);
                for (int i = 0; i < repeats; ++i) {
                    JLFunc.addExpansionToBuffer(str2, sb);
                }
                pos = resume_start;
                continue;
            }
            sb.append(ch);
            ++pos;
        }
    }

    protected static int[] tryParseRepeat(String str, int fromPos) {
        int depth = 0;
        for (int pos = fromPos; pos < str.length(); ++pos) {
            char ch = str.charAt(pos);
            if (ch == '(') {
                ++depth;
                continue;
            }
            if (ch != ')' || --depth != 0) continue;
            Pattern pat = Pattern.compile("^\\s*\\^\\s*(\\d+).*");
            Matcher m = pat.matcher(str.substring(pos + 1, str.length()));
            if (!m.matches()) {
                return null;
            }
            int repeat_end = pos;
            int repeats = Integer.parseInt(m.group(1));
            int resume_start = m.end(1) + pos + 1;
            int[] result = new int[]{repeat_end, repeats, resume_start};
            return result;
        }
        return null;
    }

    public static int compareVersions(String v1, String v2) {
        String[] components1 = v1.split("\\.");
        String[] components2 = v2.split("\\.");
        int length = Math.min(components1.length, components2.length);
        for (int i = 0; i < length; ++i) {
            int result = Integer.valueOf(components1[i]).compareTo(Integer.parseInt(components2[i]));
            if (result == 0) continue;
            return result;
        }
        return Integer.compare(components1.length, components2.length);
    }

    public static boolean isNearLine(int x, int y, int x1, int y1, int x2, int y2, int slop) {
        if (x < Math.min(x1, x2) - slop || x > Math.max(x1, x2) + slop) {
            return false;
        }
        if (y < Math.min(y1, y2) - slop || y > Math.max(y1, y2) + slop) {
            return false;
        }
        double d = (x2 - x1) * (y - y1) - (x - x1) * (y2 - y1);
        return (int)(d = Math.abs(d) / Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1))) <= slop;
    }

    public static NumberFormat nf() {
        if (nf == null) {
            nf = NumberFormat.getInstance(Locale.US);
        }
        return nf;
    }

    public static double parseDouble(String s) throws NumberFormatException {
        try {
            return JLFunc.nf().parse(s).doubleValue();
        }
        catch (ParseException pe) {
            throw new NumberFormatException();
        }
    }

    public static String toStringRounded(double val, int digits) {
        String fmt = "###.##########".substring(0, digits <= 0 ? 3 : 4 + Math.min(10, digits));
        DecimalFormat formatter = new DecimalFormat(fmt, new DecimalFormatSymbols(Locale.US));
        String result = formatter.format(val);
        if (result.equals("-0")) {
            result = "0";
        }
        return result;
    }

    public static GridBagConstraints constraints(int location, int gridx, int gridy) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = location;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        return gbc;
    }

    public static GridBagConstraints constraints(int location, int gridx, int gridy, Insets ins) {
        GridBagConstraints gbc = JLFunc.constraints(location, gridx, gridy);
        gbc.insets = ins;
        return gbc;
    }

    public static JFileChooser jfc() {
        if (jfc != null) {
            return jfc;
        }
        jfc = new JFileChooser(){

            @Override
            public void approveSelection() {
                File f = this.getSelectedFile();
                if (f.exists() && this.getDialogType() == 1) {
                    String template = guistrings.getString("JFC_File_exists_message");
                    Object[] arguments = new Object[]{f.getName()};
                    String msg = MessageFormat.format(template, arguments);
                    String title = guistrings.getString("JFC_File_exists_title");
                    int result = JOptionPane.showConfirmDialog(this, msg, title, 1);
                    switch (result) {
                        case 0: {
                            super.approveSelection();
                            return;
                        }
                        case 1: {
                            return;
                        }
                        case -1: {
                            return;
                        }
                        case 2: {
                            this.cancelSelection();
                            return;
                        }
                    }
                }
                try {
                    Preferences.userRoot().node("Juggling Lab").put("base_dir", f.getParent());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                super.approveSelection();
            }
        };
        if (JugglingLab.base_dir != null) {
            jfc.setCurrentDirectory(JugglingLab.base_dir.toFile());
        }
        return jfc;
    }

    public static String sanitizeFilename(String fname) {
        String extension;
        int index = fname.lastIndexOf(".");
        String base = index >= 0 ? fname.substring(0, index) : fname;
        String string = extension = index >= 0 ? fname.substring(index) : "";
        if (JugglingLab.isMacOS) {
            String b = base.replaceAll("[:/]", "");
            while (b.startsWith(".") || b.startsWith(" ")) {
                b = b.substring(1);
            }
            if (b.length() == 0) {
                b = "Pattern";
            }
            return b + extension;
        }
        if (JugglingLab.isWindows) {
            String b = base.replaceAll("[\\/?:*\"]", "");
            boolean forbidden = b.indexOf(">") >= 0;
            forbidden = forbidden || b.indexOf("<") >= 0;
            boolean bl = forbidden = forbidden || b.indexOf("|") >= 0;
            if (forbidden || b.length() == 0) {
                b = "Pattern";
            }
            return b + extension;
        }
        if (JugglingLab.isLinux) {
            String b = base.replaceAll("/", ":");
            while (b.startsWith(".") || b.startsWith(" ")) {
                b = b.substring(1);
            }
            if (b.length() == 0) {
                b = "Pattern";
            }
            return b + extension;
        }
        return fname;
    }

    public static void errorIfNotSanitized(String fname) throws JuggleExceptionUser {
        if (fname.equals(JLFunc.sanitizeFilename(fname))) {
            return;
        }
        throw new JuggleExceptionUser(errorstrings.getString("Error_saving_disallowed_character"));
    }
}

