/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.core.ApplicationWindow;
import jugglinglab.util.ErrorDialog;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class OpenFilesServerMMF
extends Thread {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    static Thread server_thread;
    static String ipc_filename;
    static final int BUFFER_LENGTH = 1024;

    public OpenFilesServerMMF() {
        if (server_thread != null) {
            return;
        }
        server_thread = this;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File fipc = new File(ipc_filename);
        AbstractInterruptibleChannel chan = null;
        try {
            chan = FileChannel.open(fipc.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            MappedByteBuffer b_toserver = ((FileChannel)chan).map(FileChannel.MapMode.READ_WRITE, 0L, 1024L);
            CharBuffer buf_toserver = b_toserver.asCharBuffer();
            MappedByteBuffer b_fromserver = ((FileChannel)chan).map(FileChannel.MapMode.READ_WRITE, 1024L, 1024L);
            CharBuffer buf_fromserver = b_fromserver.asCharBuffer();
            while (!OpenFilesServerMMF.interrupted()) {
                OpenFilesServerMMF.clearBuffer(buf_toserver);
                while (!OpenFilesServerMMF.waitUntilMessage(buf_toserver, 1000)) {
                }
                String line = OpenFilesServerMMF.readMessage(buf_toserver);
                if (line.startsWith("open ")) {
                    String filepath = line.substring(5, line.length());
                    final File file = new File(filepath);
                    OpenFilesServerMMF.writeMessage(buf_fromserver, "opening " + filepath + "\u0000");
                    SwingUtilities.invokeLater(new Runnable(){
                        {
                            Objects.requireNonNull(this$0);
                        }

                        @Override
                        public void run() {
                            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.APP_REQUEST_FOREGROUND)) {
                                Desktop.getDesktop().requestForeground(true);
                            }
                            try {
                                ApplicationWindow.openJMLFile(file);
                            }
                            catch (JuggleExceptionUser jeu) {
                                String template = errorstrings.getString("Error_reading_file");
                                Object[] arguments = new Object[]{file.getName()};
                                String msg = MessageFormat.format(template, arguments) + ":\n" + jeu.getMessage();
                                new ErrorDialog(null, msg);
                            }
                            catch (JuggleExceptionInternal jei) {
                                ErrorDialog.handleFatalException(jei);
                            }
                        }
                    });
                    continue;
                }
                if (line.startsWith("identify")) {
                    OpenFilesServerMMF.writeMessage(buf_fromserver, "Juggling Lab version 1.6.6\u0000");
                    continue;
                }
                if (line.startsWith("done")) {
                    OpenFilesServerMMF.writeMessage(buf_fromserver, "goodbye\u0000");
                    continue;
                }
                OpenFilesServerMMF.writeMessage(buf_fromserver, line + "\u0000");
            }
        }
        catch (IOException ioe) {
            ErrorDialog.handleFatalException(ioe);
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            try {
                if (chan != null) {
                    chan.close();
                }
                Files.delete(fipc.toPath());
            }
            catch (Exception exception) {}
        }
    }

    public static boolean tryOpenFile(File f) {
        File fipc = new File(ipc_filename);
        if (!fipc.exists()) {
            return false;
        }
        FileChannel chan = null;
        try {
            chan = FileChannel.open(fipc.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
            MappedByteBuffer b_toserver = chan.map(FileChannel.MapMode.READ_WRITE, 0L, 1024L);
            CharBuffer buf_toserver = b_toserver.asCharBuffer();
            MappedByteBuffer b_fromserver = chan.map(FileChannel.MapMode.READ_WRITE, 1024L, 1024L);
            CharBuffer buf_fromserver = b_fromserver.asCharBuffer();
            OpenFilesServerMMF.clearBuffer(buf_fromserver);
            OpenFilesServerMMF.writeMessage(buf_toserver, "identify\u0000");
            if (!OpenFilesServerMMF.waitUntilMessage(buf_fromserver, 200)) {
                return false;
            }
            String line = OpenFilesServerMMF.readMessage(buf_fromserver);
            if (!line.equals("Juggling Lab version 1.6.6")) {
                return false;
            }
            OpenFilesServerMMF.clearBuffer(buf_fromserver);
            OpenFilesServerMMF.writeMessage(buf_toserver, "open " + String.valueOf(f) + "\u0000");
            if (!OpenFilesServerMMF.waitUntilMessage(buf_fromserver, 500)) {
                return false;
            }
            line = OpenFilesServerMMF.readMessage(buf_fromserver);
            if (!line.startsWith("opening ")) {
                return false;
            }
            OpenFilesServerMMF.writeMessage(buf_toserver, "done\u0000");
            return true;
        }
        catch (IOException ioe) {
            ErrorDialog.handleFatalException(ioe);
        }
        catch (InterruptedException ie) {
            ErrorDialog.handleFatalException(ie);
        }
        return false;
    }

    public static void cleanup() {
        if (server_thread != null) {
            try {
                server_thread.interrupt();
                server_thread.join(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            server_thread = null;
        }
    }

    private static void clearBuffer(CharBuffer cb) {
        cb.put(0, '\u0000');
    }

    private static String readMessage(CharBuffer cb) {
        char c;
        StringBuffer msg_sb = new StringBuffer(1024);
        for (int i = 0; i < 1024 && (c = cb.get(i)) != '\u0000'; ++i) {
            msg_sb.append(c);
        }
        return msg_sb.toString();
    }

    private static void writeMessage(CharBuffer cb, String str) {
        for (int i = 1; i < str.length(); ++i) {
            cb.put(i, str.charAt(i));
        }
        cb.put(0, str.charAt(0));
    }

    private static boolean waitUntilMessage(CharBuffer cb, int timeout) throws InterruptedException {
        int tries = timeout / 20;
        for (int i = 0; i < tries; ++i) {
            if (cb.get(0) != '\u0000') {
                return true;
            }
            Thread.sleep(20L);
        }
        return false;
    }

    static {
        ipc_filename = System.getProperty("java.io.tmpdir") + File.separator + "JugglingLabTemp";
    }
}

