/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.ResourceBundle;
import jugglinglab.JugglingLab;
import jugglinglab.util.Connection;
import jugglinglab.util.ErrorDialog;

public class OpenFilesServerSockets
extends Thread {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    static Thread server_thread;
    protected static final int OPEN_FILES_PORT = 8686;
    protected static final int POLLING_TIMEOUT_MS = 30;
    protected ServerSocket listen_socket;

    public OpenFilesServerSockets() {
        if (server_thread != null) {
            return;
        }
        try {
            this.listen_socket = new ServerSocket(8686);
            this.listen_socket.setSoTimeout(30);
        }
        catch (IOException e) {
            return;
        }
        server_thread = this;
        this.start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        try {
            while (!OpenFilesServerSockets.interrupted()) {
                try {
                    Socket client_socket = this.listen_socket.accept();
                    if (!client_socket.getInetAddress().toString().contains("127.0.0.1")) continue;
                    new Connection(client_socket);
                }
                catch (SocketTimeoutException client_socket) {}
            }
            return;
        }
        catch (IOException e) {
            ErrorDialog.handleFatalException(e);
            return;
        }
        finally {
            try {
                this.listen_socket.close();
            }
            catch (IOException iOException) {}
            this.listen_socket = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean tryOpenFile(File f) {
        Socket s = null;
        BufferedReader sin = null;
        PrintStream sout = null;
        try {
            s = new Socket("localhost", 8686);
            sin = new BufferedReader(new InputStreamReader(s.getInputStream()));
            sout = new PrintStream(s.getOutputStream());
            sout.println("identify");
            String line = sin.readLine();
            if (!line.equals("Juggling Lab version 1.6.6")) {
                boolean bl = false;
                return bl;
            }
            sout.println("open " + String.valueOf(f));
            line = sin.readLine();
            if (!line.startsWith("opening ")) {
                boolean bl = false;
                return bl;
            }
            sout.println("done");
            line = sin.readLine();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (s != null) {
                    s.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static void cleanup() {
        if (server_thread != null) {
            try {
                server_thread.interrupt();
                server_thread.join(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            server_thread = null;
        }
    }
}

