/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.lang.invoke.CallSite;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import jugglinglab.JugglingLab;
import jugglinglab.util.JuggleExceptionUser;

public class ParameterList {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    protected int size = 0;
    protected ArrayList<String> names;
    protected ArrayList<String> values;

    public ParameterList() {
    }

    public ParameterList(String source) throws JuggleExceptionUser {
        this();
        this.readParameters(source);
    }

    public boolean addParameter(String name, String value) {
        if (this.size == 0) {
            this.names = new ArrayList();
            this.values = new ArrayList();
        }
        int i = this.size - 1;
        while (i >= 0) {
            if (name.equalsIgnoreCase(this.getParameterName(i))) {
                this.values.set(i, value);
                return true;
            }
            --i;
        }
        this.names.add(name);
        this.values.add(value);
        ++this.size;
        return false;
    }

    public String getParameter(String name) {
        int i = this.size - 1;
        while (i >= 0) {
            if (name.equalsIgnoreCase(this.getParameterName(i))) {
                return this.getParameterValue(i);
            }
            --i;
        }
        return null;
    }

    public String removeParameter(String name) {
        int i = this.size - 1;
        while (i >= 0) {
            if (name.equalsIgnoreCase(this.getParameterName(i))) {
                --this.size;
                this.names.remove(i);
                return this.values.remove(i);
            }
            --i;
        }
        return null;
    }

    public String getParameterName(int index) {
        return this.names.get(index);
    }

    public String getParameterValue(int index) {
        return this.values.get(index);
    }

    public int getNumberOfParameters() {
        return this.size;
    }

    public void readParameters(String source) throws JuggleExceptionUser {
        if (source == null) {
            return;
        }
        source = source.replaceAll("\n", "").replaceAll("\r", "");
        StringTokenizer st1 = new StringTokenizer(source, ";");
        while (st1.hasMoreTokens()) {
            String str = st1.nextToken();
            int index = str.indexOf("=");
            if (index > 0) {
                String name = str.substring(0, index).trim();
                String value = str.substring(index + 1).trim();
                if (name.length() == 0) continue;
                this.addParameter(name, value);
                continue;
            }
            if ((str = str.trim()).length() <= 0) continue;
            String template = errorstrings.getString("Error_param_has_no_value");
            Object[] arg = new Object[]{str};
            throw new JuggleExceptionUser(MessageFormat.format(template, arg));
        }
    }

    public String toString() {
        Object result = "";
        int i = 0;
        while (i < this.size) {
            if (i != 0) {
                result = (String)result + ";";
            }
            result = (String)result + this.getParameterName(i) + "=" + this.getParameterValue(i);
            ++i;
        }
        return result;
    }

    public void errorIfParametersLeft() throws JuggleExceptionUser {
        int count = this.getNumberOfParameters();
        if (count == 0) {
            return;
        }
        if (count == 1) {
            String template = errorstrings.getString("Error_unused_param");
            Object[] arguments = new Object[]{"\"" + this.getParameterName(0) + "\""};
            throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
        }
        String template = errorstrings.getString("Error_unused_params");
        ArrayList<CallSite> names = new ArrayList<CallSite>();
        int i = 0;
        while (i < count) {
            names.add((CallSite)((Object)("\"" + this.getParameterName(i) + "\"")));
            ++i;
        }
        Object[] arguments = new Object[]{String.join((CharSequence)", ", names)};
        throw new JuggleExceptionUser(MessageFormat.format(template, arguments));
    }
}

