/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.util.StringTokenizer;
import jugglinglab.util.JuggleException;

public class Permutation {
    protected int size;
    protected int[] mapping;
    protected boolean reverses;

    public Permutation(int n, boolean reverses) {
        this.size = n;
        this.reverses = reverses;
        if (reverses) {
            this.mapping = new int[this.size * 2 + 1];
            int i = 0;
            while (i < this.size * 2 + 1) {
                this.mapping[i] = i - this.size;
                ++i;
            }
        } else {
            this.mapping = new int[this.size];
            int i = 0;
            while (i < n) {
                this.mapping[i] = i + 1;
                ++i;
            }
        }
    }

    public Permutation(int n, int[] mapping, boolean reverses) {
        this.size = n;
        this.reverses = reverses;
        this.mapping = mapping;
    }

    public Permutation(int n, String perm, boolean reverses) throws JuggleException {
        int i;
        boolean[] used;
        this.size = n;
        this.reverses = reverses;
        if (reverses) {
            this.mapping = new int[this.size * 2 + 1];
            used = new boolean[this.size * 2 + 1];
            i = 0;
            while (i < this.size * 2 + 1) {
                this.mapping[i] = 0;
                used[i] = false;
                ++i;
            }
        } else {
            this.mapping = new int[this.size];
            used = new boolean[this.size];
            i = 0;
            while (i < n) {
                this.mapping[i] = 0;
                used[i] = false;
                ++i;
            }
        }
        if (perm.indexOf(40) == -1) {
            StringTokenizer st = new StringTokenizer(perm, ",");
            if (st.countTokens() != this.size) {
                throw new JuggleException("Permutation init error: must have " + n + " elements in mapping");
            }
            int i2 = 0;
            while (i2 < this.size) {
                int num;
                String s = st.nextToken().trim();
                try {
                    num = Integer.parseInt(s);
                }
                catch (NumberFormatException nfe) {
                    throw new JuggleException("Permutation init error: number format");
                }
                if (num < 1 || num > this.size) {
                    throw new JuggleException("Permutation init error: out of range");
                }
                if (used[num - 1]) {
                    throw new JuggleException("Permutation init error: not one-to-one");
                }
                used[num - 1] = true;
                this.mapping[i2] = num;
                ++i2;
            }
        } else {
            StringTokenizer st1 = new StringTokenizer(perm, ")");
            while (st1.hasMoreTokens()) {
                String s1 = st1.nextToken().trim();
                if (s1.charAt(0) != '(') {
                    throw new JuggleException("Permutation init error: parenthesis not grouped");
                }
                s1 = s1.substring(1);
                int num = 0;
                int lastnum = -(this.size + 1);
                StringTokenizer st2 = new StringTokenizer(s1, ",");
                while (st2.hasMoreTokens()) {
                    String s2 = st2.nextToken().trim();
                    try {
                        if (reverses) {
                            boolean negate = false;
                            if (s2.endsWith("*")) {
                                negate = true;
                                s2 = s2.replace('*', ' ').trim();
                            }
                            num = Integer.parseInt(s2);
                            if (negate) {
                                num = -num;
                            }
                        } else {
                            num = Integer.parseInt(s2);
                        }
                    }
                    catch (NumberFormatException nfe) {
                        throw new JuggleException("Permutation init error: number format");
                    }
                    if (reverses) {
                        if (num < -this.size || num > this.size || num == 0) {
                            throw new JuggleException("Permutation init error: out of range");
                        }
                        if (used[num + this.size]) {
                            throw new JuggleException("Permutation init error: not one-to-one");
                        }
                        used[num + this.size] = true;
                        if (lastnum == -(this.size + 1)) {
                            this.mapping[num + this.size] = num;
                        } else {
                            this.mapping[num + this.size] = this.mapping[lastnum + this.size];
                            this.mapping[lastnum + this.size] = num;
                            if (used[-lastnum + this.size] && this.mapping[-lastnum + this.size] != -num) {
                                throw new JuggleException("Permutation init error: input not reversible");
                            }
                        }
                    } else {
                        if (num < 1 || num > this.size) {
                            throw new JuggleException("Permutation init error: out of range");
                        }
                        if (used[num - 1]) {
                            throw new JuggleException("Permutation init error: not one-to-one");
                        }
                        used[num - 1] = true;
                        if (lastnum == -(this.size + 1)) {
                            this.mapping[num - 1] = num;
                        } else {
                            this.mapping[num - 1] = this.mapping[lastnum - 1];
                            this.mapping[lastnum - 1] = num;
                        }
                    }
                    lastnum = num;
                }
            }
        }
        if (reverses) {
            int i3 = 1;
            while (i3 <= this.size) {
                if (used[i3 + this.size] && !used[-i3 + this.size]) {
                    this.mapping[-i3 + this.size] = -this.mapping[i3 + this.size];
                } else if (!used[i3 + this.size] && used[-i3 + this.size]) {
                    this.mapping[i3 + this.size] = -this.mapping[-i3 + this.size];
                } else if (!used[i3 + this.size] && !used[-i3 + this.size]) {
                    this.mapping[-i3 + this.size] = 0;
                    this.mapping[i3 + this.size] = 0;
                }
                ++i3;
            }
        } else {
            int i4 = 0;
            while (i4 < this.size) {
                if (!used[i4]) {
                    this.mapping[i4] = i4 + 1;
                }
                ++i4;
            }
        }
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean cyclenotation) {
        Object s;
        if (cyclenotation) {
            if (this.reverses) {
                boolean[] printed = new boolean[this.size];
                int i = 0;
                while (i < this.size) {
                    printed[i] = false;
                    ++i;
                }
                s = "";
                i = 0;
                while (i < this.size) {
                    if (!printed[i]) {
                        int start = i + 1;
                        printed[i] = true;
                        int current = this.mapping[start + this.size];
                        if (current != 0) {
                            s = (String)s + "(" + this.convertReverse(start);
                            while (current != start) {
                                if (current > 0) {
                                    printed[current - 1] = true;
                                } else if (current < 0) {
                                    printed[-current - 1] = true;
                                }
                                s = (String)s + "," + this.convertReverse(current);
                                current = this.mapping[current + this.size];
                            }
                            s = (String)s + ")";
                        }
                    }
                    ++i;
                }
            } else {
                int left = this.size;
                boolean[] printed = new boolean[this.size];
                int i = 0;
                while (i < this.size) {
                    printed[i] = false;
                    ++i;
                }
                s = "";
                while (left > 0) {
                    i = 0;
                    while (i < this.size) {
                        if (!printed[i]) break;
                        ++i;
                    }
                    int start = i + 1;
                    printed[i] = true;
                    s = (String)s + "(" + start;
                    --left;
                    int current = this.mapping[i];
                    while (current != start) {
                        s = (String)s + "," + current;
                        printed[current - 1] = true;
                        --left;
                        current = this.mapping[current - 1];
                    }
                    s = (String)s + ")";
                }
            }
        } else if (this.reverses) {
            s = this.convertReverse(this.mapping[this.size + 1]);
            int i = 1;
            while (i < this.size) {
                s = (String)s + "," + this.convertReverse(this.mapping[this.size + 1 + i]);
                ++i;
            }
        } else {
            s = "" + this.mapping[0];
            int i = 1;
            while (i < this.size) {
                s = (String)s + "," + this.mapping[i];
                ++i;
            }
        }
        return s;
    }

    protected String convertReverse(int num) {
        if (num >= 0) {
            return "" + num;
        }
        return -num + "*";
    }

    public int getSize() {
        return this.size;
    }

    public boolean hasReverses() {
        return this.reverses;
    }

    public boolean equals(Permutation p) {
        if (p == null) {
            return false;
        }
        if (this.reverses != p.hasReverses()) {
            return false;
        }
        if (this.getSize() != p.getSize()) {
            return false;
        }
        int i = 0;
        while (i < this.getSize()) {
            if (this.getMapping(i + 1) != p.getMapping(i + 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public int getMapping(int elem) {
        if (this.reverses) {
            return this.mapping[elem + this.size];
        }
        return this.mapping[elem - 1];
    }

    public int getMapping(int elem, int power) {
        block3: {
            block2: {
                if (power <= 0) break block2;
                int i = 0;
                while (i < power) {
                    elem = this.getMapping(elem);
                    ++i;
                }
                break block3;
            }
            if (power >= 0) break block3;
            int i = power;
            while (i < 0) {
                elem = this.getInverseMapping(elem);
                ++i;
            }
        }
        return elem;
    }

    public Permutation apply(Permutation firstp) {
        if (this.getSize() != firstp.getSize()) {
            return null;
        }
        if (this.hasReverses() || firstp.hasReverses()) {
            return null;
        }
        int[] res = new int[this.getSize()];
        int i = 0;
        while (i < this.getSize()) {
            res[i] = this.getMapping(firstp.getMapping(i + 1));
            ++i;
        }
        return new Permutation(this.getSize(), res, false);
    }

    public int getInverseMapping(int elem) {
        if (this.reverses) {
            int i = 0;
            while (i < 2 * this.size + 1) {
                if (this.mapping[i] == elem) {
                    return i - this.size;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.size) {
                if (this.mapping[i] == elem) {
                    return i + 1;
                }
                ++i;
            }
        }
        return 0;
    }

    public Permutation getInverse() {
        int[] invmapping = null;
        if (this.reverses) {
            invmapping = new int[this.size * 2 + 1];
            int i = 0;
            while (i < this.size * 2 + 1) {
                invmapping[this.mapping[i] + this.size] = i - this.size;
                ++i;
            }
        } else {
            invmapping = new int[this.size];
            int i = 0;
            while (i < this.size) {
                invmapping[this.mapping[i] - 1] = i + 1;
                ++i;
            }
        }
        return new Permutation(this.size, invmapping, this.reverses);
    }

    public static int lcm(int x, int y) {
        int x0 = x;
        int y0 = y;
        int g = y;
        while (x > 0) {
            g = x;
            x = y % x;
            y = g;
        }
        return x0 * y0 / g;
    }

    public int getOrder() {
        int ord = 1;
        int elem = 1;
        while (elem <= this.size) {
            if (this.getMapping(elem) != 0) {
                ord = Permutation.lcm(ord, this.getOrder(elem));
            }
            ++elem;
        }
        return ord;
    }

    public int getOrder(int elem) {
        int ord = 1;
        int index = this.reverses ? elem + this.size : elem - 1;
        while (this.mapping[index] != elem) {
            ++ord;
            index = this.mapping[index] + (this.reverses ? this.size : -1);
        }
        return ord;
    }

    public int[] getCycle(int elem) {
        int ord = this.getOrder(elem);
        int[] result = new int[ord];
        int term = elem;
        int i = 0;
        while (i < ord) {
            result[i] = term;
            term = this.mapping[this.reverses ? term + this.size : term - 1];
            ++i;
        }
        return result;
    }
}

