/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.util;

import java.awt.ComponentOrientation;
import java.awt.Desktop;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jugglinglab.JugglingLab;
import jugglinglab.util.JLFunc;
import jugglinglab.util.LabelDialog;

public class UpdateChecker
extends Thread {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;

    public UpdateChecker() {
        this.setPriority(1);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream is = null;
        InputStreamReader isr = null;
        String line = null;
        try {
            URL url = new URL("http://jugglinglab.org");
            is = url.openStream();
            isr = new InputStreamReader(is);
            BufferedReader br = new BufferedReader(isr);
            while ((line = br.readLine()) != null && !line.contains("versionstring")) {
            }
        }
        catch (MalformedURLException url) {
        }
        catch (IOException url) {
        }
        finally {
            try {
                if (isr != null) {
                    isr.close();
                }
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException url) {}
        }
        if (line == null) {
            return;
        }
        String pattern = ".*versionstring.*?>(.*?)<.*";
        final String current_version = line.replaceAll(pattern, "$1");
        String running_version = "1.6.6";
        if (current_version == null || current_version.length() == 0 || JLFunc.compareVersions(current_version, running_version) <= 0) {
            return;
        }
        try {
            Thread.sleep(3000L);
            SwingUtilities.invokeLater(new Runnable(){
                {
                    Objects.requireNonNull(this$0);
                }

                @Override
                public void run() {
                    UpdateChecker.showUpdateBox(current_version);
                }
            });
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected static void showUpdateBox(String version) {
        final String title = guistrings.getString("New_version_available");
        final JFrame updateBox = new JFrame(title);
        updateBox.setDefaultCloseOperation(2);
        JPanel updatePanel = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        updatePanel.setLayout(gb);
        String template1 = guistrings.getString("New_version_text1");
        Object[] arguments1 = new Object[]{version};
        JLabel text1 = new JLabel(MessageFormat.format(template1, arguments1));
        text1.setFont(new Font("SansSerif", 0, 14));
        updatePanel.add(text1);
        gb.setConstraints(text1, JLFunc.constraints(21, 0, 1, new Insets(20, 25, 0, 25)));
        String template2 = guistrings.getString("New_version_text2");
        Object[] arguments2 = new Object[]{"1.6.6"};
        JLabel text2 = new JLabel(MessageFormat.format(template2, arguments2));
        text2.setFont(new Font("SansSerif", 0, 14));
        updatePanel.add(text2);
        gb.setConstraints(text2, JLFunc.constraints(21, 0, 2, new Insets(0, 25, 0, 25)));
        JLabel text3 = new JLabel(guistrings.getString("New_version_text3"));
        text3.setFont(new Font("SansSerif", 0, 14));
        updatePanel.add(text3);
        gb.setConstraints(text3, JLFunc.constraints(21, 0, 3, new Insets(20, 25, 5, 25)));
        JPanel butp = new JPanel();
        butp.setLayout(new FlowLayout(3));
        JButton cancelbutton = new JButton(guistrings.getString("Update_cancel"));
        cancelbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                updateBox.dispose();
            }
        });
        butp.add(cancelbutton);
        JButton yesbutton = new JButton(guistrings.getString("Update_yes"));
        yesbutton.setDefaultCapable(true);
        yesbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean browse_supported = Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
                boolean browse_problem = false;
                if (browse_supported) {
                    try {
                        Desktop.getDesktop().browse(new URI("https://jugglinglab.org/#download"));
                    }
                    catch (Exception excep) {
                        browse_problem = true;
                    }
                }
                if (!browse_supported || browse_problem) {
                    String template3 = guistrings.getString("Download_message");
                    Object[] arguments3 = new Object[]{"https://jugglinglab.org/#download"};
                    String message = MessageFormat.format(template3, arguments3);
                    new LabelDialog(updateBox, title, message);
                }
                updateBox.dispose();
            }
        });
        butp.add(yesbutton);
        updatePanel.add(butp);
        gb.setConstraints(butp, JLFunc.constraints(22, 0, 4, new Insets(10, 10, 10, 10)));
        updatePanel.setOpaque(true);
        updateBox.setContentPane(updatePanel);
        updateBox.getRootPane().setDefaultButton(yesbutton);
        Locale loc = Locale.getDefault();
        updateBox.applyComponentOrientation(ComponentOrientation.getOrientation(loc));
        updateBox.pack();
        updateBox.setResizable(false);
        updateBox.setLocationRelativeTo(null);
        updateBox.setVisible(true);
    }
}

