/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.io.File;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import jugglinglab.core.AnimationEditPanel;
import jugglinglab.core.AnimationPanel;
import jugglinglab.core.AnimationPrefs;
import jugglinglab.core.EditLadderDiagram;
import jugglinglab.core.LadderDiagram;
import jugglinglab.jml.JMLPattern;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;
import jugglinglab.view.View;

public class EditView
extends View {
    protected AnimationPanel ap = new AnimationEditPanel();
    protected JPanel ladder;
    protected JSplitPane jsp;

    public EditView(Dimension dim, JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        this.ap.setPreferredSize(dim);
        this.ap.setMinimumSize(new Dimension(10, 10));
        this.ladder = new JPanel();
        this.ladder.setLayout(new BorderLayout());
        this.ladder.setBackground(Color.white);
        this.ladder.add((Component)new LadderDiagram(pat), "Center");
        Locale loc = Locale.getDefault();
        if (ComponentOrientation.getOrientation(loc) == ComponentOrientation.LEFT_TO_RIGHT) {
            this.jsp = new JSplitPane(1, true, this.ap, this.ladder);
            this.jsp.setResizeWeight(1.0);
        } else {
            this.jsp = new JSplitPane(1, true, this.ladder, this.ap);
            this.jsp.setResizeWeight(0.0);
        }
        this.jsp.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.jsp.setBackground(Color.white);
        this.setBackground(Color.white);
        this.setLayout(new BorderLayout());
        this.add((Component)this.jsp, "Center");
    }

    @Override
    public void restartView(JMLPattern p, AnimationPrefs c) throws JuggleExceptionUser, JuggleExceptionInternal {
        boolean changing_jugglers = p != null && this.getPattern() != null && p.getNumberOfJugglers() != this.getPattern().getNumberOfJugglers();
        this.ap.restartJuggle(p, c);
        this.setAnimationPanelPreferredSize(this.getAnimationPrefs().getSize());
        if (p == null) {
            return;
        }
        LadderDiagram new_ladder = null;
        new_ladder = this.ap instanceof AnimationEditPanel ? new EditLadderDiagram(p, this.parent, this) : new LadderDiagram(p);
        new_ladder.setAnimationPanel(this.ap);
        this.ap.removeAllAttachments();
        this.ap.addAnimationAttachment(new_ladder);
        if (this.ap instanceof AnimationEditPanel) {
            AnimationEditPanel aep = (AnimationEditPanel)this.ap;
            aep.deactivateEvent();
            aep.deactivatePosition();
        }
        this.ladder.removeAll();
        this.ladder.add((Component)new_ladder, "Center");
        if (changing_jugglers && this.parent != null) {
            this.jsp.resetToPreferredSizes();
            if (this.parent.isWindowMaximized()) {
                this.parent.validate();
            } else {
                this.parent.pack();
            }
        } else {
            this.ladder.validate();
        }
        if (this.parent != null) {
            this.parent.setTitle(p.getTitle());
        }
    }

    @Override
    public void restartView() throws JuggleExceptionUser, JuggleExceptionInternal {
        this.ap.restartJuggle();
    }

    @Override
    public Dimension getAnimationPanelSize() {
        return this.ap.getSize(new Dimension());
    }

    @Override
    public void setAnimationPanelPreferredSize(Dimension d) {
        this.ap.setPreferredSize(d);
        this.jsp.resetToPreferredSizes();
    }

    @Override
    public JMLPattern getPattern() {
        return this.ap.getPattern();
    }

    @Override
    public AnimationPrefs getAnimationPrefs() {
        return this.ap.getAnimationPrefs();
    }

    @Override
    public double getZoomLevel() {
        return this.ap.getZoomLevel();
    }

    @Override
    public void setZoomLevel(double z) {
        this.ap.setZoomLevel(z);
    }

    @Override
    public boolean isPaused() {
        return this.ap.isPaused();
    }

    @Override
    public void setPaused(boolean pause) {
        if (this.ap.message == null) {
            this.ap.setPaused(pause);
        }
    }

    @Override
    public void disposeView() {
        this.ap.disposeAnimation();
    }

    @Override
    public void writeGIF(File f) {
        this.ap.writingGIF = true;
        final boolean origpause = this.isPaused();
        this.setPaused(true);
        this.jsp.setEnabled(false);
        if (this.parent != null) {
            this.parent.setResizable(false);
        }
        Runnable cleanup = new Runnable(){
            final /* synthetic */ EditView this$0;
            {
                EditView editView = this$0;
                Objects.requireNonNull(editView);
                this.this$0 = editView;
            }

            @Override
            public void run() {
                this.this$0.ap.writingGIF = false;
                this.this$0.setPaused(origpause);
                this.this$0.jsp.setEnabled(true);
                if (this.this$0.parent != null) {
                    this.this$0.parent.setResizable(true);
                }
            }
        };
        new View.GIFWriter(this, this.ap, f, cleanup);
    }
}

