/*
 * Decompiled with CFR 0.152.
 */
package jugglinglab.view;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Hashtable;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import jugglinglab.JugglingLab;
import jugglinglab.jml.JMLEvent;
import jugglinglab.jml.JMLPattern;
import jugglinglab.jml.JMLPosition;
import jugglinglab.jml.JMLSymmetry;
import jugglinglab.jml.JMLTransition;
import jugglinglab.util.Coordinate;
import jugglinglab.util.JuggleExceptionInternal;
import jugglinglab.util.JuggleExceptionUser;

public class Mutator {
    static final ResourceBundle guistrings = JugglingLab.guistrings;
    static final ResourceBundle errorstrings = JugglingLab.errorstrings;
    static final double mutationPositionCm = 40.0;
    static final double mutationMinEventDeltaSec = 0.03;
    static final double mutationTimingScale = 0.5;
    static final double mutationNewEventPositionCm = 40.0;
    static final double[] mutation_freq = new double[]{0.4, 0.1, 0.1, 0.2, 0.2};
    static final double[] slider_rates = new double[]{0.2, 0.4, 0.7, 1.0, 1.3, 1.6, 2.0};
    protected double rate;
    protected JPanel controls = this.makeControlPanel();
    protected JCheckBox[] cb;
    protected JSlider slider_rate;

    public JMLPattern mutatePattern(JMLPattern pat) throws JuggleExceptionInternal {
        double[] cdf = new double[5];
        double freq_sum = 0.0;
        for (int i = 0; i < 5; ++i) {
            cdf[i] = freq_sum += this.cb[i].isSelected() ? mutation_freq[i] : 0.0;
        }
        try {
            JMLPattern clone;
            double r;
            if (freq_sum == 0.0) {
                return new JMLPattern(pat);
            }
            this.rate = this.slider_rate == null ? 1.0 : slider_rates[this.slider_rate.getValue()];
            JMLPattern mutant = null;
            int tries = 0;
            do {
                clone = new JMLPattern(pat);
            } while ((mutant = (r = freq_sum * Math.random()) < cdf[0] ? this.mutateEventPosition(clone) : (r < cdf[1] ? this.mutateEventTime(clone) : (r < cdf[2] ? this.mutatePatternTiming(clone) : (r < cdf[3] ? this.mutateAddEvent(clone) : this.mutateRemoveEvent(clone))))) == null && ++tries < 5);
            return mutant == null ? new JMLPattern(pat) : mutant;
        }
        catch (JuggleExceptionUser jeu) {
            throw new JuggleExceptionInternal("Mutator: User error: " + jeu.getMessage());
        }
    }

    public JPanel getControlPanel() {
        return this.controls;
    }

    protected JMLPattern mutateEventPosition(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        JMLEvent ev = this.pickMasterEvent(pat);
        Coordinate pos = ev.getLocalCoordinate();
        pos = this.pickNewPosition(ev.getHand(), this.rate * 40.0, pos);
        ev.setLocalCoordinate(pos);
        pat.setNeedsLayout();
        return pat;
    }

    protected JMLPattern mutateEventTime(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        double tmax;
        JMLEvent ev_next;
        JMLEvent ev_prev;
        JMLEvent ev = this.pickMasterEvent(pat);
        for (ev_prev = ev.getPrevious(); ev_prev != null && (ev_prev.getJuggler() != ev.getJuggler() || ev_prev.getHand() != ev.getHand()); ev_prev = ev_prev.getPrevious()) {
        }
        double tmin = ev_prev == null ? pat.getLoopStartTime() : Math.max(pat.getLoopStartTime(), ev_prev.getT()) + 0.03;
        for (ev_next = ev.getNext(); ev_next != null && (ev_next.getJuggler() != ev.getJuggler() || ev_next.getHand() != ev.getHand()); ev_next = ev_next.getNext()) {
        }
        double d = tmax = ev_next == null ? pat.getLoopEndTime() : Math.min(pat.getLoopEndTime(), ev_next.getT()) - 0.03;
        if (tmax <= tmin) {
            return null;
        }
        double r = Math.random();
        double tnow = ev.getT();
        double t = 0.0;
        t = r < 0.5 ? tmin + (tnow - tmin) * Math.sqrt(2.0 * r) : tmax - (tmax - tnow) * Math.sqrt(2.0 * (1.0 - r));
        ev.setT(t);
        pat.setNeedsLayout();
        return pat;
    }

    protected JMLPattern mutatePatternTiming(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        double r = Math.random();
        double scalemin = 1.0 / (1.0 + this.rate * 0.5);
        double scalemax = 1.0 + this.rate * 0.5;
        double scale = 0.0;
        scale = r < 0.5 ? scalemin + (1.0 - scalemin) * Math.sqrt(2.0 * r) : scalemax - (scalemax - 1.0) * Math.sqrt(2.0 * (1.0 - r));
        for (JMLEvent ev = pat.getEventList(); ev != null; ev = ev.getNext()) {
            if (!ev.isMaster()) continue;
            ev.setT(ev.getT() * scale);
        }
        for (JMLPosition pos = pat.getPositionList(); pos != null; pos = pos.getNext()) {
            pos.setT(pos.getT() * scale);
        }
        for (JMLSymmetry sym : pat.symmetries()) {
            double delay = sym.getDelay();
            if (!(delay > 0.0)) continue;
            sym.setDelay(delay * scale);
        }
        pat.setNeedsLayout();
        return pat;
    }

    protected JMLPattern mutateAddEvent(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        double t;
        int hand;
        int juggler;
        double tmax;
        double tmin;
        pat.layoutPattern();
        JMLEvent ev = null;
        int tries = 0;
        do {
            juggler = 1 + (int)((double)pat.getNumberOfJugglers() * Math.random());
            hand = Math.random() < 0.5 ? 1 : 2;
            tmin = pat.getLoopStartTime();
            tmax = pat.getLoopEndTime();
            t = tmin + (tmax - tmin) * Math.random();
            for (ev = pat.getEventList(); !(ev == null || ev.getJuggler() == juggler && ev.getHand() == hand && ev.getT() >= t); ev = ev.getNext()) {
            }
            if (ev == null) {
                return null;
            }
            tmax = ev.getT() - 0.03;
            while (!(ev == null || ev.getJuggler() == juggler && ev.getHand() == hand && ev.getT() <= t)) {
                ev = ev.getPrevious();
            }
            if (ev != null) continue;
            return null;
        } while ((tmin = ev.getT() + 0.03) > tmax && ++tries < 5);
        if (tries == 5) {
            return null;
        }
        for (t = (r = Math.random()) < 0.5 ? tmin + (tmax - tmin) * Math.sqrt(0.5 * r) : tmax - (tmax - tmin) * Math.sqrt(0.5 * (1.0 - r)); t < pat.getLoopStartTime(); t += pat.getLoopEndTime() - pat.getLoopStartTime()) {
        }
        while (t > pat.getLoopEndTime()) {
            t -= pat.getLoopEndTime() - pat.getLoopStartTime();
        }
        ev = new JMLEvent();
        ev.setHand(juggler, hand);
        ev.setT(t);
        ev.setMaster(null);
        Coordinate pos = new Coordinate();
        pat.getHandCoordinate(juggler, hand, t, pos);
        pos = pat.convertGlobalToLocal(pos, juggler, t);
        pos = this.pickNewPosition(hand, this.rate * 40.0, pos);
        ev.setLocalCoordinate(pos);
        for (int path = 1; path <= pat.getNumberOfPaths(); ++path) {
            if (!pat.isHandHoldingPath(juggler, hand, t, path)) continue;
            JMLTransition trans = new JMLTransition(5, path, null, null);
            ev.addTransition(trans);
        }
        pat.addEvent(ev);
        pat.setNeedsLayout();
        return pat;
    }

    protected JMLPattern mutateRemoveEvent(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        int type;
        boolean holding_only;
        JMLEvent ev;
        int count = 0;
        for (ev = pat.getEventList(); ev != null; ev = ev.getNext()) {
            if (!ev.isMaster()) continue;
            holding_only = true;
            for (JMLTransition tr : ev.transitions()) {
                type = tr.getType();
                if (type == 0 || type == 5) continue;
                holding_only = false;
                break;
            }
            if (!holding_only) continue;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        count = (int)((double)count * Math.random());
        for (ev = pat.getEventList(); ev != null; ev = ev.getNext()) {
            if (!ev.isMaster()) continue;
            holding_only = true;
            for (JMLTransition tr : ev.transitions()) {
                type = tr.getType();
                if (type == 0 || type == 5) continue;
                holding_only = false;
                break;
            }
            if (!holding_only) continue;
            if (count == 0) {
                pat.removeEvent(ev);
                pat.setNeedsLayout();
                return pat;
            }
            --count;
        }
        throw new JuggleExceptionInternal("mutateRemoveEvent error");
    }

    protected JMLEvent pickMasterEvent(JMLPattern pat) throws JuggleExceptionUser, JuggleExceptionInternal {
        pat.layoutPattern();
        JMLEvent eventlist = pat.getEventList();
        int master_count = 0;
        JMLEvent current = eventlist;
        do {
            if (!current.isMaster()) continue;
            ++master_count;
        } while ((current = current.getNext()) != null);
        int event_num = (int)(Math.random() * (double)master_count);
        current = eventlist;
        do {
            if (!current.isMaster()) continue;
            if (event_num == 0) {
                return current;
            }
            --event_num;
        } while ((current = current.getNext()) != null);
        throw new JuggleExceptionInternal("Mutator: pickEvent() failed");
    }

    protected Coordinate pickNewPosition(int hand, double scaleDistance, Coordinate pos) {
        boolean outside_box;
        Coordinate result = null;
        do {
            result = new Coordinate(pos);
            result.x += 2.0 * scaleDistance * (Math.random() - 0.5);
            result.z += 2.0 * scaleDistance * (Math.random() - 0.5);
            if (hand == 1) {
                outside_box = result.x < -75.0 || result.x > 40.0 || result.z < -20.0 || result.z > 80.0;
                continue;
            }
            boolean bl = outside_box = result.x < -40.0 || result.x > 75.0 || result.z < -20.0 || result.z > 80.0;
        } while (outside_box && Math.random() < 0.5);
        return result;
    }

    protected JPanel makeControlPanel() {
        JPanel controls = new JPanel();
        GridBagLayout gb = new GridBagLayout();
        controls.setLayout(gb);
        controls.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        JLabel lab = new JLabel(guistrings.getString("Mutator_header1"));
        gb.setConstraints(lab, Mutator.make_constraints(21, 0, 0, new Insets(0, 0, 10, 0)));
        controls.add(lab);
        this.cb = new JCheckBox[5];
        this.cb[0] = new JCheckBox(guistrings.getString("Mutator_type1"), true);
        gb.setConstraints(this.cb[0], Mutator.make_constraints(21, 0, 1, null));
        controls.add(this.cb[0]);
        this.cb[1] = new JCheckBox(guistrings.getString("Mutator_type2"), true);
        gb.setConstraints(this.cb[1], Mutator.make_constraints(21, 0, 2, null));
        controls.add(this.cb[1]);
        this.cb[2] = new JCheckBox(guistrings.getString("Mutator_type3"), true);
        gb.setConstraints(this.cb[2], Mutator.make_constraints(21, 0, 3, null));
        controls.add(this.cb[2]);
        this.cb[3] = new JCheckBox(guistrings.getString("Mutator_type4"), true);
        gb.setConstraints(this.cb[3], Mutator.make_constraints(21, 0, 4, null));
        controls.add(this.cb[3]);
        this.cb[4] = new JCheckBox(guistrings.getString("Mutator_type5"), true);
        gb.setConstraints(this.cb[4], Mutator.make_constraints(21, 0, 5, null));
        controls.add(this.cb[4]);
        lab = new JLabel(guistrings.getString("Mutator_header2"));
        gb.setConstraints(lab, Mutator.make_constraints(21, 0, 6, new Insets(20, 0, 10, 0)));
        controls.add(lab);
        this.slider_rate = new JSlider(0, 0, 6, 3);
        GridBagConstraints gbc = Mutator.make_constraints(21, 0, 7, null);
        gbc.fill = 2;
        gb.setConstraints(this.slider_rate, gbc);
        this.slider_rate.setMajorTickSpacing(1);
        this.slider_rate.setPaintTicks(true);
        this.slider_rate.setSnapToTicks(true);
        Hashtable<Integer, JLabel> labels = new Hashtable<Integer, JLabel>();
        labels.put(0, new JLabel(guistrings.getString("Mutation_rate_low")));
        labels.put(3, new JLabel(guistrings.getString("Mutation_rate_medium")));
        labels.put(6, new JLabel(guistrings.getString("Mutation_rate_high")));
        this.slider_rate.setLabelTable(labels);
        this.slider_rate.setPaintLabels(true);
        controls.add(this.slider_rate);
        return controls;
    }

    protected static GridBagConstraints make_constraints(int location, int gridx, int gridy, Insets ins) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = location;
        gbc.fill = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.gridx = gridx;
        gbc.gridy = gridy;
        gbc.insets = ins == null ? new Insets(0, 0, 0, 0) : ins;
        gbc.weighty = 0.0;
        gbc.weightx = 0.0;
        return gbc;
    }
}

